/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.mapping.ui.actions.MappingAction;
import org.teiid.designer.mapping.ui.actions.MappingGlobalActionsManager;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class CopyAction
extends MappingAction
implements UiConstants {
    private static final String PROBLEM = "CopyAction.problem";

    public CopyAction(EObject transformationEObject) {
        super(transformationEObject);
        ISharedImages imgs = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(imgs.getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(imgs.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
        this.determineEnablement();
    }

    @Override
    protected void doRun() {
        EObject obj;
        String objectString = null;
        List lstObjs = SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection());
        if (lstObjs.size() == 1) {
            obj = (EObject)lstObjs.get(0);
            ILabelProvider ilp = ModelUtilities.getEMFLabelProvider();
            objectString = ilp.getText((Object)obj);
        } else {
            objectString = "" + lstObjs.size();
        }
        try {
            if (lstObjs.size() == 1) {
                obj = (EObject)lstObjs.get(0);
                ModelerCore.getModelEditor().copyToClipboard(obj);
            } else {
                ModelerCore.getModelEditor().copyAllToClipboard((Collection)lstObjs);
            }
        }
        catch (ModelerCoreException err) {
            String msg = Util.getString(PROBLEM, (Object)objectString);
            this.getPluginUtils().log(4, (Throwable)err, msg);
        }
        this.determineEnablement();
    }

    private void determineEnablement() {
        boolean enable = false;
        if (!this.isReadOnly()) {
            List<Object> sourceEObjects = null;
            if (SelectionUtilities.isSingleSelection((ISelection)this.getSelection())) {
                sourceEObjects = new ArrayList(1);
                Object o = SelectionUtilities.getSelectedObject((ISelection)this.getSelection());
                sourceEObjects.add(o);
            } else if (SelectionUtilities.isMultiSelection((ISelection)this.getSelection())) {
                sourceEObjects = SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection());
            }
            enable = MappingGlobalActionsManager.canCopy(sourceEObjects);
        }
        this.setEnabled(enable);
    }
}

