/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.mapping.ui.UiConstants;
import org.teiid.designer.mapping.ui.actions.MappingAction;
import org.teiid.designer.mapping.ui.actions.MappingGlobalActionsManager;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.MappingClassColumn;
import org.teiid.designer.metamodels.transformation.StagingTable;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.TransactionSettings;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.viewsupport.ModelObjectEditHelperManager;

public class DeleteAction
extends MappingAction
implements UiConstants {
    private static final String PROBLEM = "org.teiid.designer.transformation.ui.actions.DeleteAction.problem";
    private static final String ACTION_DESCRIPTION = "Delete From Mapping";
    private static final String CANNOT_UNDO_TITLE = "DeleteAction.cannotUndoTitle";
    private static final String CANNOT_UNDO_MSG = "DeleteAction.cannotUndoMsg";

    public DeleteAction(EObject transformationEObject) {
        super(transformationEObject);
        ISharedImages imgs = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(imgs.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(imgs.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
        this.determineEnablement();
    }

    @Override
    protected void doRun() {
        block12: {
            List selectedEObjects = SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection());
            if (selectedEObjects != null) {
                TransactionSettings ts = this.determineCanUndoStatus();
                if (!ts.isUndoable()) {
                    String sTitle = UiConstants.Util.getString(CANNOT_UNDO_TITLE, new Object[0]);
                    String sMsg = UiConstants.Util.getString(CANNOT_UNDO_MSG, new Object[0]);
                    boolean bDoAnyway = MessageDialog.openQuestion((Shell)this.getShell(), (String)sTitle, (String)sMsg);
                    if (!bDoAnyway) {
                        return;
                    }
                }
                boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)ts.isUndoable(), (String)ACTION_DESCRIPTION, (Object)this);
                boolean succeeded = false;
                try {
                    try {
                        this.delete(selectedEObjects);
                        succeeded = true;
                    }
                    catch (ModelerCoreException theException) {
                        String msg = Util.getString(PROBLEM, new Object[0]);
                        this.getPluginUtils().log(4, (Throwable)theException, msg);
                        this.setEnabled(false);
                        if (!requiredStart) break block12;
                        if (succeeded) {
                            ModelerCore.commitTxn();
                            break block12;
                        }
                        ModelerCore.rollbackTxn();
                    }
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        }
    }

    private TransactionSettings determineCanUndoStatus() {
        ISelection iSelection;
        TransactionSettings ts = new TransactionSettings();
        boolean bCanUndoDelete = false;
        ISelection selection = this.getSelection();
        if (selection instanceof ISelection && !(iSelection = selection).isEmpty() && !this.isReadOnly() && this.canLegallyEditResource()) {
            if (SelectionUtilities.isSingleSelection((ISelection)iSelection)) {
                EObject o = SelectionUtilities.getSelectedEObject((ISelection)iSelection);
                bCanUndoDelete = o != null && ModelObjectEditHelperManager.canUndoDelete((Object)o);
            } else if (SelectionUtilities.isMultiSelection((ISelection)iSelection)) {
                List sourceEObjects = SelectionUtilities.getSelectedEObjects((ISelection)iSelection);
                bCanUndoDelete = true;
                if (sourceEObjects.size() > 0) {
                    bCanUndoDelete = ModelObjectEditHelperManager.canUndoDelete((Object)sourceEObjects);
                }
            }
        }
        ts.setIsUndoable(bCanUndoDelete);
        return ts;
    }

    private void delete(List deleteList) throws ModelerCoreException {
        EObject eObj2 = null;
        boolean hasMCF = this.getMappingClassFactory() != null;
        for (EObject eObj2 : deleteList) {
            if (this.isStagingTable(eObj2)) {
                if (!hasMCF) continue;
                this.getMappingClassFactory().deleteStagingTable((StagingTable)eObj2);
                continue;
            }
            if (this.isMappingClass(eObj2)) {
                if (!hasMCF) continue;
                this.getMappingClassFactory().deleteMappingClass((MappingClass)eObj2);
                continue;
            }
            if (this.isMappingClassColumn(eObj2)) {
                if (!hasMCF) continue;
                this.getMappingClassFactory().deleteMappingClassColumn((MappingClassColumn)eObj2);
                continue;
            }
            ModelerCore.getModelEditor().delete(eObj2);
        }
    }

    private void determineEnablement() {
        boolean enable = false;
        if (!this.isReadOnly()) {
            enable = true;
            List selectedEObjects = SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection());
            EObject eObj = null;
            if (this.isDetailed()) {
                enable = MappingGlobalActionsManager.canDelete(selectedEObjects);
            } else {
                Iterator iter = selectedEObjects.iterator();
                while (iter.hasNext() && enable) {
                    eObj = (EObject)iter.next();
                    if (this.isMappingClassColumn(eObj) || this.isMappingClass(eObj) || this.isStagingTable(eObj)) continue;
                    enable = false;
                }
            }
        }
        this.setEnabled(enable);
    }

    protected Shell getShell() {
        return UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
    }
}

