/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.mapping.ui.UiPlugin;
import org.teiid.designer.mapping.ui.actions.MappingAction;
import org.teiid.designer.mapping.ui.model.MappingExtentNode;
import org.teiid.designer.mapping.ui.part.MappingExtentEditPart;
import org.teiid.designer.metamodels.transformation.MappingClassColumn;
import org.teiid.designer.ui.editors.ModelEditor;

public class DeleteMappingLinksAction
extends MappingAction {
    private static final String ACTION_DESCRIPTION = "Delete Mapping Links";

    public DeleteMappingLinksAction() {
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/cview16/tb_delete_mapping_link.gif"));
    }

    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
        super.selectionChanged(thePart, theSelection);
        this.determineEnablement();
    }

    @Override
    protected void doRun() {
        if (this.getMappingClassFactory() != null && this.getMappingClassFactory() != null) {
            MappingClassColumn mcc = null;
            EObject locationEObject = null;
            EObject mappingRef = null;
            MappingExtentEditPart nextMEEP2 = null;
            List selectedEditParts = this.getSelectedMappedExtents();
            boolean canUndo = false;
            boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)canUndo, (String)ACTION_DESCRIPTION, (Object)((Object)this));
            boolean succeeded = false;
            try {
                for (MappingExtentEditPart nextMEEP2 : selectedEditParts) {
                    mappingRef = ((MappingExtentNode)((Object)nextMEEP2.getModel())).getExtent().getMappingReference();
                    if (this.isMappingClassColumn(mappingRef)) {
                        mcc = (MappingClassColumn)mappingRef;
                    }
                    locationEObject = ((MappingExtentNode)((Object)nextMEEP2.getModel())).getExtent().getDocumentNodeReference();
                    if (mcc != null && locationEObject != null) {
                        this.getMappingClassFactory().removeLocation(mcc, locationEObject);
                    }
                    succeeded = true;
                }
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        this.setEnabled(false);
    }

    private void determineEnablement() {
        boolean canWrite;
        boolean enable = false;
        if (this.getPart() instanceof ModelEditor && (canWrite = this.isWritable()) && this.getMappingClassFactory() != null) {
            MappingClassColumn mcc = null;
            EObject locationEObject = null;
            List selectedEditParts = this.getSelectedMappedExtents();
            if (selectedEditParts != null && !selectedEditParts.isEmpty()) {
                Iterator iter = selectedEditParts.iterator();
                boolean allOK = true;
                MappingExtentEditPart nextMEEP = null;
                while (iter.hasNext() && allOK) {
                    nextMEEP = (MappingExtentEditPart)((Object)iter.next());
                    EObject object = ((MappingExtentNode)((Object)nextMEEP.getModel())).getExtent().getMappingReference();
                    if (this.isMappingClassColumn(object)) {
                        mcc = (MappingClassColumn)object;
                    }
                    locationEObject = ((MappingExtentNode)((Object)nextMEEP.getModel())).getExtent().getDocumentNodeReference();
                    allOK = mcc != null && locationEObject != null ? this.getMappingClassFactory().canRemoveLocation(mcc, locationEObject) : false;
                }
                enable = allOK;
            }
        }
        this.setEnabled(enable);
    }

    private List getSelectedMappedExtents() {
        ArrayList selectedEditParts = new ArrayList(this.editor.getDiagramViewer().getSelectedEditParts());
        boolean allOK = true;
        Object nextObject = null;
        Iterator iter = selectedEditParts.iterator();
        while (iter.hasNext() && allOK) {
            nextObject = iter.next();
            if (nextObject instanceof MappingExtentEditPart) continue;
            allOK = false;
        }
        if (allOK) {
            return selectedEditParts;
        }
        return Collections.EMPTY_LIST;
    }
}

