/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.actions;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.metamodels.transformation.InputParameter;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.MappingClassColumn;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;

public class MappingGlobalActionsManager {
    public static boolean canDelete(List selectedEObjects) {
        return MappingGlobalActionsManager.allValidMappingClassChildren(selectedEObjects);
    }

    public static void delete(List sourceEObjects) throws ModelerCoreException {
        if (sourceEObjects != null && !sourceEObjects.isEmpty()) {
            Iterator iter = sourceEObjects.iterator();
            Object nextEObject = null;
            while (iter.hasNext()) {
                nextEObject = iter.next();
                if (!(nextEObject instanceof EObject)) continue;
                ModelerCore.getModelEditor().delete((EObject)nextEObject);
            }
        }
    }

    public static boolean canCut(List selectedEObjects) {
        return MappingGlobalActionsManager.allValidMappingClassChildren(selectedEObjects);
    }

    public static void cut(List sourceEObjects) throws ModelerCoreException {
        if (sourceEObjects != null && !sourceEObjects.isEmpty()) {
            ModelerCore.getModelEditor().cutAllToClipboard((Collection)sourceEObjects);
        }
    }

    public static boolean canCopy(List sourceEObjects) {
        return sourceEObjects != null && !sourceEObjects.isEmpty() && MappingGlobalActionsManager.allValidMappingClassChildren(sourceEObjects);
    }

    public static void copy(List sourceEObjects) throws ModelerCoreException {
        if (sourceEObjects != null && !sourceEObjects.isEmpty()) {
            ModelerCore.getModelEditor().copyAllToClipboard((Collection)sourceEObjects);
        }
    }

    public static boolean canPaste(EObject transformationEObject, List selectedEObjects) {
        EObject selectedEObject;
        boolean canPaste = false;
        if (!ModelObjectUtilities.isReadOnly((EObject)transformationEObject) && TransformationHelper.isSqlTransformationMappingRoot((Object)transformationEObject) && selectedEObjects != null && !selectedEObjects.isEmpty() && selectedEObjects.size() == 1 && (selectedEObject = (EObject)selectedEObjects.get(0)) instanceof MappingClass) {
            canPaste = ModelerCore.getModelEditor().isValidPasteParent((Object)selectedEObject);
        }
        return canPaste;
    }

    public static void paste(List selectedEObjects) throws ModelerCoreException {
        if (selectedEObjects != null && !selectedEObjects.isEmpty() && selectedEObjects.size() == 1) {
            EObject selectedEObject = (EObject)selectedEObjects.get(0);
            ModelerCore.getModelEditor().pasteFromClipboard((Object)selectedEObject);
        }
    }

    public static boolean canClone(List selectedEObjects) {
        return MappingGlobalActionsManager.allValidMappingClassChildren(selectedEObjects);
    }

    public static void clone(List sourceEObjects) throws ModelerCoreException {
        if (sourceEObjects != null && !sourceEObjects.isEmpty()) {
            Iterator iter = sourceEObjects.iterator();
            Object nextEObject = null;
            while (iter.hasNext()) {
                nextEObject = iter.next();
                if (!(nextEObject instanceof EObject)) continue;
                ModelerCore.getModelEditor().clone((EObject)nextEObject);
            }
        }
    }

    private static boolean allValidMappingClassChildren(List selectedEObjects) {
        boolean allOK = true;
        if (selectedEObjects != null && !selectedEObjects.isEmpty()) {
            Iterator iter = selectedEObjects.iterator();
            Object oTemp = null;
            EObject eoTemp = null;
            while (iter.hasNext() && allOK) {
                oTemp = iter.next();
                if (oTemp instanceof EObject) {
                    eoTemp = oTemp;
                    if (eoTemp instanceof MappingClassColumn || eoTemp instanceof InputParameter) continue;
                    allOK = false;
                    continue;
                }
                allOK = false;
            }
        } else {
            allOK = false;
        }
        return allOK;
    }
}

