/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.mapping.ui.UiConstants;
import org.teiid.designer.mapping.ui.UiPlugin;
import org.teiid.designer.mapping.ui.actions.MappingAction;
import org.teiid.designer.mapping.ui.diagram.MappingDiagramUtil;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelEditor;

public class MergeMappingClassesAction
extends MappingAction {
    private static final String ACTION_DESCRIPTION = "Merge Mapping Classes";
    private static final String MERGE_MAPPING_CLASSES_ERROR = "MergeMappingClassesAction: Error merging mapping classes. Object = ";

    public MergeMappingClassesAction() {
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/cview16/tb_merge_mapping_classes.gif"));
    }

    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
        super.selectionChanged(thePart, theSelection);
        this.determineEnablement();
    }

    @Override
    protected void doRun() {
        if (this.getMappingClassFactory() != null) {
            this.mergeWithProgress();
        }
        this.setEnabled(false);
    }

    private boolean mergeWithProgress() {
        boolean success;
        block4: {
            success = false;
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    Object[] mcArray = MergeMappingClassesAction.this.getOrderedSelectedMappingClasses();
                    MergeMappingClassesAction.this.printMCArray(mcArray);
                    int nWork = 10 * mcArray.length;
                    monitor.beginTask("Merging Mapping Classes", nWork);
                    MergeMappingClassesAction.this.mergeMultiple(mcArray, monitor);
                }
            };
            ProgressMonitorDialog dlg = new ProgressMonitorDialog(this.getPlugin().getCurrentWorkbenchWindow().getShell());
            dlg.setCancelable(false);
            dlg.run(false, true, op);
            if (!dlg.getProgressMonitor().isCanceled()) break block4;
            return true;
        }
        try {
            success = true;
        }
        catch (InterruptedException interruptedException) {
            success = true;
        }
        catch (Exception exception) {
            success = false;
        }
        return success;
    }

    void mergeMultiple(Object[] mcArray, IProgressMonitor monitor) {
        block10: {
            boolean canUndo = false;
            boolean removeDuplicateAttributes = ModelerCore.getTransformationPreferences().getRemoveDuplicateAttibutes();
            boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)canUndo, (String)ACTION_DESCRIPTION, (Object)((Object)this));
            boolean succeeded = false;
            MappingClass firstMC = (MappingClass)mcArray[0];
            MappingClass secondMC = null;
            try {
                try {
                    String progressMessage = null;
                    int nMCs = mcArray.length;
                    int i = 1;
                    while (i < nMCs) {
                        secondMC = (MappingClass)mcArray[i];
                        progressMessage = "Merging " + (i + 1) + " of " + nMCs + ":  Name = " + secondMC.getName();
                        monitor.subTask(progressMessage);
                        monitor.worked(10);
                        this.getMappingClassFactory().mergeMappingClasses(firstMC, secondMC, removeDuplicateAttributes);
                        ++i;
                    }
                    succeeded = true;
                }
                catch (ModelerCoreException e) {
                    String message = MERGE_MAPPING_CLASSES_ERROR + firstMC.toString();
                    UiConstants.Util.log(4, (Throwable)e, message);
                    if (!requiredStart) break block10;
                    if (succeeded) {
                        ModelerCore.commitTxn();
                        break block10;
                    }
                    ModelerCore.rollbackTxn();
                }
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    private boolean enableForMultiple() {
        if (this.getPart() instanceof ModelEditor && this.multipleMappingClassesSelected()) {
            Object[] mcArray = this.getOrderedSelectedMappingClasses();
            MappingClass firstMC = null;
            MappingClass secondMC = null;
            boolean canMerge = true;
            int i = 1;
            while (i < mcArray.length) {
                int j = i - 1;
                while (j >= 0) {
                    firstMC = (MappingClass)mcArray[j];
                    secondMC = (MappingClass)mcArray[i];
                    canMerge = this.getMappingClassFactory().canMergeMappingClasses(firstMC, secondMC);
                    if (canMerge) {
                        return true;
                    }
                    --j;
                }
                ++i;
            }
        }
        return false;
    }

    Object[] getOrderedSelectedMappingClasses() {
        List allOrderedMCs = MappingDiagramUtil.getOrderedCoarseMappingClasses();
        List selectedMCs = SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection());
        ArrayList<EObject> orderedSelectedMCs = new ArrayList<EObject>(selectedMCs.size());
        EObject nextMC2 = null;
        for (EObject nextMC2 : allOrderedMCs) {
            if (!selectedMCs.contains(nextMC2)) continue;
            orderedSelectedMCs.add(nextMC2);
        }
        return orderedSelectedMCs.toArray();
    }

    private void determineEnablement() {
        this.setEnabled(this.enableForMultiple());
    }

    private boolean multipleMappingClassesSelected() {
        List selectedEObjects;
        if (SelectionUtilities.isMultiSelection((ISelection)this.getSelection()) && this.isWritable() && (selectedEObjects = SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection())).size() > 1) {
            EObject eObj2 = null;
            for (EObject eObj2 : selectedEObjects) {
                if (!this.isStagingTable(eObj2) && this.isMappingClass(eObj2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return "MergeMappingClassesAction[]";
    }

    void printMCArray(Object[] mcArray) {
    }
}

