/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.actions;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.mapping.ui.actions.MappingAction;
import org.teiid.designer.mapping.ui.actions.MappingGlobalActionsManager;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class PasteAction
extends MappingAction
implements UiConstants {
    private static final String PROBLEM = "PasteAction.problem";
    private static final String UNDO_TEXT = "PasteAction.undoText";

    public PasteAction(EObject transformationEObject) {
        super(transformationEObject);
        ISharedImages imgs = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(imgs.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setDisabledImageDescriptor(imgs.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
        this.determineEnablement();
    }

    @Override
    protected void doRun() {
        block15: {
            EObject obj = SelectionUtilities.getSelectedEObject((ISelection)this.getSelection());
            String objectString = null;
            String description = null;
            if (obj != null) {
                ILabelProvider ilp = ModelUtilities.getEMFLabelProvider();
                objectString = ilp.getText((Object)obj);
                description = this.getPluginUtils().getString(UNDO_TEXT, (Object)objectString);
            }
            boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, description, (Object)((Object)this));
            boolean succeeded = false;
            try {
                try {
                    ModelerCore.getModelEditor().pasteFromClipboard((Object)obj);
                    succeeded = true;
                }
                catch (ModelerCoreException theException) {
                    String msg = this.getPluginUtils().getString(PROBLEM, (Object)objectString);
                    this.getPluginUtils().log(4, (Throwable)theException, msg);
                    this.setEnabled(false);
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                throw throwable;
            }
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        this.determineEnablement();
    }

    private void determineEnablement() {
        boolean enable = false;
        if (!this.isReadOnly()) {
            ArrayList<EObject> sourceEObjects = null;
            EObject targetEObject = null;
            if (SelectionUtilities.isSingleSelection((ISelection)this.getSelection())) {
                sourceEObjects = new ArrayList<EObject>(1);
                targetEObject = SelectionUtilities.getSelectedEObject((ISelection)this.getSelection());
                sourceEObjects.add(targetEObject);
            }
            if (targetEObject != null) {
                enable = this.getTransformation() != null ? MappingGlobalActionsManager.canPaste(this.getTransformation(), sourceEObjects) && ModelerCore.getModelEditor().isValidPasteParent((Object)targetEObject) : ModelerCore.getModelEditor().isValidPasteParent(targetEObject);
            }
        }
        this.setEnabled(enable);
    }
}

