/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.actions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.mapping.factory.MappingClassFactory;
import org.teiid.designer.mapping.ui.UiPlugin;
import org.teiid.designer.mapping.ui.actions.MappingAction;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.editors.ModelEditor;

public class SplitMappingClassAction
extends MappingAction {
    private static final String ERROR_MESSAGE = "Cannot Split Mapping Class.\n\nCurrent mapping class multiplicity values are satisfied.\nCannot automatically split.\nSplit manually by selecting a node (i.e. sequence) in the mapping tree \nand selecting the \"New Mapping Class\" action.";
    private static final String ACTION_DESCRIPTION = "Split Mapping Class";

    public SplitMappingClassAction() {
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/cview16/tb_split_mapping_classes.gif"));
    }

    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
        super.selectionChanged(thePart, theSelection);
        this.determineEnablement();
    }

    @Override
    protected void doRun() {
        if (this.getMappingClassFactory() != null) {
            EObject eObject = SelectionUtilities.getSelectedEObject((ISelection)this.getSelection());
            boolean canSplit = this.getMappingClassFactory().canSplitMappingClass((MappingClass)eObject, MappingClassFactory.getDefaultStrategy());
            if (canSplit) {
                boolean canUndo = false;
                boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)canUndo, (String)ACTION_DESCRIPTION, (Object)((Object)this));
                boolean succeeded = false;
                try {
                    this.getMappingClassFactory().splitMappingClass((MappingClass)eObject, MappingClassFactory.getDefaultStrategy(), false);
                    succeeded = true;
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            } else {
                WidgetUtil.showWarning((String)ERROR_MESSAGE);
            }
        }
        this.setEnabled(false);
    }

    private void determineEnablement() {
        EObject eObj;
        boolean enable = false;
        if (this.getPart() instanceof ModelEditor && SelectionUtilities.isSingleSelection((ISelection)this.getSelection()) && (eObj = SelectionUtilities.getSelectedEObject((ISelection)this.getSelection())) != null && this.isWritable() && this.isMappingClass(eObj) && !this.isStagingTable(eObj) && this.getMappingClassFactory() != null) {
            enable = true;
        }
        this.setEnabled(enable);
    }
}

