/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.actions;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.mapping.ui.UiConstants;
import org.teiid.designer.mapping.ui.UiPlugin;
import org.teiid.designer.mapping.ui.actions.MappingAction;
import org.teiid.designer.mapping.ui.diagram.MappingDiagramUtil;
import org.teiid.designer.mapping.ui.editor.MappingDiagramBehavior;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;

public class ToggleFoldAllMappingClassesAction
extends MappingAction {
    private static String TOGGLE_UNFOLD_ALL_TOOLTIP = UiConstants.Util.getString("ToggleFoldAllMappingClassesAction.unfoldAll.tooltip", new Object[0]);
    private static String TOGGLE_UNFOLD_ALL_TEXT = UiConstants.Util.getString("ToggleFoldAllMappingClassesAction.unfoldAll.text", new Object[0]);
    private static String TOGGLE_FOLD_ALL_TEXT = UiConstants.Util.getString("ToggleFoldAllMappingClassesAction.foldAll.text", new Object[0]);
    private boolean logicalModel = false;

    public ToggleFoldAllMappingClassesAction() {
        super(UiPlugin.getDefault(), 2);
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/cview16/expand_mapping_classes.gif"));
        this.setToolTipText(TOGGLE_UNFOLD_ALL_TOOLTIP);
        this.setText(TOGGLE_UNFOLD_ALL_TEXT);
    }

    @Override
    public void setDiagramEditor(DiagramEditor editor) {
        super.setDiagramEditor(editor);
        boolean logical = ModelIdentifier.isLogicalModel((ModelResource)editor.getCurrentModelResource());
        if (this.logicalModel != logical) {
            this.logicalModel = logical;
            String key = logical ? "ToggleFoldAllMappingClassesAction.logicalModel.unfoldAll.tooltip" : TOGGLE_UNFOLD_ALL_TOOLTIP;
            this.setToolTipText(UiConstants.Util.getString(key, new Object[0]));
            key = logical ? "ToggleFoldAllMappingClassesAction.logicalModel.unfoldAll.text" : TOGGLE_UNFOLD_ALL_TEXT;
            this.setText(UiConstants.Util.getString(key, new Object[0]));
        }
        this.updateButtonState();
    }

    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
        super.selectionChanged(thePart, theSelection);
        this.determineEnablement();
    }

    private MappingDiagramBehavior getBehavior() {
        return MappingDiagramUtil.getCurrentMappingDiagramBehavior();
    }

    @Override
    protected void doRun() {
        boolean bMappingClassFoldedState = this.getBehavior().getDefaultMappingClassFoldedState();
        bMappingClassFoldedState = !bMappingClassFoldedState;
        this.getBehavior().setDefaultMappingClassFoldedState(bMappingClassFoldedState);
        this.updateButtonState();
        this.editor.doRefreshDiagram();
    }

    private void determineEnablement() {
        boolean enable = true;
        this.setEnabled(enable);
    }

    protected void updateButtonState() {
        boolean bMappingClassFoldedState = this.getBehavior().getDefaultMappingClassFoldedState();
        this.setChecked(bMappingClassFoldedState);
        if (bMappingClassFoldedState) {
            this.setText(TOGGLE_FOLD_ALL_TEXT);
        } else {
            this.setText(TOGGLE_UNFOLD_ALL_TEXT);
        }
    }
}

