/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.choice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.mapping.choice.IChoiceObject;
import org.teiid.designer.mapping.factory.IMappableTree;
import org.teiid.designer.mapping.factory.TreeMappingAdapter;
import org.teiid.designer.mapping.ui.PluginConstants;
import org.teiid.designer.mapping.ui.UiConstants;
import org.teiid.designer.mapping.ui.UiPlugin;
import org.teiid.designer.mapping.ui.choice.BuilderTreeProvider;
import org.teiid.designer.mapping.ui.choice.ChoiceCriteriaStrategy;
import org.teiid.designer.mapping.ui.choice.CriteriaSourceViewerConfiguration;
import org.teiid.designer.mapping.ui.choice.CriteriaTextViewer;
import org.teiid.designer.mapping.ui.choice.actions.ClearCriteria;
import org.teiid.designer.mapping.ui.choice.actions.HideExcludedOptions;
import org.teiid.designer.mapping.ui.choice.actions.LaunchCriteriaBuilder;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.query.IQueryParser;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.metadata.IQueryMetadataInterface;
import org.teiid.designer.query.sql.IResolverVisitor;
import org.teiid.designer.query.sql.ISQLStringVisitor;
import org.teiid.designer.query.sql.lang.ICriteria;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.transformation.ui.builder.CriteriaBuilder;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.transformation.validation.TransformationValidator;
import org.teiid.designer.ui.common.graphics.ColorManager;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.query.ui.builder.util.ElementViewerFactory;
import org.teiid.query.ui.builder.util.ICriteriaStrategy;

public class ChoicePanel
extends SashForm
implements ISelectionChangedListener,
SelectionListener,
UiConstants,
PluginConstants,
INotifyChangedListener {
    private static final int BUTTON_GRID_STYLE = 320;
    private static final String NEED_MAPPING_CLASS_TITLE = UiConstants.Util.getString("ChoicePanel.needMappingClass.title", new Object[0]);
    private static final String NEED_MAPPING_CLASS_MSG = UiConstants.Util.getString("ChoicePanel.needMappingClass.text", new Object[0]);
    private static final int ORDINAL_INDEX = 0;
    private static final int OPTION_NAME_INDEX = 1;
    private static final int INCLUDES_INDEX = 2;
    private static final int CRITERIA_INDEX = 3;
    private static final String LEFT_PAREN = "(";
    private static final String RIGHT_PAREN = ") ";
    private static final String COLON = ":";
    IChoiceObject icoChoiceObject;
    private TreeMappingAdapter mappingAdapter;
    private IMappableTree mappableTree;
    private Composite pnlEditTabOuterComposite;
    private CTabFolder tabFolder;
    private CTabItem tiEditTab;
    private CTabItem tiSummaryTab;
    private CriteriaTextViewer svrSummarySource;
    protected static final int VERTICAL_RULER_WIDTH = 12;
    private Document docChoiceCriteria;
    private String NEWLINE = "\n";
    private String INDENT = "     ";
    private String DEFAULT = "Default";
    private String UNDEFINED = "<undefined>";
    private Composite pnlTableStuff;
    private Table tblOptionTable;
    TableViewer tvOptionTableViewer;
    private Composite pnlRowMoveButtons;
    private Button btnUp;
    private Button btnDown;
    CLabel lblDefaultTitle;
    private ComboContribution contDefaultComboBoxContribution;
    private LaunchCriteriaBuilder actLaunchCriteriaBuilder;
    private ClearCriteria actClearCriteria;
    private HideExcludedOptions actHideExcludedOptions;
    private ChoiceViewerFilter cvfExcludeFilter;
    private TableContentProvider cpChoiceContentProvider;
    private TableLabelProvider lpChoiceLabelProvider;
    private CriteriaSourceViewerConfiguration csvcViewerConfig;
    private ColorManager colorManager;
    private List lstReservedWords;
    private ModelExplorerLabelProvider melpAdHocLabelProvider;
    private String[] columnNames = new String[]{ORDINAL_COL_TEXT, NAME_COL_TEXT, INCLUDE_COL_TEXT, CRITERIA_COL_TEXT};
    private static final int LABEL_GRID_STYLE = 32;
    private static final String EDIT_TAB_TEXT = UiConstants.Util.getString("ChoicePanel.editTab.text", new Object[0]);
    private static final String SUMMARY_TAB_TEXT = UiConstants.Util.getString("ChoicePanel.summaryTab.text", new Object[0]);
    private static final String ORDINAL_COL_TEXT = UiConstants.Util.getString("ChoicePanel.ordinalCol.text", new Object[0]);
    private static final String NAME_COL_TEXT = UiConstants.Util.getString("ChoicePanel.nameCol.text", new Object[0]);
    private static final String INCLUDE_COL_TEXT = UiConstants.Util.getString("ChoicePanel.includeCol.text", new Object[0]);
    private static final String CRITERIA_COL_TEXT = UiConstants.Util.getString("ChoicePanel.criteriaCol.text", new Object[0]);
    private static final String UP_BUTTON_TEXT = UiConstants.Util.getString("ChoicePanel.upButton.text", new Object[0]);
    private static final String UP_BUTTON_TOOLTIP = UiConstants.Util.getString("ChoicePanel.upButton.toolTip", new Object[0]);
    private static final String DOWN_BUTTON_TEXT = UiConstants.Util.getString("ChoicePanel.downButton.text", new Object[0]);
    private static final String DOWN_BUTTON_TOOLTIP = UiConstants.Util.getString("ChoicePanel.downButton.toolTip", new Object[0]);
    private static final String EDIT_BUTTON_TOOLTIP = UiConstants.Util.getString("ChoicePanel.editButton.toolTip", new Object[0]);
    private static final String CLEAR_BUTTON_TOOLTIP = UiConstants.Util.getString("ChoicePanel.clearButton.toolTip", new Object[0]);
    private static final String HIDE_CHECKBOX_TOOLTIP = UiConstants.Util.getString("ChoicePanel.hideCheckbox.toolTip", new Object[0]);
    private static final String DEFAULT_COMBOBOX_TEXT = UiConstants.Util.getString("ChoicePanel.defaultCombobox.text", new Object[0]);
    static final String DEFAULT_COMBOBOX_TOOLTIP = UiConstants.Util.getString("ChoicePanel.defaultCombobox.toolTip", new Object[0]);

    public ChoicePanel(Composite parent, IChoiceObject ico) {
        super(parent, 512);
        this.icoChoiceObject = ico;
        this.init();
    }

    private void init() {
        this.createControl((Composite)this);
        this.setButtonStates();
        this.tblOptionTable.addSelectionListener((SelectionListener)this);
        this.tblOptionTable.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent event) {
                ChoicePanel.this.handleMouseEvent(event);
            }

            public void mouseUp(MouseEvent event) {
            }

            public void mouseDoubleClick(MouseEvent event) {
            }
        });
        if (this.icoChoiceObject != null) {
            this.refreshFromBusinessObject();
        }
    }

    ModelExplorerLabelProvider getAdHocLabelProvider() {
        if (this.melpAdHocLabelProvider == null) {
            this.melpAdHocLabelProvider = new ModelExplorerLabelProvider();
        }
        return this.melpAdHocLabelProvider;
    }

    public void setBusinessObject(IChoiceObject icoChoice) {
        this.icoChoiceObject = icoChoice;
        this.refreshFromBusinessObject();
    }

    public IChoiceObject getChoiceObject() {
        return this.icoChoiceObject;
    }

    public IChoiceObject getChoiceObject2() {
        return this.icoChoiceObject;
    }

    public IChoiceObject getChoiceObject3() {
        return this.icoChoiceObject;
    }

    public void refreshFromBusinessObject() {
        if (!this.tvOptionTableViewer.getControl().isDisposed()) {
            UiUtil.runInSwtThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ChoicePanel.this.tvOptionTableViewer.setInput((Object)ChoicePanel.this.icoChoiceObject);
                    ChoicePanel.this.getComboBoxContributionForDefault().loadItems();
                    ChoicePanel.this.refreshChoiceSummaryPanel();
                    ChoicePanel.this.setButtonStates();
                }
            }, (boolean)true);
        }
    }

    protected void addNotifyChangedListener() {
        ModelUtilities.addNotifyChangedListener((INotifyChangedListener)this);
    }

    public void removeNotifyChangedListener() {
        ModelUtilities.removeNotifyChangedListener((INotifyChangedListener)this);
    }

    public void notifyChanged(Notification n) {
        this.refreshFromBusinessObject();
    }

    public void createControl(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 1;
        GridData gridData = new GridData(1808);
        gridData.widthHint = 600;
        gridData.heightHint = 400;
        this.setLayoutData(gridData);
        this.tabFolder = new CTabFolder(parent, 1024);
        this.createEditTab(this.tabFolder);
        this.createSummaryTab(this.tabFolder);
        this.tabFolder.setSelection(0);
        this.pnlEditTabOuterComposite = new Composite((Composite)this.tabFolder, 0);
        gridLayout = new GridLayout();
        this.pnlEditTabOuterComposite.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 1;
        this.createTableStuffPanel(this.pnlEditTabOuterComposite);
        this.tiEditTab.setControl((Control)this.pnlEditTabOuterComposite);
        this.tiSummaryTab.setControl(this.svrSummarySource.getControl());
        this.registerListeners();
    }

    private void createEditTab(CTabFolder parent) {
        this.tiEditTab = new CTabItem(parent, 0);
        this.tiEditTab.setText(EDIT_TAB_TEXT);
        this.tiEditTab.setToolTipText(EDIT_TAB_TEXT);
    }

    private void createSummaryTab(CTabFolder parent) {
        this.tiSummaryTab = new CTabItem(parent, 0);
        this.tiSummaryTab.setText(SUMMARY_TAB_TEXT);
        this.tiSummaryTab.setToolTipText(SUMMARY_TAB_TEXT);
        this.colorManager = new ColorManager();
        VerticalRuler verticalRuler = new VerticalRuler(12);
        int styles = 68162;
        this.lstReservedWords = this.getReservedWords();
        this.csvcViewerConfig = new CriteriaSourceViewerConfiguration(this.colorManager, this.lstReservedWords);
        this.svrSummarySource = new CriteriaTextViewer((Composite)parent, (IVerticalRuler)verticalRuler, styles, this.colorManager, this.csvcViewerConfig);
        this.csvcViewerConfig.setReservedWords(this.lstReservedWords);
        this.docChoiceCriteria = new Document();
        this.svrSummarySource.setDocument((IDocument)this.docChoiceCriteria);
        this.svrSummarySource.setEditable(false);
    }

    void refreshChoiceSummaryPanel() {
        StringBuffer sbCriteria = new StringBuffer();
        this.docChoiceCriteria.set("");
        for (Object oOption : this.icoChoiceObject.getOrderedOptions()) {
            if (!this.icoChoiceObject.isIncluded(oOption)) continue;
            sbCriteria.append(String.valueOf(this.getNameWithOrdinal(this.getRowForOption(oOption))) + COLON);
            sbCriteria.append(this.NEWLINE);
            sbCriteria.append(this.INDENT);
            String criteriaText = this.icoChoiceObject.getSqlCriteria(oOption);
            if (criteriaText != null && criteriaText.trim().length() > 0) {
                sbCriteria.append(criteriaText);
            } else {
                sbCriteria.append(this.UNDEFINED);
            }
            sbCriteria.append(this.NEWLINE);
        }
        sbCriteria.append(String.valueOf(this.DEFAULT) + COLON);
        sbCriteria.append(this.NEWLINE);
        sbCriteria.append(this.INDENT);
        if (this.icoChoiceObject.getDefaultOption() != null) {
            TableRow tb = this.getRowForOption(this.icoChoiceObject.getDefaultOption());
            if (tb != null) {
                String sName = this.getNameWithOrdinal(tb);
                sbCriteria.append(sName);
            } else if (!this.icoChoiceObject.getDefaultErrorMode().equals("")) {
                sbCriteria.append(this.icoChoiceObject.getDefaultErrorMode());
            }
        } else if (!this.icoChoiceObject.getDefaultErrorMode().equals("")) {
            sbCriteria.append(this.icoChoiceObject.getDefaultErrorMode());
        }
        this.docChoiceCriteria.set(sbCriteria.toString());
        this.csvcViewerConfig.setReservedWords(this.getReservedWords());
        this.svrSummarySource.refresh();
    }

    private void createTableStuffPanel(Composite parent) {
        this.pnlTableStuff = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.pnlTableStuff.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        this.pnlTableStuff.setLayoutData((Object)gridData);
        this.createTableViewerPanel(this.pnlTableStuff);
        this.createRowMoveButtonPanel(this.pnlTableStuff);
    }

    private void createTableViewerPanel(Composite parent) {
        this.createTable(parent);
        this.createTableViewer();
        this.cpChoiceContentProvider = new TableContentProvider();
        this.lpChoiceLabelProvider = new TableLabelProvider();
        this.tvOptionTableViewer.setContentProvider((IContentProvider)this.cpChoiceContentProvider);
        this.tvOptionTableViewer.setLabelProvider((IBaseLabelProvider)this.lpChoiceLabelProvider);
    }

    private void createTable(Composite parent) {
        int style = 68356;
        this.tblOptionTable = new Table(parent, style);
        TableLayout layout = new TableLayout();
        this.tblOptionTable.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        this.tblOptionTable.setLayoutData((Object)gridData);
        this.tblOptionTable.setLinesVisible(true);
        this.tblOptionTable.setHeaderVisible(true);
        TableColumn column1 = new TableColumn(this.tblOptionTable, 16384, 0);
        column1.setText(ORDINAL_COL_TEXT);
        ColumnWeightData weight = new ColumnWeightData(1);
        layout.addColumnData((ColumnLayoutData)weight);
        TableColumn column2 = new TableColumn(this.tblOptionTable, 16384, 1);
        column2.setText(NAME_COL_TEXT);
        weight = new ColumnWeightData(3);
        layout.addColumnData((ColumnLayoutData)weight);
        TableColumn column3 = new TableColumn(this.tblOptionTable, 16384, 2);
        column3.setText(INCLUDE_COL_TEXT);
        weight = new ColumnWeightData(1);
        layout.addColumnData((ColumnLayoutData)weight);
        TableColumn column4 = new TableColumn(this.tblOptionTable, 16384, 3);
        column4.setText(CRITERIA_COL_TEXT);
        weight = new ColumnWeightData(7);
        layout.addColumnData((ColumnLayoutData)weight);
    }

    private void createTableViewer() {
        this.tvOptionTableViewer = new TableViewer(this.tblOptionTable);
        this.tvOptionTableViewer.setUseHashlookup(true);
        this.tvOptionTableViewer.setColumnProperties(this.columnNames);
        CellEditor[] editors = new CellEditor[this.columnNames.length];
        editors[0] = null;
        editors[1] = null;
        editors[2] = null;
        editors[3] = null;
        this.tvOptionTableViewer.setCellEditors(editors);
        this.cvfExcludeFilter = new ChoiceViewerFilter();
        this.tvOptionTableViewer.addFilter((ViewerFilter)this.cvfExcludeFilter);
    }

    private void createRowMoveButtonPanel(Composite parent) {
        this.pnlRowMoveButtons = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        this.pnlRowMoveButtons.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 1;
        GridData gridData = new GridData(1024);
        this.pnlRowMoveButtons.setLayoutData((Object)gridData);
        this.btnUp = WidgetFactory.createButton((Composite)this.pnlRowMoveButtons, (String)UP_BUTTON_TEXT, (int)320);
        this.btnUp.setImage(UiPlugin.getDefault().getImage("icons/full/clcl16/up.gif"));
        this.btnUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ChoicePanel.this.upButtonPressed();
            }
        });
        this.btnUp.setToolTipText(UP_BUTTON_TOOLTIP);
        this.btnUp.setLayoutData((Object)new GridData(768));
        this.btnDown = WidgetFactory.createButton((Composite)this.pnlRowMoveButtons, (String)DOWN_BUTTON_TEXT, (int)320);
        this.btnDown.setImage(UiPlugin.getDefault().getImage("icons/full/clcl16/down.gif"));
        this.btnDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ChoicePanel.this.downButtonPressed();
            }
        });
        this.btnDown.setLayoutData((Object)new GridData(768));
        this.btnDown.setToolTipText(DOWN_BUTTON_TOOLTIP);
    }

    private void registerListeners() {
    }

    void upButtonPressed() {
        int iSelectedIndex = this.tblOptionTable.getSelectionIndex();
        Object oSelectedOption = this.getOptionForTableIndex(iSelectedIndex);
        int iChoiceObjectIndexForSelection = this.getIndexForOption(oSelectedOption);
        Object oTargetOption = this.getOptionForTableIndex(iSelectedIndex - 1);
        int iChoiceObjectIndexForTarget = this.getIndexForOption(oTargetOption);
        List lstOrderedOptions = this.icoChoiceObject.getOrderedOptions();
        lstOrderedOptions = this.swapOptions(lstOrderedOptions, iChoiceObjectIndexForSelection, iChoiceObjectIndexForTarget);
        this.icoChoiceObject.setOrderedOptions(lstOrderedOptions);
        this.tvOptionTableViewer.refresh();
        this.tvOptionTableViewer.getTable().setSelection(iSelectedIndex - 1);
        this.handleTableSelection();
        this.refreshChoiceSummaryPanel();
        this.setButtonStates();
    }

    private List swapOptions(List lstOrderedOptions, int iIndexA, int iIndexB) {
        Object[] oOrderedOptions = lstOrderedOptions.toArray();
        Object oHoldOption = oOrderedOptions[iIndexA];
        oOrderedOptions[iIndexA] = oOrderedOptions[iIndexB];
        oOrderedOptions[iIndexB] = oHoldOption;
        ArrayList<Object> aryl = new ArrayList<Object>(oOrderedOptions.length);
        int i = 0;
        int j = oOrderedOptions.length;
        while (i < j) {
            aryl.add(oOrderedOptions[i]);
            ++i;
        }
        return aryl;
    }

    void downButtonPressed() {
        int iSelectedIndex = this.tblOptionTable.getSelectionIndex();
        Object oSelectedOption = this.getOptionForTableIndex(iSelectedIndex);
        int iChoiceObjectIndexForSelection = this.getIndexForOption(oSelectedOption);
        Object oTargetOption = this.getOptionForTableIndex(iSelectedIndex + 1);
        int iChoiceObjectIndexForTarget = this.getIndexForOption(oTargetOption);
        List lstOrderedOptions = this.icoChoiceObject.getOrderedOptions();
        lstOrderedOptions = this.swapOptions(lstOrderedOptions, iChoiceObjectIndexForSelection, iChoiceObjectIndexForTarget);
        this.icoChoiceObject.setOrderedOptions(lstOrderedOptions);
        this.tvOptionTableViewer.refresh();
        this.tvOptionTableViewer.getTable().setSelection(iSelectedIndex + 1);
        this.refreshChoiceSummaryPanel();
        this.setButtonStates();
    }

    private Object getOptionForTableIndex(int iIndex) {
        TableItem ti = this.tblOptionTable.getItem(iIndex);
        TableRow trRow = (TableRow)ti.getData();
        Object oOption = trRow.getOption();
        return oOption;
    }

    private int getIndexForOption(Object oOption) {
        return this.icoChoiceObject.getOrderedOptions().indexOf(oOption);
    }

    private Object getOptionForNameWithOrdinal(String sNameWithOrdinal) {
        int i = 0;
        while (i < this.tblOptionTable.getItemCount()) {
            TableItem ti = this.tblOptionTable.getItem(i);
            TableRow trRow = (TableRow)ti.getData();
            if (this.getNameWithOrdinal(trRow).equals(sNameWithOrdinal)) {
                return trRow.getOption();
            }
            ++i;
        }
        return null;
    }

    TableRow getRowForOption(Object oOption) {
        int i = 0;
        while (i < this.tblOptionTable.getItemCount()) {
            TableItem ti = this.tblOptionTable.getItem(i);
            TableRow trRow = (TableRow)ti.getData();
            if (trRow.isIncluded() && trRow.getOption() == oOption) {
                return trRow;
            }
            ++i;
        }
        return null;
    }

    public String getNameWithOrdinal(TableRow trRow) {
        String sName = "";
        if (trRow != null) {
            String sCombinedName;
            Object oOption = trRow.getOption();
            String sOrdinal = trRow.getColumnText(0);
            String sOptionName = this.getAdHocLabelProvider().getText(oOption);
            sName = sCombinedName = LEFT_PAREN + sOrdinal + RIGHT_PAREN + sOptionName;
        }
        return sName;
    }

    private void handleTableSelection() {
        this.setButtonStates();
    }

    void defaultComboboxPressed() {
        Combo cbx = this.getComboBoxContributionForDefault().getControl();
        int iSelectedIndex = cbx.getSelectionIndex();
        if (iSelectedIndex < 0) {
            return;
        }
        String sDefault = cbx.getItem(iSelectedIndex);
        if (this.getComboBoxContributionForDefault().isFoundInIncludedOptions(sDefault)) {
            this.icoChoiceObject.setDefaultOption(this.getOptionForNameWithOrdinal(sDefault));
            this.icoChoiceObject.setDefaultErrorMode("");
        } else if (this.getComboBoxContributionForDefault().isFoundInErrorModeValues(sDefault)) {
            this.icoChoiceObject.setDefaultErrorMode(sDefault);
            this.icoChoiceObject.setDefaultOption(null);
        } else {
            this.icoChoiceObject.setDefaultOption(null);
            this.icoChoiceObject.setDefaultErrorMode("");
        }
        this.refreshChoiceSummaryPanel();
    }

    private List getReservedWords() {
        ArrayList<String> aryl = new ArrayList<String>();
        Combo cbx = this.getComboBoxContributionForDefault().getControl();
        if (cbx == null || cbx.isDisposed()) {
            return aryl;
        }
        int i = 0;
        while (i < cbx.getItemCount()) {
            aryl.add(cbx.getItem(i));
            ++i;
        }
        aryl.add(String.valueOf(this.DEFAULT) + COLON);
        return aryl;
    }

    List getIncludedOptions() {
        ArrayList arylIncluded = new ArrayList();
        for (Object oOption : this.icoChoiceObject.getOrderedOptions()) {
            if (!this.icoChoiceObject.isIncluded(oOption)) continue;
            arylIncluded.add(oOption);
        }
        return arylIncluded;
    }

    public void contributeToolbarActions(ToolBarManager toolBarMgr) {
        toolBarMgr.removeAll();
        toolBarMgr.add((IContributionItem)new LabelContribution(DEFAULT_COMBOBOX_TEXT));
        toolBarMgr.add((IContributionItem)this.getComboBoxContributionForDefault());
        toolBarMgr.add((IContributionItem)new Separator());
        toolBarMgr.add((IAction)this.getLaunchCriteriaBuilderAction());
        toolBarMgr.add((IAction)this.getClearCriteriaBuilderAction());
        toolBarMgr.add((IAction)this.getHideExcludedOptionsAction());
        toolBarMgr.update(true);
        this.setButtonStates();
    }

    ComboContribution getComboBoxContributionForDefault() {
        if (this.contDefaultComboBoxContribution == null) {
            this.contDefaultComboBoxContribution = new ComboContribution();
        }
        return this.contDefaultComboBoxContribution;
    }

    private LaunchCriteriaBuilder getLaunchCriteriaBuilderAction() {
        if (this.actLaunchCriteriaBuilder == null) {
            this.actLaunchCriteriaBuilder = new LaunchCriteriaBuilder(this);
            this.actLaunchCriteriaBuilder.setToolTipText(EDIT_BUTTON_TOOLTIP);
        }
        return this.actLaunchCriteriaBuilder;
    }

    private ClearCriteria getClearCriteriaBuilderAction() {
        if (this.actClearCriteria == null) {
            this.actClearCriteria = new ClearCriteria(this);
            this.actClearCriteria.setToolTipText(CLEAR_BUTTON_TOOLTIP);
        }
        return this.actClearCriteria;
    }

    private HideExcludedOptions getHideExcludedOptionsAction() {
        if (this.actHideExcludedOptions == null) {
            this.actHideExcludedOptions = new HideExcludedOptions(this);
            this.actHideExcludedOptions.setToolTipText(HIDE_CHECKBOX_TOOLTIP);
        }
        return this.actHideExcludedOptions;
    }

    public boolean canLaunchCriteriaBuilder() {
        return this.tvOptionTableViewer.getTable().getSelectionCount() > 0;
    }

    public void launchCriteriaBuilder() {
        MappingClass mc = this.mappingAdapter.getMappingClass(this.icoChoiceObject.getChoice());
        if (mc == null) {
            EObject parent = this.icoChoiceObject.getParent();
            while (parent != null && mc == null) {
                mc = this.mappingAdapter.getMappingClass(parent);
                parent = parent.eContainer();
            }
        }
        if (mc == null) {
            Shell shell = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
            MessageDialog.openError((Shell)shell, (String)NEED_MAPPING_CLASS_TITLE, (String)NEED_MAPPING_CLASS_MSG);
            return;
        }
        new BuilderTreeProvider();
        ElementViewerFactory.setCriteriaStrategy((ICriteriaStrategy)new ChoiceCriteriaStrategy());
        ArrayList<MappingClass> lstMappingClassWrapper = new ArrayList<MappingClass>(1);
        lstMappingClassWrapper.addAll(this.getParentMappingClasses(mc));
        lstMappingClassWrapper.add(mc);
        ElementViewerFactory.setViewerInput(lstMappingClassWrapper);
        CriteriaBuilder builder = this.getCriteriaBuilder();
        String sSql = this.icoChoiceObject.getSqlCriteria(this.getSelectedOption());
        if (sSql != null && !sSql.trim().equals("")) {
            builder.setLanguageObject((ILanguageObject)this.getCriteria(mc, sSql));
        } else {
            builder.setLanguageObject(null);
        }
        int status = builder.open();
        if (status == 0) {
            ILanguageObject newCriteria = builder.getLanguageObject();
            IQueryService queryService = ModelerCore.getTeiidQueryService();
            ISQLStringVisitor visitor = queryService.getSQLStringVisitor();
            String sqlCriteria = visitor.returnSQLString(newCriteria);
            newCriteria = this.getCriteria(mc, sqlCriteria);
            this.updateCriteriaForSelectedRow(sqlCriteria, newCriteria);
        }
        this.getLaunchCriteriaBuilderAction().selectionChanged();
    }

    private Collection getParentMappingClasses(MappingClass mappingClass) {
        List parentMappingClasses;
        if (this.mappingAdapter != null && (parentMappingClasses = this.mappingAdapter.getParentMappingClasses(mappingClass, this.mappableTree, false)) != null && !parentMappingClasses.isEmpty()) {
            return parentMappingClasses;
        }
        return Collections.EMPTY_LIST;
    }

    public void setMappingAdapters(TreeMappingAdapter adapter, IMappableTree tree) {
        this.mappingAdapter = adapter;
        this.mappableTree = tree;
        MappingClass mc = this.mappingAdapter.getMappingClass(this.icoChoiceObject.getChoice());
        if (mc == null) {
            EObject eParent = this.icoChoiceObject.getParent();
            while (eParent != null && mc == null) {
                mc = this.mappingAdapter.getMappingClass(eParent);
                eParent = eParent.eContainer();
            }
        }
        if (mc != null) {
            for (Object option : this.icoChoiceObject.getOrderedOptions()) {
                String criteriaText = this.icoChoiceObject.getCriteria(option);
                if (criteriaText == null || criteriaText.trim().length() == 0) continue;
                this.icoChoiceObject.setCriteria(option, criteriaText);
                this.icoChoiceObject.setSqlCriteria(option, criteriaText);
            }
            this.tvOptionTableViewer.refresh();
        }
    }

    private ICriteria getCriteria(MappingClass mappingClass, String theCriteria) {
        SqlTransformationMappingRoot mappingRoot = (SqlTransformationMappingRoot)TransformationHelper.getTransformationMappingRoot((EObject)mappingClass);
        TransformationValidator validator = new TransformationValidator(mappingRoot, false);
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        IQueryParser parser = queryService.getQueryParser();
        ICriteria crit = null;
        try {
            crit = parser.parseCriteria(theCriteria);
        }
        catch (Exception exception) {}
        IQueryMetadataInterface metadata = validator.getQueryMetadata();
        try {
            IResolverVisitor resolverVisitor = queryService.getResolverVisitor();
            resolverVisitor.resolveLanguageObject((ILanguageObject)crit, metadata);
        }
        catch (Exception exception) {}
        return crit;
    }

    private CriteriaBuilder getCriteriaBuilder() {
        Shell shell = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder(shell);
        criteriaBuilder.create();
        return criteriaBuilder;
    }

    public boolean canClearCriteria() {
        String criteria;
        Object option = this.getSelectedOption();
        if (option != null && (criteria = this.icoChoiceObject.getSqlCriteria(option)) != null) {
            return criteria.trim().length() > 0;
        }
        return false;
    }

    public Object getSelectedOption() {
        Object oOption = null;
        TableItem[] tiArray = this.tblOptionTable.getSelection();
        if (tiArray != null && tiArray.length > 0) {
            TableItem tiSelected = tiArray[0];
            TableRow trRow = (TableRow)tiSelected.getData();
            oOption = trRow.getOption();
        }
        return oOption;
    }

    public void clearCriteria() {
        this.updateCriteriaForSelectedRow("", null);
    }

    public void updateCriteriaForSelectedRow(String sCriteria, ILanguageObject criteria) {
        int iSelectedIndex = this.tvOptionTableViewer.getTable().getSelectionIndex();
        if (iSelectedIndex < 0) {
            iSelectedIndex = 0;
        }
        Object oOption = this.getOptionForTableIndex(iSelectedIndex);
        this.icoChoiceObject.setSqlCriteria(oOption, sCriteria);
        if (criteria != null) {
            this.icoChoiceObject.setCriteria(oOption, sCriteria);
        }
        this.tvOptionTableViewer.refresh();
        this.tvOptionTableViewer.getTable().setSelection(iSelectedIndex);
        this.refreshChoiceSummaryPanel();
        this.getClearCriteriaBuilderAction().selectionChanged();
    }

    public boolean canHideExcludedOptions() {
        return true;
    }

    public void hideExcludedOptions() {
        this.cvfExcludeFilter.setFilterActive(true);
        this.tvOptionTableViewer.refresh();
        this.setButtonStates();
    }

    public void showExcludedOptions() {
        this.cvfExcludeFilter.setFilterActive(false);
        this.tvOptionTableViewer.refresh();
        this.setButtonStates();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setButtonStates();
        this.getLaunchCriteriaBuilderAction().selectionChanged();
        this.getClearCriteriaBuilderAction().selectionChanged();
    }

    void setButtonStates() {
        ClearCriteria clearAction = this.getClearCriteriaBuilderAction();
        LaunchCriteriaBuilder builderAction = this.getLaunchCriteriaBuilderAction();
        if (ModelObjectUtilities.isReadOnly((EObject)this.getChoiceObject().getChoice())) {
            this.btnUp.setEnabled(false);
            this.btnDown.setEnabled(false);
            clearAction.setEnabled(false);
            builderAction.setEnabled(false);
            if (this.getComboBoxContributionForDefault().getControl() != null && !this.getComboBoxContributionForDefault().getControl().isDisposed()) {
                this.getComboBoxContributionForDefault().getControl().setEnabled(false);
            }
            this.tblOptionTable.setEnabled(false);
        } else {
            int iSelectedIndex = this.tvOptionTableViewer.getTable().getSelectionIndex();
            if (iSelectedIndex > -1) {
                this.btnUp.setEnabled(iSelectedIndex > 0);
                this.btnDown.setEnabled(iSelectedIndex < this.tvOptionTableViewer.getTable().getItemCount() - 1);
            } else {
                this.btnUp.setEnabled(false);
                this.btnDown.setEnabled(false);
            }
            clearAction.selectionChanged();
            builderAction.selectionChanged();
            if (this.getComboBoxContributionForDefault().getControl() != null && !this.getComboBoxContributionForDefault().getControl().isDisposed()) {
                this.getComboBoxContributionForDefault().getControl().setEnabled(true);
            }
            this.tblOptionTable.setEnabled(true);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        CTabItem tiCurrSelection;
        if (e.getSource() == this.tblOptionTable) {
            this.handleTableSelection();
        } else if (e.getSource() == this.tabFolder && (tiCurrSelection = this.tabFolder.getSelection()) != this.tiEditTab && tiCurrSelection == this.tiSummaryTab) {
            this.refreshChoiceSummaryPanel();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    void handleMouseEvent(MouseEvent theEvent) {
        if (this.icoChoiceObject == null) {
            return;
        }
        int selectedColumn = -1;
        int selectedRow = -1;
        TableItem[] selection = this.tblOptionTable.getSelection();
        if (selection.length > 0) {
            int numCols = this.tblOptionTable.getColumnCount();
            int i = 0;
            while (i < numCols) {
                Rectangle bounds = selection[0].getBounds(i);
                if (bounds.contains(theEvent.x, theEvent.y)) {
                    selectedColumn = i;
                    break;
                }
                ++i;
            }
            selectedRow = this.tblOptionTable.getSelectionIndex();
        }
        if (selectedColumn == 2) {
            TableItem[] tiArray = this.tblOptionTable.getSelection();
            TableItem tiSelected = tiArray[0];
            TableRow trRow = (TableRow)tiSelected.getData();
            Object oOption = trRow.getOption();
            if (this.icoChoiceObject.isIncluded(oOption)) {
                this.icoChoiceObject.setIncluded(oOption, false);
                if (this.icoChoiceObject.getDefaultOption() == oOption) {
                    this.icoChoiceObject.setDefaultOption(null);
                    this.getComboBoxContributionForDefault().getControl().clearSelection();
                }
            } else {
                this.icoChoiceObject.setIncluded(oOption, true);
            }
            this.getComboBoxContributionForDefault().loadItems();
        }
        this.tvOptionTableViewer.refresh();
        this.tvOptionTableViewer.getTable().setSelection(selectedRow);
        this.csvcViewerConfig.setReservedWords(this.getReservedWords());
        this.refreshChoiceSummaryPanel();
    }

    public class ChoiceViewerFilter
    extends ViewerFilter {
        private boolean bFilterActive = false;

        public void setFilterActive(boolean bFilterActive) {
            this.bFilterActive = bFilterActive;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof TableRow) {
                TableRow trRow = (TableRow)element;
                if (this.bFilterActive) {
                    return ChoicePanel.this.icoChoiceObject.isIncluded(trRow.getOption());
                }
                return true;
            }
            return true;
        }
    }

    class ComboContribution
    extends ControlContribution {
        Combo cbx;

        public ComboContribution() {
            super("myId");
            this.cbx = null;
        }

        protected Control createControl(Composite parent) {
            this.cbx = new Combo(parent, 2056);
            this.cbx.setToolTipText(DEFAULT_COMBOBOX_TOOLTIP);
            this.cbx.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ChoicePanel.this.defaultComboboxPressed();
                }
            });
            this.loadItems();
            return this.cbx;
        }

        public Combo getControl() {
            return this.cbx;
        }

        public void loadItems() {
            Combo cbx = ChoicePanel.this.getComboBoxContributionForDefault().getControl();
            if (cbx == null || cbx.isDisposed()) {
                return;
            }
            String sCurrentDefault = "";
            String sErrorMode = ChoicePanel.this.icoChoiceObject.getDefaultErrorMode();
            Object oOption = ChoicePanel.this.icoChoiceObject.getDefaultOption();
            String sDefaultOption = "";
            if (oOption != null) {
                TableRow tb = ChoicePanel.this.getRowForOption(oOption);
                sDefaultOption = tb != null ? ChoicePanel.this.getNameWithOrdinal(tb) : "";
            }
            sCurrentDefault = sDefaultOption != null && !sDefaultOption.equals("") ? sDefaultOption : (sErrorMode != null && !sErrorMode.equals("") ? sErrorMode : "");
            cbx.removeAll();
            this.loadIncludedOptions();
            this.loadErrorModeValues();
            int iCurrentIndex = -1;
            if (!sCurrentDefault.equals("")) {
                int i = 0;
                while (i < cbx.getItemCount()) {
                    if (cbx.getItem(i).equals(sCurrentDefault)) {
                        iCurrentIndex = i;
                        break;
                    }
                    ++i;
                }
            }
            if (iCurrentIndex != -1) {
                cbx.select(iCurrentIndex);
            }
        }

        private void loadIncludedOptions() {
            for (Object oOption : ChoicePanel.this.getIncludedOptions()) {
                this.cbx.add(ChoicePanel.this.getNameWithOrdinal(ChoicePanel.this.getRowForOption(oOption)));
            }
        }

        private void loadErrorModeValues() {
            String[] saErrorModeVals = ChoicePanel.this.icoChoiceObject.getValidErrorModeValues();
            int i = 0;
            while (i < saErrorModeVals.length) {
                this.cbx.add(saErrorModeVals[i]);
                ++i;
            }
        }

        public boolean isFoundInIncludedOptions(String s) {
            for (Object oOption : ChoicePanel.this.getIncludedOptions()) {
                if (!ChoicePanel.this.getNameWithOrdinal(ChoicePanel.this.getRowForOption(oOption)).equals(s)) continue;
                return true;
            }
            return false;
        }

        public boolean isFoundInErrorModeValues(String s) {
            String[] saErrorModeVals = ChoicePanel.this.icoChoiceObject.getValidErrorModeValues();
            int i = 0;
            while (i < saErrorModeVals.length) {
                if (saErrorModeVals[i].equals(s)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    class LabelContribution
    extends ControlContribution {
        Combo cbx;
        String sText;

        public LabelContribution(String sText) {
            super("myId");
            this.cbx = null;
            this.sText = sText;
        }

        protected Control createControl(Composite parent) {
            ChoicePanel.this.lblDefaultTitle = WidgetFactory.createLabel((Composite)parent, (int)32, (String)this.sText);
            return ChoicePanel.this.lblDefaultTitle;
        }
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        IChoiceObject icoChoiceObject;

        TableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object theInputElement) {
            this.icoChoiceObject = (IChoiceObject)theInputElement;
            Object[] result = null;
            List lstOptions = this.icoChoiceObject.getOrderedOptions();
            if (lstOptions != null && !lstOptions.isEmpty()) {
                int numRows = lstOptions.size();
                result = new Object[numRows];
                int iOrdinal = 0;
                int iOrdinalColContent = 0;
                int i = 0;
                while (i < numRows) {
                    Object oOption = lstOptions.get(i);
                    iOrdinalColContent = this.icoChoiceObject.isIncluded(oOption) ? ++iOrdinal : -1;
                    result[i] = new TableRow(oOption, iOrdinalColContent, ChoicePanel.this.getAdHocLabelProvider().getText(oOption), this.icoChoiceObject.isIncluded(oOption), this.icoChoiceObject.getSqlCriteria(oOption));
                    ++i;
                }
            }
            return lstOptions == null || lstOptions.isEmpty() ? new Object[]{} : result;
        }

        public void inputChanged(Viewer theViewer, Object theOldInput, Object theNewInput) {
            this.icoChoiceObject = (IChoiceObject)theNewInput;
            if (theNewInput != null) {
                theViewer.refresh();
            }
        }
    }

    class TableLabelProvider
    extends ModelExplorerLabelProvider
    implements ITableLabelProvider {
        Image imgCheckedCheckBox = org.teiid.designer.ui.common.UiPlugin.getDefault().getImage("icons/full/cview16/checked_box.png");
        Image imgUncheckedCheckBox = org.teiid.designer.ui.common.UiPlugin.getDefault().getImage("icons/full/cview16/unchecked_box.png");

        TableLabelProvider() {
        }

        public Image getColumnImage(Object theElement, int theIndex) {
            TableRow trRow = (TableRow)theElement;
            Image imgResult = null;
            switch (theIndex) {
                case 1: {
                    Object oOption = trRow.getOption();
                    imgResult = super.getImage(oOption);
                    break;
                }
                case 2: {
                    imgResult = trRow.isIncluded() ? this.imgCheckedCheckBox : this.imgUncheckedCheckBox;
                }
            }
            return imgResult;
        }

        public String getColumnText(Object theElement, int theColumnIndex) {
            TableRow row = (TableRow)theElement;
            return row.getColumnText(theColumnIndex);
        }
    }

    class TableRow {
        private Object oOption;
        private int iOrdinal;
        private String sOptionName;
        private boolean bIncludes;
        private String sCriteria;

        public TableRow(Object oOption, int iOrdinal, String sOptionName, boolean bIncludes, String sCriteria) {
            this.oOption = oOption;
            this.iOrdinal = iOrdinal;
            this.sOptionName = sOptionName;
            this.bIncludes = bIncludes;
            this.sCriteria = sCriteria;
        }

        public Object getOption() {
            return this.oOption;
        }

        public int getOrdinal() {
            return this.iOrdinal;
        }

        public String getOptionName() {
            return this.sOptionName;
        }

        public boolean isIncluded() {
            return this.bIncludes;
        }

        public String getCriteria() {
            return this.sCriteria;
        }

        public String getColumnText(int theIndex) {
            String result = "";
            switch (theIndex) {
                case 0: {
                    if (this.iOrdinal == -1) {
                        result = "";
                        break;
                    }
                    result = String.valueOf(this.iOrdinal);
                    break;
                }
                case 1: {
                    result = this.sOptionName;
                    break;
                }
                case 2: {
                    result = "";
                    break;
                }
                case 3: {
                    result = this.sCriteria;
                }
            }
            if (result == null) {
                result = "";
            }
            return result;
        }

        public Object getValue(int theIndex) {
            String result = "unknown";
            Object oResult = result;
            switch (theIndex) {
                case 0: {
                    oResult = new Integer(this.iOrdinal);
                    break;
                }
                case 1: {
                    oResult = this.sOptionName;
                    result = this.sOptionName;
                    break;
                }
                case 2: {
                    oResult = new Boolean(this.bIncludes);
                    break;
                }
                case 3: {
                    oResult = this.sCriteria;
                }
            }
            if (result == null) {
                result = "";
            }
            return oResult;
        }
    }
}

