/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.choice;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.teiid.designer.ui.common.graphics.ColorManager;
import org.teiid.query.ui.sqleditor.sql.SqlWhiteSpaceDetector;
import org.teiid.query.ui.sqleditor.sql.SqlWordDetector;

public class CriteriaCodeScanner
extends RuleBasedScanner {
    private List rules;
    private ColorManager colorManager;
    private List lstReservedWords;
    IToken keyword;
    IToken datatype;
    IToken function;
    IToken string;
    IToken comment;
    IToken other;

    public CriteriaCodeScanner(ColorManager colorManager, List lstReservedWords) {
        this.colorManager = colorManager;
        this.lstReservedWords = lstReservedWords;
        this.createTokens();
        this.setDefaultReturnToken(this.other);
        this.init();
    }

    private void init() {
        this.rules = new ArrayList();
        this.createStandardRules();
        this.createReservedWordRules();
        this.applyRules();
    }

    private void createStandardRules() {
        this.rules.add(new EndOfLineRule("//", this.comment));
        this.rules.add(new SingleLineRule("\"", "\"", this.string, '\\'));
        this.rules.add(new SingleLineRule("'", "'", this.string, '\\'));
        this.rules.add(new WhitespaceRule((IWhitespaceDetector)new SqlWhiteSpaceDetector()));
        WordRule wordRule = new WordRule((IWordDetector)new SqlWordDetector(), this.other);
        this.rules.add(wordRule);
    }

    private void createReservedWordRules() {
        WordRule wordRule = new WordRule((IWordDetector)new SqlWordDetector(), this.other);
        for (String sReservedWord : this.lstReservedWords) {
            wordRule.addWord(sReservedWord, this.keyword);
        }
        this.rules.add(wordRule);
    }

    private void applyRules() {
        IRule[] result = new IRule[this.rules.size()];
        this.rules.toArray(result);
        this.setRules(result);
    }

    public void setReservedWords(List lstReservedWords) {
        this.lstReservedWords = lstReservedWords;
        this.init();
    }

    public void createTokens() {
        this.keyword = new Token((Object)new TextAttribute(this.colorManager.getColor(ColorManager.KEYWORD), null, 1));
        this.datatype = new Token((Object)new TextAttribute(this.colorManager.getColor(ColorManager.DATATYPE), null, 1));
        this.function = new Token((Object)new TextAttribute(this.colorManager.getColor(ColorManager.FUNCTION), null, 1));
        this.string = new Token((Object)new TextAttribute(this.colorManager.getColor(ColorManager.STRING), null, 0));
        this.comment = new Token((Object)new TextAttribute(this.colorManager.getColor(ColorManager.SINGLE_LINE_COMMENT), null, 0));
        this.other = new Token((Object)new TextAttribute(this.colorManager.getColor(ColorManager.DEFAULT), null, 0));
    }
}

