/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.connection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.diagram.ui.connection.AnchorManager;
import org.teiid.designer.diagram.ui.connection.NodeConnectionAnchor;
import org.teiid.designer.diagram.ui.connection.NodeConnectionEditPart;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlClassifierNode;
import org.teiid.designer.diagram.ui.part.DiagramEditPart;
import org.teiid.designer.mapping.ui.model.MappingExtentNode;
import org.teiid.designer.mapping.ui.part.MappingDiagramEditPart;
import org.teiid.designer.mapping.ui.part.MappingExtentEditPart;
import org.teiid.designer.transformation.util.TransformationHelper;

public class MappingClassAnchorManager
implements AnchorManager {
    private List eastAnchors;
    private List westAnchors;
    private List southAnchors;
    private DiagramEditPart diagramEditPart;

    public MappingClassAnchorManager(DiagramEditPart diagramEditPart) {
        this.diagramEditPart = diagramEditPart;
        this.init();
    }

    private void init() {
    }

    private boolean isCoarse() {
        MappingDiagramEditPart diagramEP = (MappingDiagramEditPart)this.diagramEditPart.getParent();
        return diagramEP.isCoarseMapping();
    }

    private boolean isPrimary() {
        MappingDiagramEditPart diagramEP = (MappingDiagramEditPart)this.diagramEditPart.getParent();
        return diagramEP.isPrimary(this.diagramEditPart);
    }

    private boolean isInputSet() {
        EObject eObj;
        return !this.isCoarse() && TransformationHelper.isSqlInputSet((Object)(eObj = this.diagramEditPart.getModelObject()));
    }

    private List getEastAnchors() {
        return this.eastAnchors;
    }

    private List getWestAnchors() {
        return this.westAnchors;
    }

    private List getSouthAnchors() {
        return this.southAnchors;
    }

    private boolean addEastAnchor(NodeConnectionAnchor newAnchor) {
        if (this.eastAnchors == null) {
            this.eastAnchors = new ArrayList(1);
        }
        if (!this.containsEquivalentAnchor(this.eastAnchors, newAnchor)) {
            this.eastAnchors.add(newAnchor);
            return true;
        }
        return false;
    }

    private boolean addWestAnchor(NodeConnectionAnchor newAnchor) {
        if (this.westAnchors == null) {
            this.westAnchors = new ArrayList(1);
        }
        if (!this.containsEquivalentAnchor(this.westAnchors, newAnchor)) {
            this.westAnchors.add(newAnchor);
            return true;
        }
        return false;
    }

    private boolean addSouthAnchor(NodeConnectionAnchor newAnchor) {
        if (this.southAnchors == null) {
            this.southAnchors = new ArrayList(1);
        }
        if (!this.containsEquivalentAnchor(this.southAnchors, newAnchor)) {
            this.southAnchors.add(newAnchor);
            return true;
        }
        return false;
    }

    private boolean containsEquivalentAnchor(List list, NodeConnectionAnchor newAnchor) {
        if (this.eastAnchors == null) {
            this.eastAnchors = new ArrayList(1);
        }
        for (NodeConnectionAnchor ncaTemp : list) {
            if (!ncaTemp.equals((Object)newAnchor)) continue;
            return true;
        }
        return false;
    }

    public boolean add(NodeConnectionAnchor targetAnchor) {
        boolean added = false;
        if (targetAnchor.getDirection() == 1) {
            added = this.addEastAnchor(targetAnchor);
        } else if (targetAnchor.getDirection() == 3) {
            added = this.addWestAnchor(targetAnchor);
        } else if (targetAnchor.getDirection() == 2) {
            added = this.addSouthAnchor(targetAnchor);
        }
        return added;
    }

    public boolean move(NodeConnectionAnchor targetAnchor) {
        boolean removed = this.remove(targetAnchor);
        boolean added = this.add(targetAnchor);
        return removed && added;
    }

    public boolean remove(NodeConnectionAnchor targetAnchor) {
        boolean removed = false;
        if (targetAnchor.getDirection() != 1 && this.getEastAnchors() != null && this.getEastAnchors().contains(targetAnchor)) {
            this.getEastAnchors().remove(targetAnchor);
            removed = true;
        }
        if (targetAnchor.getDirection() != 3 && this.getWestAnchors() != null && this.getWestAnchors().contains(targetAnchor)) {
            this.getWestAnchors().remove(targetAnchor);
            removed = true;
        }
        if (targetAnchor.getDirection() != 2 && this.getSouthAnchors() != null && this.getSouthAnchors().contains(targetAnchor)) {
            this.getSouthAnchors().remove(targetAnchor);
            removed = true;
        }
        return removed;
    }

    public void resetSourceAnchors(boolean updateTargetEnd) {
        this.cleanUpAnchors();
        List sConnections = this.getSourceConnections();
        if (sConnections.isEmpty()) {
            return;
        }
        NodeConnectionEditPart nextConnection = null;
        Iterator iter = sConnections.iterator();
        DiagramEditPart targetEditPart = null;
        NodeConnectionAnchor sourceAnchor = null;
        while (iter.hasNext()) {
            nextConnection = (NodeConnectionEditPart)iter.next();
            sourceAnchor = (NodeConnectionAnchor)nextConnection.getSourceAnchor();
            targetEditPart = (DiagramEditPart)nextConnection.getTarget();
            if (targetEditPart == null) continue;
            this.setSourceAnchorPosition(sourceAnchor, targetEditPart);
            nextConnection.refresh();
            if (!updateTargetEnd) continue;
            targetEditPart.createOrUpdateAnchorsLocations(false);
        }
    }

    public void resetTargetAnchors(boolean updateSourceEnd) {
        this.cleanUpAnchors();
        List tConnections = this.getTargetConnections();
        if (tConnections.isEmpty()) {
            return;
        }
        NodeConnectionEditPart nextConnection = null;
        Iterator iter = tConnections.iterator();
        DiagramEditPart sourceEditPart = null;
        NodeConnectionAnchor targetAnchor = null;
        while (iter.hasNext()) {
            nextConnection = (NodeConnectionEditPart)iter.next();
            targetAnchor = (NodeConnectionAnchor)nextConnection.getTargetAnchor();
            sourceEditPart = (DiagramEditPart)nextConnection.getSource();
            if (sourceEditPart == null) continue;
            this.setAnchorPosition(targetAnchor, 1);
            nextConnection.refresh();
            if (!updateSourceEnd) continue;
            sourceEditPart.createOrUpdateAnchorsLocations(false);
        }
    }

    public List getSourceConnections() {
        return this.diagramEditPart.getSourceConnections();
    }

    public List getTargetConnections() {
        return this.diagramEditPart.getTargetConnections();
    }

    public ConnectionAnchor getSourceAnchor(NodeConnectionEditPart connection) {
        if (connection.getSourceAnchor() == null) {
            NodeConnectionAnchor newAnchor = this.createSourceAnchor();
            connection.setSourceAnchor((ConnectionAnchor)newAnchor);
            return newAnchor;
        }
        return connection.getSourceAnchor();
    }

    public ConnectionAnchor getTargetAnchor(NodeConnectionEditPart connection) {
        if (connection.getTargetAnchor() == null) {
            NodeConnectionAnchor newAnchor = this.createTargetAnchor();
            connection.setTargetAnchor((ConnectionAnchor)newAnchor);
            return newAnchor;
        }
        return connection.getTargetAnchor();
    }

    private NodeConnectionAnchor createTargetAnchor() {
        NodeConnectionAnchor newAnchor = new NodeConnectionAnchor(this.diagramEditPart.getFigure(), false);
        newAnchor.setDirection(1);
        this.add(newAnchor);
        return newAnchor;
    }

    private NodeConnectionAnchor createSourceAnchor() {
        NodeConnectionAnchor newAnchor = new NodeConnectionAnchor(this.diagramEditPart.getFigure(), true);
        newAnchor.setDirection(3);
        this.add(newAnchor);
        return newAnchor;
    }

    public boolean hasSourceAnchors() {
        NodeConnectionAnchor nextAnchor2 = null;
        Iterator iter = null;
        if (this.eastAnchors != null && !this.eastAnchors.isEmpty()) {
            for (NodeConnectionAnchor nextAnchor2 : this.eastAnchors) {
                if (nextAnchor2 == null || !nextAnchor2.isSource()) continue;
                return true;
            }
        }
        if (this.westAnchors != null && !this.westAnchors.isEmpty()) {
            for (NodeConnectionAnchor nextAnchor2 : this.westAnchors) {
                if (nextAnchor2 == null || !nextAnchor2.isSource()) continue;
                return true;
            }
        }
        if (this.southAnchors != null && !this.southAnchors.isEmpty()) {
            for (NodeConnectionAnchor nextAnchor2 : this.southAnchors) {
                if (nextAnchor2 == null || !nextAnchor2.isSource()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasTargetAnchors() {
        NodeConnectionAnchor nextAnchor2 = null;
        Iterator iter = null;
        if (this.eastAnchors != null && !this.eastAnchors.isEmpty()) {
            for (NodeConnectionAnchor nextAnchor2 : this.eastAnchors) {
                if (nextAnchor2 == null || nextAnchor2.isSource()) continue;
                return true;
            }
        }
        if (this.westAnchors != null && !this.westAnchors.isEmpty()) {
            for (NodeConnectionAnchor nextAnchor2 : this.westAnchors) {
                if (nextAnchor2 == null || nextAnchor2.isSource()) continue;
                return true;
            }
        }
        if (this.southAnchors != null && !this.southAnchors.isEmpty()) {
            for (NodeConnectionAnchor nextAnchor2 : this.southAnchors) {
                if (nextAnchor2 == null || nextAnchor2.isSource()) continue;
                return true;
            }
        }
        return false;
    }

    private int getAnchorListId(List anchors, NodeConnectionAnchor anchor) {
        int id = 0;
        Iterator iter = anchors.iterator();
        while (iter.hasNext()) {
            if (anchor.equals(iter.next())) break;
            ++id;
        }
        return id;
    }

    private int getAttributeYMidpoint(int id) {
        int yPosition = 0;
        UmlClassifierNode classifierNode = (UmlClassifierNode)this.diagramEditPart.getModel();
        if (classifierNode != null && classifierNode.getAttributesContainer() != null) {
            int containerY = classifierNode.getAttributesContainer().getY();
            List attributes = classifierNode.getAttributes();
            if (id < attributes.size()) {
                yPosition = ((DiagramModelNode)attributes.get(id)).getCenterY() + containerY;
            }
        }
        return yPosition;
    }

    private int getAttributeYMidpoint(EObject attributeEObject) {
        int yPosition = 0;
        UmlClassifierNode classifierNode = (UmlClassifierNode)this.diagramEditPart.getModel();
        if (classifierNode != null && classifierNode.getAttributesContainer() != null) {
            int containerY = classifierNode.getAttributesContainer().getY();
            DiagramModelNode attributeNode = this.getAttributeNode(attributeEObject);
            if (attributeNode != null) {
                yPosition = attributeNode.getCenterY() + containerY;
            }
        }
        return yPosition;
    }

    private DiagramModelNode getAttributeNode(EObject attributeEObject) {
        UmlClassifierNode classifierNode = (UmlClassifierNode)this.diagramEditPart.getModel();
        if (classifierNode != null && classifierNode.getAttributesContainer() != null) {
            Iterator iter = classifierNode.getAttributes().iterator();
            DiagramModelNode nextNode = null;
            while (iter.hasNext()) {
                nextNode = (DiagramModelNode)iter.next();
                if (nextNode.getModelObject() == null || nextNode.getModelObject() != attributeEObject) continue;
                return nextNode;
            }
        }
        return null;
    }

    public void setAnchorPosition(NodeConnectionAnchor theAnchor, int direction) {
        if (this.diagramEditPart.getModel() != null) {
            Dimension partSize = ((DiagramModelNode)this.diagramEditPart.getModel()).getSize();
            int oldDirection = theAnchor.getDirection();
            theAnchor.setDirection(direction);
            boolean moved = this.move(theAnchor);
            if (moved) {
                this.setAnchorPositions(oldDirection, direction);
            } else if (direction == 3) {
                if (!this.isCoarse()) {
                    if (this.isPrimary()) {
                        int anchorId = this.getAnchorListId(this.getWestAnchors(), theAnchor) + 1;
                        int vOffset = this.getAttributeYMidpoint(anchorId - 1);
                        theAnchor.setOffsetV(vOffset);
                        theAnchor.setOffsetH(0);
                    } else {
                        theAnchor.setOffsetH(0);
                        theAnchor.setOffsetV(partSize.height / 2);
                    }
                }
            } else {
                theAnchor.setOffsetH(partSize.width);
                theAnchor.setOffsetV(partSize.height / 2);
            }
        }
    }

    public void setSourceAnchorPosition(NodeConnectionAnchor theAnchor, DiagramEditPart targetEditPart) {
        if (this.diagramEditPart.getModel() != null) {
            Dimension partSize = ((DiagramModelNode)this.diagramEditPart.getModel()).getSize();
            theAnchor.setDirection(3);
            if (!this.isCoarse()) {
                if (this.isPrimary() && targetEditPart instanceof MappingExtentEditPart) {
                    EObject targetEObject = ((MappingExtentNode)((Object)targetEditPart.getModel())).getExtent().getMappingReference();
                    int vOffset = this.getAttributeYMidpoint(targetEObject);
                    theAnchor.setOffsetV(vOffset);
                    theAnchor.setOffsetH(0);
                } else if (this.isInputSet()) {
                    theAnchor.setDirection(2);
                    theAnchor.setOffsetH(partSize.width / 2);
                    theAnchor.setOffsetV(partSize.height);
                } else {
                    theAnchor.setOffsetH(0);
                    theAnchor.setOffsetV(partSize.height / 2);
                }
            }
        }
    }

    private void setAnchorPositions(int oldDirection, int newDirection) {
        this.setAnchorPositions(oldDirection);
        this.setAnchorPositions(newDirection);
    }

    private void setAnchorPositions(int direction) {
        block3: {
            Iterator iter;
            Dimension partSize;
            block5: {
                block4: {
                    if (this.diagramEditPart.getModel() == null) break block3;
                    partSize = ((DiagramModelNode)this.diagramEditPart.getModel()).getSize();
                    iter = null;
                    if (direction != 3 || this.getWestAnchors() == null || this.getWestAnchors().isEmpty()) break block4;
                    iter = this.getWestAnchors().iterator();
                    NodeConnectionAnchor theAnchor = null;
                    while (iter.hasNext()) {
                        theAnchor = (NodeConnectionAnchor)iter.next();
                        theAnchor.setOffsetH(0);
                        theAnchor.setOffsetV(0);
                    }
                    break block3;
                }
                if (this.getEastAnchors() == null || this.getEastAnchors().isEmpty()) break block5;
                iter = this.getEastAnchors().iterator();
                NodeConnectionAnchor theAnchor = null;
                while (iter.hasNext()) {
                    theAnchor = (NodeConnectionAnchor)iter.next();
                    theAnchor.setOffsetH(partSize.width);
                    theAnchor.setOffsetV(partSize.height / 2);
                }
                break block3;
            }
            if (this.getSouthAnchors() == null || this.getSouthAnchors().isEmpty()) break block3;
            iter = this.getSouthAnchors().iterator();
            NodeConnectionAnchor theAnchor = null;
            while (iter.hasNext()) {
                theAnchor = (NodeConnectionAnchor)iter.next();
                theAnchor.setOffsetH(partSize.width / 2);
                theAnchor.setOffsetV(partSize.height);
            }
        }
    }

    private void cleanUpAnchors() {
        NodeConnectionEditPart nextConnection2;
        List sConnections = this.getSourceConnections();
        List tConnections = this.getTargetConnections();
        ArrayList<ConnectionAnchor> connectionAnchors = new ArrayList<ConnectionAnchor>(sConnections.size() + tConnections.size());
        if (sConnections.isEmpty()) {
            if (this.westAnchors != null) {
                this.westAnchors.clear();
            }
            if (this.southAnchors != null) {
                this.southAnchors.clear();
            }
        } else {
            nextConnection2 = null;
            for (NodeConnectionEditPart nextConnection2 : sConnections) {
                if (nextConnection2.getSourceAnchor() == null) continue;
                connectionAnchors.add(nextConnection2.getSourceAnchor());
            }
        }
        if (tConnections.isEmpty()) {
            if (this.eastAnchors != null) {
                this.eastAnchors.clear();
            }
        } else {
            nextConnection2 = null;
            for (NodeConnectionEditPart nextConnection2 : tConnections) {
                if (nextConnection2.getTargetAnchor() == null) continue;
                connectionAnchors.add(nextConnection2.getTargetAnchor());
            }
        }
        if (!connectionAnchors.isEmpty()) {
            ArrayList<NodeConnectionAnchor> staleAnchors = new ArrayList<NodeConnectionAnchor>();
            Iterator iter = null;
            NodeConnectionAnchor nextAnchor2 = null;
            if (this.westAnchors != null) {
                for (NodeConnectionAnchor nextAnchor2 : this.westAnchors) {
                    if (connectionAnchors.contains(nextAnchor2)) continue;
                    staleAnchors.add(nextAnchor2);
                }
            }
            if (this.eastAnchors != null) {
                for (NodeConnectionAnchor nextAnchor2 : this.eastAnchors) {
                    if (connectionAnchors.contains(nextAnchor2)) continue;
                    staleAnchors.add(nextAnchor2);
                }
            }
            if (this.southAnchors != null) {
                for (NodeConnectionAnchor nextAnchor2 : this.southAnchors) {
                    if (connectionAnchors.contains(nextAnchor2)) continue;
                    staleAnchors.add(nextAnchor2);
                }
            }
            if (!staleAnchors.isEmpty()) {
                for (NodeConnectionAnchor nextAnchor2 : staleAnchors) {
                    if (this.westAnchors != null) {
                        this.westAnchors.remove(nextAnchor2);
                    }
                    if (this.eastAnchors != null) {
                        this.eastAnchors.remove(nextAnchor2);
                    }
                    if (this.southAnchors == null) continue;
                    this.southAnchors.remove(nextAnchor2);
                }
            }
        }
    }

    public void reorderAllAnchors(boolean updateBothEnds) {
        this.resetSourceAnchors(updateBothEnds);
        this.resetTargetAnchors(updateBothEnds);
    }
}

