/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.diagram;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.swt.widgets.Display;
import org.teiid.designer.core.metamodel.aspect.MetamodelAspect;
import org.teiid.designer.core.metamodel.aspect.uml.UmlClassifier;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.diagram.ui.editor.DiagramEditorUtil;
import org.teiid.designer.diagram.ui.editor.DiagramSelectionHandler;
import org.teiid.designer.diagram.ui.editor.DiagramViewer;
import org.teiid.designer.diagram.ui.notation.uml.part.UmlAttributeEditPart;
import org.teiid.designer.diagram.ui.notation.uml.part.UmlClassifierEditPart;
import org.teiid.designer.diagram.ui.part.DiagramEditPart;
import org.teiid.designer.diagram.ui.part.EditableEditPart;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.mapping.ui.UiConstants;
import org.teiid.designer.mapping.ui.actions.MappingObjectEditHelper;
import org.teiid.designer.mapping.ui.diagram.MappingDiagramProvider;
import org.teiid.designer.mapping.ui.editor.MappingDiagramController;
import org.teiid.designer.mapping.ui.part.MappingExtentEditPart;
import org.teiid.designer.mapping.ui.part.MappingLinkEditPart;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.transformation.InputSet;
import org.teiid.designer.metamodels.transformation.MappingClassColumn;
import org.teiid.designer.metamodels.transformation.TransformationMappingRoot;
import org.teiid.designer.metamodels.transformation.impl.MappingClassImpl;
import org.teiid.designer.metamodels.xml.XmlAttribute;
import org.teiid.designer.metamodels.xml.XmlElement;
import org.teiid.designer.transformation.ui.part.TransformationEditPart;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class MappingDiagramSelectionHandler
extends DiagramSelectionHandler {
    private MappingObjectEditHelper editHelper = new MappingObjectEditHelper();
    private MappingDiagramProvider diagramProvider = new MappingDiagramProvider();

    public MappingDiagramSelectionHandler(DiagramViewer viewer) {
        super(viewer);
    }

    public void select(EObject selectedObject) {
        super.deselectAll();
        super.select(selectedObject);
        this.hiliteDependenciesForTreeSelection(selectedObject);
    }

    public void select(List selectedEObjects) {
        this.clearDependencyHilites();
        super.select(selectedEObjects);
    }

    public List getSelectedEObjects() {
        ArrayList<EObject> selectedEObjects = new ArrayList<EObject>();
        Iterator iter = this.getViewer().getSelectedEditParts().iterator();
        Object obj = null;
        EObject nextEObject = null;
        while (iter.hasNext()) {
            obj = iter.next();
            if (!(obj instanceof DiagramEditPart)) continue;
            DiagramEditPart dep = obj;
            nextEObject = null;
            nextEObject = dep.getModelObject();
            if (nextEObject == null || selectedEObjects.contains(nextEObject)) continue;
            selectedEObjects.add(nextEObject);
        }
        return selectedEObjects;
    }

    public void hiliteDependencies(Object selectedObject) {
        this.clearDependencyHilites();
        EObject selectedEObject = null;
        EditPart selectedPart = null;
        if (selectedObject != null && selectedObject instanceof EObject) {
            selectedEObject = (EObject)selectedObject;
            selectedPart = this.findEditPart(selectedEObject, false);
            if (selectedPart != null && selectedPart instanceof DiagramEditPart) {
                if (selectedPart instanceof UmlClassifierEditPart) {
                    List sConnectionEditParts = ((DiagramEditPart)selectedPart).getSourceConnections();
                    Iterator sIter = sConnectionEditParts.iterator();
                    MappingLinkEditPart nextMLEP = null;
                    Object nextObj = null;
                    while (sIter.hasNext()) {
                        nextObj = sIter.next();
                        if (!(nextObj instanceof MappingLinkEditPart)) continue;
                        nextMLEP = nextObj;
                        ((DiagramEditPart)nextMLEP.getTarget()).hiliteBackground(UiConstants.Colors.DEPENDENCY);
                    }
                } else if (selectedPart instanceof MappingExtentEditPart) {
                    if (this.getDiagramType().equals("mappingDiagramType")) {
                        List tConnectionEditParts = ((DiagramEditPart)selectedPart).getTargetConnections();
                        Iterator tIter = tConnectionEditParts.iterator();
                        MappingLinkEditPart nextMLEP = null;
                        Object nextObj = null;
                        int iEditPartsProcessed = 0;
                        while (tIter.hasNext()) {
                            nextObj = tIter.next();
                            if (!(nextObj instanceof MappingLinkEditPart)) continue;
                            nextMLEP = nextObj;
                            ((DiagramEditPart)nextMLEP.getSource()).hiliteBackground(UiConstants.Colors.DEPENDENCY);
                            if (++iEditPartsProcessed >= 2) continue;
                            this.getViewer().reveal(nextMLEP.getSource());
                        }
                    } else {
                        MappingClassColumn selectedColumn = ((MappingDiagramController)this.getViewer().getEditor().getDiagramController()).getMappingAdapter().getMappingClassColumn((EObject)selectedObject);
                        if (selectedColumn != null && (selectedPart = this.findEditPart((EObject)selectedColumn, false)) != null) {
                            ((DiagramEditPart)selectedPart).hiliteBackground(UiConstants.Colors.DEPENDENCY);
                            DiagramEditPart dep = DiagramUiUtilities.getClassifierParent((DiagramEditPart)((DiagramEditPart)selectedPart));
                            if (dep != null) {
                                this.getViewer().reveal((EditPart)dep);
                            }
                        }
                    }
                } else if (selectedPart instanceof UmlAttributeEditPart && this.getDiagramType().equals("mappingTransformationDiagramType")) {
                    super.hiliteDependencies(selectedObject);
                    TransformationMappingRoot tmr = null;
                    Diagram detailedDiagram = this.getViewer().getEditor().getDiagram();
                    if (detailedDiagram != null) {
                        EObject virtualGroup = detailedDiagram.getTarget();
                        tmr = (TransformationMappingRoot)TransformationHelper.getTransformationMappingRoot((EObject)virtualGroup);
                        ArrayList allDependencies = new ArrayList();
                        if (ModelObjectUtilities.isVirtual((EObject)selectedEObject)) {
                            allDependencies.addAll(TransformationHelper.getSourceAttributesForTargetAttr((Object)selectedObject, (Object)tmr));
                        }
                        allDependencies.addAll(TransformationHelper.getTargetAttributesForSourceAttr((Object)selectedObject, (Object)tmr));
                        Iterator iter = allDependencies.iterator();
                        EditPart nextEP = null;
                        EObject nextEObject = null;
                        while (iter.hasNext()) {
                            nextEObject = (EObject)iter.next();
                            nextEP = this.findEditPart(nextEObject, false);
                            if (nextEP == null || !(nextEP instanceof DiagramEditPart)) continue;
                            ((DiagramEditPart)nextEP).hiliteBackground(UiConstants.Colors.DEPENDENCY);
                        }
                    }
                } else {
                    super.hiliteDependencies(selectedObject);
                }
            } else {
                MappingClassColumn selectedColumn = ((MappingDiagramController)this.getViewer().getEditor().getDiagramController()).getMappingAdapter().getMappingClassColumn((EObject)selectedObject);
                if (selectedColumn != null && (selectedPart = this.findEditPart((EObject)selectedColumn, false)) != null) {
                    ((DiagramEditPart)selectedPart).hiliteBackground(UiConstants.Colors.DEPENDENCY);
                    DiagramEditPart dep = DiagramUiUtilities.getClassifierParent((DiagramEditPart)((DiagramEditPart)selectedPart));
                    if (dep != null) {
                        this.getViewer().reveal((EditPart)dep);
                    }
                }
            }
        }
    }

    public void hiliteDependenciesForTreeSelection(Object selectedObject) {
        MappingClassColumn selectedColumn;
        this.clearDependencyHilites();
        EditPart selectedPart = null;
        if (selectedObject != null && selectedObject instanceof EObject && (selectedObject instanceof XmlElement || selectedObject instanceof XmlAttribute) && (selectedColumn = ((MappingDiagramController)this.getViewer().getEditor().getDiagramController()).getMappingAdapter().getMappingClassColumn((EObject)selectedObject)) != null && (selectedPart = this.findEditPart((EObject)selectedColumn, false)) != null) {
            ((DiagramEditPart)selectedPart).hiliteBackground(UiConstants.Colors.DEPENDENCY);
            DiagramEditPart dep = DiagramUiUtilities.getClassifierParent((DiagramEditPart)((DiagramEditPart)selectedPart));
            if (dep != null) {
                this.getViewer().reveal((EditPart)dep);
            }
            return;
        }
    }

    public boolean handleDoubleClick(final EObject selectedObject) {
        boolean handledHere = false;
        MappingDiagramController controller = (MappingDiagramController)this.getViewer().getEditor().getDiagramController();
        if (controller != null && controller.getMappingType() == 0) {
            MetamodelAspect aspect;
            final EditPart selectedEP = this.findEditPart(selectedObject, false);
            if (selectedEP != null && ModelObjectUtilities.isVirtual((EObject)selectedObject) && (aspect = DiagramUiPlugin.getDiagramAspectManager().getUmlAspect(selectedObject)) instanceof UmlClassifier) {
                boolean navigateToDetailedDiagram = true;
                if (selectedEP instanceof UmlClassifierEditPart && ((UmlClassifierEditPart)selectedEP).doubleClickedName()) {
                    navigateToDetailedDiagram = false;
                }
                if (!navigateToDetailedDiagram) {
                    ((EditableEditPart)selectedEP).edit();
                    handledHere = true;
                } else {
                    final Diagram detailedDiagram = this.getDetailedMappingDiagram(selectedObject);
                    if (detailedDiagram != null) {
                        if (this.getViewer().getEditor().canOpenContext((Object)detailedDiagram)) {
                            UiBusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    if (selectedEP instanceof EditableEditPart) {
                                        DiagramEditor editor;
                                        ((EditableEditPart)selectedEP).edit();
                                        if (selectedEP instanceof UmlClassifierEditPart) {
                                            MappingDiagramController controller = (MappingDiagramController)MappingDiagramSelectionHandler.this.getViewer().getEditor().getDiagramController();
                                            UmlClassifierEditPart ucep = (UmlClassifierEditPart)selectedEP;
                                            MappingClassImpl mci = (MappingClassImpl)ucep.getModelObject();
                                            EList elst = mci.getColumns();
                                            controller.notifyElementsRevealed(ucep, (List)elst);
                                        }
                                        if ((editor = DiagramEditorUtil.getVisibleDiagramEditor()) != null && editor.getCurrentModel() != null) {
                                            editor.doRefreshDiagram();
                                            editor.getDiagramViewer().setFocus(selectedEP);
                                        }
                                    } else {
                                        MappingDiagramSelectionHandler.this.getViewer().getEditor().openContext((Object)detailedDiagram);
                                    }
                                    MappingDiagramSelectionHandler.this.select(selectedObject);
                                }
                            });
                        }
                        handledHere = true;
                    }
                }
            }
        } else if (controller != null && controller.getMappingType() == 1) {
            ModelResource modelResource = ModelUtilities.getModelResourceForModelObject((EObject)controller.getDocumentEObject());
            EditPart selectedEP = this.findEditPart(selectedObject, false);
            if (selectedEP != null && selectedEP instanceof EditableEditPart && this.editHelper.canEdit(selectedObject, modelResource)) {
                ((EditableEditPart)selectedEP).edit();
                handledHere = true;
            } else if (ModelObjectUtilities.isVirtual((EObject)selectedObject) && ModelUtilities.areModelResourcesSame((EObject)selectedObject, (EObject)controller.getCurrentDiagram())) {
                final Diagram detailedDiagram = this.getDetailedMappingDiagram(selectedObject);
                if (detailedDiagram != null && detailedDiagram != this.getViewer().getEditor().getDiagram() && this.getViewer().getEditor().canOpenContext((Object)detailedDiagram)) {
                    UiBusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MappingDiagramSelectionHandler.this.getViewer().getEditor().openContext((Object)detailedDiagram);
                            MappingDiagramSelectionHandler.this.select(selectedObject);
                        }
                    });
                }
                handledHere = true;
            } else {
                ModelEditorManager.open((EObject)selectedObject, (boolean)true);
                handledHere = true;
            }
        } else if (controller != null) {
            EditPart selectedEP = this.findEditPart(selectedObject, false);
            if (selectedEP != null && selectedEP instanceof TransformationEditPart && selectedEP instanceof EditableEditPart) {
                ((EditableEditPart)selectedEP).edit();
                handledHere = true;
            } else if (ModelObjectUtilities.isVirtual((EObject)selectedObject) && selectedEP != null && (selectedEP instanceof UmlClassifierEditPart || selectedObject instanceof InputSet) && ModelEditorManager.canEdit((EObject)selectedObject)) {
                UiBusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ModelEditorManager.edit((EObject)selectedObject);
                    }
                });
                handledHere = true;
            }
        }
        return handledHere;
    }

    private Diagram getDetailedMappingDiagram(EObject targetEObject) {
        return this.diagramProvider.getDetailedMappingDiagram(targetEObject);
    }

    public boolean shouldReveal(EObject eObject) {
        return TransformationHelper.isSqlTable((Object)eObject);
    }
}

