/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.diagram;

import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.diagram.ui.AbstractDiagramType;
import org.teiid.designer.diagram.ui.editor.CanOpenContextException;
import org.teiid.designer.diagram.ui.editor.DiagramController;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.diagram.ui.editor.DiagramViewer;
import org.teiid.designer.diagram.ui.editor.IDiagramActionAdapter;
import org.teiid.designer.diagram.ui.editor.IDiagramSelectionHandler;
import org.teiid.designer.diagram.ui.figure.DiagramFigureFactory;
import org.teiid.designer.diagram.ui.model.DiagramModelFactory;
import org.teiid.designer.diagram.ui.notation.uml.model.IClassifierContentAdapter;
import org.teiid.designer.diagram.ui.pakkage.IPackageDiagramProvider;
import org.teiid.designer.diagram.ui.part.DiagramEditPartFactory;
import org.teiid.designer.diagram.ui.preferences.DiagramColorObject;
import org.teiid.designer.diagram.ui.util.colors.ColorPaletteManager;
import org.teiid.designer.mapping.ui.UiConstants;
import org.teiid.designer.mapping.ui.actions.MappingDiagramActionAdapter;
import org.teiid.designer.mapping.ui.diagram.MappingClassContentAdapter;
import org.teiid.designer.mapping.ui.diagram.MappingDiagramProvider;
import org.teiid.designer.mapping.ui.diagram.MappingDiagramSelectionHandler;
import org.teiid.designer.mapping.ui.diagram.MappingDiagramUtil;
import org.teiid.designer.mapping.ui.editor.MappingDiagramController;
import org.teiid.designer.mapping.ui.figure.MappingColorPaletteManager;
import org.teiid.designer.mapping.ui.figure.MappingDiagramFigureFactory;
import org.teiid.designer.mapping.ui.model.MappingDiagramModelFactory;
import org.teiid.designer.mapping.ui.part.MappingDiagramPartFactory;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.StagingTable;
import org.teiid.designer.metamodels.transformation.TreeMappingRoot;
import org.teiid.designer.metamodels.xml.XmlDocument;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.editors.ModelEditorPage;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class MappingDiagramType
extends AbstractDiagramType {
    private static DiagramEditPartFactory editPartFactory;
    private static DiagramModelFactory modelFactory;
    private static DiagramFigureFactory figureFactory;
    private static ColorPaletteManager colorPaletteManager;
    private static DiagramColorObject bkgdColorObject;
    private static IPackageDiagramProvider mappingDiagramProvider;
    private static final String CANT_OPEN_MESSAGE = "Cannot Open Transformation.\n\nModel is read-only and must be writable for underlying \ntransformation to be constructed and displayed.\n";

    public DiagramEditPartFactory getEditPartFactory() {
        if (editPartFactory == null) {
            editPartFactory = new MappingDiagramPartFactory();
        }
        return editPartFactory;
    }

    public DiagramFigureFactory getFigureFactory() {
        if (figureFactory == null) {
            figureFactory = new MappingDiagramFigureFactory();
        }
        return figureFactory;
    }

    public DiagramModelFactory getModelFactory() {
        if (modelFactory == null) {
            modelFactory = new MappingDiagramModelFactory();
        }
        return modelFactory;
    }

    public IDiagramActionAdapter getActionAdapter(ModelEditorPage editor) {
        return new MappingDiagramActionAdapter(editor);
    }

    public String getDisplayName() {
        return UiConstants.Util.getString("DiagramNames.mappingDiagram", new Object[0]);
    }

    public IDiagramSelectionHandler getSelectionHandler(DiagramViewer viewer) {
        MappingDiagramSelectionHandler handler = new MappingDiagramSelectionHandler(viewer);
        return handler;
    }

    public DiagramController getDiagramController(DiagramEditor editor) {
        MappingDiagramController controller = new MappingDiagramController(editor);
        return controller;
    }

    public ColorPaletteManager getColorPaletteManager() {
        if (colorPaletteManager == null) {
            colorPaletteManager = new MappingColorPaletteManager();
        }
        return colorPaletteManager;
    }

    public Class getDiagramControllerClass() {
        return MappingDiagramController.class;
    }

    public boolean canOpenContext(Object input) throws CanOpenContextException {
        boolean canOpen = false;
        boolean readOnlyFailure = false;
        if (input instanceof EObject) {
            EObject eObj = (EObject)input;
            boolean eObjectIsStale = ModelObjectUtilities.isStale((EObject)eObj);
            if (eObj instanceof Diagram && ((Diagram)eObj).getType() != null) {
                EObject virtualGroupEObject;
                if (((Diagram)eObj).getType().equals("mappingDiagramType")) {
                    EObject targetEObj = ((Diagram)eObj).getTarget();
                    if (targetEObj != null && !ModelObjectUtilities.isStale((EObject)targetEObj)) {
                        canOpen = true;
                    }
                } else if (((Diagram)eObj).getType().equals("mappingTransformationDiagramType") && (virtualGroupEObject = ((Diagram)eObj).getTarget()) != null && TransformationHelper.isVirtual((Object)virtualGroupEObject) && !ModelObjectUtilities.isStale((EObject)virtualGroupEObject)) {
                    EObject transformation = TransformationHelper.getTransformationMappingRoot((EObject)virtualGroupEObject);
                    if (transformation != null) {
                        canOpen = true;
                    } else if (!ModelObjectUtilities.isReadOnly((EObject)virtualGroupEObject)) {
                        canOpen = true;
                    } else {
                        readOnlyFailure = true;
                    }
                }
            } else if (!eObjectIsStale) {
                if (MappingDiagramUtil.isMappingSqlTable(eObj)) {
                    EObject transformation = TransformationHelper.getTransformationMappingRoot((EObject)eObj);
                    if (transformation != null) {
                        canOpen = true;
                    } else if (!ModelObjectUtilities.isReadOnly((EObject)eObj)) {
                        canOpen = true;
                    } else {
                        readOnlyFailure = true;
                    }
                } else if (MappingDiagramUtil.isMappingDocument(eObj)) {
                    canOpen = true;
                } else if (MappingDiagramUtil.isInputSet(eObj)) {
                    canOpen = true;
                } else if (MappingDiagramUtil.hasMappingDocument(eObj)) {
                    canOpen = true;
                } else if (MappingDiagramUtil.isTreeMappingRoot(eObj)) {
                    canOpen = true;
                } else if (TransformationHelper.isSqlTransformationMappingRoot((Object)eObj)) {
                    EObject virtualGroup = TransformationHelper.getTransformationLinkTarget((EObject)eObj);
                    if (virtualGroup instanceof StagingTable || virtualGroup instanceof MappingClass) {
                        canOpen = true;
                    }
                } else {
                    EObject container = eObj.eContainer();
                    if (MappingDiagramUtil.isInputSet(container) || MappingDiagramUtil.isMappingClassColumn(eObj)) {
                        canOpen = true;
                    }
                }
            }
        }
        if (!canOpen && readOnlyFailure) {
            throw new CanOpenContextException(CANT_OPEN_MESSAGE);
        }
        return canOpen;
    }

    public Diagram getDiagramForContext(Object input) {
        EObject virtualGroup;
        Diagram mappingDiagram = null;
        if (input instanceof Diagram && ((Diagram)input).getType() != null && (((Diagram)input).getType().equals("mappingDiagramType") || ((Diagram)input).getType().equals("mappingTransformationDiagramType"))) {
            mappingDiagram = (Diagram)input;
        } else if (MappingDiagramUtil.isMappingSqlTable(input)) {
            mappingDiagram = ((MappingDiagramProvider)this.getPackageDiagramProvider()).getDetailedMappingDiagram((EObject)input);
        } else if (MappingDiagramUtil.isInputSet(input)) {
            EObject eoContainer = ((EObject)input).eContainer();
            if (eoContainer != null) {
                mappingDiagram = ((MappingDiagramProvider)this.getPackageDiagramProvider()).getDetailedMappingDiagram(eoContainer);
            }
        } else if (MappingDiagramUtil.isMappingDocument(input)) {
            mappingDiagram = this.getPackageDiagramProvider().getPackageDiagram(input, true);
        } else if (MappingDiagramUtil.hasMappingDocument(input)) {
            EObject thePackage = MappingDiagramUtil.getMappingDocument(input);
            if (thePackage != null) {
                mappingDiagram = this.getPackageDiagramProvider().getPackageDiagram((Object)thePackage, true);
            }
        } else if (MappingDiagramUtil.isInputSetParameter(input) || MappingDiagramUtil.isMappingClassColumn(input)) {
            EObject container = ((EObject)input).eContainer();
            if (MappingDiagramUtil.isInputSet(container)) {
                EObject eoContainer = container.eContainer();
                if (eoContainer != null) {
                    mappingDiagram = ((MappingDiagramProvider)this.getPackageDiagramProvider()).getDetailedMappingDiagram(eoContainer);
                }
            } else if (MappingDiagramUtil.isMappingSqlTable(container)) {
                mappingDiagram = ((MappingDiagramProvider)this.getPackageDiagramProvider()).getDetailedMappingDiagram(container);
            }
        } else if (MappingDiagramUtil.isTreeMappingRoot(input)) {
            EObject targ = ((TreeMappingRoot)input).getTarget();
            mappingDiagram = this.getPackageDiagramProvider().getPackageDiagram((Object)targ, true);
        } else if (TransformationHelper.isSqlTransformationMappingRoot((Object)input) && ((virtualGroup = TransformationHelper.getTransformationLinkTarget((EObject)((EObject)input))) instanceof StagingTable || virtualGroup instanceof MappingClass)) {
            mappingDiagram = ((MappingDiagramProvider)this.getPackageDiagramProvider()).getDetailedMappingDiagram(virtualGroup);
        }
        return mappingDiagram;
    }

    public IClassifierContentAdapter getClassifierContentAdapter() {
        return new MappingClassContentAdapter();
    }

    public IPackageDiagramProvider getPackageDiagramProvider() {
        if (mappingDiagramProvider == null) {
            mappingDiagramProvider = new MappingDiagramProvider();
        }
        return mappingDiagramProvider;
    }

    public DiagramColorObject getBackgroundColorObject(String extensionID) {
        if (bkgdColorObject == null) {
            bkgdColorObject = new DiagramColorObject(this.getDisplayName(), "modeler.preference.diagram.mapping.backgroundcolor");
        }
        if (extensionID.equals("mappingDiagramType")) {
            return bkgdColorObject;
        }
        return null;
    }

    public Diagram getDiagramForGoToMarkerEObject(EObject eObject) {
        return this.getDiagramForContext(eObject);
    }

    public String getDisplayedPath(Diagram diagram, EObject eObject) {
        String path = null;
        if (diagram.getType() != null && diagram.getType().equals("mappingTransformationDiagramType") && (diagram.getTarget() == null || !diagram.getTarget().equals(eObject))) {
            path = !ModelUtilities.areModelResourcesSame((EObject)diagram, (EObject)eObject) ? ModelObjectUtilities.getTrimmedFullPath((EObject)eObject) : ModelObjectUtilities.getTrimmedRelativePath((EObject)eObject);
        }
        return path;
    }

    public boolean isTransientDiagram(Diagram diagram) {
        EObject target = diagram.getTarget();
        if (MappingDiagramUtil.isStagingTable(target)) {
            return true;
        }
        return target instanceof XmlDocument;
    }

    public EObject getRevealedEObject(Diagram diagram, Object object) {
        if (diagram.getType() != null && diagram.getType().equals("mappingTransformationDiagramType")) {
            return diagram.getTarget();
        }
        return null;
    }
}

