/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.diagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.diagram.ui.editor.DiagramEditorUtil;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlClassifierNode;
import org.teiid.designer.diagram.ui.part.DiagramEditPart;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.mapping.factory.ModelMapperFactory;
import org.teiid.designer.mapping.ui.UiConstants;
import org.teiid.designer.mapping.ui.editor.MappingAdapterFilter;
import org.teiid.designer.mapping.ui.editor.MappingDiagramBehavior;
import org.teiid.designer.mapping.ui.editor.MappingDiagramController;
import org.teiid.designer.mapping.ui.figure.MappingExtentFigure;
import org.teiid.designer.mapping.ui.model.MappingExtentNode;
import org.teiid.designer.mapping.ui.part.MappingDiagramEditPart;
import org.teiid.designer.mapping.ui.part.MappingExtentEditPart;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.transformation.InputSet;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.MappingClassColumn;
import org.teiid.designer.metamodels.transformation.MappingClassSet;
import org.teiid.designer.metamodels.transformation.StagingTable;
import org.teiid.designer.metamodels.transformation.TreeMappingRoot;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.xsd.util.ModelerXsdUtils;

public class MappingDiagramUtil {
    public static Diagram getCoarseMappingDiagram(EObject documentTreeRootEObject) {
        Iterator iter = null;
        ModelResource modelResource = ModelUtilities.getModelResourceForModelObject((EObject)documentTreeRootEObject);
        if (modelResource != null) {
            try {
                iter = modelResource.getModelDiagrams().getDiagrams(documentTreeRootEObject).iterator();
            }
            catch (ModelWorkspaceException e) {
                String message = UiConstants.Util.getString("getCoarseMappingDiagram.getDiagramsError", (Object)modelResource.toString());
                UiConstants.Util.log(4, (Throwable)e, message);
            }
            if (iter != null) {
                Diagram nextDiagram = null;
                while (iter.hasNext()) {
                    nextDiagram = (Diagram)iter.next();
                    if (nextDiagram.getType() == null || !nextDiagram.getType().equals("mappingDiagramType")) continue;
                    return nextDiagram;
                }
            }
            boolean requiresStart = false;
            boolean succeeded = false;
            boolean persist = false;
            try {
                requiresStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Create Mapping Diagram", (Object)documentTreeRootEObject);
                Diagram depDiagram = modelResource.getModelDiagrams().createNewDiagram(documentTreeRootEObject, persist);
                depDiagram.setType("mappingDiagramType");
                succeeded = true;
                Diagram diagram = depDiagram;
                return diagram;
            }
            catch (ModelWorkspaceException mwe) {
                String message = UiConstants.Util.getString("getCoarseMappingDiagram.createMappingDiagramError", (Object)modelResource.toString());
                UiConstants.Util.log(4, (Throwable)mwe, message);
            }
            finally {
                if (requiresStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        return null;
    }

    public static Diagram getCoarseMappingDiagram(Diagram detailedMappingDiagram) {
        EObject documentTreeRoot = null;
        if (detailedMappingDiagram != null) {
            MappingClass mappingClass = (MappingClass)detailedMappingDiagram.getTarget();
            documentTreeRoot = mappingClass.getMappingClassSet().getTarget();
        }
        if (documentTreeRoot != null) {
            return MappingDiagramUtil.getCoarseMappingDiagram(documentTreeRoot);
        }
        return null;
    }

    public static boolean isMappingSqlTable(Object input) {
        boolean result = false;
        if (input instanceof EObject && TransformationHelper.isVirtualSqlTable((Object)input) && input instanceof MappingClass) {
            return true;
        }
        return result;
    }

    public static boolean isMappingClassColumn(Object input) {
        EObject container;
        boolean result = false;
        if (input instanceof EObject && MappingDiagramUtil.isMappingSqlTable(container = ((EObject)input).eContainer())) {
            result = true;
        }
        return result;
    }

    public static boolean isInputSet(Object input) {
        boolean result = false;
        if (input instanceof EObject && TransformationHelper.isVirtualSqlTable((Object)input) && input instanceof InputSet) {
            return true;
        }
        return result;
    }

    public static boolean isMappingClass(Object input) {
        boolean result = false;
        if (input instanceof EObject && input instanceof MappingClass && !(input instanceof StagingTable)) {
            return true;
        }
        return result;
    }

    public static boolean isStagingTable(Object input) {
        boolean result = false;
        if (input instanceof EObject && input instanceof StagingTable) {
            return true;
        }
        return result;
    }

    public static boolean isInputSetParameter(Object input) {
        EObject container;
        boolean result = false;
        if (input instanceof EObject && MappingDiagramUtil.isInputSet(container = ((EObject)input).eContainer())) {
            result = true;
        }
        return result;
    }

    public static boolean isMappingDocument(Object input) {
        boolean result = false;
        if (input instanceof EObject && ModelMapperFactory.isTreeRoot((EObject)((EObject)input))) {
            return true;
        }
        return result;
    }

    public static EObject getTreeRoot(EObject eObject) {
        EObject treeRootEObject = null;
        if (ModelMapperFactory.isTreeRoot((EObject)eObject)) {
            treeRootEObject = eObject;
        } else {
            MappingClassSet mappingClassSet = null;
            if (eObject instanceof MappingClass) {
                mappingClassSet = ((MappingClass)eObject).getMappingClassSet();
            } else if (eObject instanceof MappingClassColumn) {
                EObject mappingClass = eObject.eContainer();
                mappingClassSet = ((MappingClass)mappingClass).getMappingClassSet();
            }
            if (mappingClassSet != null) {
                treeRootEObject = mappingClassSet.getTarget();
            }
        }
        return treeRootEObject;
    }

    public static boolean hasMappingDocument(Object input) {
        EObject eObject;
        EObject parentPackage;
        boolean result = false;
        if (input instanceof EObject && (parentPackage = MappingDiagramUtil.getMappingDocument(eObject = (EObject)input)) != null) {
            result = true;
        }
        return result;
    }

    public static EObject getMappingDocument(Object input) {
        EObject eObject;
        EObject parent;
        EObject documentEObject = null;
        if (input instanceof EObject && (parent = (eObject = (EObject)input).eContainer()) != null && parent instanceof EObject) {
            documentEObject = MappingDiagramUtil.isMappingDocument(parent) ? parent : MappingDiagramUtil.getMappingDocument(parent);
        }
        return documentEObject;
    }

    public static void layoutDiagram(DiagramModelNode diagramNode) {
        EditPart contents;
        DiagramEditor editor = DiagramEditorUtil.getVisibleDiagramEditor();
        if (diagramNode != null && editor != null && editor.getCurrentModel() != null && editor.getCurrentModel().getModelObject().equals(diagramNode.getModelObject()) && (contents = editor.getDiagramViewer().getContents()) instanceof MappingDiagramEditPart) {
            ((MappingDiagramEditPart)contents).layout();
        }
    }

    public static void layoutDiagram(DiagramModelNode diagramNode, boolean layoutChildren) {
        EditPart contents;
        DiagramEditor editor = DiagramEditorUtil.getVisibleDiagramEditor();
        if (diagramNode != null && editor != null && editor.getCurrentModel() != null && editor.getCurrentModel().getModelObject().equals(diagramNode.getModelObject()) && (contents = editor.getDiagramViewer().getContents()) instanceof MappingDiagramEditPart) {
            ((MappingDiagramEditPart)contents).layout(layoutChildren);
        }
    }

    public static void hiliteUnconnectedExtents(DiagramModelNode diagramNode) {
        EditPart contents;
        DiagramEditor editor = DiagramEditorUtil.getVisibleDiagramEditor();
        if (diagramNode != null && diagramNode.getModelObject() != null && editor != null && editor.getCurrentModel() != null && editor.getCurrentModel().getModelObject() != null && editor.getCurrentModel().getModelObject().equals(diagramNode.getModelObject()) && (contents = editor.getDiagramViewer().getContents()) instanceof MappingDiagramEditPart) {
            List editParts = contents.getChildren();
            Iterator iter = editParts.iterator();
            EditPart nextEP = null;
            while (iter.hasNext()) {
                nextEP = (EditPart)iter.next();
                if (!(nextEP instanceof MappingExtentEditPart)) continue;
                MappingDiagramUtil.hiliteExtent((MappingExtentEditPart)nextEP);
            }
        }
    }

    public static void hiliteExtent(MappingExtentEditPart meep) {
        MappingExtentNode nextNode = (MappingExtentNode)((Object)meep.getModel());
        if (nextNode != null && !(nextNode.getModelObject() instanceof StagingTable) && !DiagramUiUtilities.isNodeConnected((DiagramModelNode)nextNode)) {
            if (nextNode.getExtent().isMappingRequired()) {
                ((MappingExtentFigure)meep.getDiagramFigure()).setDefaultBkgdColor(UiConstants.Colors.REQUIRES_MAPPING);
                meep.getDiagramFigure().hiliteBackground(UiConstants.Colors.REQUIRES_MAPPING);
            } else {
                ((MappingExtentFigure)meep.getDiagramFigure()).setDefaultBkgdColor(UiConstants.Colors.UNMAPPED);
                meep.getDiagramFigure().hiliteBackground(UiConstants.Colors.UNMAPPED);
            }
        }
    }

    public static DiagramEditPart getInputSetEditPart(DiagramEditPart detailedDiagramEditPart) {
        DiagramEditPart inputSetEP = null;
        Iterator iter = detailedDiagramEditPart.getChildren().iterator();
        Object nextObj = null;
        DiagramEditPart nextDEP = null;
        while (iter.hasNext() && inputSetEP == null) {
            nextObj = iter.next();
            if (!(nextObj instanceof DiagramEditPart) || (nextDEP = (DiagramEditPart)nextObj).getModelObject() == null || !TransformationHelper.isSqlInputSet((Object)nextDEP.getModelObject())) continue;
            inputSetEP = nextDEP;
        }
        return inputSetEP;
    }

    public static DiagramEditPart getTransformationEditPart(DiagramEditPart detailedDiagramEditPart) {
        DiagramEditPart transformationEP = null;
        Iterator iter = detailedDiagramEditPart.getChildren().iterator();
        Object nextObj = null;
        DiagramEditPart nextDEP = null;
        while (iter.hasNext() && transformationEP == null) {
            nextObj = iter.next();
            if (!(nextObj instanceof DiagramEditPart) || (nextDEP = (DiagramEditPart)nextObj).getModelObject() == null || !TransformationHelper.isTransformationMappingRoot((Object)nextDEP.getModelObject())) continue;
            transformationEP = nextDEP;
        }
        return transformationEP;
    }

    public static boolean isTreeMappingRoot(Object obj) {
        return obj instanceof TreeMappingRoot;
    }

    public static List getOrderedCoarseMappingClasses() {
        MappingDiagramController controller;
        ArrayList<MappingClass> onlyMappingClasses = new ArrayList<MappingClass>();
        DiagramEditor editor = DiagramEditorUtil.getVisibleDiagramEditor();
        if (editor != null && (controller = (MappingDiagramController)editor.getDiagramController()) != null) {
            MappingAdapterFilter filter = controller.getMappingFilter();
            List visibleMappingClasses = filter.getMappedClassifiers();
            MappingClass nextMC2 = null;
            for (MappingClass nextMC2 : visibleMappingClasses) {
                if (nextMC2 instanceof StagingTable) continue;
                onlyMappingClasses.add(nextMC2);
            }
        }
        if (onlyMappingClasses.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return onlyMappingClasses;
    }

    public static DiagramModelNode[] getEnumeratedTypeNodes() {
        DiagramModelNode theMSDiagramNode;
        DiagramModelNode[] result = null;
        ArrayList tempList = new ArrayList();
        DiagramEditor editor = DiagramEditorUtil.getVisibleDiagramEditor();
        if (editor != null && (theMSDiagramNode = editor.getCurrentModel()) != null) {
            List children = theMSDiagramNode.getChildren();
            Object nextObj2 = null;
            for (Object nextObj2 : children) {
                if (!(nextObj2 instanceof UmlClassifierNode) || !ModelerXsdUtils.isEnumeratedType((EObject)((DiagramModelNode)nextObj2).getModelObject())) continue;
                tempList.add(nextObj2);
            }
        }
        if (!tempList.isEmpty()) {
            result = new DiagramModelNode[tempList.size()];
            tempList.toArray(result);
        }
        if (result == null) {
            result = new DiagramModelNode[]{};
        }
        return result;
    }

    public static MappingDiagramBehavior getCurrentMappingDiagramBehavior() {
        MappingDiagramController controller;
        DiagramEditor editor = DiagramEditorUtil.getVisibleDiagramEditor();
        if (editor != null && (controller = (MappingDiagramController)editor.getDiagramController()) != null) {
            return controller.getMappingDiagramBehavior();
        }
        return new MappingDiagramBehavior();
    }

    public static boolean isDetailedDiagram(Diagram diagram) {
        return diagram != null && diagram.getType() != null && diagram.getType().equals("mappingTransformationDiagramType");
    }
}

