/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ScrollBar;
import org.teiid.designer.core.notification.util.NotificationUtilities;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.mapping.factory.ModelMapperFactory;
import org.teiid.designer.mapping.ui.diagram.MappingDiagramUtil;
import org.teiid.designer.mapping.ui.editor.DocumentContentProvider;
import org.teiid.designer.mapping.ui.editor.DocumentTreeViewer;
import org.teiid.designer.mapping.ui.editor.MappingAdapterFilter;
import org.teiid.designer.mapping.ui.editor.MappingDiagramController;
import org.teiid.designer.mapping.ui.editor.XmlDocumentModelObjectLabelProvider;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.MappingClassColumn;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.event.IRevealHideListener;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class DocumentTreeController
implements ITreeViewerListener,
ISelectionProvider,
ISelectionChangedListener {
    MappingDiagramController diagramController;
    ScrollBar docTreeVertScrollBar;
    private static final int ROW_HEIGHT = 16;
    int verticalScrollValue = 0;
    private DocumentTreeViewer viewer;
    XmlDocumentModelObjectLabelProvider provider;
    private ExtendedDecoratingLabelProvider decLabelProvider;

    public DocumentTreeController(MappingDiagramController mdc) {
        this.diagramController = mdc;
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    public void createControl(Composite theParent) {
        this.viewer = new DocumentTreeViewer(theParent);
        this.viewer.setUseHashlookup(true);
        this.provider = new XmlDocumentModelObjectLabelProvider(this);
        ILabelDecorator decorator = DiagramUiPlugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator();
        this.decLabelProvider = new ExtendedDecoratingLabelProvider((ILabelProvider)this.provider, decorator);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.decLabelProvider);
        this.viewer.addTreeListener(this);
        this.docTreeVertScrollBar = this.viewer.getTree().getVerticalBar();
        this.docTreeVertScrollBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                if (DocumentTreeController.this.verticalScrollValue != DocumentTreeController.this.docTreeVertScrollBar.getSelection()) {
                    DocumentTreeController.this.resetExtentsFromDocument();
                }
            }
        });
    }

    public void resetExtentsFromDocument() {
        int newY = 0 - this.docTreeVertScrollBar.getSelection();
        this.verticalScrollValue = this.docTreeVertScrollBar.getSelection() / 16;
        this.diagramController.resetExtentLocationsFromDocument(newY);
    }

    public MappingAdapterFilter getMappingAdapterFilter() {
        return this.viewer.getMappingAdapterFilter();
    }

    public MappingAdapterFilter getMappingAdapterFilter(boolean bForceRecreate) {
        return this.viewer.getMappingAdapterFilter(bForceRecreate);
    }

    public XmlDocumentModelObjectLabelProvider getXmlDocumentModelObjectLabelProvider() {
        return this.provider;
    }

    public void treeCollapsed(final TreeExpansionEvent event) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IRevealHideListener rhl = DocumentTreeController.this.diagramController.getRevealHideListener();
                if (rhl != null && rhl.isRevealHideBehaviorEnabled()) {
                    List lstChildren = DocumentTreeController.this.getChildrenOfExpandedNode((EObject)event.getElement(), DocumentTreeController.this.diagramController.getMappingFilter());
                    rhl.notifyElementsHidden((Object)DocumentTreeController.this, lstChildren);
                }
                DocumentTreeController.this.diagramController.refresh(true);
                DocumentTreeController.this.resetExtentsFromDocument();
            }
        });
    }

    public void treeExpanded(final TreeExpansionEvent event) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IRevealHideListener rhl = DocumentTreeController.this.diagramController.getRevealHideListener();
                if (rhl != null && rhl.isRevealHideBehaviorEnabled()) {
                    List lstChildren = DocumentTreeController.this.getChildrenOfExpandedNode((EObject)event.getElement(), DocumentTreeController.this.diagramController.getMappingFilter());
                    rhl.notifyElementsRevealed((Object)DocumentTreeController.this, lstChildren);
                }
                DocumentTreeController.this.diagramController.refresh(true);
                DocumentTreeController.this.resetExtentsFromDocument();
            }
        });
    }

    List getChildrenOfExpandedNode(EObject eo, MappingAdapterFilter xmlFilter) {
        ArrayList<Object> lstResult = new ArrayList<Object>();
        DocumentContentProvider dcpContentProvider = (DocumentContentProvider)xmlFilter.getTreeViewer().getContentProvider();
        Object[] children = dcpContentProvider.getChildren(eo);
        int i = 0;
        while (i < children.length) {
            lstResult.add(children[i]);
            ++i;
        }
        return lstResult;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.viewer.addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.viewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.viewer.removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.viewer.setSelection(selection, true);
    }

    public DocumentTreeViewer getViewer() {
        return this.viewer;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        List selections = SelectionUtilities.getSelectedEObjects((ISelection)selection);
        ArrayList mappingSelections = new ArrayList(selections.size());
        ArrayList nodeSelections = new ArrayList(selections.size());
        Iterator iter = selections.iterator();
        boolean allSelectionsValid = true;
        boolean selectedMappings = false;
        boolean selectedTreeNodes = false;
        if (selections.size() < 1) {
            allSelectionsValid = false;
        }
        while (iter.hasNext() && allSelectionsValid) {
            Object obj = iter.next();
            if (obj instanceof MappingClass || obj instanceof MappingClassColumn) {
                mappingSelections.add(obj);
                selectedMappings = true;
                continue;
            }
            if (ModelMapperFactory.isXmlTreeNode((EObject)((EObject)obj))) {
                nodeSelections.add(obj);
                selectedTreeNodes = true;
                continue;
            }
            allSelectionsValid = false;
        }
        if (allSelectionsValid) {
            if (selectedMappings) {
                this.viewer.setSelectedMapping(mappingSelections);
                this.resetExtentsFromDocument();
            } else if (selectedTreeNodes) {
                boolean bPopulateDiagramFromTreeSelection;
                this.viewer.setSelectedNodes(nodeSelections);
                this.resetExtentsFromDocument();
                if (this.diagramController != null && this.diagramController.getMappingType() == 0 && (bPopulateDiagramFromTreeSelection = MappingDiagramUtil.getCurrentMappingDiagramBehavior().getPopulateDiagramFromTreeSelectionState())) {
                    this.refreshOnTreeSelection();
                }
            }
        } else if (!event.getSource().equals(this.viewer)) {
            this.viewer.showNoneSelected();
        } else {
            this.viewer.clearAllHilites();
            this.diagramController.clearDiagramSelection();
        }
    }

    public void refreshOnTreeSelection() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!DocumentTreeController.this.getViewer().getControl().isDisposed()) {
                    DocumentTreeController.this.diagramController.refresh(false);
                }
            }
        });
    }

    public void reveal(Object eObject) {
    }

    public void dispose() {
        this.decLabelProvider.removeListeners();
    }

    class ExtendedDecoratingLabelProvider
    extends DecoratingLabelProvider {
        INotifyChangedListener notifyChangedListener;

        public ExtendedDecoratingLabelProvider(ILabelProvider provider, ILabelDecorator decorator) {
            super(provider, decorator);
            this.addListener();
        }

        public void removeListeners() {
            ModelUtilities.removeNotifyChangedListener((INotifyChangedListener)this.notifyChangedListener);
        }

        private void addListener() {
            this.notifyChangedListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    Display display = Display.getDefault();
                    if (display.isDisposed()) {
                        return;
                    }
                    EObject eo = NotificationUtilities.getEObject((Notification)notification);
                    if (eo != null) {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ExtendedDecoratingLabelProvider.this.changeLabel();
                            }
                        });
                    }
                }
            };
            ModelUtilities.addNotifyChangedListener((INotifyChangedListener)this.notifyChangedListener);
        }

        void changeLabel() {
            LabelProviderChangedEvent event = new LabelProviderChangedEvent(DocumentTreeController.this.provider.getLabelProviderChangedEventSource(), null);
            this.fireLabelProviderChanged(event);
        }
    }
}

