/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.mapping.factory.ITreeToRelationalMapper;
import org.teiid.designer.mapping.factory.MappingClassFactory;
import org.teiid.designer.mapping.factory.ModelMapperFactory;
import org.teiid.designer.mapping.factory.TreeMappingAdapter;
import org.teiid.designer.mapping.ui.UiConstants;
import org.teiid.designer.mapping.ui.editor.MappingAdapterFilter;
import org.teiid.designer.mapping.ui.util.MappingUiUtil;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.MappingClassColumn;
import org.teiid.designer.metamodels.transformation.StagingTable;
import org.teiid.designer.metamodels.xml.XmlContainerNode;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.ModelerActionService;
import org.teiid.designer.ui.common.actions.ActionService;

public final class DocumentTreeViewer
extends TreeViewer
implements UiConstants {
    private static final Color TEMP_TABLE_BACKGROUND = DiagramUiConstants.Colors.TEMP_GROUP_HEADER;
    private static final Color CLEAR_BACKGROUND = ColorConstants.white;
    private static final Color LOCATION_BACKGROUND = DiagramUiConstants.Colors.VIRTUAL_GROUP_HEADER;
    private static final Color MAPPING_BACKGROUND = DiagramUiConstants.Colors.VIRTUAL_GROUP_BKGRND;
    private IAction collapseAllAction;
    private IAction expandAllAction;
    private MappingAdapterFilter mappingFilter;
    private TreeMappingAdapter mappingAdapter;
    private MappingClassFactory mcfFactory;
    private int mappingType = 0;
    private EObject target;
    private Collection selectedNodeList;

    public DocumentTreeViewer(Composite parent) {
        super(parent, 770);
        this.createContextMenu();
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager theMenuMgr) {
                DocumentTreeViewer.this.fillContextMenu(theMenuMgr);
            }
        });
        Tree tree = this.getTree();
        tree.setMenu(menuMgr.createContextMenu((Control)tree));
        this.expandAllAction = new Action(){

            public void run() {
                DocumentTreeViewer.this.myExpandAll();
            }
        };
        this.expandAllAction.setToolTipText(UiConstants.Util.getString("DocumentTreeViewer.expandAllAction.tooltip", new Object[0]));
        this.expandAllAction.setText(UiConstants.Util.getString("DocumentTreeViewer.expandAllAction.text", new Object[0]));
        this.expandAllAction.setEnabled(true);
        this.collapseAllAction = new Action(){

            public void run() {
                DocumentTreeViewer.this.myCollapseAll();
            }
        };
        this.collapseAllAction.setToolTipText(UiConstants.Util.getString("DocumentTreeViewer.collapseAllAction.tooltip", new Object[0]));
        this.collapseAllAction.setText(UiConstants.Util.getString("DocumentTreeViewer.collapseAllAction.text", new Object[0]));
        this.collapseAllAction.setEnabled(true);
    }

    void myExpandAll() {
        this.getControl().setRedraw(false);
        this.expandAll();
        this.getControl().setRedraw(true);
        this.getMappingAdapterFilter().getTreeExpansionMonitor().handleAllExpanded();
        TreeExpansionEvent tee = new TreeExpansionEvent(this.getThis(), this.getTree().getItems()[0].getData());
        this.fireTreeExpanded(tee);
        this.reveal(this.getTree().getItems()[0].getData());
    }

    void myCollapseAll() {
        this.collapseAll();
        this.getMappingAdapterFilter().getTreeExpansionMonitor().handleAllCollapsed();
        this.fireTreeCollapsed(new TreeExpansionEvent(this.getThis(), this.getTree().getItems()[0].getData()));
    }

    private void createMappingFilter() {
        if (this.mappingFilter != null) {
            this.mappingFilter.dispose();
        }
        this.mappingFilter = null;
        if (this.target != null) {
            try {
                this.mappingFilter = new MappingAdapterFilter(this.target, this, this.mappingAdapter);
                this.mappingAdapter = this.mappingFilter.getMappingAdapter();
                this.mappingFilter.setSelectedNodes((List)this.selectedNodeList);
                this.createMappingClassFactory(this.target);
            }
            catch (Exception e) {
                Util.log((Throwable)e);
            }
        } else {
            CoreArgCheck.isNotNull((Object)this.target);
        }
    }

    public void createMappingClassFactory(EObject target) {
        ITreeToRelationalMapper ittrm = ModelMapperFactory.createModelMapper((EObject)target);
        this.mcfFactory = new MappingClassFactory(ittrm, MappingUiUtil.getCurrentTreeMappingAdapter());
    }

    public MappingClassFactory getMappingClassFactory() {
        return this.mcfFactory;
    }

    void fillContextMenu(IMenuManager theMenuMgr) {
        UiPlugin plugin = UiPlugin.getDefault();
        ActionService actionService = plugin.getActionService(plugin.getCurrentWorkbenchWindow().getActivePage());
        ((ModelerActionService)actionService).contributeToContextMenu(theMenuMgr, null, this.getSelection());
        theMenuMgr.add(this.collapseAllAction);
        theMenuMgr.add(this.expandAllAction);
    }

    public void setXmlMappingTarget(EObject theTarget) {
        if (this.target == null || this.target != theTarget) {
            this.mappingAdapter = null;
        }
        this.target = theTarget;
        if (this.target != null) {
            this.getMappingAdapterFilter(true);
        }
    }

    public MappingAdapterFilter getMappingAdapterFilter() {
        return this.getMappingAdapterFilter(false);
    }

    public MappingAdapterFilter getMappingAdapterFilter(boolean theRefreshFlag) {
        if (theRefreshFlag || this.mappingFilter == null) {
            this.createMappingFilter();
        }
        return this.mappingFilter;
    }

    public void setSelectedMapping(Collection mappingClasses) {
        ArrayList<EObject> locations = new ArrayList<EObject>();
        ArrayList extent = new ArrayList();
        for (Object nextObject : mappingClasses) {
            if (nextObject instanceof StagingTable) {
                locations.add(this.mappingFilter.getLocation((StagingTable)nextObject));
            } else if (nextObject instanceof MappingClass) {
                locations.addAll(this.mappingFilter.getLocations((MappingClass)nextObject));
                extent.addAll(this.mappingFilter.getCoarseMappingExtentNodes((MappingClass)nextObject));
            } else if (nextObject instanceof MappingClassColumn) {
                locations.addAll(this.mappingFilter.getLocations((MappingClassColumn)nextObject));
            }
            extent.removeAll(locations);
        }
        if (locations.size() > 0) {
            this.reveal(locations.get(0));
        }
        this.paintBackground(Collections.EMPTY_LIST, locations, extent);
    }

    public void setSelectedNodes(Collection nodeList) {
        boolean singleSelection;
        this.selectedNodeList = nodeList;
        this.getMappingAdapterFilter().setSelectedNodes((List)nodeList);
        ArrayList locations = new ArrayList();
        for (Object nextObject : nodeList) {
            locations.add(nextObject);
        }
        boolean bl = singleSelection = locations.size() == 1;
        if (singleSelection) {
            this.reveal(locations.get(0));
        }
        this.paintBackground(Collections.EMPTY_LIST, Collections.EMPTY_LIST, locations);
    }

    private void paintBackground(Collection tempTableLocations, Collection mappingClassLocations, Collection mappedNodes) {
        ArrayList nodes = new ArrayList();
        this.buildTreeItemList(this.getTree().getItems(), nodes);
        for (TreeItem item : nodes) {
            Object o = item.getData();
            if (mappingClassLocations.contains(o) && this.shouldHighlight(o)) {
                this.highlightMappingClassLocation(item);
                continue;
            }
            if (mappedNodes.contains(o) && this.shouldHighlight(o)) {
                this.highlightAttributeLocation(item);
                continue;
            }
            this.clearHighlight(item, tempTableLocations.contains(o));
        }
    }

    private boolean shouldHighlight(Object oItem) {
        boolean bResult = false;
        if (oItem instanceof EObject) {
            StagingTable st;
            EObject eo = (EObject)oItem;
            MappingClass mc = this.mappingFilter.getMappingAdapter().getMappingClass(eo);
            if (mc != null) {
                bResult = true;
            }
            if ((st = this.mappingFilter.getMappingAdapter().getStagingTableForRootTreeNode(eo)) != null) {
                bResult = true;
            }
            if (!bResult) {
                bResult = !(eo instanceof XmlContainerNode);
            }
        }
        return bResult;
    }

    public void showNoneSelected() {
        this.clearAllHilites();
        this.setSelection(Collections.EMPTY_LIST);
    }

    public void clearAllHilites() {
        ArrayList nodes = new ArrayList();
        if (!this.getTree().isDisposed()) {
            this.buildTreeItemList(this.getTree().getItems(), nodes);
            for (TreeItem item : nodes) {
                this.clearHighlight(item, false);
            }
        }
    }

    private void buildTreeItemList(TreeItem[] level, List result) {
        int i = 0;
        while (i < level.length) {
            result.add(level[i]);
            TreeItem[] children = level[i].getItems();
            if (children != null && children.length > 0) {
                this.buildTreeItemList(children, result);
            }
            ++i;
        }
    }

    private void highlightMappingClassLocation(TreeItem row) {
        row.setBackground(LOCATION_BACKGROUND);
    }

    private void highlightAttributeLocation(TreeItem row) {
        row.setBackground(MAPPING_BACKGROUND);
    }

    private void clearHighlight(TreeItem row, boolean hasTempTable) {
        if (hasTempTable) {
            row.setBackground(TEMP_TABLE_BACKGROUND);
        } else {
            row.setBackground(CLEAR_BACKGROUND);
        }
    }

    public int getMappingType() {
        return this.mappingType;
    }

    private AbstractTreeViewer getThis() {
        return this;
    }

    public void setMappingType(int i) {
        this.mappingType = i;
    }

    protected void handleLabelProviderChanged(LabelProviderChangedEvent theEvent) {
        this.refresh();
    }
}

