/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.editor;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.diagram.ui.editor.DiagramController;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.mapping.factory.DefaultMappableTree;
import org.teiid.designer.mapping.factory.IMappableTree;
import org.teiid.designer.mapping.factory.TreeMappingAdapter;
import org.teiid.designer.mapping.ui.UiConstants;
import org.teiid.designer.mapping.ui.UiPlugin;
import org.teiid.designer.mapping.ui.editor.EditInputSetPanel;
import org.teiid.designer.mapping.ui.editor.InputSetAdapter;
import org.teiid.designer.mapping.ui.editor.MappingDiagramController;
import org.teiid.designer.metamodels.transformation.InputSet;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.ui.common.widget.ScrollableTitleAreaDialog;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorPage;

public class EditInputSetDialog
extends ScrollableTitleAreaDialog {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(EditInputSetDialog.class);
    private static final String TITLE = EditInputSetDialog.getString("title");
    private static final String MESSAGE = EditInputSetDialog.getString("message");
    private InputSet inputSet;
    EditInputSetPanel editorPanel;

    private static String getString(String id) {
        return UiConstants.Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public EditInputSetDialog(Shell parent, InputSet inputSet) {
        super(parent);
        this.inputSet = inputSet;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(TITLE);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x400);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(TITLE);
        this.setMessage(MESSAGE);
        Composite dialogComposite = (Composite)super.createDialogArea(parent);
        ((GridData)dialogComposite.getLayoutData()).grabExcessHorizontalSpace = true;
        ((GridData)dialogComposite.getLayoutData()).grabExcessVerticalSpace = true;
        ((GridData)dialogComposite.getLayoutData()).widthHint = 500;
        ((GridData)dialogComposite.getLayoutData()).heightHint = 250;
        this.editorPanel = new EditInputSetPanel(dialogComposite);
        this.setMappingAdapters(this.inputSet);
        MappingClass currentMappingClass = this.inputSet.getMappingClass();
        InputSetAdapter inputSetAdapter = new InputSetAdapter(currentMappingClass);
        this.editorPanel.setBusinessObject(inputSetAdapter);
        this.sizeScrolledPanel();
        return dialogComposite;
    }

    public void setMappingAdapters(InputSet inputSet) {
        ModelEditorPage editorPage;
        this.inputSet = inputSet;
        IWorkbenchWindow window = UiPlugin.getDefault().getCurrentWorkbenchWindow();
        IEditorPart editorPart = window.getActivePage().getActiveEditor();
        if (editorPart instanceof ModelEditor && (editorPage = (ModelEditorPage)((ModelEditor)editorPart).getCurrentPage()) instanceof DiagramEditor) {
            DiagramController controller = ((DiagramEditor)editorPage).getDiagramController();
            if (controller instanceof MappingDiagramController) {
                TreeMappingAdapter mapping = ((MappingDiagramController)controller).getMappingAdapter();
                IMappableTree mappableTree = ((MappingDiagramController)controller).getMappableTree();
                this.editorPanel.setMappingAdapters(mapping, mappableTree);
            } else {
                EObject docRoot = inputSet.getMappingClass().getMappingClassSet().getTarget();
                TreeMappingAdapter mapping = new TreeMappingAdapter(docRoot);
                DefaultMappableTree mappableTree = new DefaultMappableTree(docRoot);
                this.editorPanel.setMappingAdapters(mapping, (IMappableTree)mappableTree);
            }
        }
    }
}

