/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.editor;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.teiid.designer.mapping.ui.editor.BindingAdapter;
import org.teiid.designer.mapping.ui.editor.BindingList;
import org.teiid.designer.metamodels.transformation.InputBinding;
import org.teiid.designer.metamodels.transformation.InputParameter;
import org.teiid.designer.metamodels.transformation.InputSet;
import org.teiid.designer.metamodels.transformation.MappingClass;

public class InputSetAdapter {
    private MappingClass mappingClass;
    private BindingList bindingList;
    private Collection colParentResultSets;

    public InputSetAdapter(MappingClass mappingClass) {
        this.mappingClass = mappingClass;
        this.init(this.mappingClass);
    }

    public InputSet getInputSet() {
        return this.mappingClass.getInputSet();
    }

    private void init(MappingClass mappingClass) {
        if (mappingClass != null) {
            EList inputs = mappingClass.getInputSet().getInputParameters();
            EList bindings = mappingClass.getMappingClassSet().getInputBinding();
            HashMap<InputParameter, BindingAdapter> bindingMap = new HashMap<InputParameter, BindingAdapter>();
            for (InputBinding inputBinding : bindings) {
                InputParameter testInput = inputBinding.getInputParameter();
                if (testInput == null) {
                    mappingClass.getMappingClassSet().getInputBinding().remove((Object)inputBinding);
                    continue;
                }
                if (!inputs.contains(testInput)) continue;
                BindingAdapter binding = new BindingAdapter(inputBinding);
                bindingMap.put(inputBinding.getInputParameter(), binding);
            }
            for (InputParameter input : inputs) {
                BindingAdapter binding = (BindingAdapter)bindingMap.get(input);
                if (binding == null) {
                    binding = new BindingAdapter(input);
                }
                this.getBindingList().add(binding);
            }
        }
    }

    public String getStatus() {
        String message = "";
        return message;
    }

    public BindingList getBindingList() {
        if (this.bindingList == null) {
            this.bindingList = new BindingList();
        }
        return this.bindingList;
    }

    public Collection getResultSetsTreeModel() {
        return this.colParentResultSets;
    }

    public void refresh() {
        this.getBindingList().refresh(true);
    }

    public void refreshFromMetadata() {
    }

    public void updateMetadata() {
    }

    public void addBinding(BindingAdapter binding) {
        this.getBindingList().add(binding);
    }
}

