/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.TreeItem;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.mapping.factory.IMappableTree;
import org.teiid.designer.mapping.factory.ITreeToRelationalMapper;
import org.teiid.designer.mapping.factory.ModelMapperFactory;
import org.teiid.designer.mapping.factory.TreeMappingAdapter;
import org.teiid.designer.mapping.ui.diagram.MappingDiagramUtil;
import org.teiid.designer.mapping.ui.editor.DocumentContentProvider;
import org.teiid.designer.mapping.ui.editor.MappingDiagramBehavior;
import org.teiid.designer.mapping.ui.editor.MappingExtent;
import org.teiid.designer.mapping.ui.editor.SummaryExtent;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.MappingClassColumn;
import org.teiid.designer.metamodels.transformation.StagingTable;
import org.teiid.designer.metamodels.transformation.impl.MappingClassImpl;
import org.teiid.designer.metamodels.xml.XmlAttribute;
import org.teiid.designer.metamodels.xml.XmlContainerNode;
import org.teiid.designer.metamodels.xml.XmlElement;
import org.teiid.designer.metamodels.xml.XmlRoot;
import org.teiid.designer.ui.common.tree.TreeExpansionMonitor;
import org.teiid.designer.ui.common.tree.TreeNodeMap;

public class MappingAdapterFilter {
    private int rowHeight;
    private TreeViewer treeViewer;
    private TreeExpansionMonitor treeExpansionMonitor;
    private TreeMappingAdapter mappingAdapter;
    private ITreeToRelationalMapper mapper;
    private List lstNodes = Collections.EMPTY_LIST;

    public MappingAdapterFilter(EObject target, TreeViewer treeViewer, TreeMappingAdapter theMappingAdapter) {
        this.treeViewer = treeViewer;
        this.rowHeight = treeViewer.getTree().getItemHeight();
        this.treeExpansionMonitor = new TreeExpansionMonitor(treeViewer);
        this.mappingAdapter = theMappingAdapter;
        if (this.mappingAdapter == null) {
            this.mappingAdapter = new TreeMappingAdapter(target);
        }
        this.mapper = ModelMapperFactory.createModelMapper((EObject)target);
        CoreArgCheck.isNotNull((Object)this.mapper);
    }

    public void setTreeExpansionMonitorStale() {
        this.treeExpansionMonitor.setIsStale(true);
    }

    public TreeMappingAdapter getMappingAdapter() {
        return this.mappingAdapter;
    }

    public IMappableTree getMappableTree() {
        return this.mapper.getMappableTree();
    }

    public ITreeToRelationalMapper getMapper() {
        return this.mapper;
    }

    private MappingDiagramBehavior getBehavior() {
        return MappingDiagramUtil.getCurrentMappingDiagramBehavior();
    }

    public List getCoarseMappingExtents(IProgressMonitor monitor) {
        boolean bPopulateDiagramFromTreeSelection = this.getBehavior().getPopulateDiagramFromTreeSelectionState();
        if (bPopulateDiagramFromTreeSelection && this.getSelectedNodes() != null && this.getSelectedNodes().size() > 0 && this.getMappingClassesImpliedBySelection().size() > 0) {
            return this.getCoarseMappingExtentsInSelectionDrivenStyle(monitor, this.getSelectedNodes());
        }
        return this.getCoarseMappingExtentsForFullDiagram(monitor);
    }

    public List getCoarseMappingExtentsInSelectionDrivenStyle(IProgressMonitor monitor, List lstSelectedNodes) {
        boolean showProgress = monitor != null;
        int rowHeight = this.getTreeViewer().getTree().getItemHeight();
        ArrayList<MappingExtent> totalExtentList = new ArrayList<MappingExtent>();
        if (showProgress) {
            monitor.subTask("Getting mapping classes from XmlFilter");
        }
        List visibleMappingClasses = this.getMappedClassifiersForSelectionDrivenDiagram();
        List visibleTreeNodes = this.getTreeExpansionMonitor().getVisibleTreeItems();
        TreeItem nextTreeItem = null;
        Iterator iter = visibleTreeNodes.iterator();
        int iTreeNodesCnt = visibleTreeNodes.size();
        int iTreeNodes = 0;
        String pMessage = null;
        MappingClass mcCurrentMappingClass = null;
        MappingExtent meCurrentExtent = null;
        HashMap hmMappingClassesToDisplay = this.getMappingClassesImpliedBySelection();
        while (iter.hasNext()) {
            int iRow;
            EObject eoNext;
            if (showProgress && iTreeNodes % 10 == 0) {
                pMessage = "Getting extents for tree location " + iTreeNodes + " of " + iTreeNodesCnt;
                monitor.subTask(pMessage);
            }
            if ((eoNext = (EObject)(nextTreeItem = (TreeItem)iter.next()).getData()) instanceof XmlContainerNode || eoNext instanceof XmlRoot || this.isUnexpandedElementWithChildren(eoNext, this)) {
                boolean bExpanded = this.getTreeViewer().getExpandedState((Object)eoNext);
                if (bExpanded) {
                    meCurrentExtent = null;
                } else {
                    HashMap hmapMappingClasses;
                    if (this.getSelectedNodes().contains(eoNext)) {
                        this.isNodeAMappingClassRoot(eoNext);
                    }
                    if (!(hmapMappingClasses = this.getMappingClassesInBranch(eoNext)).isEmpty()) {
                        MappingClassImpl eoMappingRef = null;
                        iRow = iTreeNodes;
                        MappingExtent extent = null;
                        if (eoNext instanceof XmlRoot) {
                            eoMappingRef = (MappingClassImpl)hmapMappingClasses.keySet().iterator().next();
                            extent = new MappingExtent(iRow * rowHeight, rowHeight, (EObject)eoMappingRef, eoNext);
                        } else {
                            extent = new SummaryExtent(iRow * rowHeight, rowHeight, (EObject)eoMappingRef, eoNext);
                            ((SummaryExtent)extent).setMappingClasses(hmapMappingClasses);
                            boolean bSomeAreVisible = this.someMappingClassesAreVisible(hmapMappingClasses, visibleMappingClasses);
                            ((SummaryExtent)extent).setSomeMappingClassesAreVisible(bSomeAreVisible);
                        }
                        boolean bMapped = this.getMappingAdapter().getMappingClassColumn(eoNext) != null;
                        boolean bThisNodeIsRequired = this.isMappingRequiredForNode(eoNext);
                        if (bThisNodeIsRequired) {
                            extent.setCompletelyMapped(bMapped);
                            extent.setMappingRequired(true);
                        } else {
                            extent.setCompletelyMapped(bMapped);
                            extent.setMappingRequired(false);
                        }
                        extent.setPathToDocumentRoot(this.getMapper().getPathInDocument(eoNext));
                        totalExtentList.add(extent);
                        meCurrentExtent = null;
                    }
                }
            } else if (eoNext instanceof XmlElement || eoNext instanceof XmlAttribute) {
                MappingClass mc = this.getMappingAdapter().getMappingClassForTreeNode(eoNext);
                if (mc != null) {
                    if (hmMappingClassesToDisplay.get(mc) != null) {
                        boolean bMapped = this.getMappingAdapter().getMappingClassColumn(eoNext) != null;
                        boolean bThisNodeIsRequired = this.isMappingRequiredForNode(eoNext);
                        if (meCurrentExtent != null && mc == mcCurrentMappingClass) {
                            if (!bMapped && bThisNodeIsRequired) {
                                meCurrentExtent.setCompletelyMapped(bMapped);
                                meCurrentExtent.setMappingRequired(true);
                            }
                            meCurrentExtent.increaseHeight(rowHeight);
                        } else {
                            iRow = iTreeNodes;
                            meCurrentExtent = new MappingExtent(iRow * rowHeight, rowHeight, (EObject)mc, eoNext);
                            meCurrentExtent.setPathToDocumentRoot(this.getMapper().getPathInDocument(eoNext));
                            if (bThisNodeIsRequired) {
                                meCurrentExtent.setCompletelyMapped(bMapped);
                                meCurrentExtent.setMappingRequired(true);
                            } else {
                                meCurrentExtent.setCompletelyMapped(true);
                                meCurrentExtent.setMappingRequired(false);
                            }
                            totalExtentList.add(meCurrentExtent);
                            mcCurrentMappingClass = mc;
                        }
                    } else {
                        meCurrentExtent = null;
                    }
                } else {
                    meCurrentExtent = null;
                }
            }
            StagingTable st = this.getMappingAdapter().getStagingTable(eoNext);
            ++iTreeNodes;
        }
        return totalExtentList;
    }

    private HashMap getMappingClassesImpliedBySelection() {
        List lstSelectedTreeNodes = this.getSelectedNodes();
        HashMap<MappingClass, String> hmMappingClassesToDisplay = new HashMap<MappingClass, String>();
        Iterator itNodes = lstSelectedTreeNodes.iterator();
        EObject eoTemp = null;
        while (itNodes.hasNext()) {
            MappingClass mc;
            eoTemp = (EObject)itNodes.next();
            MappingClassColumn mccol = this.getMappingAdapter().getMappingClassColumn(eoTemp);
            if (mccol != null) {
                mc = mccol.getMappingClass();
                if (mc == null) continue;
                hmMappingClassesToDisplay.put(mc, "x");
                continue;
            }
            if (!this.isNodeAMappingClassRoot(eoTemp) || (mc = this.getMappingAdapter().getMappingClass(eoTemp)) == null) continue;
            hmMappingClassesToDisplay.put(mc, "x");
        }
        return hmMappingClassesToDisplay;
    }

    public List getCoarseMappingExtentsForFullDiagram(IProgressMonitor monitor) {
        boolean showProgress = monitor != null;
        int rowHeight = this.getTreeViewer().getTree().getItemHeight();
        ArrayList<MappingExtent> totalExtentList = new ArrayList<MappingExtent>();
        if (showProgress) {
            monitor.subTask("Getting mapping classes from XmlFilter");
        }
        List visibleMappingClasses = this.getMappedClassifiersForFullDiagram();
        List visibleTreeNodes = this.getTreeExpansionMonitor().getVisibleTreeItems();
        TreeItem nextTreeItem = null;
        Iterator iter = visibleTreeNodes.iterator();
        int iTreeNodesCnt = visibleTreeNodes.size();
        int iTreeNodes = 0;
        String pMessage = null;
        MappingClass mcCurrentMappingClass = null;
        MappingExtent meCurrentExtent = null;
        while (iter.hasNext()) {
            int iRow;
            EObject eoNext;
            if (showProgress && iTreeNodes % 10 == 0) {
                pMessage = "Getting extents for tree location " + iTreeNodes + " of " + iTreeNodesCnt;
                monitor.subTask(pMessage);
            }
            if ((eoNext = (EObject)(nextTreeItem = (TreeItem)iter.next()).getData()) instanceof XmlContainerNode || eoNext instanceof XmlRoot || this.isUnexpandedElementWithChildren(eoNext, this)) {
                boolean bExpanded = this.getTreeViewer().getExpandedState((Object)eoNext);
                if (bExpanded) {
                    meCurrentExtent = null;
                } else {
                    HashMap hmapMappingClasses = this.getMappingClassesInBranch(eoNext);
                    if (!hmapMappingClasses.isEmpty()) {
                        MappingClassImpl eoMappingRef = null;
                        iRow = iTreeNodes;
                        MappingExtent extent = null;
                        if (eoNext instanceof XmlRoot) {
                            Object nextKey = hmapMappingClasses.keySet().iterator().next();
                            if (nextKey instanceof MappingClassImpl) {
                                eoMappingRef = (MappingClassImpl)nextKey;
                            }
                            extent = new MappingExtent(iRow * rowHeight, rowHeight, (EObject)eoMappingRef, eoNext);
                        } else {
                            extent = new SummaryExtent(iRow * rowHeight, rowHeight, (EObject)eoMappingRef, eoNext);
                            ((SummaryExtent)extent).setMappingClasses(hmapMappingClasses);
                            boolean bSomeAreVisible = this.someMappingClassesAreVisible(hmapMappingClasses, visibleMappingClasses);
                            ((SummaryExtent)extent).setSomeMappingClassesAreVisible(bSomeAreVisible);
                        }
                        boolean bMapped = this.getMappingAdapter().getMappingClassColumn(eoNext) != null;
                        boolean bThisNodeIsRequired = this.isMappingRequiredForNode(eoNext);
                        if (bThisNodeIsRequired) {
                            extent.setCompletelyMapped(bMapped);
                            extent.setMappingRequired(true);
                        } else {
                            extent.setCompletelyMapped(bMapped);
                            extent.setMappingRequired(false);
                        }
                        extent.setPathToDocumentRoot(this.getMapper().getPathInDocument(eoNext));
                        totalExtentList.add(extent);
                        meCurrentExtent = null;
                    }
                }
            } else if (eoNext instanceof XmlElement || eoNext instanceof XmlAttribute) {
                MappingClass mc = this.getMappingAdapter().getMappingClassForTreeNode(eoNext);
                if (mc != null) {
                    boolean bMapped = this.getMappingAdapter().getMappingClassColumn(eoNext) != null;
                    boolean bThisNodeIsRequired = this.isMappingRequiredForNode(eoNext);
                    if (meCurrentExtent != null && mc == mcCurrentMappingClass) {
                        if (!bMapped && bThisNodeIsRequired) {
                            meCurrentExtent.setCompletelyMapped(bMapped);
                            meCurrentExtent.setMappingRequired(true);
                        }
                        meCurrentExtent.increaseHeight(rowHeight);
                    } else {
                        iRow = iTreeNodes;
                        meCurrentExtent = new MappingExtent(iRow * rowHeight, rowHeight, (EObject)mc, eoNext);
                        meCurrentExtent.setPathToDocumentRoot(this.getMapper().getPathInDocument(eoNext));
                        if (bThisNodeIsRequired) {
                            meCurrentExtent.setCompletelyMapped(bMapped);
                            meCurrentExtent.setMappingRequired(true);
                        } else {
                            meCurrentExtent.setCompletelyMapped(bMapped);
                            meCurrentExtent.setMappingRequired(false);
                        }
                        totalExtentList.add(meCurrentExtent);
                        mcCurrentMappingClass = mc;
                    }
                } else {
                    meCurrentExtent = null;
                }
            }
            StagingTable st = this.getMappingAdapter().getStagingTable(eoNext);
            if (st != null) {
                totalExtentList.add(this.getExtent(st));
            }
            ++iTreeNodes;
        }
        return totalExtentList;
    }

    private boolean isMappingRequiredForNode(EObject eoNode) {
        if (eoNode instanceof XmlElement) {
            if (((XmlElement)eoNode).getXsdComponent() == null) {
                return false;
            }
            return ((XmlElement)eoNode).getMinOccurs() > 0;
        }
        if (eoNode instanceof XmlAttribute) {
            return ((XmlAttribute)eoNode).getMinOccurs() > 0;
        }
        return false;
    }

    private boolean isUnexpandedElementWithChildren(EObject eo, MappingAdapterFilter xmlFilter) {
        DocumentContentProvider dcpContentProvider;
        Object[] children;
        boolean bExpanded = xmlFilter.getTreeViewer().getExpandedState((Object)eo);
        return !bExpanded && (children = (dcpContentProvider = (DocumentContentProvider)xmlFilter.getTreeViewer().getContentProvider()).getChildren(eo)).length > 0;
    }

    private boolean someMappingClassesAreVisible(HashMap hmapMappingClasses, List lstVisibleMappingClasses) {
        for (MappingClass mcTemp : hmapMappingClasses.keySet()) {
            if (!lstVisibleMappingClasses.contains(mcTemp)) continue;
            return true;
        }
        return false;
    }

    private boolean isNodeAMappingClassRoot(EObject eo) {
        TreeMappingAdapter tmaMappingAdapter = this.getMappingAdapter();
        MappingClass mc = tmaMappingAdapter.getMappingClass(eo);
        return mc != null;
    }

    public MappingExtent getExtent(StagingTable theStagingTable) {
        EObject documentLocation = this.mappingAdapter.getStagingTableOutputLocation(theStagingTable);
        int index = this.treeExpansionMonitor.getVisibleObjects().indexOf(documentLocation);
        MappingExtent extent = new MappingExtent(index * this.rowHeight, this.rowHeight, (EObject)theStagingTable, documentLocation);
        extent.setPathToDocumentRoot(this.mapper.getPathInDocument(documentLocation));
        return extent;
    }

    public List getDetailedMappingExtents(MappingClass theMappingClass) {
        CoreArgCheck.isNotNull((Object)theMappingClass);
        List allNodes = this.getCoarseMappingExtentNodes(theMappingClass);
        ArrayList<EObject> mappableNodes = new ArrayList<EObject>(allNodes.size());
        for (EObject node : allNodes) {
            if (!this.isMappable(node)) continue;
            mappableNodes.add(node);
        }
        TreeNodeMap tnmVisibleNodes = this.treeExpansionMonitor.getVisibleObjectsAsMap();
        ArrayList<MappingExtent> result = new ArrayList<MappingExtent>(mappableNodes.size());
        for (EObject node : mappableNodes) {
            int row = tnmVisibleNodes.indexOf((Object)node);
            MappingClassColumn column = this.mappingAdapter.getMappingClassColumn(node, theMappingClass);
            MappingExtent extent = new MappingExtent(row * this.rowHeight, this.rowHeight, (EObject)column, node);
            extent.setPathToDocumentRoot(this.mapper.getPathInDocument(node));
            extent.setXsdQualifiedName(this.mapper.getXsdQualifiedName(node));
            extent.setXsdTargetNamespace(this.mapper.getXsdTargetNamespace(node));
            extent.setMappingRequired(this.isMappingRequiredForNode(node));
            result.add(extent);
        }
        List mcLocations = this.mappingAdapter.getMappingClassOutputLocations(theMappingClass);
        block2: for (StagingTable st : this.mappingAdapter.getAllStagingTables()) {
            EObject stLocation = this.mappingAdapter.getStagingTableOutputLocation(st);
            if (!tnmVisibleNodes.contains((Object)stLocation)) continue;
            for (EObject mcLocation : mcLocations) {
                if (stLocation.equals(mcLocation)) {
                    result.add(this.getExtent(st));
                    continue block2;
                }
                if (!this.mapper.getMappableTree().isAncestorOf(stLocation, mcLocation)) continue;
                result.add(this.getExtent(st));
            }
        }
        return result;
    }

    public List getCoarseMappingExtentNodes(MappingClass theMappingClass) {
        List locations = this.mappingAdapter.getMappingClassOutputLocations(theMappingClass);
        ArrayList extentNodes = new ArrayList();
        List columnLocations = this.getColumnLocations(theMappingClass);
        ArrayList visibleTreeNodes = new ArrayList(this.treeExpansionMonitor.getVisibleObjects());
        HashMap visibleTNMap = new HashMap();
        Iterator iter = visibleTreeNodes.iterator();
        while (iter.hasNext()) {
            visibleTNMap.put(iter.next(), "x");
        }
        if (!locations.isEmpty()) {
            ArrayList mappingClassLocations = new ArrayList();
            Iterator mcIter = this.mappingAdapter.getAllMappingClasses().iterator();
            while (mcIter.hasNext()) {
                mappingClassLocations.addAll(this.mappingAdapter.getMappingClassOutputLocations((MappingClass)mcIter.next()));
            }
            int size = locations.size();
            int i = 0;
            while (i < size) {
                if (visibleTNMap.get(locations.get(i)) != null) {
                    extentNodes.add(locations.get(i));
                    extentNodes.addAll(this.gatherCoarseExtentNodes((EObject)locations.get(i), columnLocations, mappingClassLocations, visibleTNMap));
                }
                ++i;
            }
        }
        visibleTreeNodes.retainAll(extentNodes);
        return visibleTreeNodes;
    }

    private List gatherCoarseExtentNodes(EObject visibleNode, Collection columnLocations, Collection mappingClassLocations, HashMap visibleTreeNodes) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject node : this.mapper.getMappableTree().getChildren(visibleNode)) {
            if (visibleTreeNodes.get(node) == null) continue;
            if (columnLocations.contains(node)) {
                result.add(node);
                result.addAll(this.gatherCoarseExtentNodes(node, columnLocations, mappingClassLocations, visibleTreeNodes));
                continue;
            }
            if (mappingClassLocations.contains(node)) continue;
            result.add(node);
            result.addAll(this.gatherCoarseExtentNodes(node, columnLocations, mappingClassLocations, visibleTreeNodes));
        }
        return result;
    }

    public List getColumnLocations(MappingClass theMappingClass) {
        ArrayList result = new ArrayList();
        Iterator iter = theMappingClass.getColumns().iterator();
        while (iter.hasNext()) {
            result.addAll(this.mappingAdapter.getMappingClassColumnOutputLocations((MappingClassColumn)iter.next()));
        }
        return result;
    }

    public List getLocations(MappingClass theMappingClass) {
        return this.mappingAdapter.getMappingClassOutputLocations(theMappingClass);
    }

    public EObject getLocation(StagingTable theStagingTable) {
        return this.mappingAdapter.getStagingTableOutputLocation(theStagingTable);
    }

    public List getLocations(MappingClassColumn theMappingClassColumn) {
        return this.mappingAdapter.getMappingClassColumnOutputLocations(theMappingClassColumn);
    }

    public int getLevel(MappingClass theMappingClass) {
        int result = 0;
        List locations = this.getLocations(theMappingClass);
        if (locations != null && locations.size() > 0) {
            EObject location = (EObject)locations.iterator().next();
            result = ModelerCore.getModelEditor().getModelRelativePath(location).segmentCount() - 2;
        }
        return result;
    }

    public int getLevel(StagingTable theStagingTable) {
        int result = 0;
        EObject location = this.getLocation(theStagingTable);
        if (location != null) {
            result = ModelerCore.getModelEditor().getModelRelativePath(location).segmentCount() - 2;
        }
        return result;
    }

    public List getMappedClassifiers() {
        boolean bPopulateDiagramFromTreeSelection = this.getBehavior().getPopulateDiagramFromTreeSelectionState();
        if (bPopulateDiagramFromTreeSelection && this.getSelectedNodes() != null && this.getSelectedNodes().size() == 1) {
            return this.getMappedClassifiersForSelectionDrivenDiagram();
        }
        return this.getMappedClassifiersForFullDiagram();
    }

    private List getMappedClassifiersForSelectionDrivenDiagram() {
        ArrayList<MappingClass> result = new ArrayList<MappingClass>();
        ArrayList mappingClassObjects = new ArrayList(this.mappingAdapter.getAllMappingClasses());
        mappingClassObjects.addAll(this.mappingAdapter.getAllStagingTables());
        for (MappingClass mappingClass : mappingClassObjects) {
            HashMap hmMappingClassesToDisplay = this.getMappingClassesImpliedBySelection();
            if (hmMappingClassesToDisplay.get(mappingClass) == null) continue;
            result.add(mappingClass);
            break;
        }
        return result;
    }

    public List getMappedClassifiersForFullDiagram() {
        ArrayList<MappingClass> result = new ArrayList<MappingClass>();
        TreeNodeMap tnmVisibleNodes = this.treeExpansionMonitor.getVisibleObjectsAsMap();
        ArrayList mappingClassObjects = new ArrayList(this.mappingAdapter.getAllMappingClasses());
        mappingClassObjects.addAll(this.mappingAdapter.getAllStagingTables());
        boolean bShowAllMappingClasses = this.getBehavior().getDisplayAllMappingClasses();
        block0: for (MappingClass mappingClass : mappingClassObjects) {
            List<EObject> locations = null;
            locations = mappingClass instanceof StagingTable ? Collections.singletonList(this.mappingAdapter.getStagingTableOutputLocation((StagingTable)mappingClass)) : this.mappingAdapter.getMappingClassOutputLocations(mappingClass);
            for (EObject node : locations) {
                if (!bShowAllMappingClasses && !tnmVisibleNodes.contains((Object)node)) continue;
                result.add(mappingClass);
                continue block0;
            }
        }
        return result;
    }

    private boolean isMappable(EObject theTreeNode) {
        return this.mapper.isMappable(theTreeNode);
    }

    public int getNumberVisibleNodes() {
        if (this.treeExpansionMonitor != null) {
            return this.treeExpansionMonitor.getVisibleObjects().size();
        }
        return 0;
    }

    public void dispose() {
        this.treeExpansionMonitor.dispose();
    }

    public TreeExpansionMonitor getTreeExpansionMonitor() {
        return this.treeExpansionMonitor;
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public HashMap getMappingClassesInBranch(EObject eo) {
        HashMap hmap = new HashMap();
        DocumentContentProvider dcpContentProvider = (DocumentContentProvider)this.getTreeViewer().getContentProvider();
        hmap = this.internalGetMappingClassesInBranch(dcpContentProvider, dcpContentProvider.getChildren(eo), hmap);
        if (hmap.isEmpty() && eo instanceof XmlRoot) {
            Object[] children = new Object[]{eo};
            hmap = this.internalGetMappingClassesInBranch(dcpContentProvider, children, hmap);
        }
        return hmap;
    }

    private HashMap internalGetMappingClassesInBranch(DocumentContentProvider dcpContentProvider, Object[] eoChildren, HashMap hmap) {
        int i = 0;
        while (i < eoChildren.length) {
            Object[] eoNextChildren;
            EObject eoTemp = (EObject)eoChildren[i];
            if (eoTemp != null) {
                MappingClassColumn mccol = this.getMappingAdapter().getMappingClassColumn(eoTemp);
                if (mccol != null) {
                    MappingClass mc = mccol.getMappingClass();
                    if (mc != null) {
                        Integer ICount = (Integer)hmap.get(mc);
                        if (ICount != null) {
                            hmap.put(mc, new Integer(ICount + 1));
                        } else {
                            hmap.put(mc, new Integer(1));
                        }
                    }
                } else if (this.isMappable(eoTemp)) {
                    Integer ICount = (Integer)hmap.get("UNMAPPED_MAPPABLE_COLUMN_COUNT");
                    if (ICount != null) {
                        hmap.put("UNMAPPED_MAPPABLE_COLUMN_COUNT", new Integer(ICount + 1));
                    } else {
                        hmap.put("UNMAPPED_MAPPABLE_COLUMN_COUNT", new Integer(1));
                    }
                }
            }
            if ((eoNextChildren = dcpContentProvider.getChildren(eoTemp)).length > 0) {
                this.internalGetMappingClassesInBranch(dcpContentProvider, eoNextChildren, hmap);
            }
            ++i;
        }
        return hmap;
    }

    public void setSelectedNodes(List lstNodes) {
        this.lstNodes = lstNodes;
    }

    public List getSelectedNodes() {
        return this.lstNodes;
    }
}

