/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.figure;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.teiid.designer.diagram.ui.util.colors.ColorPalette;
import org.teiid.designer.mapping.ui.figure.MappingExtentFigure;
import org.teiid.designer.ui.common.graphics.GlobalUiFontManager;

public class SummaryExtentFigure
extends MappingExtentFigure {
    private int iMappingNodeCount;
    private int iUnmappedNodeCount;
    private String sNumber;
    private Label numberLabel;
    private Color defaultBkgdColor = null;
    private PointList transformPointsForPointedFace = new PointList();
    private PointList transformPointsForFlatFace = new PointList();
    private boolean bSomeMappingClassesAreVisible;
    private Image imgImage;
    private int iPreferredWidth = 60;
    private int iPreferredHeight = 12;
    private int iPreferredLabelWidth = 55;
    private int iPreferredLabelHeight = 12;

    public SummaryExtentFigure(int iMappingNodeCount, int iUnmappedNodeCount, ColorPalette colorPalette, boolean bSomeMappingClassesAreVisible, Image imgImage, int iPosition) {
        super(colorPalette);
        this.iMappingNodeCount = iMappingNodeCount;
        this.iUnmappedNodeCount = iUnmappedNodeCount;
        this.bSomeMappingClassesAreVisible = bSomeMappingClassesAreVisible;
        this.imgImage = imgImage;
        this.sNumber = this.createDisplayString();
        this.init(this.sNumber);
        this.createComponent();
    }

    private String createDisplayString() {
        String sCount = "" + this.iMappingNodeCount;
        if (this.iUnmappedNodeCount > 0) {
            sCount = String.valueOf(sCount) + " / " + this.iUnmappedNodeCount;
        }
        return sCount;
    }

    public Color getDefaultBackgroundColor() {
        if (this.iUnmappedNodeCount > 0) {
            return ColorConstants.yellow;
        }
        return ColorConstants.lightGray;
    }

    @Override
    protected void init(String sNumber) {
        if (sNumber != null) {
            this.numberLabel = new Label(sNumber);
            this.numberLabel.setIcon(this.imgImage);
            this.numberLabel.setLabelAlignment(1);
            this.numberLabel.setTextAlignment(1);
            int iHeight = 8;
            this.numberLabel.setFont(GlobalUiFontManager.getFont((FontData)new FontData("Arial", iHeight, 3)));
            this.add((IFigure)this.numberLabel);
            this.numberLabel.setForegroundColor(ColorConstants.blue);
            this.numberLabel.setBackgroundColor(ColorConstants.red);
            this.setLabelSize(this.numberLabel);
            this.setSize(this.numberLabel.getSize().width + 20, iHeight + 2);
        }
        this.defaultBkgdColor = this.getDefaultBackgroundColor();
        this.transformPointsForPointedFace = new PointList();
        this.transformPointsForFlatFace = new PointList();
        int iXOffset = this.getBounds().width - 16;
        this.transformPointsForPointedFace.addPoint(0, 0);
        this.transformPointsForPointedFace.addPoint(10 + iXOffset, 0);
        this.transformPointsForPointedFace.addPoint(16 + iXOffset, 8);
        this.transformPointsForPointedFace.addPoint(10 + iXOffset, 16);
        this.transformPointsForPointedFace.addPoint(0, 16);
        this.transformPointsForPointedFace.addPoint(0, 0);
        this.transformPointsForFlatFace.addPoint(0, 0);
        this.transformPointsForFlatFace.addPoint(10 + iXOffset, 0);
        this.transformPointsForFlatFace.addPoint(10 + iXOffset, 8);
        this.transformPointsForFlatFace.addPoint(10 + iXOffset, 16);
        this.transformPointsForFlatFace.addPoint(0, 16);
        this.transformPointsForFlatFace.addPoint(0, 0);
        this.extentOutline = new Polygon();
        if (this.getSomeMappingClassesAreVisible()) {
            this.extentOutline.setPoints(this.transformPointsForPointedFace);
        } else {
            this.extentOutline.setPoints(this.transformPointsForFlatFace);
        }
        this.add((IFigure)this.extentOutline);
        this.extentOutline.setLineWidth(2);
        this.extentOutline.setForegroundColor(ColorConstants.darkBlue);
        this.extentOutline.setBackgroundColor(this.getDefaultBackgroundColor());
        this.extentOutline.setFill(true);
    }

    @Override
    protected void createComponent() {
        this.setInitialSize();
        this.layoutThisFigure(this.getSize());
    }

    @Override
    protected void setLabelSize(Label label) {
        Font theFont = label.getFont();
        int cfr_ignored_0 = FigureUtilities.getTextExtents((String)label.getText(), (Font)theFont).width;
        if (label.getIcon() != null) {
            int cfr_ignored_1 = label.getIcon().getBounds().width;
        }
        int iTextWidth = FigureUtilities.getTextExtents((String)this.numberLabel.getText(), (Font)this.numberLabel.getFont()).width;
        Image icon = this.numberLabel.getIcon();
        if (icon != null) {
            int iIconWidth = icon.getBounds().width;
            int iFudgeFactor = 0;
            int iGap = this.iPreferredLabelWidth - (iTextWidth + iIconWidth + iFudgeFactor);
            label.setIconTextGap(iGap);
        }
        label.setSize(this.iPreferredLabelWidth, this.iPreferredLabelHeight);
    }

    @Override
    protected void setInitialSize() {
        this.setSize(new Dimension(this.iPreferredWidth, this.iPreferredHeight));
    }

    @Override
    protected void layoutThisFigure(Dimension newSize) {
        this.setSize(newSize);
        int centerX = newSize.width / 2;
        int centerY = newSize.height / 2;
        int iShiftLeft = 6;
        if (this.numberLabel != null) {
            int iDiff = newSize.width - this.numberLabel.getSize().width;
            iShiftLeft = iDiff / 2 - 2;
            this.numberLabel.setLocation(new Point(centerX - this.numberLabel.getBounds().width / 2 - iShiftLeft, centerY - this.numberLabel.getBounds().height / 2));
        }
    }

    @Override
    public void updateForSize(Dimension size) {
        this.refreshOutlinePoints();
        if (this.getSomeMappingClassesAreVisible()) {
            this.extentOutline.setPoints(this.transformPointsForPointedFace);
            this.extentOutline.setBackgroundColor(this.getDefaultBackgroundColor());
        } else {
            this.extentOutline.setPoints(this.transformPointsForFlatFace);
            this.extentOutline.setBackgroundColor(this.getDefaultBackgroundColor());
        }
        this.layoutThisFigure(size);
        this.repaint();
    }

    @Override
    public void layoutComponent() {
        this.layoutThisFigure(this.getSize());
    }

    @Override
    public void updateSize() {
    }

    @Override
    protected void replacePoint(int index, int newX, int newY) {
        if (this.getSomeMappingClassesAreVisible()) {
            this.transformPointsForPointedFace.setPoint(new Point(newX, newY), index);
        } else {
            this.transformPointsForFlatFace.setPoint(new Point(newX, newY), index);
        }
    }

    @Override
    public void hiliteBackground(Color hiliteColor) {
        if (hiliteColor == null) {
            this.extentOutline.setBackgroundColor(this.defaultBkgdColor);
        } else {
            this.extentOutline.setBackgroundColor(hiliteColor);
        }
    }

    @Override
    public void showSelected(boolean selected) {
        if (selected) {
            this.extentOutline.setBackgroundColor(this.getColor(3));
        } else {
            this.extentOutline.setBackgroundColor(this.defaultBkgdColor);
        }
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, h);
    }

    @Override
    public void setDefaultBkgdColor(Color someColor) {
        this.defaultBkgdColor = someColor;
    }

    @Override
    public void setOutlineColor(Color someColor) {
        this.extentOutline.setForegroundColor(someColor);
    }

    @Override
    public void setOutlineWidth(int newWidth) {
        this.extentOutline.setLineWidth(newWidth);
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.pushState();
        super.paint(graphics);
        this.paintOutline(graphics);
        graphics.popState();
        graphics.restoreState();
    }

    @Override
    protected void paintOutline(Graphics graphics) {
        PointList pts = this.extentOutline.getPoints();
        int orgX = this.getBounds().x;
        int orgY = this.getBounds().y;
        graphics.setLineWidth(1);
        graphics.setForegroundColor(ColorConstants.buttonDarkest);
        graphics.drawLine(orgX + pts.getPoint((int)0).x, orgY + pts.getPoint((int)0).y + 1, orgX + pts.getPoint((int)1).x, orgY + pts.getPoint((int)1).y + 1);
        graphics.drawLine(orgX + pts.getPoint((int)1).x, orgY + pts.getPoint((int)1).y, orgX + pts.getPoint((int)2).x - 1, orgY + pts.getPoint((int)2).y);
        graphics.setForegroundColor(ColorConstants.buttonDarkest);
        graphics.drawLine(orgX + pts.getPoint((int)2).x - 1, orgY + pts.getPoint((int)2).y, orgX + pts.getPoint((int)3).x, orgY + pts.getPoint((int)3).y - 2);
        graphics.drawLine(orgX + pts.getPoint((int)3).x, orgY + pts.getPoint((int)3).y - 2, orgX + pts.getPoint((int)4).x, orgY + pts.getPoint((int)4).y - 2);
        graphics.drawLine(orgX + pts.getPoint((int)4).x, orgY + pts.getPoint((int)4).y - 2, orgX + pts.getPoint((int)5).x, orgY + pts.getPoint((int)5).y - 2);
    }

    private void refreshOutlinePoints() {
        if (this.getSomeMappingClassesAreVisible()) {
            this.extentOutline.setPoints(this.transformPointsForPointedFace);
        } else {
            this.extentOutline.setPoints(this.transformPointsForFlatFace);
        }
        this.add((IFigure)this.numberLabel);
    }

    public void setSomeMappingClassesAreVisible(boolean b) {
        this.bSomeMappingClassesAreVisible = b;
        this.refreshOutlinePoints();
    }

    public boolean getSomeMappingClassesAreVisible() {
        return this.bSomeMappingClassesAreVisible;
    }
}

