/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.notification.util.NotificationUtilities;
import org.teiid.designer.core.transaction.SourcedNotification;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.diagram.ui.connection.NodeConnectionModel;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.diagram.ui.editor.DiagramEditorUtil;
import org.teiid.designer.diagram.ui.editor.DiagramViewer;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlAttributeNode;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlClassifierContainerNode;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlClassifierNode;
import org.teiid.designer.diagram.ui.part.DiagramEditPart;
import org.teiid.designer.diagram.ui.util.DiagramEntityManager;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.mapping.factory.ModelMapperFactory;
import org.teiid.designer.mapping.ui.UiConstants;
import org.teiid.designer.mapping.ui.UiPlugin;
import org.teiid.designer.mapping.ui.actions.MergeMappingClassesAction;
import org.teiid.designer.mapping.ui.actions.SplitMappingClassAction;
import org.teiid.designer.mapping.ui.connection.EnumeratedTypeLink;
import org.teiid.designer.mapping.ui.connection.MappingLink;
import org.teiid.designer.mapping.ui.diagram.MappingDiagramUtil;
import org.teiid.designer.mapping.ui.editor.MappingAdapterFilter;
import org.teiid.designer.mapping.ui.editor.MappingExtent;
import org.teiid.designer.mapping.ui.editor.SummaryExtent;
import org.teiid.designer.mapping.ui.model.MappingDiagramNode;
import org.teiid.designer.mapping.ui.model.MappingExtentNode;
import org.teiid.designer.mapping.ui.model.SummaryExtentNode;
import org.teiid.designer.mapping.ui.util.MappingUiUtil;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.transformation.InputBinding;
import org.teiid.designer.metamodels.transformation.InputParameter;
import org.teiid.designer.metamodels.transformation.InputSet;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.MappingClassColumn;
import org.teiid.designer.metamodels.transformation.MappingClassSet;
import org.teiid.designer.metamodels.transformation.StagingTable;
import org.teiid.designer.transformation.ui.actions.TransformationSourceManager;
import org.teiid.designer.transformation.ui.model.TransformationDiagramModelFactory;
import org.teiid.designer.transformation.ui.model.TransformationNode;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.xsd.util.ModelerXsdUtils;

public class MappingDiagramModelFactory
extends TransformationDiagramModelFactory {
    private static final String KEY_MAPPING_DIAGRAM_NAME = "DiagramNames.mappingDiagram";
    private static final String THIS_CLASS = "MappingDiagramModelFactory";

    public MappingDiagramModelFactory() {
        super.setHideLinksAlways(true);
    }

    public DiagramModelNode createModel(Object baseObject) {
        return null;
    }

    public DiagramModelNode createModel(Object baseObject, String sNotationId, IProgressMonitor monitor) {
        this.setNotationId(sNotationId);
        if (!(baseObject instanceof Diagram)) {
            return null;
        }
        Diagram diagram = (Diagram)baseObject;
        MappingDiagramNode diagramModelNode = null;
        diagramModelNode = new MappingDiagramNode((EObject)diagram, UiConstants.Util.getString(KEY_MAPPING_DIAGRAM_NAME, new Object[0]));
        if (this.isDetailedDiagram((DiagramModelNode)diagramModelNode)) {
            DiagramModelNode transDiagramNode = super.createModel(baseObject, sNotationId, monitor);
            diagramModelNode.addChildren(transDiagramNode.getChildren());
            DiagramModelNode baseVirtualTableNode = this.getBaseNode((DiagramModelNode)diagramModelNode);
            if (baseVirtualTableNode != null) {
                this.addRecursionImage(baseVirtualTableNode);
            }
            this.addInputSet(baseVirtualTableNode, (DiagramModelNode)diagramModelNode);
        }
        return diagramModelNode;
    }

    private void addInputSet(DiagramModelNode baseVirtualTableNode, DiagramModelNode diagramNode) {
        DiagramModelNode inputSetModelNode;
        InputSet inputSet;
        DiagramModelNode tNode = super.getTransformationNode(diagramNode);
        MappingClass mappingClass = (MappingClass)baseVirtualTableNode.getModelObject();
        if (tNode != null && mappingClass != null && (inputSet = mappingClass.getInputSet()) != null && this.getGenerator() != null && (inputSetModelNode = this.getGenerator().createModel((Object)inputSet, (Diagram)diagramNode.getModelObject())) != null) {
            inputSetModelNode.setHideLocation(true);
            this.addEditInputSetImage(inputSetModelNode);
            diagramNode.addChild(inputSetModelNode);
        }
    }

    private MappingLink getMappingLinkConnectionModel(DiagramModelNode sourceMappingClassNode, DiagramModelNode targetExtentNode) {
        MappingLink association = new MappingLink(sourceMappingClassNode, targetExtentNode);
        return association;
    }

    private boolean isDetailedDiagram(DiagramModelNode diagramNode) {
        return diagramNode.getModelObject() instanceof Diagram && ((Diagram)diagramNode.getModelObject()).getType() != null && ((Diagram)diagramNode.getModelObject()).getType().equals("mappingTransformationDiagramType");
    }

    private boolean isDetailedDiagram(Diagram diagram) {
        return diagram.getType() != null && diagram.getType().equals("mappingTransformationDiagramType");
    }

    private DiagramModelNode getBaseNode(DiagramModelNode diagramModelNode) {
        EObject virtualGroupEObject = ((Diagram)diagramModelNode.getModelObject()).getTarget();
        Iterator iter = diagramModelNode.getChildren().iterator();
        DiagramModelNode nextNode = null;
        while (iter.hasNext()) {
            nextNode = (DiagramModelNode)iter.next();
            if (!nextNode.getModelObject().equals(virtualGroupEObject)) continue;
            return nextNode;
        }
        return null;
    }

    private boolean isValidDiagram(DiagramModelNode diagramModelNode) {
        String type;
        ModelResource mr;
        boolean result = false;
        Diagram diagram = (Diagram)diagramModelNode.getModelObject();
        if (diagram != null && diagram.getTarget() != null && (mr = ModelUtilities.getModelResourceForModelObject((EObject)diagram)) != null && (type = diagram.getType()) != null && (type.equals("mappingDiagramType") || type.equals("mappingTransformationDiagramType"))) {
            result = true;
        }
        return result;
    }

    public boolean notifyModel(Notification notification, DiagramModelNode diagramModelNode, String sDiagramTypeId) {
        boolean currentDiagramOK = true;
        Diagram diagram = (Diagram)diagramModelNode.getModelObject();
        if (this.currentDiagramRemoved(diagram)) {
            currentDiagramOK = false;
        }
        if (currentDiagramOK && this.isValidDiagram(diagramModelNode) && this.sourceIsNotThis(notification) && this.shouldHandleNotification(notification, diagramModelNode)) {
            boolean requiredStart = false;
            boolean succeeded = false;
            boolean handleConstruction = !DiagramEditorUtil.isDiagramUnderConstruction((Diagram)diagram);
            try {
                try {
                    if (handleConstruction) {
                        DiagramEditorUtil.setDiagramUnderConstruction((Diagram)diagram);
                    }
                    requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Update Mapping Diagram", (Object)((Object)this));
                    this.handleNotification(notification, diagramModelNode);
                    succeeded = true;
                }
                catch (Exception ex) {
                    UiConstants.Util.log(4, (Throwable)ex, String.valueOf(ex.getClass().getName()) + ":" + THIS_CLASS + ".notifyModel()");
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                    if (handleConstruction) {
                        DiagramEditorUtil.setDiagramConstructionComplete((Diagram)diagram, (boolean)true);
                    }
                }
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                if (handleConstruction) {
                    DiagramEditorUtil.setDiagramConstructionComplete((Diagram)diagram, (boolean)true);
                }
            }
        }
        return currentDiagramOK;
    }

    private boolean shouldHandleNotification(Notification notification, DiagramModelNode diagramModelNode) {
        boolean shouldHandle = false;
        Diagram currentDiagram = (Diagram)diagramModelNode.getModelObject();
        boolean isDetailed = this.isDetailedDiagram(currentDiagram);
        ModelResource diagramMR = ModelUtilities.getModelResourceForModelObject((EObject)currentDiagram);
        if (diagramMR != null) {
            if (notification instanceof SourcedNotification) {
                Object source = ((SourcedNotification)notification).getSource();
                if (source == null || !source.equals((Object)this)) {
                    Collection notifications = ((SourcedNotification)notification).getNotifications();
                    Iterator iter = notifications.iterator();
                    Notification nextNotification = null;
                    while (iter.hasNext() && !shouldHandle) {
                        nextNotification = (Notification)iter.next();
                        Object targetObject = ModelerCore.getModelEditor().getChangedObject(nextNotification);
                        if (targetObject == null || !(targetObject instanceof EObject) || DiagramUiUtilities.isDiagramObject((EObject)((EObject)targetObject))) continue;
                        if (isDetailed) {
                            shouldHandle = true;
                            continue;
                        }
                        ModelResource mr = ModelUtilities.getModelResourceForModelObject((EObject)((EObject)targetObject));
                        if (mr == null || !mr.equals(diagramMR)) continue;
                        shouldHandle = true;
                    }
                }
            } else {
                Object targetObject = ModelerCore.getModelEditor().getChangedObject(notification);
                if (targetObject != null && targetObject instanceof EObject && !DiagramUiUtilities.isDiagramObject((EObject)((EObject)targetObject))) {
                    if (isDetailed) {
                        shouldHandle = true;
                    } else {
                        ModelResource mr = ModelUtilities.getModelResourceForModelObject((EObject)((EObject)targetObject));
                        if (mr != null && mr.equals(diagramMR)) {
                            shouldHandle = true;
                        }
                    }
                }
            }
        }
        return shouldHandle;
    }

    protected boolean currentDiagramRemoved(Diagram diagram) {
        boolean isRemoved = false;
        if (diagram == null) {
            isRemoved = true;
        } else if (diagram.eResource() == null) {
            isRemoved = true;
            if (diagram.getTarget() != null && diagram.getTarget().eResource() != null) {
                isRemoved = false;
            }
        }
        return isRemoved;
    }

    private boolean sourceIsNotThis(Notification notification) {
        if (notification instanceof SourcedNotification) {
            Object source = ((SourcedNotification)notification).getSource();
            if (source == null) {
                return true;
            }
            return !source.equals((Object)this);
        }
        return true;
    }

    private void handleSingleNotification(Notification notification, DiagramModelNode transformationDiagramModelNode, Object source) {
        if (!this.isDiagramNotifier(notification)) {
            if (NotificationUtilities.isAdded((Notification)notification)) {
                this.performAdd(notification, transformationDiagramModelNode, source);
            } else if (NotificationUtilities.isRemoved((Notification)notification)) {
                this.performRemove(notification, transformationDiagramModelNode);
            } else if (NotificationUtilities.isChanged((Notification)notification)) {
                this.performChange(notification, transformationDiagramModelNode);
            }
        }
    }

    private void handleNotification(Notification notification, DiagramModelNode mappingDiagramModelNode) {
        boolean isTransformation = this.isDetailedDiagram(mappingDiagramModelNode);
        if (notification instanceof SourcedNotification) {
            Object source = ((SourcedNotification)notification).getSource();
            if (isTransformation) {
                this.reconcileSourceTables(mappingDiagramModelNode);
            }
            Collection notifications = ((SourcedNotification)notification).getNotifications();
            Iterator iter = notifications.iterator();
            while (iter.hasNext()) {
                this.handleSingleNotification((Notification)iter.next(), mappingDiagramModelNode, source);
            }
            if (isTransformation) {
                DiagramModelNode transNode = this.getTransformationNode(mappingDiagramModelNode);
                if (transNode != null) {
                    transNode.updateAssociations();
                }
            } else {
                this.addLockedImages(mappingDiagramModelNode);
            }
        } else {
            DiagramModelNode transNode;
            if (isTransformation) {
                this.reconcileSourceTables(mappingDiagramModelNode);
            }
            this.handleSingleNotification(notification, mappingDiagramModelNode, null);
            if (isTransformation && (transNode = this.getTransformationNode(mappingDiagramModelNode)) != null) {
                transNode.updateAssociations();
            }
        }
    }

    protected void performAdd(Notification notification, DiagramModelNode mappingDiagramModelNode, Object source) {
        EObject targetObject;
        DiagramModelNode targetNode;
        if (this.isDetailedDiagram(mappingDiagramModelNode)) {
            super.performAdd(notification, mappingDiagramModelNode);
        }
        if ((targetNode = this.getModelNode(mappingDiagramModelNode, targetObject = this.getEObjectTarget(notification))) != null && !(targetNode instanceof TransformationNode) && !this.isDetailedDiagram(mappingDiagramModelNode)) {
            if (this.isNestedClassifier(targetNode)) {
                EObject[] newChildren = NotificationUtilities.getAddedChildren((Notification)notification);
                int iChild = 0;
                while (iChild < newChildren.length) {
                    if (this.isDrawable(newChildren[iChild])) {
                        DiagramModelNode newNode = this.getGenerator().createChildModel(targetNode, (Object)newChildren[iChild]);
                        if (newChildren.length == 1 && newNode instanceof UmlAttributeNode && this.isValidRenameSource(source)) {
                            ((UmlAttributeNode)newNode).rename();
                        }
                    }
                    ++iChild;
                }
                targetNode.getParent().getParent().updateForChild(false);
            } else if (!this.isDetailedDiagram(mappingDiagramModelNode)) {
                EObject[] newChildren = NotificationUtilities.getAddedChildren((Notification)notification);
                int iChild = 0;
                while (iChild < newChildren.length) {
                    if (this.isDrawable(newChildren[iChild])) {
                        DiagramModelNode newNode = this.getGenerator().createChildModel(targetNode, (Object)newChildren[iChild]);
                        if (newChildren.length == 1 && newNode instanceof UmlAttributeNode && this.isValidRenameSource(source)) {
                            targetNode.updateForChild(false);
                            ((UmlAttributeNode)newNode).rename();
                        }
                    }
                    ++iChild;
                }
                MappingDiagramUtil.layoutDiagram(mappingDiagramModelNode);
            }
        } else if (this.isDetailedDiagram(mappingDiagramModelNode) && targetObject instanceof MappingClassSet) {
            EObject[] newChildren = NotificationUtilities.getAddedChildren((Notification)notification);
            if (newChildren.length > 0) {
                int i = 0;
                while (i < newChildren.length) {
                    DiagramModelNode parentNode;
                    InputSet inputSet;
                    InputParameter newInputParameter;
                    if (newChildren[i] instanceof InputBinding && (newInputParameter = ((InputBinding)newChildren[i]).getInputParameter()) != null && (inputSet = newInputParameter.getInputSet()) != null && (parentNode = this.getModelNode(mappingDiagramModelNode, (EObject)inputSet)) != null) {
                        DiagramModelNode dNode = this.getGenerator().createChildModel(parentNode, (Object)newInputParameter);
                        dNode.update("children");
                        dNode.update("layout");
                    }
                    ++i;
                }
            }
            MappingDiagramUtil.layoutDiagram(mappingDiagramModelNode);
        }
    }

    private boolean isNestedClassifier(DiagramModelNode targetNode) {
        return targetNode.getParent() instanceof UmlClassifierContainerNode;
    }

    protected void performRemove(Notification notification, DiagramModelNode mappingDiagramModelNode) {
        EObject targetObject;
        if (this.isDetailedDiagram(mappingDiagramModelNode) && this.isRemovingSqlObjects(notification)) {
            super.performRemove(notification, mappingDiagramModelNode);
        }
        if (this.isValidTarget(targetObject = this.getEObjectTarget(notification))) {
            List diagramSourceEObjects = this.getDiagramEObjects(mappingDiagramModelNode);
            DiagramModelNode parentNode = null;
            DiagramModelNode removedNode = null;
            boolean childrenRemoved = false;
            EObject[] removedChildren = NotificationUtilities.getRemovedChildren((Notification)notification);
            int iChild = 0;
            while (iChild < removedChildren.length) {
                if (!diagramSourceEObjects.contains(removedChildren[iChild]) && (removedNode = this.getModelNode(mappingDiagramModelNode, removedChildren[iChild])) != null && (parentNode = removedNode.getParent()) != null) {
                    parentNode.removeChild(removedNode, false);
                    childrenRemoved = true;
                    DiagramModelNode topClassifierNode = DiagramUiUtilities.getTopClassifierParentNode((DiagramModelNode)parentNode);
                    if (topClassifierNode != null) {
                        topClassifierNode.updateForChild(false);
                        topClassifierNode.update("size");
                        topClassifierNode.update("children");
                        topClassifierNode.update("layout");
                    }
                }
                ++iChild;
            }
            if (childrenRemoved) {
                MappingDiagramUtil.layoutDiagram(mappingDiagramModelNode, childrenRemoved);
            } else {
                MappingDiagramUtil.layoutDiagram(mappingDiagramModelNode);
            }
        }
    }

    protected void performChange(Notification notification, DiagramModelNode mappingDiagramModelNode) {
        DiagramModelNode targetNode;
        EObject targetObject;
        if (this.isDetailedDiagram(mappingDiagramModelNode)) {
            super.performChange(notification, mappingDiagramModelNode);
        }
        if (this.isValidTarget(targetObject = this.getEObjectTarget(notification)) && (targetNode = this.getModelNode(mappingDiagramModelNode, targetObject)) != null) {
            this.getGenerator().performUpdate(targetNode, notification);
            this.addRecursionImage(targetNode);
            targetNode.update("image");
        }
    }

    public void updateNodes(Collection inputExtentList, DiagramModelNode mappingDiagramModelNode) {
    }

    public void removeNodes(Collection inputExtentList, DiagramModelNode mappingDiagramModelNode) {
        MappingExtent nextExtent2 = null;
        ArrayList<MappingExtentNode> removeList = new ArrayList<MappingExtentNode>(1);
        ArrayList extentList = new ArrayList(inputExtentList);
        for (MappingExtent nextExtent2 : extentList) {
            MappingExtentNode existingMappingNode = this.getExtentNode(mappingDiagramModelNode, nextExtent2.getMappingReference(), nextExtent2.getMappingReference());
            if (existingMappingNode == null) continue;
            removeList.add(existingMappingNode);
        }
        if (!removeList.isEmpty()) {
            mappingDiagramModelNode.removeChildren(removeList, false);
        }
    }

    public void updateMappingLinks(Collection inputExtentList) {
    }

    private List getExistingMappingExtentNodes(DiagramModelNode mappingDiagramModelNode) {
        if (mappingDiagramModelNode == null) {
            return Collections.EMPTY_LIST;
        }
        Iterator iter = mappingDiagramModelNode.getChildren().iterator();
        ArrayList<DiagramModelNode> existingExtentNodes = new ArrayList<DiagramModelNode>(10);
        DiagramModelNode nextDMN = null;
        while (iter.hasNext()) {
            nextDMN = (DiagramModelNode)iter.next();
            if (!(nextDMN instanceof MappingExtentNode)) continue;
            existingExtentNodes.add(nextDMN);
        }
        if (existingExtentNodes.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return existingExtentNodes;
    }

    private List getExistingMappingExtents(DiagramModelNode mappingDiagramModelNode) {
        if (mappingDiagramModelNode == null) {
            return Collections.EMPTY_LIST;
        }
        Iterator iter = mappingDiagramModelNode.getChildren().iterator();
        ArrayList<MappingExtent> existingExtents = new ArrayList<MappingExtent>(10);
        DiagramModelNode nextDMN = null;
        while (iter.hasNext()) {
            nextDMN = (DiagramModelNode)iter.next();
            if (!(nextDMN instanceof MappingExtentNode)) continue;
            existingExtents.add(((MappingExtentNode)nextDMN).getExtent());
        }
        if (existingExtents.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return existingExtents;
    }

    public int getNumberOfMappingExtents(Object mappingDiagramModelNode) {
        int nExt = 0;
        Iterator iter = ((DiagramModelNode)mappingDiagramModelNode).getChildren().iterator();
        DiagramModelNode nextDMN = null;
        while (iter.hasNext()) {
            nextDMN = (DiagramModelNode)iter.next();
            if (!(nextDMN instanceof MappingExtentNode)) continue;
            ++nExt;
        }
        return nExt;
    }

    public void refresh(DiagramModelNode diagramModelNode, Diagram diagram, MappingAdapterFilter xmlFilter, boolean reconcileMappingClasses, IProgressMonitor monitor) {
        boolean showProgress;
        boolean bl = showProgress = monitor != null;
        if (diagram.getType() != null) {
            DiagramEditor editor = DiagramEditorUtil.getDiagramEditor((Diagram)diagram);
            DiagramEditPart diagramEP = null;
            if (editor != null && editor.getDiagramViewer() != null) {
                ((MappingDiagramNode)diagramModelNode).setViewer(editor.getDiagramViewer());
                diagramEP = (DiagramEditPart)editor.getDiagramViewer().getContents();
            }
            if (diagramEP != null) {
                diagramEP.setUnderConstruction(true);
            }
            if (diagram.getType().equals("mappingDiagramType")) {
                if (reconcileMappingClasses) {
                    if (showProgress) {
                        monitor.subTask("Reconciling Coarse Mapping Classes");
                        monitor.worked(20);
                    }
                    this.reconcileCoarseMappingClasses(diagramModelNode, diagram, xmlFilter);
                }
                if (showProgress) {
                    monitor.subTask("Reconciling Coarse Extents");
                    monitor.worked(20);
                }
                List coarseExents = this.reconcileCoarseExtents(diagramModelNode, diagram, xmlFilter, monitor);
                if (showProgress) {
                    monitor.subTask("Update Coarse Mapping Links");
                    monitor.worked(30);
                }
                this.updateCoarseMappingLinks(diagramModelNode, coarseExents);
                if (MappingUiUtil.isLogicalModelType(diagram)) {
                    this.showEnumeratedTypes(diagramModelNode, diagram);
                }
            } else {
                this.removeStaleSourceNodeEntities(diagramModelNode);
                if (showProgress) {
                    monitor.subTask("Reconciling Detailed Extents");
                    monitor.worked(35);
                }
                List detailedExents = this.reconcileDetailedExtents(diagramModelNode, diagram, xmlFilter);
                if (showProgress) {
                    monitor.subTask("Update Detailed Mapping LInks");
                    monitor.worked(35);
                }
                this.updateDetailedMappingLinks(diagramModelNode, detailedExents);
            }
            if (diagramEP != null) {
                diagramEP.constructionCompleted(false);
            }
        }
    }

    private void deleteAllEnumeratedTypeLinks(DiagramModelNode theDiagramModelNode) {
        List links = this.getCurrentEnumeratedTypeLinks(theDiagramModelNode);
        if (!links.isEmpty()) {
            ArrayList<DiagramModelNode> processedNodes = new ArrayList<DiagramModelNode>();
            int numLinks = links.size();
            int i = 0;
            while (i < numLinks) {
                NodeConnectionModel link = (NodeConnectionModel)links.get(i);
                DiagramModelNode source = (DiagramModelNode)link.getSourceNode();
                source.removeSourceConnection(link);
                if (!processedNodes.contains(source)) {
                    processedNodes.add(source);
                    source.updateAssociations();
                }
                DiagramModelNode target = (DiagramModelNode)link.getTargetNode();
                target.removeTargetConnection(link);
                if (!processedNodes.contains(target)) {
                    processedNodes.add(target);
                    target.updateAssociations();
                }
                ++i;
            }
        }
    }

    private void showEnumeratedTypes(DiagramModelNode theDiagramNode, Diagram theDiagram) {
        List mappingClassNodes = this.getCurrentMappingClassNodes(theDiagramNode);
        if (!mappingClassNodes.isEmpty()) {
            this.deleteAllEnumeratedTypeLinks(theDiagramNode);
            HashMap<EObject, DiagramModelNode> typeNodeMap = new HashMap<EObject, DiagramModelNode>();
            int size = mappingClassNodes.size();
            int i = 0;
            while (i < size) {
                DiagramModelNode mcModelNode = (DiagramModelNode)mappingClassNodes.get(i);
                MappingClass mappingClass = (MappingClass)mcModelNode.getModelObject();
                EList columns = mappingClass.getColumns();
                if (!columns.isEmpty()) {
                    ArrayList<EObject> processedTypes = new ArrayList<EObject>();
                    int numCols = columns.size();
                    int j = 0;
                    while (j < numCols) {
                        MappingClassColumn col = (MappingClassColumn)columns.get(j);
                        EObject type = col.getType();
                        if (type instanceof XSDSimpleTypeDefinition && ModelerXsdUtils.isEnumeratedType((EObject)type)) {
                            DiagramModelNode node = null;
                            if (!processedTypes.contains(type)) {
                                processedTypes.add(type);
                                if (typeNodeMap.containsKey(type)) {
                                    node = (DiagramModelNode)typeNodeMap.get(type);
                                } else {
                                    node = this.getGenerator().createModel((Object)type, theDiagram);
                                    if (node != null) {
                                        typeNodeMap.put(type, node);
                                    }
                                }
                                if (node != null) {
                                    this.createEnumeratedTypeLink(node, mcModelNode);
                                    node.updateAssociations();
                                    mcModelNode.updateAssociations();
                                } else {
                                    String msgKey = String.valueOf(I18nUtil.getPropertyPrefix(MappingDiagramModelFactory.class)) + "enumeratedTypeModelNodeNotFound";
                                    String msg = UiConstants.Util.getString(msgKey, (Object)((XSDSimpleTypeDefinition)type).getName());
                                    UiConstants.Util.log(4, msg);
                                }
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (!typeNodeMap.isEmpty()) {
                theDiagramNode.addChildren(new ArrayList(typeNodeMap.values()));
            }
        }
    }

    private void createEnumeratedTypeLink(DiagramModelNode theEnumeratedType, DiagramModelNode theMappingClass) {
        EnumeratedTypeLink link = new EnumeratedTypeLink(theEnumeratedType, theMappingClass);
        ((DiagramModelNode)link.getSourceNode()).addSourceConnection((NodeConnectionModel)link);
        ((DiagramModelNode)link.getTargetNode()).addTargetConnection((NodeConnectionModel)link);
    }

    private void removeStaleSourceNodeEntities(DiagramModelNode diagramModelNode) {
        DiagramEntityManager.cleanUpDiagram((Diagram)((Diagram)diagramModelNode.getModelObject()));
    }

    private MappingExtent getMatchingMappingExtent(List extentList, MappingExtent extent) {
        Iterator iter = extentList.iterator();
        MappingExtent nextExtent = null;
        while (iter.hasNext()) {
            nextExtent = (MappingExtent)iter.next();
            if (!this.extentsAreEqual(nextExtent, extent)) continue;
            return nextExtent;
        }
        return null;
    }

    private List reconcileDetailedExtents(DiagramModelNode diagramModelNode, Diagram diagram, MappingAdapterFilter xmlFilter) {
        ArrayList expectedExtents = new ArrayList(this.getAllDetailedExtents(diagram, xmlFilter));
        ArrayList existingExtents = new ArrayList(this.getExistingMappingExtents(diagramModelNode));
        List currentMappingExtentNodes = this.getExistingMappingExtentNodes(diagramModelNode);
        ArrayList<MappingExtent> removeExtentList = new ArrayList<MappingExtent>();
        ArrayList<MappingExtent> addExtentList = new ArrayList<MappingExtent>();
        ArrayList<MappingExtent> updateExtentList = new ArrayList<MappingExtent>();
        MappingExtent nextExtent2 = null;
        for (MappingExtent nextExtent2 : existingExtents) {
            if (!this.extentListContains(expectedExtents, nextExtent2)) {
                removeExtentList.add(nextExtent2);
                continue;
            }
            MappingExtent updatedExtent = this.getMatchingMappingExtent(expectedExtents, nextExtent2);
            if (updatedExtent == null) continue;
            updateExtentList.add(updatedExtent);
        }
        Iterator iter = removeExtentList.iterator();
        while (iter.hasNext()) {
            existingExtents.remove(iter.next());
        }
        for (MappingExtent nextExtent2 : expectedExtents) {
            if (this.extentListContains(existingExtents, nextExtent2)) continue;
            addExtentList.add(nextExtent2);
        }
        if (!removeExtentList.isEmpty()) {
            ArrayList<MappingExtentNode> removeNodeList = new ArrayList<MappingExtentNode>(removeExtentList.size());
            iter = removeExtentList.iterator();
            MappingExtentNode nextNode = null;
            while (iter.hasNext()) {
                nextExtent2 = (MappingExtent)iter.next();
                nextNode = this.getExtentNode(diagramModelNode, nextExtent2, currentMappingExtentNodes);
                removeNodeList.add(nextNode);
            }
            if (!removeNodeList.isEmpty()) {
                diagramModelNode.removeChildren(removeNodeList, false);
            }
        }
        if (!updateExtentList.isEmpty()) {
            iter = updateExtentList.iterator();
            MappingExtentNode nextNode = null;
            while (iter.hasNext()) {
                nextExtent2 = (MappingExtent)iter.next();
                nextNode = this.getExtentNode(diagramModelNode, nextExtent2, currentMappingExtentNodes);
                this.updateExtentNode(nextNode, nextExtent2);
            }
        }
        if (!addExtentList.isEmpty()) {
            this.addExentNodes(diagramModelNode, addExtentList, null);
        }
        return expectedExtents;
    }

    private List reconcileCoarseExtents(DiagramModelNode diagramModelNode, Diagram diagram, MappingAdapterFilter xmlFilter, IProgressMonitor monitor) {
        boolean showProgress;
        boolean bl = showProgress = monitor != null;
        if (showProgress) {
            monitor.subTask("Getting all coarse extents from XmlFilter.");
        }
        List expectedExtents = new ArrayList(this.getAllCoarseExtents(xmlFilter, monitor));
        if (this.getCurrentMappingClasses(diagramModelNode).isEmpty()) {
            expectedExtents = Collections.EMPTY_LIST;
        }
        if (showProgress) {
            monitor.subTask("Getting existing extents in diagram.");
        }
        ArrayList existingExtents = new ArrayList(this.getExistingMappingExtents(diagramModelNode));
        List currentMappingExtentNodes = this.getExistingMappingExtentNodes(diagramModelNode);
        ArrayList<MappingExtent> removeExtentList = new ArrayList<MappingExtent>();
        ArrayList<MappingExtent> addExtentList = new ArrayList<MappingExtent>();
        ArrayList<MappingExtent> updateExtentList = new ArrayList<MappingExtent>();
        MappingExtent nextExtent2 = null;
        if (showProgress) {
            monitor.subTask("Find old extents");
        }
        for (MappingExtent nextExtent2 : existingExtents) {
            if (!this.extentListContains(expectedExtents, nextExtent2)) {
                removeExtentList.add(nextExtent2);
                continue;
            }
            MappingExtent updatedExtent = this.getMatchingMappingExtent(expectedExtents, nextExtent2);
            if (updatedExtent == null) continue;
            updateExtentList.add(updatedExtent);
        }
        if (showProgress) {
            monitor.subTask("Find new extents");
        }
        Iterator iter = removeExtentList.iterator();
        while (iter.hasNext()) {
            existingExtents.remove(iter.next());
        }
        for (MappingExtent nextExtent2 : expectedExtents) {
            if (this.extentListContains(existingExtents, nextExtent2)) continue;
            addExtentList.add(nextExtent2);
        }
        if (showProgress) {
            monitor.subTask("Remove old extents from diagram");
        }
        if (!removeExtentList.isEmpty()) {
            ArrayList<MappingExtentNode> removeNodeList = new ArrayList<MappingExtentNode>(removeExtentList.size());
            iter = removeExtentList.iterator();
            MappingExtentNode nextNode = null;
            while (iter.hasNext()) {
                nextExtent2 = (MappingExtent)iter.next();
                nextNode = this.getExtentNode(diagramModelNode, nextExtent2, currentMappingExtentNodes);
                removeNodeList.add(nextNode);
            }
            if (!removeNodeList.isEmpty()) {
                diagramModelNode.removeChildren(removeNodeList, false);
            }
        }
        if (showProgress) {
            monitor.subTask("Update existing extents");
        }
        if (!updateExtentList.isEmpty()) {
            iter = updateExtentList.iterator();
            MappingExtentNode nextNode = null;
            while (iter.hasNext()) {
                nextExtent2 = (MappingExtent)iter.next();
                nextNode = this.getExtentNode(diagramModelNode, nextExtent2, currentMappingExtentNodes);
                this.updateExtentNode(nextNode, nextExtent2);
            }
        }
        if (!addExtentList.isEmpty()) {
            this.addExentNodes(diagramModelNode, addExtentList, monitor);
        }
        return expectedExtents;
    }

    private void reconcileCoarseMappingClasses(DiagramModelNode diagramModelNode, Diagram diagram, MappingAdapterFilter xmlFilter) {
        ArrayList<DiagramModelNode> removeNodeList = new ArrayList<DiagramModelNode>();
        List currentMappingClassNodes = this.getCurrentMappingClassNodes(diagramModelNode);
        List visibleMappingClasses = xmlFilter.getMappedClassifiers();
        DiagramModelNode nextNode2 = null;
        for (DiagramModelNode nextNode2 : currentMappingClassNodes) {
            if (visibleMappingClasses.contains(nextNode2.getModelObject())) continue;
            removeNodeList.add(nextNode2);
        }
        diagramModelNode.removeChildren(removeNodeList, false);
        boolean bDefaultFoldedState = MappingDiagramUtil.getCurrentMappingDiagramBehavior().getDefaultMappingClassFoldedState();
        ArrayList<DiagramModelNode> addedNodes = new ArrayList<DiagramModelNode>();
        List currentMappingClasses = this.getCurrentMappingClasses(diagramModelNode);
        for (Object nextObj : visibleMappingClasses) {
            DiagramModelNode childModelNode;
            if (currentMappingClasses.contains(nextObj) || (childModelNode = this.getGenerator().createModel(nextObj, diagram)) == null) continue;
            addedNodes.add(childModelNode);
            this.addRecursionImage(childModelNode);
            if (!(childModelNode instanceof UmlClassifierNode)) continue;
            ((UmlClassifierNode)childModelNode).setExpandedState(!bDefaultFoldedState);
        }
        diagramModelNode.addChildren(addedNodes);
        this.addLockedImages(diagramModelNode);
    }

    private MappingExtentNode getDetailedExtentNode(DiagramModelNode diagramModelNode, EObject mappingReferenceEObject, EObject locationEObject) {
        Iterator iter = this.getExistingMappingExtentNodes(diagramModelNode).iterator();
        MappingExtentNode nextNode = null;
        while (iter.hasNext()) {
            nextNode = (MappingExtentNode)((Object)iter.next());
            if (!nextNode.getModelObject().equals(locationEObject) || nextNode.getExtent().getMappingReference() == null || !nextNode.getExtent().getMappingReference().equals(mappingReferenceEObject)) continue;
            return nextNode;
        }
        return null;
    }

    private MappingExtentNode getExtentNode(DiagramModelNode diagramModelNode, EObject mappingClassEObject, EObject locationEObject) {
        Iterator iter = this.getExistingMappingExtentNodes(diagramModelNode).iterator();
        MappingExtentNode nextNode = null;
        while (iter.hasNext()) {
            nextNode = (MappingExtentNode)((Object)iter.next());
            if (nextNode == null || nextNode.getModelObject() == null || nextNode.getMappingClass() == null || nextNode instanceof SummaryExtentNode || !nextNode.getModelObject().equals(locationEObject) || !nextNode.getMappingClass().equals(mappingClassEObject)) continue;
            return nextNode;
        }
        return null;
    }

    private MappingExtentNode getSummaryExtentNode(DiagramModelNode diagramModelNode, EObject mappingClassEObject, EObject locationEObject) {
        Iterator iter = this.getExistingMappingExtentNodes(diagramModelNode).iterator();
        SummaryExtentNode seNode = null;
        while (iter.hasNext()) {
            Object oNextNode = iter.next();
            if (!(oNextNode instanceof SummaryExtentNode) || !(seNode = (SummaryExtentNode)oNextNode).getModelObject().equals(locationEObject) || !((SummaryExtent)seNode.getExtent()).getMappingClasses().keySet().contains(mappingClassEObject)) continue;
            return seNode;
        }
        return null;
    }

    private MappingExtentNode getExtentNode(DiagramModelNode diagramModelNode, MappingExtent mappingExtent, List mappingExtentNodes) {
        Iterator iter = mappingExtentNodes.iterator();
        MappingExtentNode nextNode = null;
        while (iter.hasNext()) {
            nextNode = (MappingExtentNode)((Object)iter.next());
            if (!this.extentsAreEqual(nextNode.getExtent(), mappingExtent)) continue;
            return nextNode;
        }
        return null;
    }

    private void updateExtentNode(MappingExtentNode extentNode, MappingExtent currentExtent) {
        double zoomFactor = DiagramEditorUtil.getCurrentZoomFactor();
        extentNode.setExtent(currentExtent);
        extentNode.setExtentPosition(0);
        int newH = (int)(currentExtent.getHeight() / zoomFactor);
        int oldW = extentNode.getWidth();
        extentNode.setSize(new Dimension(oldW, newH));
    }

    private MappingExtentNode createExtentNode(DiagramModelNode diagramModelNode, MappingExtent currentExtent) {
        MappingExtentNode mappingExtentNode = null;
        if (((Diagram)diagramModelNode.getModelObject()).getType() != null && ((Diagram)diagramModelNode.getModelObject()).getType().equals("mappingDiagramType")) {
            EObject mappingClassEObject = currentExtent.getMappingReference();
            EObject locationEObject = currentExtent.getDocumentNodeReference();
            DiagramModelNode mappingClassNode = this.getModelNode(diagramModelNode, mappingClassEObject);
            if (mappingClassNode != null) {
                mappingExtentNode = new MappingExtentNode(diagramModelNode, locationEObject, currentExtent, true);
                mappingExtentNode.setMappingClass(mappingClassEObject);
                mappingExtentNode.setParent(diagramModelNode);
                MappingLink targetLink = this.getMappingLinkConnectionModel(mappingClassNode, (DiagramModelNode)mappingExtentNode);
                ((DiagramModelNode)targetLink.getSourceNode()).addSourceConnection((NodeConnectionModel)targetLink);
                ((DiagramModelNode)targetLink.getTargetNode()).addTargetConnection((NodeConnectionModel)targetLink);
                mappingClassNode.updateAssociations();
                mappingExtentNode.updateAssociations();
            } else {
                mappingExtentNode = new MappingExtentNode(diagramModelNode, locationEObject, currentExtent, true);
                mappingExtentNode.setParent(diagramModelNode);
            }
        } else {
            EObject mappingReference = currentExtent.getMappingReference();
            EObject locationEObject = currentExtent.getDocumentNodeReference();
            EObject mappingClassReference = null;
            if (mappingReference != null) {
                mappingClassReference = mappingReference.eContainer();
            }
            DiagramModelNode mappingClassNode = this.getModelNode(diagramModelNode, mappingClassReference);
            mappingExtentNode = new MappingExtentNode(diagramModelNode, locationEObject, currentExtent, false);
            mappingExtentNode.setParent(diagramModelNode);
            if (mappingClassNode != null) {
                MappingLink targetLink = this.getMappingLinkConnectionModel(mappingClassNode, (DiagramModelNode)mappingExtentNode);
                ((DiagramModelNode)targetLink.getSourceNode()).addSourceConnection((NodeConnectionModel)targetLink);
                ((DiagramModelNode)targetLink.getTargetNode()).addTargetConnection((NodeConnectionModel)targetLink);
                mappingClassNode.updateAssociations();
                mappingExtentNode.updateAssociations();
            }
        }
        return mappingExtentNode;
    }

    private SummaryExtentNode createSummaryExtentNode(DiagramModelNode diagramModelNode, SummaryExtent currentExtent) {
        SummaryExtentNode mappingExtentNode = null;
        if (((Diagram)diagramModelNode.getModelObject()).getType() != null && ((Diagram)diagramModelNode.getModelObject()).getType().equals("mappingDiagramType")) {
            EObject locationEObject = currentExtent.getDocumentNodeReference();
            HashMap hmapMappingClasses = currentExtent.getMappingClasses();
            if (hmapMappingClasses == null) {
                return null;
            }
            mappingExtentNode = new SummaryExtentNode(diagramModelNode, locationEObject, currentExtent, true);
            mappingExtentNode.setParent(diagramModelNode);
            mappingExtentNode.setMappingClasses(hmapMappingClasses);
            for (EObject nextMappingClassEObject : hmapMappingClasses.keySet()) {
                DiagramModelNode nextMappingClassNode = this.getModelNode(diagramModelNode, nextMappingClassEObject);
                if (nextMappingClassNode == null) continue;
                MappingLink targetLink = this.getMappingLinkConnectionModel(nextMappingClassNode, (DiagramModelNode)mappingExtentNode);
                ((DiagramModelNode)targetLink.getSourceNode()).addSourceConnection((NodeConnectionModel)targetLink);
                ((DiagramModelNode)targetLink.getTargetNode()).addTargetConnection((NodeConnectionModel)targetLink);
                nextMappingClassNode.updateAssociations();
                mappingExtentNode.updateAssociations();
            }
        }
        return mappingExtentNode;
    }

    private void addExentNodes(DiagramModelNode diagramModelNode, List newExtents, IProgressMonitor monitor) {
        boolean showProgress = monitor != null;
        ArrayList<MappingExtentNode> newChildren = new ArrayList<MappingExtentNode>(newExtents.size());
        String message = null;
        int nExtents = newExtents.size();
        Iterator iter = newExtents.iterator();
        MappingExtent nextExtent = null;
        int iExtent = 0;
        while (iter.hasNext()) {
            if (showProgress && iExtent % 10 == 0) {
                message = "Create node for missing extent " + iExtent + " of " + nExtents;
                monitor.subTask(message);
            }
            nextExtent = (MappingExtent)iter.next();
            MappingExtentNode meNode = null;
            meNode = nextExtent instanceof SummaryExtent ? this.createSummaryExtentNode(diagramModelNode, (SummaryExtent)nextExtent) : this.createExtentNode(diagramModelNode, nextExtent);
            if (meNode != null) {
                newChildren.add(meNode);
            }
            ++iExtent;
        }
        if (showProgress) {
            message = "Adding " + newChildren.size() + " extent nodes to diagram.";
            monitor.subTask(message);
        }
        diagramModelNode.addChildren(newChildren);
        iter = newChildren.iterator();
        MappingExtentNode nextNode = null;
        iExtent = 0;
        while (iter.hasNext()) {
            if (showProgress && iExtent % 10 == 0) {
                message = "Updating extent " + iExtent + " of " + nExtents;
                monitor.subTask(message);
            }
            nextNode = (MappingExtentNode)((Object)iter.next());
            nextNode.updateAssociations();
            this.updateExtentNode(nextNode, nextNode.getExtent());
            ++iExtent;
        }
    }

    private List getCurrentMappingClasses(DiagramModelNode diagramModelNode) {
        Iterator iter = diagramModelNode.getChildren().iterator();
        DiagramModelNode nextNode = null;
        ArrayList<EObject> returnList = new ArrayList<EObject>();
        while (iter.hasNext()) {
            nextNode = (DiagramModelNode)iter.next();
            if (!(nextNode instanceof UmlClassifierNode) || MappingDiagramUtil.isInputSet(nextNode.getModelObject())) continue;
            returnList.add(nextNode.getModelObject());
        }
        return returnList;
    }

    protected void clearAllSourceNodes(DiagramModelNode transformationDiagramModelNode) {
        EObject transformationEObject = TransformationSourceManager.getTransformationFromDiagram((Diagram)((Diagram)transformationDiagramModelNode.getModelObject()));
        Iterator iter = this.getCurrentSourceNodes(transformationDiagramModelNode).iterator();
        DiagramModelNode nextSourceNode = null;
        while (iter.hasNext()) {
            nextSourceNode = (DiagramModelNode)iter.next();
            if (TransformationHelper.isSqlInputSet((Object)nextSourceNode.getModelObject())) continue;
            this.removeSourceTable(transformationEObject, transformationDiagramModelNode, nextSourceNode.getModelObject());
        }
    }

    private List getCurrentMappingClassNodes(DiagramModelNode diagramModelNode) {
        Iterator iter = diagramModelNode.getChildren().iterator();
        DiagramModelNode nextNode = null;
        ArrayList<DiagramModelNode> returnList = new ArrayList<DiagramModelNode>();
        while (iter.hasNext()) {
            nextNode = (DiagramModelNode)iter.next();
            if (!(nextNode instanceof UmlClassifierNode) || MappingDiagramUtil.isInputSet(nextNode.getModelObject())) continue;
            returnList.add(nextNode);
        }
        return returnList;
    }

    private List getAllCoarseExtents(MappingAdapterFilter xmlFilter, IProgressMonitor monitor) {
        boolean showProgress = monitor != null;
        ArrayList totalExtentList = new ArrayList();
        if (showProgress) {
            monitor.subTask("Getting mapping classes from XmlFilter");
        }
        totalExtentList.addAll(xmlFilter.getCoarseMappingExtents(monitor));
        return totalExtentList;
    }

    private List getAllDetailedExtents(Diagram diagram, MappingAdapterFilter xmlFilter) {
        MappingClass targetMappingClass = (MappingClass)diagram.getTarget();
        ArrayList detailedExtentList = new ArrayList(xmlFilter.getDetailedMappingExtents(targetMappingClass));
        return detailedExtentList;
    }

    public void updateCoarseMappingLinks(DiagramModelNode mappingDiagramModelNode, List currentExtents) {
        List realMappingLinks = this.getRealCoarseMappingLinks(mappingDiagramModelNode, currentExtents);
        List realSummaryLinks = this.getRealCoarseMappingLinksForSummaryExtents(mappingDiagramModelNode, currentExtents);
        ArrayList arylRealLinks = new ArrayList();
        arylRealLinks.addAll(realMappingLinks);
        arylRealLinks.addAll(realSummaryLinks);
        List staleMappingLinks = this.getStaleMappingLinks(arylRealLinks, mappingDiagramModelNode);
        ArrayList<Object> updatedNodes = new ArrayList<Object>(this.cleanUpStaleMappingLinks(staleMappingLinks, mappingDiagramModelNode));
        for (NodeConnectionModel nextAssociation : arylRealLinks) {
            List labelNodes;
            if (this.mappingLinkExists(mappingDiagramModelNode, nextAssociation)) continue;
            ((DiagramModelNode)nextAssociation.getSourceNode()).addSourceConnection(nextAssociation);
            ((DiagramModelNode)nextAssociation.getTargetNode()).addTargetConnection(nextAssociation);
            if (!updatedNodes.contains(nextAssociation.getSourceNode())) {
                updatedNodes.add(nextAssociation.getSourceNode());
            }
            if (!updatedNodes.contains(nextAssociation.getTargetNode())) {
                updatedNodes.add(nextAssociation.getTargetNode());
            }
            if ((labelNodes = nextAssociation.getLabelNodes()) == null || labelNodes.isEmpty()) continue;
            mappingDiagramModelNode.addChildren(labelNodes);
        }
        if (!updatedNodes.isEmpty()) {
            Iterator iter = updatedNodes.iterator();
            DiagramModelNode nextNode = null;
            while (iter.hasNext()) {
                nextNode = (DiagramModelNode)iter.next();
                nextNode.updateAssociations();
            }
        }
    }

    public void updateDetailedMappingLinks(DiagramModelNode mappingDiagramModelNode, List currentExtents) {
        List realMappingLinks = this.getRealDetailedMappingLinks(mappingDiagramModelNode, currentExtents);
        List staleMappingLinks = this.getStaleMappingLinks(realMappingLinks, mappingDiagramModelNode);
        ArrayList<Object> updatedNodes = new ArrayList<Object>(this.cleanUpStaleMappingLinks(staleMappingLinks, mappingDiagramModelNode));
        for (NodeConnectionModel nextAssociation : realMappingLinks) {
            List labelNodes;
            if (this.mappingLinkExists(mappingDiagramModelNode, nextAssociation)) continue;
            ((DiagramModelNode)nextAssociation.getSourceNode()).addSourceConnection(nextAssociation);
            ((DiagramModelNode)nextAssociation.getTargetNode()).addTargetConnection(nextAssociation);
            if (!updatedNodes.contains(nextAssociation.getSourceNode())) {
                updatedNodes.add(nextAssociation.getSourceNode());
            }
            if (!updatedNodes.contains(nextAssociation.getTargetNode())) {
                updatedNodes.add(nextAssociation.getTargetNode());
            }
            if ((labelNodes = nextAssociation.getLabelNodes()) == null || labelNodes.isEmpty()) continue;
            mappingDiagramModelNode.addChildren(labelNodes);
        }
        if (!updatedNodes.isEmpty()) {
            Iterator iter = updatedNodes.iterator();
            DiagramModelNode nextNode = null;
            while (iter.hasNext()) {
                nextNode = (DiagramModelNode)iter.next();
                nextNode.updateAssociations();
            }
        }
    }

    protected List getRealDetailedMappingLinks(DiagramModelNode mappingDiagramModelNode, List extentList) {
        ArrayList<MappingLink> realMappingLinks = new ArrayList<MappingLink>();
        Iterator extentIter = extentList.iterator();
        EObject nextMappingReference = null;
        EObject nextExtentLocation = null;
        MappingExtent nextExtent = null;
        DiagramModelNode mappingClassNode = null;
        MappingExtentNode extentNode = null;
        while (extentIter.hasNext()) {
            nextExtent = (MappingExtent)extentIter.next();
            nextMappingReference = nextExtent.getMappingReference();
            nextExtentLocation = nextExtent.getDocumentNodeReference();
            if (nextMappingReference == null || nextExtentLocation == null) continue;
            mappingClassNode = DiagramUiUtilities.getDiagramModelNode((EObject)nextMappingReference.eContainer(), (DiagramModelNode)mappingDiagramModelNode);
            extentNode = this.getDetailedExtentNode(mappingDiagramModelNode, nextExtent.getMappingReference(), nextExtent.getDocumentNodeReference());
            if (extentNode == null || mappingClassNode == null) continue;
            realMappingLinks.add(new MappingLink(mappingClassNode, (DiagramModelNode)extentNode));
        }
        return realMappingLinks;
    }

    protected List getRealCoarseMappingLinks(DiagramModelNode mappingDiagramModelNode, List extentList) {
        ArrayList<MappingLink> realMappingLinks = new ArrayList<MappingLink>();
        Iterator extentIter = extentList.iterator();
        EObject nextMappingClass = null;
        EObject nextExtentLocation = null;
        MappingExtent nextExtent = null;
        DiagramModelNode mappingClassNode = null;
        MappingExtentNode extentNode = null;
        while (extentIter.hasNext()) {
            nextExtent = (MappingExtent)extentIter.next();
            if (nextExtent instanceof SummaryExtent) continue;
            nextMappingClass = nextExtent.getMappingReference();
            nextExtentLocation = nextExtent.getDocumentNodeReference();
            if (nextMappingClass == null || nextExtentLocation == null) continue;
            mappingClassNode = DiagramUiUtilities.getDiagramModelNode((EObject)nextMappingClass, (DiagramModelNode)mappingDiagramModelNode);
            extentNode = this.getExtentNode(mappingDiagramModelNode, nextExtent.getMappingReference(), nextExtent.getDocumentNodeReference());
            if (extentNode == null || mappingClassNode == null) continue;
            realMappingLinks.add(new MappingLink(mappingClassNode, (DiagramModelNode)extentNode));
        }
        return realMappingLinks;
    }

    protected List getRealCoarseMappingLinksForSummaryExtents(DiagramModelNode mappingDiagramModelNode, List extentList) {
        ArrayList<MappingLink> realMappingLinks = new ArrayList<MappingLink>();
        Iterator extentIter = extentList.iterator();
        EObject nextMappingClass2 = null;
        EObject nextExtentLocation = null;
        MappingExtent nextExtent = null;
        SummaryExtent nextSummaryExtent = null;
        DiagramModelNode mappingClassNode = null;
        MappingExtentNode extentNode = null;
        while (extentIter.hasNext()) {
            nextExtent = (MappingExtent)extentIter.next();
            if (!(nextExtent instanceof SummaryExtent)) continue;
            nextSummaryExtent = (SummaryExtent)nextExtent;
            nextExtentLocation = nextExtent.getDocumentNodeReference();
            HashMap hmapMappingClasses = nextSummaryExtent.getMappingClasses();
            for (EObject nextMappingClass2 : hmapMappingClasses.keySet()) {
                if (nextMappingClass2 == null || nextExtentLocation == null) continue;
                mappingClassNode = DiagramUiUtilities.getDiagramModelNode((EObject)nextMappingClass2, (DiagramModelNode)mappingDiagramModelNode);
                extentNode = this.getSummaryExtentNode(mappingDiagramModelNode, nextMappingClass2, nextExtentLocation);
                if (extentNode == null || mappingClassNode == null) continue;
                realMappingLinks.add(new MappingLink(mappingClassNode, (DiagramModelNode)extentNode));
            }
        }
        return realMappingLinks;
    }

    protected List getStaleMappingLinks(List expectedMappingLinks, DiagramModelNode diagramModelNode) {
        ArrayList<MappingLink> staleAssociations = new ArrayList<MappingLink>();
        Iterator iter = this.getCurrentMappingLinks(diagramModelNode).iterator();
        Iterator expectedIter = null;
        MappingLink nextCurrentAssociation = null;
        MappingLink nextExpectedAssociation = null;
        boolean foundMatch = false;
        while (iter.hasNext()) {
            foundMatch = false;
            nextCurrentAssociation = (MappingLink)((Object)iter.next());
            expectedIter = expectedMappingLinks.iterator();
            while (expectedIter.hasNext() && !foundMatch) {
                nextExpectedAssociation = (MappingLink)((Object)expectedIter.next());
                if (!this.associationsMatch((NodeConnectionModel)nextExpectedAssociation, (NodeConnectionModel)nextCurrentAssociation)) continue;
                foundMatch = true;
            }
            if (foundMatch) continue;
            staleAssociations.add(nextCurrentAssociation);
        }
        return staleAssociations;
    }

    protected boolean mappingLinkExists(DiagramModelNode diagramModelNode, NodeConnectionModel targetAssociation) {
        List currentChildren = diagramModelNode.getChildren();
        for (DiagramModelNode childModelNode : currentChildren) {
            Vector sourceConnections = childModelNode.getSourceConnections();
            NodeConnectionModel nextAssociation2 = null;
            for (NodeConnectionModel nextAssociation2 : sourceConnections) {
                if (!this.associationsMatch(targetAssociation, nextAssociation2)) continue;
                return true;
            }
            Vector targetConnections = childModelNode.getTargetConnections();
            for (NodeConnectionModel nextAssociation2 : targetConnections) {
                if (!this.associationsMatch(targetAssociation, nextAssociation2)) continue;
                return true;
            }
        }
        return false;
    }

    protected List cleanUpStaleMappingLinks(List staleLinks, DiagramModelNode diagramModelNode) {
        ArrayList<Object> updatedNodes = new ArrayList<Object>();
        Iterator iter = staleLinks.iterator();
        NodeConnectionModel nextLink = null;
        while (iter.hasNext()) {
            nextLink = (NodeConnectionModel)iter.next();
            if (!(nextLink instanceof MappingLink)) continue;
            ((DiagramModelNode)nextLink.getSourceNode()).removeSourceConnection(nextLink);
            ((DiagramModelNode)nextLink.getTargetNode()).removeTargetConnection(nextLink);
            if (!updatedNodes.contains(nextLink.getSourceNode())) {
                updatedNodes.add(nextLink.getSourceNode());
            }
            if (updatedNodes.contains(nextLink.getTargetNode())) continue;
            updatedNodes.add(nextLink.getTargetNode());
        }
        return updatedNodes;
    }

    protected List getCurrentMappingLinks(DiagramModelNode diagramModelNode) {
        ArrayList<NodeConnectionModel> currentAssociations = new ArrayList<NodeConnectionModel>();
        for (DiagramModelNode childModelNode : diagramModelNode.getChildren()) {
            Vector sourceConnections = childModelNode.getSourceConnections();
            NodeConnectionModel nextAssociation2 = null;
            for (NodeConnectionModel nextAssociation2 : sourceConnections) {
                if (!(nextAssociation2 instanceof MappingLink) || currentAssociations.contains(nextAssociation2)) continue;
                currentAssociations.add(nextAssociation2);
            }
            Vector targetConnections = childModelNode.getTargetConnections();
            for (NodeConnectionModel nextAssociation2 : targetConnections) {
                if (!(nextAssociation2 instanceof MappingLink) || currentAssociations.contains(nextAssociation2)) continue;
                currentAssociations.add(nextAssociation2);
            }
        }
        return currentAssociations;
    }

    private List getCurrentEnumeratedTypeLinks(DiagramModelNode theDiagramModelNode) {
        ArrayList<NodeConnectionModel> associations = new ArrayList<NodeConnectionModel>();
        for (DiagramModelNode child : theDiagramModelNode.getChildren()) {
            NodeConnectionModel nextAssociation2 = null;
            for (NodeConnectionModel nextAssociation2 : child.getSourceConnections()) {
                if (!(nextAssociation2 instanceof EnumeratedTypeLink) || associations.contains(nextAssociation2)) continue;
                associations.add(nextAssociation2);
            }
            for (NodeConnectionModel nextAssociation2 : child.getTargetConnections()) {
                if (!(nextAssociation2 instanceof EnumeratedTypeLink) || associations.contains(nextAssociation2)) continue;
                associations.add(nextAssociation2);
            }
        }
        return associations;
    }

    public void resetExtentLocations(DiagramModelNode mappingDiagramModelNode, Diagram diagram, MappingAdapterFilter xmlFilter, int newY) {
        if (diagram.getType() != null) {
            DiagramEditPart diagramEP = null;
            DiagramViewer viewer = ((MappingDiagramNode)mappingDiagramModelNode).getViewer();
            if (viewer != null) {
                diagramEP = (DiagramEditPart)viewer.getContents();
            }
            if (diagramEP != null) {
                diagramEP.setUnderConstruction(true);
            }
            if (diagram.getType().equals("mappingDiagramType")) {
                ((MappingDiagramNode)mappingDiagramModelNode).setCurrentYOrigin(newY);
                this.resetExtents(mappingDiagramModelNode, newY);
            } else {
                ((MappingDiagramNode)mappingDiagramModelNode).setCurrentYOrigin(newY);
                this.resetExtents(mappingDiagramModelNode, newY);
            }
            if (diagramEP != null) {
                diagramEP.constructionCompleted(false);
            }
        }
    }

    private boolean extentsAreEqual(MappingExtent extent1, MappingExtent extent2) {
        boolean result = false;
        if (extent1.getDocumentNodeReference() != null && extent2.getDocumentNodeReference() != null && extent1.getDocumentNodeReference().equals(extent2.getDocumentNodeReference())) {
            if (extent1.getMappingReference() != null && extent2.getMappingReference() != null && extent1.getMappingReference().equals(extent2.getMappingReference())) {
                result = true;
            } else if (extent1.getMappingReference() == null) {
                result = true;
            }
        } else if (extent1.getDocumentNodeReference() == null && extent2.getDocumentNodeReference() == null && extent1.getMappingReference() != null && extent2.getMappingReference() != null && extent1.getMappingReference().equals(extent2.getMappingReference())) {
            result = true;
        }
        return result;
    }

    private boolean extentListContains(List extentList, MappingExtent extent) {
        Iterator iter = extentList.iterator();
        MappingExtent nextExtent = null;
        while (iter.hasNext()) {
            nextExtent = (MappingExtent)iter.next();
            if (!this.extentsAreEqual(extent, nextExtent)) continue;
            return true;
        }
        return false;
    }

    private void resetExtents(DiagramModelNode mappingDiagramModelNode, int newY) {
        Iterator iter = this.getExistingMappingExtentNodes(mappingDiagramModelNode).iterator();
        MappingExtentNode nextExtentNode = null;
        while (iter.hasNext()) {
            nextExtentNode = (MappingExtentNode)((Object)iter.next());
            if (nextExtentNode == null) continue;
            nextExtentNode.setExtentPosition(newY);
        }
    }

    private void addRecursionImage(DiagramModelNode diagramNode) {
        if (diagramNode instanceof UmlClassifierNode && diagramNode.getModelObject() instanceof MappingClass) {
            MappingClass mc = (MappingClass)diagramNode.getModelObject();
            if (mc.isRecursionAllowed()) {
                Image image = UiPlugin.getDefault().getImage("icons/full/obj16/recursion.gif");
                if (image != null) {
                    diagramNode.setFirstOverlayImage(image, "org.teiid.designer.mapping.ui.recursion.RecursionObjectEditorPage");
                }
            } else {
                diagramNode.setFirstOverlayImage(null, null);
            }
        }
    }

    private void addEditInputSetImage(DiagramModelNode diagramNode) {
    }

    public boolean isDrawable(EObject object) {
        boolean bResult = true;
        if (ModelMapperFactory.isXmlTreeNode((EObject)object)) {
            bResult = false;
        }
        return bResult;
    }

    public String toString() {
        return "MappingDiagamModelFactory()";
    }

    public void addSourceTable(EObject transformationEObject, DiagramModelNode transformationDiagramModelNode, EObject sourceEObject) {
        super.addSourceTable(transformationEObject, transformationDiagramModelNode, sourceEObject);
        if (sourceEObject instanceof StagingTable) {
            DiagramModelNode dmn = this.getStagingTableNode(transformationDiagramModelNode, sourceEObject);
            DiagramModelNode tNode = this.getTransformationNode(transformationDiagramModelNode);
            Point tNodePos = tNode.getPosition();
            if (dmn != null) {
                Point newPosition = new Point(tNodePos.x + tNode.getWidth() + 40, tNodePos.y + tNode.getHeight() + 40);
                dmn.setPosition(newPosition);
            }
        }
    }

    private DiagramModelNode getStagingTableNode(DiagramModelNode transformationDiagramModelNode, EObject sourceEObject) {
        List contents = transformationDiagramModelNode.getChildren();
        Iterator iter = contents.iterator();
        Object nextChild = null;
        while (iter.hasNext()) {
            EObject nodeEObject;
            nextChild = iter.next();
            if (!(nextChild instanceof DiagramModelNode) || !(nextChild instanceof UmlClassifierNode) || (nodeEObject = ((DiagramModelNode)nextChild).getModelObject()) != sourceEObject) continue;
            return nextChild;
        }
        return null;
    }

    private boolean isValidRenameSource(Object source) {
        return source == null || !(source instanceof MergeMappingClassesAction) && !(source instanceof SplitMappingClassAction);
    }
}

