/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Image;
import org.teiid.designer.diagram.ui.connection.NodeConnectionModel;
import org.teiid.designer.diagram.ui.editor.DiagramEditorUtil;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.mapping.ui.UiConstants;
import org.teiid.designer.mapping.ui.UiPlugin;
import org.teiid.designer.mapping.ui.editor.MappingExtent;
import org.teiid.designer.mapping.ui.editor.SummaryExtent;
import org.teiid.designer.mapping.ui.model.MappingExtentNode;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.diagram.DiagramEntity;
import org.teiid.designer.metamodels.transformation.FragmentMappingRoot;
import org.teiid.designer.metamodels.transformation.StagingTable;
import org.teiid.designer.metamodels.transformation.TreeMappingRoot;

public class SummaryExtentNode
extends MappingExtentNode
implements UiConstants {
    private Image image;
    private HashMap hmapMappingClasses = new HashMap();
    private static final String MAPPED_NODES_PREFIX = UiConstants.Util.getString("SummaryExtentNode.mappedNodes.prefix", new Object[0]);
    private static final String UNMAPPED_NODES_PREFIX = UiConstants.Util.getString("SummaryExtentNode.unmappedNodes.prefix", new Object[0]);

    public SummaryExtentNode(DiagramModelNode diagramModelNode, EObject modelObject, MappingExtent theExtent, boolean isCoarse) {
        super(diagramModelNode, modelObject, theExtent, isCoarse);
    }

    @Override
    protected DiagramEntity findDiagramEntity(Diagram diagram, Object secondaryObject) {
        return null;
    }

    @Override
    protected void initialize(Diagram diagramModelObject, Object secondObject) {
    }

    @Override
    public String toString() {
        return "SummaryExtentNode(" + this.getName() + ")";
    }

    @Override
    public void setMappingClass(EObject locationEObject) {
    }

    @Override
    public EObject getMappingClass() {
        return null;
    }

    public Image getImage() {
        if (this.image == null) {
            this.image = UiPlugin.getDefault().getImage("icons/full/obj16/Column.png");
        }
        return this.image;
    }

    public int getImagePosition() {
        return 0;
    }

    public HashMap getMappingClasses() {
        return this.hmapMappingClasses;
    }

    public void setMappingClasses(HashMap hmapMappingClasses) {
        this.hmapMappingClasses = hmapMappingClasses;
    }

    @Override
    public List getDependencies() {
        if (this.getModelObject() instanceof TreeMappingRoot || this.getModelObject() instanceof FragmentMappingRoot) {
            ArrayList<EObject> deps = new ArrayList<EObject>(1);
            Iterator connIter = this.getTargetConnections().iterator();
            NodeConnectionModel nextLink = null;
            while (connIter.hasNext()) {
                nextLink = (NodeConnectionModel)connIter.next();
                if (nextLink.getSourceNode() == null) continue;
                deps.add(((DiagramModelNode)nextLink.getSourceNode()).getModelObject());
            }
            return deps;
        }
        return Collections.EMPTY_LIST;
    }

    public List getAssociations(HashMap nodeMap) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public MappingExtent getExtent() {
        return this.extent;
    }

    @Override
    public void setExtent(MappingExtent extent) {
        this.extent = extent;
    }

    @Override
    public void setExtentPosition(int newYOrigin) {
        double zoomFactor = DiagramEditorUtil.getCurrentZoomFactor();
        if (this.getExtent() != null) {
            int newY = (int)(this.getExtent().getOffset() / zoomFactor) + (int)((double)newYOrigin / zoomFactor);
            this.setPosition(new Point(4, newY));
        } else {
            this.setPosition(new Point(4, (int)((double)newYOrigin / zoomFactor)));
        }
    }

    @Override
    public String getReferenceName() {
        String extentReference = this.extent.getDocumentNodeReference().toString();
        return extentReference;
    }

    @Override
    public boolean isOnCoarseMappingDiagram() {
        return this.isCoarseExtent;
    }

    @Override
    public EObject getModelObject() {
        if (this.isOnCoarseMappingDiagram()) {
            return super.getModelObject();
        }
        if (this.getExtent() != null && !(this.getExtent().getMappingReference() instanceof StagingTable)) {
            return super.getModelObject();
        }
        if (this.getExtent() != null) {
            return this.getExtent().getMappingReference();
        }
        return super.getModelObject();
    }

    @Override
    public List getToolTipStrings() {
        ArrayList<String> returnList = new ArrayList<String>();
        SummaryExtent seExtent = (SummaryExtent)this.getExtent();
        this.addToolTipStringsForLocation(returnList, seExtent);
        returnList.add(String.valueOf(MAPPED_NODES_PREFIX) + " " + seExtent.getMappingClassColumnCount());
        returnList.add(String.valueOf(UNMAPPED_NODES_PREFIX) + " " + seExtent.getUnmappedNodeCount());
        return returnList;
    }
}

