/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.part;

import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.swt.graphics.Color;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.part.AbstractDiagramEditPart;
import org.teiid.designer.diagram.ui.part.DiagramEditPart;
import org.teiid.designer.diagram.ui.util.DiagramNodeSelectionEditPolicy;
import org.teiid.designer.mapping.ui.figure.MappingExtentFigure;
import org.teiid.designer.mapping.ui.model.MappingExtentNode;
import org.teiid.designer.metamodels.transformation.StagingTable;

public class MappingExtentEditPart
extends AbstractDiagramEditPart {
    private static int nExtents = 0;
    private DragTracker myDragTracker = null;

    public MappingExtentEditPart() {
    }

    public MappingExtentEditPart(String diagramTypeId) {
        this.setDiagramTypeId(diagramTypeId);
        this.init();
        ++nExtents;
    }

    public void init() {
        if (this.getAnchorManager() == null) {
            this.setAnchorManager(this.getEditPartFactory().getAnchorManager((DiagramEditPart)this));
        }
    }

    protected IFigure createFigure() {
        Point location = new Point(100, 100);
        MappingExtentFigure extentFigure = (MappingExtentFigure)this.getFigureFactory().createFigure(this.getModel());
        extentFigure.setLocation(location);
        List toolTips = ((MappingExtentNode)((Object)this.getModel())).getToolTipStrings();
        if (toolTips != null && !toolTips.isEmpty()) {
            extentFigure.setToolTip(extentFigure.createToolTip(toolTips));
        }
        extentFigure.setOutlineWidth(3);
        return extentFigure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", (EditPolicy)new DiagramNodeSelectionEditPolicy());
        this.installEditPolicy("PrimaryDrag Policy", null);
    }

    protected List getModelChildren() {
        List children = ((DiagramModelNode)this.getModel()).getChildren();
        return children;
    }

    protected void refreshVisuals() {
        Point loc = ((DiagramModelNode)this.getModel()).getPosition();
        Dimension size = ((DiagramModelNode)this.getModel()).getSize();
        Rectangle r = new Rectangle(loc, size);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)r);
        this.getFigure().repaint();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if (prop.equals("size")) {
            ((MappingExtentFigure)this.getFigure()).updateForSize(((DiagramModelNode)this.getModel()).getSize());
            this.getChangeManager().refresh(4, false);
            this.getChangeManager().refresh(1, false);
        } else if (prop.equals("connection")) {
            this.getChangeManager().refresh(0, false);
            this.getChangeManager().refresh(4, false);
            this.getChangeManager().refresh(1, false);
        } else if (prop.equals("location")) {
            this.getChangeManager().refresh(4, false);
            this.getChangeManager().refresh(1, false);
        }
    }

    public void resizeChildren() {
        this.getDiagramFigure().updateForSize(((DiagramModelNode)this.getModel()).getSize());
    }

    public void hiliteBackground(Color hiliteColor) {
        if (this.hasConnections()) {
            this.getDiagramFigure().hiliteBackground(hiliteColor);
        } else {
            MappingExtentNode nextNode = (MappingExtentNode)((Object)this.getModel());
            if (!(nextNode.getModelObject() instanceof StagingTable)) {
                this.getDiagramFigure().hiliteBackground(null);
            } else {
                this.getDiagramFigure().hiliteBackground(hiliteColor);
            }
        }
    }

    private boolean hasConnections() {
        MappingExtentNode nextNode = (MappingExtentNode)((Object)this.getModel());
        return nextNode.getSourceConnections() != null && !nextNode.getSourceConnections().isEmpty() || nextNode.getTargetConnections() != null && !nextNode.getTargetConnections().isEmpty();
    }

    public List getDependencies() {
        DiagramModelNode modelNode = (DiagramModelNode)this.getModel();
        if (modelNode != null) {
            return modelNode.getDependencies();
        }
        return Collections.EMPTY_LIST;
    }

    public void layout(boolean layoutChildren) {
        if (this.getDiagramFigure() != null) {
            this.getDiagramFigure().layoutFigure();
        }
        this.updateModelSize();
    }

    public DragTracker getDragTracker(Request req) {
        if (this.myDragTracker == null) {
            this.myDragTracker = new SelectEditPartTracker((EditPart)this);
        }
        return this.myDragTracker;
    }

    public boolean shouldReveal() {
        return false;
    }

    public void updateModelSize() {
        if (((MappingExtentNode)((Object)this.getModel())).getExtent().getMappingReference() instanceof StagingTable) {
            ((MappingExtentNode)((Object)this.getModel())).updateModelForExtent();
        } else {
            super.updateModelSize();
        }
    }

    public void activate() {
        super.activate();
        if (((MappingExtentNode)((Object)this.getModel())).getExtent().getMappingReference() instanceof StagingTable) {
            ((MappingExtentNode)((Object)this.getModel())).updateModelForExtent();
        }
    }

    public void constructionCompleted(boolean updateLinkedParts) {
        if (this.isUnderConstruction()) {
            this.getChangeManager().executeRefresh(updateLinkedParts);
            super.constructionCompleted(updateLinkedParts);
        }
    }
}

