/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.mapping.ui.PluginConstants;
import org.teiid.designer.mapping.ui.UiConstants;
import org.teiid.designer.mapping.ui.UiPlugin;
import org.teiid.designer.ui.common.preferences.IEditorPreferencesComponent;
import org.teiid.designer.ui.common.preferences.IEditorPreferencesValidationListener;
import org.teiid.designer.ui.common.util.WidgetFactory;

public class XmlDocumentPreferencesComponent
implements IEditorPreferencesComponent,
UiConstants,
PluginConstants {
    private Text upperRecursionLimit;
    private Button removeDuplicateAttributesButton;
    private String name = UiPlugin.getDefault().getPluginUtil().getString("XmlDocumentPreferencesComponent.name", new Object[0]);
    private String upperRecurionLimitMessage = UiPlugin.getDefault().getPluginUtil().getString("XmlDocumentPreferencesComponent.upperRecursionLimit", new Object[0]);
    private String removeDuplicateAttributesMessage = UiPlugin.getDefault().getPluginUtil().getString("XmlDocumentPreferencesComponent.removeDuplicateAttributes", new Object[0]);
    String sNumericErrorMsg = Util.getString("XmlDocumentPreferencesComponent.numericErrorMsg", new Object[0]);
    private List<IEditorPreferencesValidationListener> validationListeners = new ArrayList<IEditorPreferencesValidationListener>();
    private Text txfAutoExpandMappingClassMax;
    private Text txfAutoExpandTreeTargetLevel;
    private Button btnDisplayMappingClassesFolded;
    private boolean changeMade;
    private boolean isSelected;

    public String getName() {
        return this.name;
    }

    public String getTooltip() {
        return this.name;
    }

    public Composite createEditorPreferencesComponent(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.numColumns = 1;
        comp.setLayout((Layout)layout);
        String mappingTreeHeader = Util.getString("XmlDocumentPreferencesComponent.mappingDiagramTreePrefsHeader", new Object[0]);
        Group mappingTreeGroup = WidgetFactory.createGroup((Composite)comp, (String)mappingTreeHeader, (int)768, (int)1, (int)3);
        String sAutoExpandMappingClassMaxLabel1 = Util.getString("XmlDocumentPreferencesComponent.autoExpandMappingClassMaxLabel1", new Object[0]);
        WidgetFactory.createLabel((Composite)mappingTreeGroup, (String)sAutoExpandMappingClassMaxLabel1);
        this.txfAutoExpandMappingClassMax = WidgetFactory.createTextField((Composite)mappingTreeGroup);
        GridData gd1 = new GridData();
        gd1.widthHint = 40;
        this.txfAutoExpandMappingClassMax.setLayoutData((Object)gd1);
        String sAutoExpandMappingClassMaxLabel2 = Util.getString("XmlDocumentPreferencesComponent.autoExpandMappingClassMaxLabel2", new Object[0]);
        WidgetFactory.createLabel((Composite)mappingTreeGroup, (String)sAutoExpandMappingClassMaxLabel2);
        String sAutoExpandMappingClassMaxValue = "0";
        sAutoExpandMappingClassMaxValue = this.getPreferenceStore().getString("autoExpandMaxMappingClasses");
        if (sAutoExpandMappingClassMaxValue.trim().equals("")) {
            sAutoExpandMappingClassMaxValue = this.getPreferenceStore().getDefaultString("autoExpandMaxMappingClasses");
        }
        this.txfAutoExpandMappingClassMax.setText(sAutoExpandMappingClassMaxValue);
        this.txfAutoExpandMappingClassMax.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XmlDocumentPreferencesComponent.this.validate();
            }
        });
        String sAutoExpandTreeTargetLevelLabel = Util.getString("XmlDocumentPreferencesComponent.autoExpandTreeTargetLevelLabel", new Object[0]);
        WidgetFactory.createLabel((Composite)mappingTreeGroup, (String)sAutoExpandTreeTargetLevelLabel);
        this.txfAutoExpandTreeTargetLevel = WidgetFactory.createTextField((Composite)mappingTreeGroup);
        GridData gd2 = new GridData();
        gd2.widthHint = 40;
        gd2.horizontalSpan = 2;
        this.txfAutoExpandTreeTargetLevel.setLayoutData((Object)gd2);
        String sAutoExpandTreeTargetLevelValue = "0";
        sAutoExpandTreeTargetLevelValue = this.getPreferenceStore().getString("autoExpandTargetLevel");
        if (sAutoExpandTreeTargetLevelValue.trim().equals("")) {
            sAutoExpandTreeTargetLevelValue = this.getPreferenceStore().getDefaultString("autoExpandTargetLevel");
        }
        this.txfAutoExpandTreeTargetLevel.setText(sAutoExpandTreeTargetLevelValue);
        this.txfAutoExpandTreeTargetLevel.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XmlDocumentPreferencesComponent.this.validate();
            }
        });
        this.btnDisplayMappingClassesFolded = new Button((Composite)mappingTreeGroup, 32);
        String sDisplayMappingClassesFoldedLabel = Util.getString("XmlDocumentPreferencesComponent.displayMappingClassesFoldedLabel", new Object[0]);
        this.btnDisplayMappingClassesFolded.setText(sDisplayMappingClassesFoldedLabel);
        boolean bool = this.getPreferenceStore().getBoolean("foldMappingClassesByDefault");
        this.btnDisplayMappingClassesFolded.setSelection(bool);
        this.createOtherSettingsControls(comp);
        return comp;
    }

    private void createOtherSettingsControls(Composite parent) {
        String mappingGroupHdr = Util.getString("XmlDocumentPreferencesComponent.xmlMappingGroupLabel", new Object[0]);
        Group mappingGroup = WidgetFactory.createGroup((Composite)parent, (String)mappingGroupHdr, (int)768, (int)1, (int)2);
        Label label = new Label((Composite)mappingGroup, 0);
        label.setText(this.upperRecurionLimitMessage);
        this.upperRecursionLimit = new Text((Composite)mappingGroup, 2048);
        this.upperRecursionLimit.setText("111");
        this.upperRecursionLimit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XmlDocumentPreferencesComponent.this.validate();
            }
        });
        this.removeDuplicateAttributesButton = new Button((Composite)mappingGroup, 32);
        this.removeDuplicateAttributesButton.setText(this.removeDuplicateAttributesMessage);
        this.removeDuplicateAttributesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                XmlDocumentPreferencesComponent.this.setButtonEnabling();
            }
        });
        this.setInitialButtonStates();
    }

    private void setInitialButtonStates() {
        this.upperRecursionLimit.setText(String.valueOf(ModelerCore.getTransformationPreferences().getUpperRecursionLimit()));
        this.removeDuplicateAttributesButton.setSelection(ModelerCore.getTransformationPreferences().getRemoveDuplicateAttibutes());
        this.setButtonEnabling();
    }

    public boolean performOk() {
        Integer val;
        String sNewAutoExpandTreeTargetLevel;
        String sOldAutoExpandTreeTargetLevel;
        String sNewAutoExpandMappingClassMax;
        String sOldAutoExpandMappingClassMax = this.getPreferenceStore().getString("autoExpandMaxMappingClasses");
        if (!sOldAutoExpandMappingClassMax.equals(sNewAutoExpandMappingClassMax = this.txfAutoExpandMappingClassMax.getText())) {
            this.getPreferenceStore().setValue("autoExpandMaxMappingClasses", sNewAutoExpandMappingClassMax);
            UiPlugin.getDefault().savePreferences();
        }
        if (!(sOldAutoExpandTreeTargetLevel = this.getPreferenceStore().getString("autoExpandTargetLevel")).equals(sNewAutoExpandTreeTargetLevel = this.txfAutoExpandTreeTargetLevel.getText())) {
            this.getPreferenceStore().setValue("autoExpandTargetLevel", sNewAutoExpandTreeTargetLevel);
            UiPlugin.getDefault().savePreferences();
        }
        this.getPreferenceStore().setValue("foldMappingClassesByDefault", this.btnDisplayMappingClassesFolded.getSelection());
        boolean bl = this.isSelected = this.removeDuplicateAttributesButton.getEnabled() && this.removeDuplicateAttributesButton.getSelection();
        if (this.isSelected != ModelerCore.getTransformationPreferences().getRemoveDuplicateAttibutes()) {
            ModelerCore.getTransformationPreferences().setRemoveDuplicateAttibutes(this.isSelected);
            this.changeMade = true;
        }
        if ((val = new Integer(this.upperRecursionLimit.getText())).intValue() != ModelerCore.getTransformationPreferences().getUpperRecursionLimit()) {
            ModelerCore.getTransformationPreferences().setUpperRecursionLimit(val.intValue());
            this.changeMade = true;
        }
        if (this.changeMade) {
            UiPlugin.getDefault().savePreferences();
        }
        return true;
    }

    public void performDefaults() {
        String sAutoExpandMappingClassMaxValue = this.getPreferenceStore().getDefaultString("autoExpandMaxMappingClasses");
        this.txfAutoExpandMappingClassMax.setText(sAutoExpandMappingClassMaxValue);
        String sAutoExpandTreeTargetLevelValue = this.getPreferenceStore().getDefaultString("autoExpandTargetLevel");
        this.txfAutoExpandTreeTargetLevel.setText(sAutoExpandTreeTargetLevelValue);
        boolean bool = this.getPreferenceStore().getDefaultBoolean("foldMappingClassesByDefault");
        this.btnDisplayMappingClassesFolded.setSelection(bool);
        this.upperRecursionLimit.setText(String.valueOf(ModelerCore.getTransformationPreferences().getUpperRecursionLimitDefault()));
        this.removeDuplicateAttributesButton.setSelection(ModelerCore.getTransformationPreferences().getRemoveDuplicateAttibutesDefault());
    }

    void setButtonEnabling() {
    }

    private IPreferenceStore getPreferenceStore() {
        return UiPlugin.getDefault().getPreferenceStore();
    }

    public void addValidationListener(IEditorPreferencesValidationListener listener) {
        this.validationListeners.add(listener);
    }

    public void removeValidationListener(IEditorPreferencesValidationListener listener) {
        this.validationListeners.remove(listener);
    }

    public void fireValidationStatus(boolean validationStatus, String message) {
        int i = 0;
        while (i < this.validationListeners.size()) {
            this.validationListeners.get(i).validationStatus(validationStatus, message);
            ++i;
        }
    }

    public void validate() {
        try {
            new Integer(this.txfAutoExpandTreeTargetLevel.getText());
            new Integer(this.txfAutoExpandMappingClassMax.getText());
            new Integer(this.upperRecursionLimit.getText());
            this.fireValidationStatus(true, null);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            this.fireValidationStatus(false, this.sNumericErrorMsg);
            return;
        }
    }
}

