/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.recursion;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.mapping.ui.PluginConstants;
import org.teiid.designer.mapping.ui.UiConstants;
import org.teiid.designer.mapping.ui.UiPlugin;
import org.teiid.designer.mapping.ui.recursion.BuilderTreeProvider;
import org.teiid.designer.mapping.ui.recursion.RecursionCriteriaStrategy;
import org.teiid.designer.mapping.ui.recursion.RecursionObject;
import org.teiid.designer.mapping.ui.recursion.actions.ClearCriteria;
import org.teiid.designer.mapping.ui.recursion.actions.LaunchCriteriaBuilder;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.sql.ISQLStringVisitor;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.lang.IQuery;
import org.teiid.designer.transformation.ui.builder.CriteriaBuilder;
import org.teiid.designer.transformation.validation.SqlTransformationResult;
import org.teiid.designer.transformation.validation.TransformationValidator;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.Label;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.query.ui.builder.util.ElementViewerFactory;
import org.teiid.query.ui.builder.util.ICriteriaStrategy;

public class RecursionPanel
extends SashForm
implements SelectionListener,
UiConstants,
PluginConstants {
    private static final int BUTTON_GRID_STYLE = 32;
    private RecursionObject roRecursionObject;
    private Composite pnlOuter;
    CheckBoxContribution recurseContribution;
    private Composite pnlCountControls;
    private Spinner spinCountLimit;
    private int upperRecursionLimit = 10;
    private CLabel lblErrorIfLimitExceeded;
    private Combo cbxErrorIfLimitExceeded;
    private Button btnEditCriteria;
    boolean listenToTextChange = false;
    static final String RECURSE_QUERY_TEXT = UiConstants.Util.getString("RecursionPanel.recurseQuery.text", new Object[0]);
    private static final String COUNT_LIMIT_TEXT = UiConstants.Util.getString("RecursionPanel.countLimit.text", new Object[0]);
    private static final String ERROR_IF_EXCEEDED_CHECKBOX_TEXT = UiConstants.Util.getString("RecursionPanel.errorIfExceededCheckBox.text", new Object[0]);
    private static final String LIMIT_CONDITION_TEXT = UiConstants.Util.getString("RecursionPanel.limitCondition.text", new Object[0]);
    private static final String EDIT_LIMIT_CONDITION_TEXT = UiConstants.Util.getString("RecursionPanel.editButton.text", new Object[0]);
    private static final String EDIT_LIMIT_CONDITION_TOOLTIP = UiConstants.Util.getString("RecursionPanel.editButton.text", new Object[0]);
    private Composite pnlConditionControls;
    private CLabel lblLimitCondition;
    private SourceViewer svrRecursionConditionCriteria;
    private Document docRecursionConditionCriteria;
    private String EMPTY_STRING = "";
    private String DEFAULT_SELECT = "Select * from Dummy Where ";
    protected static final int VERTICAL_RULER_WIDTH = 12;
    private int CHECKBOX_INDENT = 12;
    String sConditionSql = this.EMPTY_STRING;
    private LaunchCriteriaBuilder actLaunchCriteriaBuilder;
    private ClearCriteria actClearCriteria;
    private static final int LABEL_GRID_STYLE = 32;
    private static final String EDIT_BUTTON_TOOLTIP = UiConstants.Util.getString("RecursionPanel.editAction.toolTip", new Object[0]);
    private static final String CLEAR_BUTTON_TOOLTIP = UiConstants.Util.getString("RecursionPanel.clearAction.toolTip", new Object[0]);

    public RecursionPanel(Composite parent, RecursionObject roRecursionObject) {
        super(parent, 512);
        this.roRecursionObject = roRecursionObject;
        this.init();
    }

    public RecursionObject getRecursionObject() {
        return this.roRecursionObject;
    }

    private void init() {
        this.createControl((Composite)this);
        this.setButtonStates();
        if (this.roRecursionObject != null) {
            this.refreshFromBusinessObject();
        }
    }

    public void setBusinessObject(RecursionObject roRecursionObject) {
        this.roRecursionObject = roRecursionObject;
        this.refreshFromBusinessObject();
    }

    public void refreshFromBusinessObject() {
        this.listenToTextChange = false;
        this.docRecursionConditionCriteria.set(this.getRecursionObject().getRecursionCriteria());
        String sText = this.getRecursionObject().getRecursionLimitErrorMode();
        if (sText != null && !sText.equals(this.EMPTY_STRING)) {
            int iIndex = this.cbxErrorIfLimitExceeded.indexOf(sText);
            if (iIndex > -1) {
                this.cbxErrorIfLimitExceeded.select(iIndex);
            } else {
                this.cbxErrorIfLimitExceeded.select(0);
            }
        } else {
            this.cbxErrorIfLimitExceeded.select(0);
        }
        this.restoreRecursionLimit();
        this.spinCountLimit.setSelection(this.getRecursionObject().getRecursionLimit());
        this.getCheckBoxContributionForRecurseQuery().setSelection(this.getRecursionObject().isRecursive());
        this.setButtonStates();
        this.listenToTextChange = true;
    }

    private void restoreRecursionLimit() {
        this.upperRecursionLimit = ModelerCore.getTransformationPreferences().getUpperRecursionLimit();
        this.upperRecursionLimit = Math.max(this.upperRecursionLimit, this.getRecursionObject().getRecursionLimit());
        this.spinCountLimit.setMinimum(1);
        this.spinCountLimit.setMaximum(this.upperRecursionLimit);
        this.spinCountLimit.setToolTipText(UiConstants.Util.getString("RecursionPanel.limitSpinner.toolTip", new Object[]{this.spinCountLimit.getMinimum(), this.spinCountLimit.getMaximum()}));
    }

    public void createControl(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 1;
        GridData gridData = new GridData(1808);
        gridData.widthHint = 600;
        gridData.heightHint = 400;
        this.setLayoutData(gridData);
        this.pnlOuter = new Composite((Composite)this, 0);
        gridLayout = new GridLayout();
        this.pnlOuter.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 1;
        this.createCountControlsPanel(this.pnlOuter);
        this.createConditionControlsPanel(this.pnlOuter);
    }

    private void createCountControlsPanel(Composite parent) {
        this.pnlCountControls = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        this.pnlCountControls.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 4;
        WidgetFactory.createLabel((Composite)this.pnlCountControls, (int)32, (String)COUNT_LIMIT_TEXT);
        this.spinCountLimit = new Spinner(this.pnlCountControls, 0);
        this.restoreRecursionLimit();
        this.spinCountLimit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent theEvent) {
                if (RecursionPanel.this.listenToTextChange) {
                    RecursionPanel.this.handleSpinnerChanged();
                }
            }
        });
        this.lblErrorIfLimitExceeded = WidgetFactory.createLabel((Composite)this.pnlCountControls, (int)32, (String)ERROR_IF_EXCEEDED_CHECKBOX_TEXT);
        GridData gridData3 = new GridData();
        gridData3.horizontalIndent = 7;
        this.lblErrorIfLimitExceeded.setLayoutData((Object)gridData3);
        this.createErrorIfCountExceededCombobox(this.pnlCountControls);
    }

    private void createErrorIfCountExceededCombobox(Composite parent) {
        this.cbxErrorIfLimitExceeded = new Combo(parent, 2056);
        this.cbxErrorIfLimitExceeded.setToolTipText(ERROR_IF_EXCEEDED_CHECKBOX_TEXT);
        this.cbxErrorIfLimitExceeded.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RecursionPanel.this.handleCountExceededComboboxPressed();
            }
        });
        String[] saErrorModeVals = this.getRecursionObject().getValidErrorModeValues();
        int i = 0;
        while (i < saErrorModeVals.length) {
            this.cbxErrorIfLimitExceeded.add(saErrorModeVals[i]);
            ++i;
        }
    }

    void handleCountExceededComboboxPressed() {
        int iSelectedIndex = this.cbxErrorIfLimitExceeded.getSelectionIndex();
        if (iSelectedIndex < 0) {
            return;
        }
        String sErrorMode = this.cbxErrorIfLimitExceeded.getItem(iSelectedIndex);
        this.getRecursionObject().setRecursionLimitErrorMode(sErrorMode);
    }

    void handleRecursiveQueryCheckBoxChanged() {
        this.getRecursionObject().setRecursive(this.getCheckBoxContributionForRecurseQuery().getSelection());
        this.getCheckBoxContributionForRecurseQuery().getControl().update();
        this.setButtonStates();
    }

    void handleSpinnerChanged() {
        int newValue = this.spinCountLimit.getSelection();
        if (newValue != this.roRecursionObject.getRecursionLimit()) {
            this.getRecursionObject().setRecursionLimit(newValue);
        }
    }

    private void createConditionControlsPanel(Composite parent) {
        this.pnlConditionControls = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        this.pnlConditionControls.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 3;
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.pnlConditionControls.setLayoutData((Object)gridData);
        this.lblLimitCondition = WidgetFactory.createLabel((Composite)this.pnlConditionControls, (int)32, (String)LIMIT_CONDITION_TEXT);
        GridData gridData3 = new GridData();
        gridData3.horizontalIndent = this.CHECKBOX_INDENT;
        this.lblLimitCondition.setLayoutData((Object)gridData3);
        this.btnEditCriteria = WidgetFactory.createButton((Composite)this.pnlConditionControls, (String)EDIT_LIMIT_CONDITION_TEXT);
        this.btnEditCriteria.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RecursionPanel.this.handleEditButtonClicked();
            }
        });
        this.btnEditCriteria.setToolTipText(EDIT_LIMIT_CONDITION_TOOLTIP);
        GridData gridData4 = new GridData();
        gridData4.horizontalIndent = 5;
        this.btnEditCriteria.setLayoutData((Object)gridData4);
        Label lblFiller = WidgetFactory.createLabel((Composite)this.pnlConditionControls, (int)32, (String)this.EMPTY_STRING);
        GridData gridData5 = new GridData(1808);
        gridData5.grabExcessHorizontalSpace = true;
        lblFiller.setLayoutData((Object)gridData5);
        VerticalRuler verticalRuler = new VerticalRuler(12);
        int styles = 68162;
        this.svrRecursionConditionCriteria = new SourceViewer(this.pnlConditionControls, (IVerticalRuler)verticalRuler, styles);
        this.docRecursionConditionCriteria = new Document();
        this.svrRecursionConditionCriteria.setDocument((IDocument)this.docRecursionConditionCriteria);
        this.svrRecursionConditionCriteria.setEditable(false);
        this.svrRecursionConditionCriteria.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        GridData gridData2 = new GridData(1808);
        gridData2.horizontalAlignment = 4;
        gridData2.verticalAlignment = 4;
        gridData2.horizontalSpan = 3;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.grabExcessVerticalSpace = true;
        this.svrRecursionConditionCriteria.getControl().setLayoutData((Object)gridData2);
    }

    void handleEditButtonClicked() {
        this.launchCriteriaBuilder();
    }

    public void contributeToolbarActions(ToolBarManager toolBarMgr) {
        toolBarMgr.removeAll();
        toolBarMgr.add((IContributionItem)this.getCheckBoxContributionForRecurseQuery());
        toolBarMgr.add((IContributionItem)new Separator());
        toolBarMgr.add((IAction)this.getLaunchCriteriaBuilderAction());
        toolBarMgr.add((IAction)this.getClearCriteriaBuilderAction());
        toolBarMgr.update(true);
        this.getCheckBoxContributionForRecurseQuery().setEnabled(true);
        this.getCheckBoxContributionForRecurseQuery().setSelection(this.getRecursionObject().isRecursive());
        this.setButtonStates();
    }

    private void setButtonStates() {
        if (ModelObjectUtilities.isReadOnly((EObject)this.getRecursionObject().getMappingClass())) {
            this.spinCountLimit.setEnabled(false);
            this.cbxErrorIfLimitExceeded.setEnabled(false);
            if (this.getCheckBoxContributionForRecurseQuery().getControl() != null) {
                this.getCheckBoxContributionForRecurseQuery().getControl().setEnabled(false);
            }
            this.btnEditCriteria.setEnabled(false);
            this.getClearCriteriaBuilderAction().selectionChanged();
            this.getLaunchCriteriaBuilderAction().selectionChanged();
            return;
        }
        if (!this.getCheckBoxContributionForRecurseQuery().getSelection()) {
            this.spinCountLimit.setEnabled(false);
            this.cbxErrorIfLimitExceeded.setEnabled(false);
        } else {
            this.spinCountLimit.setEnabled(true);
            this.cbxErrorIfLimitExceeded.setEnabled(true);
        }
        this.spinCountLimit.update();
        this.cbxErrorIfLimitExceeded.update();
        this.getClearCriteriaBuilderAction().selectionChanged();
        this.getLaunchCriteriaBuilderAction().selectionChanged();
        this.btnEditCriteria.setEnabled(this.canLaunchCriteriaBuilder());
    }

    private CheckBoxContribution getCheckBoxContributionForRecurseQuery() {
        if (this.recurseContribution == null) {
            this.recurseContribution = new CheckBoxContribution(RECURSE_QUERY_TEXT);
        }
        return this.recurseContribution;
    }

    private LaunchCriteriaBuilder getLaunchCriteriaBuilderAction() {
        if (this.actLaunchCriteriaBuilder == null) {
            this.actLaunchCriteriaBuilder = new LaunchCriteriaBuilder(this);
            this.actLaunchCriteriaBuilder.setToolTipText(EDIT_BUTTON_TOOLTIP);
        }
        return this.actLaunchCriteriaBuilder;
    }

    private ClearCriteria getClearCriteriaBuilderAction() {
        if (this.actClearCriteria == null) {
            this.actClearCriteria = new ClearCriteria(this);
            this.actClearCriteria.setToolTipText(CLEAR_BUTTON_TOOLTIP);
        }
        return this.actClearCriteria;
    }

    public boolean canLaunchCriteriaBuilder() {
        boolean enable;
        boolean bl = enable = !ModelObjectUtilities.isReadOnly((EObject)this.getRecursionObject().getMappingClass());
        if (enable) {
            enable = !this.getRecursionObject().getMappingClass().getColumns().isEmpty();
        }
        return enable;
    }

    public void launchCriteriaBuilder() {
        MappingClass mc = this.getRecursionObject().getMappingClass();
        new BuilderTreeProvider();
        ElementViewerFactory.setCriteriaStrategy((ICriteriaStrategy)new RecursionCriteriaStrategy());
        ArrayList<MappingClass> lstMappingClassWrapper = new ArrayList<MappingClass>(1);
        lstMappingClassWrapper.add(mc);
        ElementViewerFactory.setViewerInput(lstMappingClassWrapper);
        CriteriaBuilder builder = this.getCriteriaBuilder();
        String sSql = this.getRecursionObject().getRecursionCriteria();
        if (sSql != null && !sSql.trim().equals(this.EMPTY_STRING)) {
            builder.setLanguageObject((ILanguageObject)this.getCommand(sSql).getCriteria());
        } else {
            builder.setLanguageObject(null);
        }
        int status = builder.open();
        if (status == 0) {
            ILanguageObject newCriteria = builder.getLanguageObject();
            IQueryService queryService = ModelerCore.getTeiidQueryService();
            ISQLStringVisitor visitor = queryService.getSQLStringVisitor();
            String sCriteriaString = visitor.returnSQLString(newCriteria);
            this.docRecursionConditionCriteria.set(sCriteriaString);
            this.getRecursionObject().setRecursionCriteria(sCriteriaString);
        }
        this.getLaunchCriteriaBuilderAction().selectionChanged();
        this.setButtonStates();
    }

    private IQuery getCommand(String sSql) {
        String sCommand = String.valueOf(this.DEFAULT_SELECT) + sSql;
        SqlTransformationResult result = TransformationValidator.parseSQL((String)sCommand);
        return (IQuery)result.getCommand();
    }

    private CriteriaBuilder getCriteriaBuilder() {
        Shell shell = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder(shell);
        criteriaBuilder.create();
        return criteriaBuilder;
    }

    public boolean canClearCriteria() {
        if (ModelObjectUtilities.isReadOnly((EObject)this.getRecursionObject().getMappingClass())) {
            return false;
        }
        return !this.docRecursionConditionCriteria.get().equals(this.EMPTY_STRING);
    }

    public void clearCriteria() {
        this.docRecursionConditionCriteria.set(this.EMPTY_STRING);
        this.getRecursionObject().setRecursionCriteria(this.EMPTY_STRING);
        this.setButtonStates();
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    class CheckBoxContribution
    extends ControlContribution {
        private Button chkRecurseQuery;
        Combo cbx;

        public CheckBoxContribution(String id) {
            super(id);
            this.cbx = null;
        }

        protected Control createControl(Composite parent) {
            this.chkRecurseQuery = WidgetFactory.createCheckBox((Composite)parent, (String)RECURSE_QUERY_TEXT, (int)32);
            this.chkRecurseQuery.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    RecursionPanel.this.handleRecursiveQueryCheckBoxChanged();
                }
            });
            this.chkRecurseQuery.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ((CheckBoxContribution)CheckBoxContribution.this).RecursionPanel.this.recurseContribution = null;
                }
            });
            this.chkRecurseQuery.setEnabled(true);
            if (RecursionPanel.this.getRecursionObject() != null) {
                this.chkRecurseQuery.setSelection(RecursionPanel.this.getRecursionObject().isRecursive());
            } else {
                this.chkRecurseQuery.setSelection(true);
            }
            return this.chkRecurseQuery;
        }

        public Control getControl() {
            return this.chkRecurseQuery;
        }

        public void setSelection(boolean b) {
            if (this.chkRecurseQuery != null) {
                this.chkRecurseQuery.setSelection(b);
            }
        }

        public boolean getSelection() {
            if (this.chkRecurseQuery != null) {
                return this.chkRecurseQuery.getSelection();
            }
            return true;
        }

        public void setEnabled(boolean enabled) {
            if (this.chkRecurseQuery != null) {
                this.chkRecurseQuery.setEnabled(enabled);
            }
        }
    }
}

