/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.util;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.util.INewModelObjectHelper;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.mapping.ui.diagram.MappingDiagramProvider;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class MappingUiNewModelObjectHelper
implements INewModelObjectHelper {
    private static MappingDiagramProvider mappingDiagramProvider;

    public MappingUiNewModelObjectHelper() {
        mappingDiagramProvider = new MappingDiagramProvider();
    }

    public boolean canHelpCreate(Object newObject) {
        CoreArgCheck.isNotNull((Object)newObject);
        if (newObject != null && newObject instanceof EObject) {
            EObject newEObject = (EObject)newObject;
            return this.isMappingClass(newEObject);
        }
        return false;
    }

    private boolean isMappingClass(EObject newEObject) {
        return TransformationHelper.isVirtual((Object)newEObject) && TransformationHelper.isSqlTable((Object)newEObject) && !TransformationHelper.isXmlDocument((Object)newEObject) && TransformationHelper.isMappingClass((Object)newEObject);
    }

    public boolean helpCreate(Object newObject, Map properties, List<EObject> references) {
        ModelResource mr;
        EObject newTarget;
        CoreArgCheck.isNotNull((Object)newObject);
        if (newObject instanceof EObject && this.isMappingClass(newTarget = (EObject)newObject) && (mr = ModelUtilities.getModelResourceForModelObject((EObject)newTarget)) != null && !this.diagramExists(newTarget, mr)) {
            mappingDiagramProvider.getDetailedMappingDiagram(newTarget);
        }
        return true;
    }

    private boolean diagramExists(EObject target, ModelResource modelResource) {
        return mappingDiagramProvider.hasDetailedMappingDiagram(modelResource, target);
    }
}

