/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.util;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.diagram.ui.editor.DiagramController;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.mapping.factory.MappingClassFactory;
import org.teiid.designer.mapping.factory.TreeMappingAdapter;
import org.teiid.designer.mapping.ui.UiConstants;
import org.teiid.designer.mapping.ui.editor.MappingDiagramController;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.AbstractUiPlugin;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class MappingUiUtil
implements UiConstants {
    public static TreeMappingAdapter getCurrentTreeMappingAdapter() {
        DiagramController controller;
        ModelEditor editor = MappingUiUtil.getActiveEditor();
        if (editor != null && editor.getCurrentPage() != null && editor.getCurrentPage() instanceof DiagramEditor && (controller = ((DiagramEditor)editor.getCurrentPage()).getDiagramController()) instanceof MappingDiagramController) {
            return ((MappingDiagramController)controller).getMappingAdapter();
        }
        return null;
    }

    public static MappingClassFactory getCurrentMappingClassFactory() {
        DiagramController controller;
        ModelEditor editor = MappingUiUtil.getActiveEditor();
        if (editor != null && editor.getCurrentPage() != null && editor.getCurrentPage() instanceof DiagramEditor && (controller = ((DiagramEditor)editor.getCurrentPage()).getDiagramController()) instanceof MappingDiagramController) {
            return ((MappingDiagramController)controller).getDocumentTreeController().getViewer().getMappingClassFactory();
        }
        return null;
    }

    public static ModelEditor getActiveEditor() {
        IWorkbenchPage page = UiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage();
        if (page == null && (page = AbstractUiPlugin.getLastValidPage()) == null) {
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor instanceof ModelEditor) {
            return (ModelEditor)editor;
        }
        return null;
    }

    public static boolean isLogicalModelType(Diagram theDiagram) {
        boolean result = false;
        ModelResource model = ModelUtilities.getModelResource((Resource)theDiagram.getTarget().eResource(), (boolean)true);
        if (model != null && ModelIdentifier.isLogicalModelType((ModelResource)model)) {
            result = true;
        }
        return result;
    }
}

