/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.validation;

import java.util.HashMap;
import java.util.Map;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.validation.ValidationResult;
import org.fusesource.ide.camel.validation.ValidationSupport;
import org.fusesource.ide.camel.validation.diagram.BasicNodeValidator;

public class ValidationFactory {
    private static Map<Class<? extends AbstractCamelModelElement>, ValidationSupport> registeredValidators = new HashMap<Class<? extends AbstractCamelModelElement>, ValidationSupport>();
    private static ValidationFactory instance;

    static {
        registeredValidators.put(AbstractCamelModelElement.class, new BasicNodeValidator());
    }

    private ValidationFactory() {
    }

    public static synchronized ValidationFactory getInstance() {
        if (instance == null) {
            instance = new ValidationFactory();
        }
        return instance;
    }

    public ValidationResult validate(AbstractCamelModelElement node) {
        ValidationResult result = null;
        for (Class<? extends AbstractCamelModelElement> c : registeredValidators.keySet()) {
            if (!c.isInstance(node)) continue;
            ValidationSupport validator = registeredValidators.get(c);
            if (validator == null) {
                validator = registeredValidators.get(AbstractCamelModelElement.class);
            }
            result = validator.validate(node);
        }
        return result;
    }
}

