/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.validation.model;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.fusesource.ide.camel.model.service.core.catalog.Parameter;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.util.PropertiesUtils;

public class RefOrDataFormatUnicityChoiceValidator
implements IValidator {
    private AbstractCamelModelElement cme;
    private Parameter parameter;

    public RefOrDataFormatUnicityChoiceValidator(AbstractCamelModelElement cme, Parameter parameter) {
        this.cme = cme;
        this.parameter = parameter;
    }

    public IStatus validate(Object value) {
        Object refValue;
        String parameterName = this.parameter.getName();
        if (parameterName.equalsIgnoreCase("ref")) {
            if (this.isRefEmpty(value)) {
                for (Parameter otherParameter : PropertiesUtils.getPropertiesFor((AbstractCamelModelElement)this.cme)) {
                    if (!this.isDataFormatToCheck(otherParameter) || this.cme.getParameter(otherParameter.getName()) == null) continue;
                    return ValidationStatus.error((String)("Please choose only ONE of Ref and " + otherParameter.getName()));
                }
            }
        } else if (this.isDataFormatToCheck(this.parameter) && value != null && this.isRefEmpty(refValue = this.cme.getParameter("ref"))) {
            return ValidationStatus.error((String)("Please choose only ONE of " + this.parameter.getName() + " and Ref."));
        }
        return ValidationStatus.ok();
    }

    private boolean isRefEmpty(Object value) {
        return value != null && value instanceof String && !((String)value).isEmpty();
    }

    private boolean isDataFormatToCheck(Parameter otherParameter) {
        return this.cme.isElementKind(otherParameter) && this.cme.isDataFormatDefinition(otherParameter);
    }
}

