/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.validation.model;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.fusesource.ide.camel.model.service.core.catalog.Parameter;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;
import org.fusesource.ide.camel.model.service.core.util.CamelComponentUtils;
import org.fusesource.ide.camel.model.service.core.util.PropertiesUtils;
import org.fusesource.ide.foundation.core.util.Strings;

public final class TextParameterValidator
implements IValidator {
    private AbstractCamelModelElement camelModelElement;
    private Parameter parameter;

    public TextParameterValidator(AbstractCamelModelElement camelModelElement, Parameter parameter) {
        this.camelModelElement = camelModelElement;
        this.parameter = parameter;
    }

    public IStatus validate(Object value) {
        if (PropertiesUtils.isRequired((Parameter)this.parameter) || this.parameter.getName().equalsIgnoreCase("id")) {
            Object uriValue = this.camelModelElement.getParameter("uri");
            Object refValue = this.camelModelElement.getParameter("ref");
            if (this.parameter.getName().equalsIgnoreCase("uri")) {
                if (Strings.isBlank((String)((String)uriValue))) {
                    if (Strings.isBlank((String)((String)refValue))) {
                        return ValidationStatus.warning((String)"One of Ref and Uri values have to be filled!");
                    }
                    AbstractCamelModelElement cme = this.camelModelElement.getCamelContext().findNode((String)refValue);
                    if (cme == null || cme.getParameter("uri") == null || ((String)cme.getParameter("uri")).trim().length() < 1) {
                        return ValidationStatus.warning((String)"The referenced endpoint has no URI defined or does not exist.");
                    }
                }
                if (uriValue != null && ((String)uriValue).startsWith("ref:")) {
                    String refId = ((String)uriValue).trim().length() > "ref:".length() ? ((String)uriValue).substring("ref:".length()) : null;
                    List<String> refs = Arrays.asList(CamelComponentUtils.getRefs((CamelFile)this.camelModelElement.getCamelFile()));
                    if (refId == null || refId.trim().length() < 1 || !refs.contains(refId)) {
                        return ValidationStatus.warning((String)"The entered reference does not exist in your context!");
                    }
                }
                if (uriValue != null && ((String)uriValue).trim().length() > 0 && refValue != null && ((String)refValue).trim().length() > 0) {
                    return ValidationStatus.error((String)"Please choose either URI or Ref but do not enter both values.");
                }
            } else if (this.parameter.getName().equalsIgnoreCase("ref")) {
                if (value != null && value instanceof String && value.toString().trim().length() > 0) {
                    String refId = (String)value;
                    AbstractCamelModelElement cme = this.camelModelElement.getCamelContext().findNode(refId);
                    if (cme == null) {
                        if (!this.camelModelElement.getCamelFile().getGlobalDefinitions().containsKey(refId)) {
                            return ValidationStatus.warning((String)"The entered reference does not exist in your context!");
                        }
                    } else if (cme.getParameter("uri") == null || ((String)cme.getParameter("uri")).trim().length() < 1) {
                        return ValidationStatus.error((String)"The referenced endpoint does not define a valid URI!");
                    }
                }
                if (uriValue != null && ((String)uriValue).trim().length() > 0 && refValue != null && ((String)refValue).trim().length() > 0) {
                    return ValidationStatus.warning((String)"Please choose only ONE of Uri and Ref.");
                }
            } else if (this.parameter.getName().equalsIgnoreCase("id")) {
                if (value == null || !(value instanceof String) || value.toString().trim().length() < 1) {
                    return ValidationStatus.warning((String)("Parameter " + this.parameter.getName() + " is a mandatory field and cannot be empty."));
                }
                if (!this.camelModelElement.getCamelContext().isIDUnique((String)value)) {
                    return ValidationStatus.warning((String)("Parameter " + this.parameter.getName() + " does not contain a unique value."));
                }
            } else if (value == null || value instanceof String && value.toString().trim().length() < 1) {
                return ValidationStatus.warning((String)("Parameter " + this.parameter.getName() + " is a mandatory field and cannot be empty."));
            }
        }
        return ValidationStatus.ok();
    }
}

