/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.validation.xml;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationEvent;
import org.eclipse.wst.validation.ValidationState;
import org.fusesource.ide.camel.model.service.core.io.CamelIOHandler;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelContextElement;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;
import org.fusesource.ide.camel.validation.ValidationResult;
import org.fusesource.ide.camel.validation.diagram.BasicNodeValidator;

public class XMLCamelRoutesValidator
extends AbstractValidator {
    public org.eclipse.wst.validation.ValidationResult validate(ValidationEvent event, ValidationState state, IProgressMonitor monitor) {
        CamelFile camelFile;
        IResource resource = event.getResource();
        try {
            resource.deleteMarkers("org.fusesource.ide.camel.validation.JBossFuseToolingValidationProblem", true, 2);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        org.eclipse.wst.validation.ValidationResult validationResult = super.validate(event, state, monitor);
        if (validationResult == null) {
            validationResult = new org.eclipse.wst.validation.ValidationResult();
        }
        if ((camelFile = this.loadCamelFile(monitor, resource)) != null) {
            this.checkCamelFile(camelFile, validationResult, resource);
        }
        return validationResult;
    }

    public CamelFile loadCamelFile(IProgressMonitor monitor, IResource resource) {
        return new CamelIOHandler().loadCamelModel(resource, monitor);
    }

    private void checkCamelFile(CamelFile camelFile, org.eclipse.wst.validation.ValidationResult validationResult, IResource resource) {
        for (AbstractCamelModelElement cme : camelFile.getChildElements()) {
            this.checkCamelModelElement(cme, validationResult, resource);
        }
    }

    private void checkCamelModelElement(AbstractCamelModelElement cme, org.eclipse.wst.validation.ValidationResult validationResult, IResource resource) {
        ValidationResult result = new BasicNodeValidator().validate(cme);
        validationResult.incrementError(result.getErrorCount());
        validationResult.incrementWarning(result.getWarningCount());
        validationResult.incrementInfo(result.getInformationCount());
        for (AbstractCamelModelElement cmeChild : cme.getChildElements()) {
            this.checkCamelModelElement(cmeChild, validationResult, resource);
        }
        if (cme instanceof CamelContextElement) {
            for (AbstractCamelModelElement globalEndpoint : ((CamelContextElement)cme).getEndpointDefinitions().values()) {
                this.checkCamelModelElement(globalEndpoint, validationResult, resource);
            }
            for (AbstractCamelModelElement globalEndpoint : ((CamelContextElement)cme).getDataformats().values()) {
                this.checkCamelModelElement(globalEndpoint, validationResult, resource);
            }
        }
    }
}

