/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.rules;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import com.sun.codemodel.ClassType;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JType;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.jsonschema2pojo.Schema;
import org.jsonschema2pojo.rules.Rule;
import org.jsonschema2pojo.rules.RuleFactory;

public class DefaultRule
implements Rule<JFieldVar, JFieldVar> {
    private final RuleFactory ruleFactory;

    public DefaultRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    @Override
    public JFieldVar apply(String nodeName, JsonNode node, JFieldVar field, Schema currentSchema) {
        boolean defaultPresent = node != null && StringUtils.isNotEmpty((CharSequence)node.asText());
        String fieldType = field.type().fullName();
        if (defaultPresent && !field.type().isPrimitive() && node.isNull()) {
            field.init(JExpr._null());
        } else if (fieldType.startsWith(List.class.getName())) {
            field.init(this.getDefaultList(field.type(), node));
        } else if (fieldType.startsWith(Set.class.getName())) {
            field.init(this.getDefaultSet(field.type(), node));
        } else if (fieldType.startsWith(String.class.getName()) && node != null) {
            field.init(this.getDefaultValue(field.type(), node));
        } else if (defaultPresent) {
            field.init(this.getDefaultValue(field.type(), node));
        }
        return field;
    }

    private JExpression getDefaultValue(JType fieldType, JsonNode node) {
        if ((fieldType = fieldType.unboxify()).fullName().equals(String.class.getName())) {
            return JExpr.lit((String)node.asText());
        }
        if (fieldType.fullName().equals(Integer.TYPE.getName())) {
            return JExpr.lit((int)Integer.parseInt(node.asText()));
        }
        if (fieldType.fullName().equals(Double.TYPE.getName())) {
            return JExpr.lit((double)Double.parseDouble(node.asText()));
        }
        if (fieldType.fullName().equals(Boolean.TYPE.getName())) {
            return JExpr.lit((boolean)Boolean.parseBoolean(node.asText()));
        }
        if (fieldType.fullName().equals(this.getDateTimeType().getName())) {
            long millisecs = this.parseDateToMillisecs(node.asText());
            JInvocation newDateTime = JExpr._new((JType)fieldType);
            newDateTime.arg(JExpr.lit((long)millisecs));
            return newDateTime;
        }
        if (fieldType.fullName().equals(LocalDate.class.getName()) || fieldType.fullName().equals(LocalTime.class.getName())) {
            JInvocation stringParseableTypeInstance = JExpr._new((JType)fieldType);
            stringParseableTypeInstance.arg(JExpr.lit((String)node.asText()));
            return stringParseableTypeInstance;
        }
        if (fieldType.fullName().equals(Long.TYPE.getName())) {
            return JExpr.lit((long)Long.parseLong(node.asText()));
        }
        if (fieldType.fullName().equals(Float.TYPE.getName())) {
            return JExpr.lit((float)Float.parseFloat(node.asText()));
        }
        if (fieldType instanceof JDefinedClass && ((JDefinedClass)fieldType).getClassType().equals(ClassType.ENUM)) {
            return this.getDefaultEnum(fieldType, node);
        }
        return JExpr._null();
    }

    private Class<?> getDateTimeType() {
        return this.ruleFactory.getGenerationConfig().isUseJodaDates() ? DateTime.class : Date.class;
    }

    private JExpression getDefaultList(JType fieldType, JsonNode node) {
        JClass listGenericType = (JClass)((JClass)fieldType).getTypeParameters().get(0);
        JClass listImplClass = fieldType.owner().ref(ArrayList.class);
        listImplClass = listImplClass.narrow(listGenericType);
        JInvocation newListImpl = JExpr._new((JClass)listImplClass);
        if (node instanceof ArrayNode && node.size() > 0) {
            JInvocation invokeAsList = fieldType.owner().ref(Arrays.class).staticInvoke("asList");
            for (JsonNode defaultValue : node) {
                invokeAsList.arg(this.getDefaultValue((JType)listGenericType, defaultValue));
            }
            newListImpl.arg((JExpression)invokeAsList);
        } else if (!this.ruleFactory.getGenerationConfig().isInitializeCollections()) {
            return JExpr._null();
        }
        return newListImpl;
    }

    private JExpression getDefaultSet(JType fieldType, JsonNode node) {
        JClass setGenericType = (JClass)((JClass)fieldType).getTypeParameters().get(0);
        JClass setImplClass = fieldType.owner().ref(LinkedHashSet.class);
        setImplClass = setImplClass.narrow(setGenericType);
        JInvocation newSetImpl = JExpr._new((JClass)setImplClass);
        if (node instanceof ArrayNode && node.size() > 0) {
            JInvocation invokeAsList = fieldType.owner().ref(Arrays.class).staticInvoke("asList");
            for (JsonNode defaultValue : node) {
                invokeAsList.arg(this.getDefaultValue((JType)setGenericType, defaultValue));
            }
            newSetImpl.arg((JExpression)invokeAsList);
        } else if (!this.ruleFactory.getGenerationConfig().isInitializeCollections()) {
            return JExpr._null();
        }
        return newSetImpl;
    }

    private JExpression getDefaultEnum(JType fieldType, JsonNode node) {
        JInvocation invokeFromValue = ((JClass)fieldType).staticInvoke("fromValue");
        invokeFromValue.arg(node.asText());
        return invokeFromValue;
    }

    private long parseDateToMillisecs(String valueAsText) {
        try {
            return Long.parseLong(valueAsText);
        }
        catch (NumberFormatException nfe) {
            try {
                return new StdDateFormat().parse(valueAsText).getTime();
            }
            catch (ParseException pe) {
                throw new IllegalArgumentException("Unable to parse this string as a date: " + valueAsText);
            }
        }
    }
}

