/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr;

import java.util.ArrayList;
import java.util.List;
import org.jboss.tools.modeshape.jcr.ValidationStatus;

public class MultiValidationStatus
extends ValidationStatus {
    public static MultiValidationStatus OK_STATUS = new MultiValidationStatus();
    private final List<ValidationStatus> errors = new ArrayList<ValidationStatus>();
    private ValidationStatus primary = null;

    public MultiValidationStatus() {
        super(ValidationStatus.Severity.OK, 0, ValidationStatus.OK_STATUS.getMessage());
    }

    public MultiValidationStatus(ValidationStatus status) {
        super(status.getSeverity(), status.getCode(), status.getMessage());
        if (!status.isOk()) {
            this.add(status);
        }
    }

    public void add(ValidationStatus statusBeingAdded) {
        this.errors.add(statusBeingAdded);
        if (this.primary == null || statusBeingAdded.getSeverity().isMoreSevere(this.getSeverity())) {
            this.primary = statusBeingAdded;
            this.severity = this.primary.getSeverity();
            this.message = this.primary.getMessage();
            this.code = this.primary.getCode();
        }
    }

    @Override
    public boolean containsCode(int code) {
        if (code == this.getCode()) {
            return true;
        }
        for (ValidationStatus status : this.getAll()) {
            if (!(status instanceof MultiValidationStatus ? ((MultiValidationStatus)status).containsCode(code) : code == status.getCode())) continue;
            return true;
        }
        return false;
    }

    public List<ValidationStatus> getAll() {
        ArrayList<ValidationStatus> all = new ArrayList<ValidationStatus>();
        for (ValidationStatus status : this.errors) {
            if (status instanceof MultiValidationStatus) {
                all.addAll(((MultiValidationStatus)status).getAll());
                continue;
            }
            all.add(status);
        }
        return all;
    }
}

