/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.modeshape.jcr.Activator;
import org.jboss.tools.modeshape.jcr.ItemDefinition;
import org.jboss.tools.modeshape.jcr.ItemOwnerProvider;
import org.jboss.tools.modeshape.jcr.Messages;
import org.jboss.tools.modeshape.jcr.QualifiedName;
import org.jboss.tools.modeshape.jcr.Utils;
import org.jboss.tools.modeshape.jcr.attributes.AttributeState;
import org.jboss.tools.modeshape.jcr.attributes.DefaultValues;
import org.jboss.tools.modeshape.jcr.attributes.OnParentVersion;
import org.jboss.tools.modeshape.jcr.attributes.PropertyAttributes;
import org.jboss.tools.modeshape.jcr.attributes.PropertyType;
import org.jboss.tools.modeshape.jcr.attributes.QueryOperators;
import org.jboss.tools.modeshape.jcr.attributes.ValueConstraints;
import org.jboss.tools.modeshape.jcr.cnd.CndElement;
import org.jboss.tools.modeshape.jcr.cnd.CommentedCndElement;
import org.jboss.tools.modeshape.jcr.preference.JcrPreferenceConstants;
import org.jboss.tools.modeshape.jcr.preference.JcrPreferenceStore;

public class PropertyDefinition
implements ItemDefinition,
PropertyDefinitionTemplate {
    public static final String NOTATION_PREFIX = "-";
    public static final String RESIDUAL_PROPERTY_NAME = "*";
    private final PropertyAttributes attributes;
    private String comment;
    private final DefaultValues defaultValues;
    private final CopyOnWriteArrayList<PropertyChangeListener> listeners;
    private final QualifiedName name;
    private final ItemOwnerProvider ownerProvider;
    private PropertyType type;
    private final ValueConstraints valueConstraints;

    public static final PropertyDefinition copy(PropertyDefinition propertyBeingCopied, ItemOwnerProvider ownerProvider) {
        PropertyDefinition copy = new PropertyDefinition(ownerProvider);
        copy.setName(propertyBeingCopied.getName());
        copy.comment = propertyBeingCopied.comment;
        copy.attributes.getAutocreated().set(propertyBeingCopied.attributes.getAutocreated().get());
        copy.attributes.getMandatory().set(propertyBeingCopied.attributes.getMandatory().get());
        copy.attributes.getMultiple().set(propertyBeingCopied.attributes.getMultiple().get());
        copy.attributes.getNoFullText().set(propertyBeingCopied.attributes.getNoFullText().get());
        copy.attributes.getNoQueryOrder().set(propertyBeingCopied.attributes.getNoQueryOrder().get());
        copy.attributes.getProtected().set(propertyBeingCopied.attributes.getProtected().get());
        copy.attributes.setOnParentVersion(propertyBeingCopied.attributes.getOnParentVersion());
        copy.attributes.getQueryOps().set(propertyBeingCopied.attributes.getQueryOps().get());
        copy.setAvailableQueryOperators(propertyBeingCopied.getAvailableQueryOperators());
        copy.defaultValues.set(propertyBeingCopied.defaultValues.get());
        for (String defaultValue : propertyBeingCopied.getDefaultValuesAsStrings()) {
            copy.defaultValues.add(defaultValue);
        }
        copy.type = propertyBeingCopied.type;
        copy.valueConstraints.set(propertyBeingCopied.valueConstraints.get());
        String[] stringArray = propertyBeingCopied.getValueConstraints();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String constraint = stringArray[n2];
            copy.valueConstraints.add(constraint);
            ++n2;
        }
        return copy;
    }

    public PropertyDefinition(ItemOwnerProvider ownerProvider) {
        Utils.verifyIsNotNull(ownerProvider, "ownerProvider");
        this.ownerProvider = ownerProvider;
        this.type = PropertyType.DEFAULT_VALUE;
        this.name = new QualifiedName();
        this.attributes = new PropertyAttributes();
        this.defaultValues = new DefaultValues();
        this.valueConstraints = new ValueConstraints();
        this.listeners = new CopyOnWriteArrayList();
    }

    public boolean addDefaultValue(String defaultValueBeingAdded) {
        if (this.defaultValues.add(defaultValueBeingAdded)) {
            this.notifyChangeListeners(PropertyName.DEFAULT_VALUES, null, defaultValueBeingAdded);
            return true;
        }
        return false;
    }

    public boolean addListener(PropertyChangeListener newListener) {
        Utils.verifyIsNotNull(newListener, "newListener");
        return this.listeners.addIfAbsent(newListener);
    }

    public boolean addQueryOperator(QueryOperators.QueryOperator operator) {
        if (this.attributes.getQueryOps().add(operator)) {
            this.notifyChangeListeners(PropertyName.QUERY_OPS, null, operator);
            return true;
        }
        return false;
    }

    public boolean addValueConstraint(String valueConstraintBeingAdded) {
        if (this.valueConstraints.add(valueConstraintBeingAdded)) {
            this.notifyChangeListeners(PropertyName.VALUE_CONSTRAINTS, null, valueConstraintBeingAdded);
            return true;
        }
        return false;
    }

    public boolean changeState(PropertyName propertyName, AttributeState.Value newState) {
        Utils.verifyIsNotNull((Object)propertyName, "propertyName");
        Utils.verifyIsNotNull((Object)newState, "newState");
        Enum oldValue = null;
        Enum newValue = newState;
        boolean changed = false;
        if (PropertyName.AUTOCREATED == propertyName) {
            oldValue = this.attributes.getAutocreated().get();
            changed = this.attributes.getAutocreated().set(newState);
        } else if (PropertyName.DEFAULT_VALUES == propertyName) {
            oldValue = this.defaultValues.get();
            changed = this.defaultValues.set(newState);
        } else if (PropertyName.MANDATORY == propertyName) {
            oldValue = this.attributes.getMandatory().get();
            changed = this.attributes.getMandatory().set(newState);
        } else if (PropertyName.MULTIPLE == propertyName) {
            oldValue = this.attributes.getMultiple().get();
            changed = this.attributes.getMultiple().set(newState);
        } else if (PropertyName.NO_FULL_TEXT == propertyName) {
            oldValue = this.attributes.getNoFullText().get();
            changed = this.attributes.getNoFullText().set(newState);
        } else if (PropertyName.NO_QUERY_ORDER == propertyName) {
            oldValue = this.attributes.getNoQueryOrder().get();
            changed = this.attributes.getNoQueryOrder().set(newState);
        } else if (PropertyName.ON_PARENT_VERSION == propertyName) {
            if (AttributeState.Value.VARIANT == newValue) {
                oldValue = this.attributes.getOnParentVersion();
                newValue = OnParentVersion.VARIANT;
                changed = this.attributes.setOnParentVersion(OnParentVersion.VARIANT);
            }
        } else if (PropertyName.PROTECTED == propertyName) {
            oldValue = this.attributes.getProtected().get();
            changed = this.attributes.getProtected().set(newState);
        } else if (PropertyName.QUERY_OPS == propertyName) {
            oldValue = this.attributes.getQueryOps().get();
            changed = this.attributes.getQueryOps().set(newState);
        } else if (PropertyName.TYPE == propertyName) {
            if (AttributeState.Value.VARIANT == newValue) {
                return this.setType(PropertyType.VARIANT);
            }
        } else if (PropertyName.VALUE_CONSTRAINTS == propertyName) {
            oldValue = this.valueConstraints.get();
            changed = this.valueConstraints.set(newState);
        }
        if (changed) {
            this.notifyChangeListeners(propertyName, oldValue, newValue);
            return true;
        }
        return false;
    }

    public boolean clearDefaultValues() {
        ArrayList oldValue = new ArrayList(this.defaultValues.getSupportedItems());
        if (this.defaultValues.clear()) {
            this.notifyChangeListeners(PropertyName.DEFAULT_VALUES, oldValue, null);
            return true;
        }
        return false;
    }

    public boolean clearValueConstraints() {
        ArrayList oldValue = new ArrayList(this.valueConstraints.getSupportedItems());
        if (this.valueConstraints.clear()) {
            this.notifyChangeListeners(PropertyName.VALUE_CONSTRAINTS, oldValue, null);
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(ItemDefinition itemDefinition) {
        return this.getQualifiedName().compareTo(itemDefinition.getQualifiedName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        PropertyDefinition that = (PropertyDefinition)obj;
        if (!this.attributes.equals(that.attributes)) {
            return false;
        }
        if (!Utils.equals(this.getName(), that.getName())) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        if (!this.defaultValues.equals(that.defaultValues)) {
            return false;
        }
        if (!Utils.equals(this.getDeclaringNodeTypeDefinitionName(), that.getDeclaringNodeTypeDefinitionName())) {
            return false;
        }
        if (!this.valueConstraints.equals(that.valueConstraints)) {
            return false;
        }
        return Utils.equals(this.comment, that.comment);
    }

    public String getAttributesCndNotation(CndElement.NotationType notationType) {
        String cndNotation = this.attributes.toCndNotation(notationType);
        if (cndNotation == null) {
            return "";
        }
        return cndNotation;
    }

    public String[] getAvailableQueryOperators() {
        return this.attributes.getQueryOps().toArray();
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public NodeType getDeclaringNodeType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public QualifiedName getDeclaringNodeTypeDefinitionName() {
        return this.ownerProvider.getOwnerQualifiedName();
    }

    public Value[] getDefaultValues() {
        return this.defaultValues.asJcrValues();
    }

    public List<String> getDefaultValuesAsStrings() {
        return this.defaultValues.getSupportedItems();
    }

    public String getName() {
        if (Utils.isEmpty(this.name.get())) {
            return null;
        }
        return this.name.get();
    }

    public int getOnParentVersion() {
        return this.attributes.getOnParentVersion().asJcrValue();
    }

    @Override
    public QualifiedName getQualifiedName() {
        return this.name;
    }

    public int getRequiredType() {
        return this.getType().asJcrValue();
    }

    public AttributeState.Value getState(PropertyName propertyName) {
        Utils.verifyIsNotNull((Object)propertyName, "propertyName");
        if (PropertyName.AUTOCREATED == propertyName) {
            return this.attributes.getAutocreated().get();
        }
        if (PropertyName.DEFAULT_VALUES == propertyName) {
            return this.defaultValues.get();
        }
        if (PropertyName.MANDATORY == propertyName) {
            return this.attributes.getMandatory().get();
        }
        if (PropertyName.MULTIPLE == propertyName) {
            return this.attributes.getMultiple().get();
        }
        if (PropertyName.NO_FULL_TEXT == propertyName) {
            return this.attributes.getNoFullText().get();
        }
        if (PropertyName.NO_QUERY_ORDER == propertyName) {
            return this.attributes.getNoQueryOrder().get();
        }
        if (PropertyName.ON_PARENT_VERSION == propertyName) {
            if (this.isVariant(PropertyName.ON_PARENT_VERSION)) {
                return AttributeState.Value.VARIANT;
            }
            return AttributeState.Value.IS;
        }
        if (PropertyName.PROTECTED == propertyName) {
            return this.attributes.getProtected().get();
        }
        if (PropertyName.QUERY_OPS == propertyName) {
            return this.attributes.getQueryOps().get();
        }
        if (PropertyName.VALUE_CONSTRAINTS == propertyName) {
            return this.valueConstraints.get();
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.invalidGetStateRequest, (Object)((Object)propertyName)));
    }

    public PropertyType getType() {
        return this.type;
    }

    public String[] getValueConstraints() {
        return this.valueConstraints.toArray();
    }

    public String getValueConstraintsCndNotation(CndElement.NotationType notationType) {
        return this.valueConstraints.toCndNotation(notationType);
    }

    public int hashCode() {
        return Utils.hashCode(this.attributes, this.name, this.defaultValues, this.type, this.valueConstraints, this.getDeclaringNodeTypeDefinitionName(), this.comment);
    }

    public boolean isAutoCreated() {
        return this.attributes.getAutocreated().is();
    }

    public boolean isFullTextSearchable() {
        return this.attributes.getNoFullText().isNot();
    }

    public boolean isMandatory() {
        return this.attributes.getMandatory().is();
    }

    public boolean isMultiple() {
        return this.attributes.getMultiple().is();
    }

    public boolean isProtected() {
        return this.attributes.getProtected().is();
    }

    public boolean isQueryOrderable() {
        return this.attributes.getNoQueryOrder().isNot();
    }

    public boolean isVariant(PropertyName propertyName) {
        Utils.verifyIsNotNull((Object)propertyName, "propertyName");
        if (PropertyName.ON_PARENT_VERSION == propertyName) {
            return this.attributes.getOnParentVersion() == OnParentVersion.VARIANT;
        }
        if (PropertyName.TYPE == propertyName) {
            return this.type == PropertyType.VARIANT;
        }
        return this.getState(propertyName) == AttributeState.Value.VARIANT;
    }

    private void notifyChangeListeners(PropertyName property, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, property.toString(), oldValue, newValue);
        Object[] objectArray = this.listeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            try {
                ((PropertyChangeListener)listener).propertyChange(event);
            }
            catch (Exception e) {
                if (Platform.isRunning()) {
                    Activator.get().getLog().log((IStatus)new Status(4, Activator.PLUGIN_ID, null, (Throwable)e));
                } else {
                    System.err.print(e.getMessage());
                }
                this.listeners.remove(listener);
            }
            ++n2;
        }
    }

    public boolean removeDefaultValue(String defaultValueBeingRemoved) {
        if (this.defaultValues.remove(defaultValueBeingRemoved)) {
            this.notifyChangeListeners(PropertyName.DEFAULT_VALUES, defaultValueBeingRemoved, null);
            return true;
        }
        return false;
    }

    public boolean removeListener(PropertyChangeListener listener) {
        Utils.verifyIsNotNull(listener, "listener");
        return this.listeners.remove(listener);
    }

    public boolean removeQueryOperator(QueryOperators.QueryOperator operator) {
        if (this.attributes.getQueryOps().remove(operator)) {
            this.notifyChangeListeners(PropertyName.QUERY_OPS, operator, null);
            return true;
        }
        return false;
    }

    public boolean removeValueConstraint(String valueConstraintBeingRemoved) {
        if (this.valueConstraints.remove(valueConstraintBeingRemoved)) {
            this.notifyChangeListeners(PropertyName.VALUE_CONSTRAINTS, valueConstraintBeingRemoved, null);
            return true;
        }
        return false;
    }

    public void setAutoCreated(boolean newAutocreated) {
        AttributeState.Value newState = newAutocreated ? AttributeState.Value.IS : AttributeState.Value.IS_NOT;
        this.changeState(PropertyName.AUTOCREATED, newState);
    }

    public void setAvailableQueryOperators(String[] newOperators) {
        QueryOperators queryOps = this.attributes.getQueryOps();
        List oldOperators = queryOps.getSupportedItems();
        boolean changed = queryOps.clear();
        if (!Utils.isEmpty(newOperators)) {
            String[] stringArray = newOperators;
            int n = newOperators.length;
            int n2 = 0;
            while (n2 < n) {
                String operator = stringArray[n2];
                try {
                    if (queryOps.add(operator.trim())) {
                        changed = true;
                    }
                }
                catch (Exception e) {
                    if (Platform.isRunning()) {
                        Activator.get().getLog().log((IStatus)new Status(4, Activator.PLUGIN_ID, null, (Throwable)e));
                    }
                    System.err.print(e.getMessage());
                }
                ++n2;
            }
        }
        if (changed) {
            this.notifyChangeListeners(PropertyName.QUERY_OPS, oldOperators, queryOps.getSupportedItems());
        }
    }

    @Override
    public boolean setComment(String newComment) {
        boolean changed;
        if (!Utils.isEmpty(newComment)) {
            newComment = newComment.trim();
        }
        String oldValue = this.comment;
        boolean bl = changed = !Utils.equivalent(this.comment, newComment);
        if (changed) {
            this.comment = newComment;
            this.notifyChangeListeners(PropertyName.COMMENT, oldValue, newComment);
        }
        return changed;
    }

    public void setDefaultValues(Value[] newDefaultValues) {
        List items = this.defaultValues.getSupportedItems();
        boolean changed = this.defaultValues.clear();
        if (!Utils.isEmpty(newDefaultValues)) {
            Value[] valueArray = newDefaultValues;
            int n = newDefaultValues.length;
            int n2 = 0;
            while (n2 < n) {
                Value defaultValue = valueArray[n2];
                try {
                    if (this.defaultValues.add(defaultValue.getString())) {
                        changed = true;
                    }
                }
                catch (Exception e) {
                    if (Platform.isRunning()) {
                        Activator.get().getLog().log((IStatus)new Status(4, Activator.PLUGIN_ID, null, (Throwable)e));
                    }
                    System.err.print(e.getMessage());
                }
                ++n2;
            }
        }
        if (changed) {
            this.notifyChangeListeners(PropertyName.DEFAULT_VALUES, items, this.defaultValues.getSupportedItems());
        }
    }

    public void setFullTextSearchable(boolean newFullTextSearchable) {
        AttributeState.Value newState = newFullTextSearchable ? AttributeState.Value.IS_NOT : AttributeState.Value.IS;
        this.changeState(PropertyName.NO_FULL_TEXT, newState);
    }

    public void setMandatory(boolean newMandatory) {
        AttributeState.Value newState = newMandatory ? AttributeState.Value.IS : AttributeState.Value.IS_NOT;
        this.changeState(PropertyName.MANDATORY, newState);
    }

    public void setMultiple(boolean newMultiple) {
        AttributeState.Value newState = newMultiple ? AttributeState.Value.IS : AttributeState.Value.IS_NOT;
        this.changeState(PropertyName.MULTIPLE, newState);
    }

    public void setName(String newName) {
        String oldValue = this.getName();
        if (this.name.set(newName)) {
            this.notifyChangeListeners(PropertyName.NAME, oldValue, newName);
        }
    }

    public void setOnParentVersion(int newOpv) {
        OnParentVersion oldValue = this.attributes.getOnParentVersion();
        if (this.attributes.setOnParentVersion(OnParentVersion.findUsingJcrValue(newOpv))) {
            this.notifyChangeListeners(PropertyName.ON_PARENT_VERSION, oldValue, newOpv);
        }
    }

    public boolean setOnParentVersion(String newOpv) {
        OnParentVersion oldValue = this.attributes.getOnParentVersion();
        if (this.attributes.setOnParentVersion(OnParentVersion.find(newOpv))) {
            this.notifyChangeListeners(PropertyName.ON_PARENT_VERSION, oldValue, newOpv);
            return true;
        }
        return false;
    }

    public void setProtected(boolean newProtected) {
        AttributeState.Value newState = newProtected ? AttributeState.Value.IS : AttributeState.Value.IS_NOT;
        this.changeState(PropertyName.PROTECTED, newState);
    }

    public void setQueryOrderable(boolean newQueryOrderable) {
        AttributeState.Value newState = newQueryOrderable ? AttributeState.Value.IS_NOT : AttributeState.Value.IS;
        this.changeState(PropertyName.NO_QUERY_ORDER, newState);
    }

    public void setRequiredType(int newPropertyType) {
        this.setType(PropertyType.findUsingJcrValue(newPropertyType));
    }

    public boolean setType(PropertyType newType) {
        if (this.type != newType) {
            PropertyType oldValue = this.type;
            this.type = newType;
            this.notifyChangeListeners(PropertyName.TYPE, oldValue, this.type);
            return true;
        }
        return false;
    }

    public void setValueConstraints(String[] newConstraints) {
        List items = this.valueConstraints.getSupportedItems();
        boolean changed = this.valueConstraints.clear();
        if (!Utils.isEmpty(newConstraints)) {
            String[] stringArray = newConstraints;
            int n = newConstraints.length;
            int n2 = 0;
            while (n2 < n) {
                String constraint = stringArray[n2];
                if (this.valueConstraints.add(constraint)) {
                    changed = true;
                }
                ++n2;
            }
        }
        if (changed) {
            this.notifyChangeListeners(PropertyName.VALUE_CONSTRAINTS, items, this.valueConstraints.getSupportedItems());
        }
    }

    @Override
    public String toCndNotation(CndElement.NotationType notationType) {
        JcrPreferenceStore prefStore = JcrPreferenceStore.get();
        StringBuilder builder = new StringBuilder();
        if (!Utils.isEmpty(this.comment)) {
            String commentNotation = "";
            if (CndElement.NotationType.LONG == notationType) {
                commentNotation = String.valueOf(commentNotation) + '\n';
            }
            commentNotation = String.valueOf(commentNotation) + CommentedCndElement.Helper.addCommentCharacters(this.comment);
            builder.append(commentNotation);
        }
        builder.append(NOTATION_PREFIX);
        builder.append(CndElement.NotationType.LONG == notationType ? " " : "");
        String DELIM = prefStore.get(JcrPreferenceConstants.CndPreference.PROPERTY_DEFINITION_ATTRIBUTES_DELIMITER);
        builder.append(this.name.toCndNotation(notationType));
        Utils.build(builder, true, DELIM, this.type.toCndNotation(notationType));
        Utils.build(builder, true, DELIM, this.defaultValues.toCndNotation(notationType));
        Utils.build(builder, true, DELIM, this.attributes.toCndNotation(notationType));
        Utils.build(builder, true, DELIM, this.valueConstraints.toCndNotation(notationType));
        return builder.toString();
    }

    public static enum PropertyName {
        AUTOCREATED,
        COMMENT,
        DEFAULT_VALUES,
        MANDATORY,
        MULTIPLE,
        NAME,
        NO_FULL_TEXT,
        NO_QUERY_ORDER,
        ON_PARENT_VERSION,
        PROTECTED,
        QUERY_OPS,
        TYPE,
        VALUE_CONSTRAINTS;


        public String toString() {
            return String.valueOf(((Object)((Object)this)).getClass().getName()) + '.' + super.toString();
        }
    }
}

