/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.modeshape.jcr.Messages;

public final class Utils {
    public static final String DOUBLE_QUOTE = "\"";
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final String EMPTY_STRING = "";
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final int PRIME = 103;
    public static final String SINGLE_QUOTE = "'";
    public static final String SPACE_STRING = " ";

    public static boolean build(StringBuilder builder, boolean addDelimiter, String delimiter, String text) {
        if (!Utils.isEmpty(text)) {
            if (addDelimiter && !Utils.isEmpty(delimiter)) {
                builder.append(delimiter);
            }
            builder.append(text);
            return true;
        }
        return false;
    }

    public static boolean equals(Object thisObject, Object thatObject) {
        if (thisObject == null) {
            return thatObject == null;
        }
        if (thatObject == null) {
            return false;
        }
        return thisObject.equals(thatObject);
    }

    public static boolean equivalent(Collection<?> thisCollection, Collection<?> thatCollection) {
        if (Utils.isEmpty(thisCollection)) {
            return Utils.isEmpty(thatCollection);
        }
        if (Utils.isEmpty(thatCollection)) {
            return false;
        }
        if (thisCollection.size() != thatCollection.size()) {
            return false;
        }
        return thisCollection.containsAll(thatCollection);
    }

    public static boolean equivalent(Object[] thisArray, Object[] thatArray) {
        if (Utils.isEmpty(thisArray)) {
            return Utils.isEmpty(thatArray);
        }
        if (Utils.isEmpty(thatArray)) {
            return false;
        }
        if (thisArray.length != thatArray.length) {
            return false;
        }
        return Arrays.asList(thisArray).containsAll(Arrays.asList(thatArray));
    }

    public static boolean equivalent(String thisString, String thatString) {
        if (Utils.isEmpty(thisString)) {
            return Utils.isEmpty(thatString);
        }
        if (Utils.isEmpty(thatString)) {
            return false;
        }
        return thisString.equals(thatString);
    }

    public static final int hashCode(Object ... objects) {
        if (objects == null || objects.length == 0) {
            return 0;
        }
        int hc = 0;
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            hc *= 103;
            if (object instanceof byte[]) {
                hc += Arrays.hashCode((byte[])object);
            } else if (object instanceof boolean[]) {
                hc += Arrays.hashCode((boolean[])object);
            } else if (object instanceof short[]) {
                hc += Arrays.hashCode((short[])object);
            } else if (object instanceof int[]) {
                hc += Arrays.hashCode((int[])object);
            } else if (object instanceof long[]) {
                hc += Arrays.hashCode((long[])object);
            } else if (object instanceof float[]) {
                hc += Arrays.hashCode((float[])object);
            } else if (object instanceof double[]) {
                hc += Arrays.hashCode((double[])object);
            } else if (object instanceof char[]) {
                hc += Arrays.hashCode((char[])object);
            } else if (object instanceof Object[]) {
                hc += Arrays.hashCode((Object[])object);
            } else if (object != null) {
                hc += object.hashCode();
            }
            ++n2;
        }
        return hc;
    }

    public static boolean isEmpty(Collection<?> items) {
        return items == null || items.isEmpty();
    }

    public static boolean isEmpty(Object[] items) {
        return items == null || items.length == 0;
    }

    public static boolean isEmpty(String text) {
        return text == null || text.isEmpty();
    }

    public static String read(Reader reader) throws IOException {
        if (reader == null) {
            return EMPTY_STRING;
        }
        StringBuilder sb = new StringBuilder();
        boolean error = false;
        try {
            try {
                int numRead = 0;
                char[] buffer = new char[1024];
                while ((numRead = reader.read(buffer)) > -1) {
                    sb.append(buffer, 0, numRead);
                }
            }
            catch (IOException e) {
                error = true;
                throw e;
            }
            catch (RuntimeException e) {
                error = true;
                throw e;
            }
        }
        finally {
            block13: {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    if (error) break block13;
                    throw e;
                }
            }
        }
        return sb.toString();
    }

    public static String read(InputStream stream) throws IOException {
        return stream == null ? EMPTY_STRING : Utils.read(new InputStreamReader(stream));
    }

    public static String read(File file) throws IOException {
        if (file == null) {
            return EMPTY_STRING;
        }
        StringBuilder sb = new StringBuilder();
        boolean error = false;
        FileReader reader = new FileReader(file);
        try {
            try {
                int numRead = 0;
                char[] buffer = new char[1024];
                while ((numRead = reader.read(buffer)) > -1) {
                    sb.append(buffer, 0, numRead);
                }
            }
            catch (IOException e) {
                error = true;
                throw e;
            }
            catch (RuntimeException e) {
                error = true;
                throw e;
            }
        }
        finally {
            block13: {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException e) {
                    if (error) break block13;
                    throw e;
                }
            }
        }
        return sb.toString();
    }

    public static String[] toUpperCase(String[] items) {
        Utils.verifyIsNotNull(items, "items");
        String[] result = new String[items.length];
        int i = 0;
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            result[i++] = item.toUpperCase();
            ++n2;
        }
        return result;
    }

    public static void verifyIsNotEmpty(String text, String name) {
        if (Utils.isEmpty(text)) {
            if (name == null || name.isEmpty()) {
                name = EMPTY_STRING;
            }
            throw new IllegalArgumentException(NLS.bind((String)Messages.stringIsEmpty, (Object)name));
        }
    }

    public static void verifyIsNotNull(Object object, String name) {
        if (object == null) {
            if (name == null || name.isEmpty()) {
                name = EMPTY_STRING;
            }
            throw new IllegalArgumentException(NLS.bind((String)Messages.objectIsNull, (Object)name));
        }
    }

    private Utils() {
    }
}

