/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.modeshape.jcr.Activator;
import org.jboss.tools.modeshape.jcr.ChildNodeDefinition;
import org.jboss.tools.modeshape.jcr.Messages;
import org.jboss.tools.modeshape.jcr.NamespaceMapping;
import org.jboss.tools.modeshape.jcr.NodeTypeDefinition;
import org.jboss.tools.modeshape.jcr.PropertyDefinition;
import org.jboss.tools.modeshape.jcr.QualifiedName;
import org.jboss.tools.modeshape.jcr.Utils;
import org.jboss.tools.modeshape.jcr.cnd.CndImporter;
import org.jboss.tools.modeshape.jcr.cnd.CompactNodeTypeDefinition;
import org.osgi.framework.Bundle;

public class WorkspaceRegistry {
    private static WorkspaceRegistry _registry;
    private static String BUILT_INS_CND_FILE_NAME;
    private final Collection<NamespaceMapping> namespaces;
    private final Collection<NodeTypeDefinition> nodeTypes;

    static {
        BUILT_INS_CND_FILE_NAME = "cnd/jsr_283_builtins.cnd";
    }

    public static WorkspaceRegistry get() throws Exception {
        if (_registry == null) {
            _registry = new WorkspaceRegistry();
        }
        return _registry;
    }

    private WorkspaceRegistry() throws Exception {
        CndImporter importer = new CndImporter();
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        File builtInsCndFile = null;
        if (Platform.isRunning()) {
            Bundle bundle = Platform.getBundle((String)Activator.PLUGIN_ID);
            URL url = bundle.getEntry(BUILT_INS_CND_FILE_NAME);
            if (url == null) {
                throw new Exception(NLS.bind((String)Messages.jsrBuiltInsCndFileNotFound, (Object)BUILT_INS_CND_FILE_NAME));
            }
            builtInsCndFile = new File(FileLocator.toFileURL((URL)url).getFile());
            if (!builtInsCndFile.exists()) {
                throw new Exception(NLS.bind((String)Messages.jsrBuiltInsCndFileNotFoundInFilesystem, (Object)BUILT_INS_CND_FILE_NAME));
            }
        } else {
            builtInsCndFile = new File(BUILT_INS_CND_FILE_NAME);
        }
        CompactNodeTypeDefinition jsrBuiltIns = importer.importFrom(builtInsCndFile, errors);
        if (!errors.isEmpty()) {
            Throwable t = (Throwable)errors.iterator().next();
            if (t.getCause() == null) {
                throw new RuntimeException(t);
            }
            throw new Exception(t.getCause());
        }
        this.namespaces = new ArrayList<NamespaceMapping>();
        this.nodeTypes = new ArrayList<NodeTypeDefinition>();
        for (NamespaceMapping namespace : jsrBuiltIns.getNamespaceMappings()) {
            this.namespaces.add(namespace);
        }
        for (NodeTypeDefinition nodeType : jsrBuiltIns.getNodeTypeDefinitions()) {
            this.nodeTypes.add(nodeType);
        }
    }

    public Collection<ChildNodeDefinition> getChildNodeDefinitions(String nodeTypeDefinitionName, boolean includeInherited) {
        NodeTypeDefinition nodeType = this.getNodeTypeDefinition(nodeTypeDefinitionName);
        if (nodeType == null) {
            return Collections.emptyList();
        }
        ArrayList<ChildNodeDefinition> childNodes = new ArrayList<ChildNodeDefinition>(nodeType.getChildNodeDefinitions());
        if (includeInherited) {
            for (QualifiedName superType : nodeType.getSupertypes()) {
                NodeTypeDefinition superTypeNodeType = this.getNodeTypeDefinition(superType.get());
                if (superTypeNodeType == null) continue;
                childNodes.addAll(this.getChildNodeDefinitions(superTypeNodeType.getName(), true));
            }
        }
        return childNodes;
    }

    public List<NodeTypeDefinition> getMatchingNodeTypeDefinitions(String namespacePrefix) {
        boolean matchEmptyPrefix = Utils.isEmpty(namespacePrefix);
        ArrayList<NodeTypeDefinition> matches = new ArrayList<NodeTypeDefinition>();
        for (NodeTypeDefinition nodeType : this.getNodeTypeDefinitions()) {
            String qualifier = nodeType.getQualifiedName().getQualifier();
            if (matchEmptyPrefix) {
                if (!Utils.isEmpty(qualifier)) continue;
                matches.add(nodeType);
                continue;
            }
            if (!namespacePrefix.equals(qualifier)) continue;
            matches.add(nodeType);
        }
        return matches;
    }

    public NamespaceMapping getNamespaceMapping(String prefix) {
        Utils.verifyIsNotEmpty(prefix, "prefix");
        for (NamespaceMapping namespace : this.getNamespaceMappings()) {
            if (!namespace.getPrefix().equals(prefix)) continue;
            return namespace;
        }
        return null;
    }

    public Collection<NamespaceMapping> getNamespaceMappings() {
        return Collections.unmodifiableCollection(this.namespaces);
    }

    public NodeTypeDefinition getNodeTypeDefinition(String name) {
        Utils.verifyIsNotEmpty(name, "name");
        for (NodeTypeDefinition nodeType : this.getNodeTypeDefinitions()) {
            if (!nodeType.getName().equals(name)) continue;
            return nodeType;
        }
        return null;
    }

    public Collection<NodeTypeDefinition> getNodeTypeDefinitions() {
        return Collections.unmodifiableCollection(this.nodeTypes);
    }

    public String getPrefix(String uri) {
        Utils.verifyIsNotEmpty(uri, "uri");
        for (NamespaceMapping namespace : this.namespaces) {
            if (!namespace.getUri().equals(uri)) continue;
            return namespace.getPrefix();
        }
        return null;
    }

    public Collection<String> getPrefixes() {
        ArrayList<String> prefixes = new ArrayList<String>(this.namespaces.size());
        for (NamespaceMapping namespace : this.namespaces) {
            prefixes.add(namespace.getPrefix());
        }
        return prefixes;
    }

    public Collection<PropertyDefinition> getPropertyDefinitions(String nodeTypeDefinitionName, boolean includeInherited) {
        NodeTypeDefinition nodeType = this.getNodeTypeDefinition(nodeTypeDefinitionName);
        if (nodeType == null) {
            return Collections.emptyList();
        }
        ArrayList<PropertyDefinition> properties = new ArrayList<PropertyDefinition>(nodeType.getPropertyDefinitions());
        if (includeInherited) {
            for (QualifiedName superType : nodeType.getSupertypes()) {
                NodeTypeDefinition superTypeNodeType = this.getNodeTypeDefinition(superType.get());
                if (superTypeNodeType == null) continue;
                properties.addAll(this.getPropertyDefinitions(superTypeNodeType.getName(), true));
            }
        }
        return properties;
    }

    public String getUri(String prefix) {
        Utils.verifyIsNotEmpty(prefix, "prefix");
        for (NamespaceMapping namespace : this.namespaces) {
            if (!namespace.getPrefix().equals(prefix)) continue;
            return namespace.getUri();
        }
        return null;
    }

    public Collection<String> getUris() {
        ArrayList<String> uris = new ArrayList<String>(this.namespaces.size());
        for (NamespaceMapping namespace : this.namespaces) {
            uris.add(namespace.getUri());
        }
        return uris;
    }

    public boolean isBuiltIn(NamespaceMapping namespaceMapping) {
        Utils.verifyIsNotNull(namespaceMapping, "namespaceMapping");
        NamespaceMapping builtIn = this.getNamespaceMapping(namespaceMapping.getPrefix());
        return builtIn != null && builtIn.equals(namespaceMapping);
    }

    public boolean isBuiltInNamespacePrefix(String prefix) {
        Utils.verifyIsNotNull(prefix, "prefix");
        return this.getUri(prefix) != null;
    }

    public boolean isBuiltInNamespaceUri(String uri) {
        Utils.verifyIsNotNull(uri, "uri");
        return this.getPrefix(uri) != null;
    }
}

