/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr.attributes;

import org.jboss.tools.modeshape.jcr.Utils;
import org.jboss.tools.modeshape.jcr.attributes.Abstract;
import org.jboss.tools.modeshape.jcr.attributes.AttributeState;
import org.jboss.tools.modeshape.jcr.attributes.Mixin;
import org.jboss.tools.modeshape.jcr.attributes.Orderable;
import org.jboss.tools.modeshape.jcr.attributes.PrimaryItem;
import org.jboss.tools.modeshape.jcr.attributes.Queryable;
import org.jboss.tools.modeshape.jcr.cnd.CndElement;
import org.jboss.tools.modeshape.jcr.preference.JcrPreferenceConstants;
import org.jboss.tools.modeshape.jcr.preference.JcrPreferenceStore;

public class NodeTypeAttributes
implements CndElement {
    private Mixin mixin;
    private Abstract notConcrete;
    private Orderable orderable = new Orderable();
    private PrimaryItem primaryItem;
    private Queryable queryable;

    public NodeTypeAttributes() {
        this.mixin = new Mixin();
        this.notConcrete = new Abstract();
        this.primaryItem = new PrimaryItem();
        this.queryable = new Queryable();
    }

    public NodeTypeAttributes(Orderable initialOrderable, Mixin initialMixin, Abstract initialAbstract, Queryable initialQueryable, PrimaryItem initialPrimaryItem) {
        this();
        if (!this.orderable.equals(initialOrderable)) {
            this.orderable = initialOrderable;
        }
        if (!this.mixin.equals(initialMixin)) {
            this.mixin = initialMixin;
        }
        if (!this.notConcrete.equals(initialAbstract)) {
            this.notConcrete = initialAbstract;
        }
        if (!this.queryable.equals(initialQueryable)) {
            this.queryable = initialQueryable;
        }
        if (!this.primaryItem.equals(initialPrimaryItem)) {
            this.primaryItem = initialPrimaryItem;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        NodeTypeAttributes that = (NodeTypeAttributes)obj;
        return this.mixin.equals(that.mixin) && this.notConcrete.equals(that.notConcrete) && this.orderable.equals(that.orderable) && this.queryable.equals(that.queryable) && this.primaryItem.equals(that.primaryItem);
    }

    public Abstract getAbstract() {
        return this.notConcrete;
    }

    public Mixin getMixin() {
        return this.mixin;
    }

    public Orderable getOrderable() {
        return this.orderable;
    }

    public PrimaryItem getPrimaryItem() {
        return this.primaryItem;
    }

    public Queryable getQueryable() {
        return this.queryable;
    }

    public int hashCode() {
        return Utils.hashCode(this.mixin, this.notConcrete, this.orderable, this.queryable, this.primaryItem);
    }

    public boolean setAbstract(AttributeState.Value newState) {
        return this.notConcrete.set(newState);
    }

    public boolean setMixin(AttributeState.Value newState) {
        return this.mixin.set(newState);
    }

    public boolean setOrderable(AttributeState.Value newState) {
        return this.orderable.set(newState);
    }

    public boolean setPrimaryItem(AttributeState.Value newState) {
        return this.primaryItem.set(newState);
    }

    public boolean setPrimaryItem(String newPrimaryItem) {
        return this.primaryItem.setPrimaryItem(newPrimaryItem);
    }

    public boolean setQueryable(AttributeState.Value newState) {
        return this.queryable.set(newState);
    }

    @Override
    public String toCndNotation(CndElement.NotationType notationType) {
        StringBuilder builder = new StringBuilder();
        JcrPreferenceStore prefStore = JcrPreferenceStore.get();
        String DELIM = prefStore.get(JcrPreferenceConstants.CndPreference.NODE_TYPE_DEFINITION_ATTRIBUTES_DELIMITER);
        boolean addDelim = Utils.build(builder, false, DELIM, this.orderable.toCndNotation(notationType));
        if (Utils.build(builder, addDelim, DELIM, this.mixin.toCndNotation(notationType))) {
            addDelim = true;
        }
        if (Utils.build(builder, addDelim, DELIM, this.notConcrete.toCndNotation(notationType))) {
            addDelim = true;
        }
        if (Utils.build(builder, addDelim, DELIM, this.queryable.toCndNotation(notationType))) {
            addDelim = true;
        }
        if (Utils.build(builder, addDelim, DELIM, this.primaryItem.toCndNotation(notationType))) {
            addDelim = true;
        }
        return builder.toString().trim();
    }
}

