/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr.attributes;

import org.jboss.tools.modeshape.jcr.Utils;
import org.jboss.tools.modeshape.jcr.attributes.AttributeState;
import org.jboss.tools.modeshape.jcr.attributes.Autocreated;
import org.jboss.tools.modeshape.jcr.attributes.Mandatory;
import org.jboss.tools.modeshape.jcr.attributes.Multiple;
import org.jboss.tools.modeshape.jcr.attributes.NoFullText;
import org.jboss.tools.modeshape.jcr.attributes.NoQueryOrder;
import org.jboss.tools.modeshape.jcr.attributes.OnParentVersion;
import org.jboss.tools.modeshape.jcr.attributes.Protected;
import org.jboss.tools.modeshape.jcr.attributes.QueryOperators;
import org.jboss.tools.modeshape.jcr.cnd.CndElement;
import org.jboss.tools.modeshape.jcr.preference.JcrPreferenceConstants;
import org.jboss.tools.modeshape.jcr.preference.JcrPreferenceStore;

public class PropertyAttributes
implements CndElement {
    private Autocreated autocreated = new Autocreated();
    private Mandatory mandatory = new Mandatory();
    private Multiple multiple = new Multiple();
    private NoFullText noFullText;
    private NoQueryOrder noQueryOrder;
    private Protected notDeletable = new Protected();
    private OnParentVersion opv = OnParentVersion.DEFAULT_VALUE;
    private QueryOperators queryOps;

    public PropertyAttributes() {
        this.noFullText = new NoFullText();
        this.noQueryOrder = new NoQueryOrder();
        this.queryOps = new QueryOperators();
    }

    public PropertyAttributes(Autocreated initialAutocreated, Mandatory initialMandatory, Multiple initialMultiple, Protected initialProtected, OnParentVersion initialOpv, NoFullText initialNoFullText, NoQueryOrder initialNoQueryOrder, QueryOperators initialQueryOps) {
        this();
        if (!this.autocreated.equals(initialAutocreated)) {
            this.autocreated = initialAutocreated;
        }
        if (!this.mandatory.equals(initialMandatory)) {
            this.mandatory = initialMandatory;
        }
        if (!this.multiple.equals(initialMultiple)) {
            this.multiple = initialMultiple;
        }
        if (!this.notDeletable.equals(initialProtected)) {
            this.notDeletable = initialProtected;
        }
        if (initialOpv != this.opv) {
            this.opv = initialOpv;
        }
        if (!this.noFullText.equals(initialNoFullText)) {
            this.noFullText = initialNoFullText;
        }
        if (!this.noQueryOrder.equals(initialNoQueryOrder)) {
            this.noQueryOrder = initialNoQueryOrder;
        }
        if (!this.queryOps.equals(initialQueryOps)) {
            this.queryOps = initialQueryOps;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        PropertyAttributes that = (PropertyAttributes)obj;
        return this.autocreated.equals(that.autocreated) && this.mandatory.equals(that.mandatory) && this.multiple.equals(that.multiple) && this.noFullText.equals(that.noFullText) && this.noQueryOrder.equals(that.noQueryOrder) && this.notDeletable.equals(that.notDeletable) && this.opv == that.opv && this.queryOps.equals(that.queryOps);
    }

    public Autocreated getAutocreated() {
        return this.autocreated;
    }

    public Mandatory getMandatory() {
        return this.mandatory;
    }

    public Multiple getMultiple() {
        return this.multiple;
    }

    public NoFullText getNoFullText() {
        return this.noFullText;
    }

    public NoQueryOrder getNoQueryOrder() {
        return this.noQueryOrder;
    }

    public OnParentVersion getOnParentVersion() {
        return this.opv;
    }

    public Protected getProtected() {
        return this.notDeletable;
    }

    public QueryOperators getQueryOps() {
        return this.queryOps;
    }

    public int hashCode() {
        return Utils.hashCode(0, this.autocreated, this.mandatory, this.multiple, this.noFullText, this.noQueryOrder, this.notDeletable, this.opv, this.queryOps);
    }

    public boolean setAutocreated(AttributeState.Value newState) {
        return this.autocreated.set(newState);
    }

    public boolean setMandatory(AttributeState.Value newState) {
        return this.mandatory.set(newState);
    }

    public boolean setMultiple(AttributeState.Value newState) {
        return this.multiple.set(newState);
    }

    public boolean setNoFullText(AttributeState.Value newState) {
        return this.noFullText.set(newState);
    }

    public boolean setNoQueryOrder(AttributeState.Value newState) {
        return this.noQueryOrder.set(newState);
    }

    public boolean setOnParentVersion(OnParentVersion newOpv) {
        if (this.opv != newOpv) {
            this.opv = newOpv;
            return true;
        }
        return false;
    }

    public boolean setProtected(AttributeState.Value newState) {
        return this.notDeletable.set(newState);
    }

    @Override
    public String toCndNotation(CndElement.NotationType notationType) {
        StringBuilder builder = new StringBuilder();
        JcrPreferenceStore prefStore = JcrPreferenceStore.get();
        String DELIM = prefStore.get(JcrPreferenceConstants.CndPreference.PROPERTY_DEFINITION_ATTRIBUTES_DELIMITER);
        boolean addDelim = Utils.build(builder, false, DELIM, this.autocreated.toCndNotation(notationType));
        if (Utils.build(builder, addDelim, DELIM, this.mandatory.toCndNotation(notationType))) {
            addDelim = true;
        }
        if (Utils.build(builder, addDelim, DELIM, this.notDeletable.toCndNotation(notationType))) {
            addDelim = true;
        }
        if (Utils.build(builder, addDelim, DELIM, this.multiple.toCndNotation(notationType))) {
            addDelim = true;
        }
        if (Utils.build(builder, addDelim, DELIM, this.opv.toCndNotation(notationType))) {
            addDelim = true;
        }
        if (Utils.build(builder, addDelim, DELIM, this.noFullText.toCndNotation(notationType))) {
            addDelim = true;
        }
        if (Utils.build(builder, addDelim, DELIM, this.noQueryOrder.toCndNotation(notationType))) {
            addDelim = true;
        }
        if (Utils.build(builder, addDelim, DELIM, this.queryOps.toCndNotation(notationType))) {
            addDelim = true;
        }
        return builder.toString().trim();
    }
}

