/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr.attributes;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.jcr.Binary;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.modeshape.jcr.Messages;
import org.jboss.tools.modeshape.jcr.Utils;

public class PropertyValue
implements Value {
    private final int type;
    private String value;

    public PropertyValue(int jcrType) {
        this.type = jcrType;
    }

    public PropertyValue(int jcrType, String initialValue) {
        this(jcrType);
        this.value = initialValue;
    }

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        PropertyValue that = (PropertyValue)obj;
        return Utils.equals(this.type, that.type) && Utils.equals(this.value, that.value);
    }

    public Binary getBinary() {
        final byte[] bytes = this.value.getBytes();
        return new Binary(){

            public void dispose() {
            }

            public long getSize() {
                return bytes.length;
            }

            public InputStream getStream() {
                return new ByteArrayInputStream(bytes);
            }

            public int read(byte[] b, long position) throws IOException {
                if (this.getSize() <= position) {
                    return -1;
                }
                InputStream stream = null;
                IOException error = null;
                try {
                    stream = this.getStream();
                    long skip = position;
                    while (skip > 0L) {
                        long skipped = stream.skip(skip);
                        if (skipped <= 0L) {
                            return -1;
                        }
                        skip -= skipped;
                    }
                    int n = stream.read(b);
                    return n;
                }
                catch (IOException e) {
                    error = e;
                    throw e;
                }
                finally {
                    block20: {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (RuntimeException t) {
                                if (error == null) {
                                    throw t;
                                }
                            }
                            catch (IOException t) {
                                if (error != null) break block20;
                                throw t;
                            }
                        }
                    }
                }
            }
        };
    }

    public boolean getBoolean() throws ValueFormatException {
        if (!Utils.isEmpty(this.value)) {
            if (this.value.equals(Boolean.TRUE.toString())) {
                return true;
            }
            if (this.value.equals(Boolean.FALSE.toString())) {
                return false;
            }
        }
        throw new ValueFormatException();
    }

    public Calendar getDate() throws ValueFormatException {
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-mm-dd hh:mm:ss");
            Calendar cal = Calendar.getInstance();
            Date d1 = df.parse(this.value);
            cal.setTime(d1);
            return cal;
        }
        catch (Exception e) {
            String from = PropertyType.nameFromValue((int)this.getType());
            String to = PropertyType.nameFromValue((int)3);
            throw new ValueFormatException(NLS.bind((String)Messages.unableToConvertValue, (Object[])new Object[]{this.value, from, to}), (Throwable)e);
        }
    }

    public BigDecimal getDecimal() throws ValueFormatException {
        try {
            return new BigDecimal(this.value);
        }
        catch (NumberFormatException t) {
            String from = PropertyType.nameFromValue((int)this.getType());
            String to = PropertyType.nameFromValue((int)12);
            throw new ValueFormatException(NLS.bind((String)Messages.unableToConvertValue, (Object[])new Object[]{this.value, from, to}), (Throwable)t);
        }
    }

    public double getDouble() throws ValueFormatException {
        try {
            return Double.parseDouble(this.value);
        }
        catch (NumberFormatException t) {
            String from = PropertyType.nameFromValue((int)this.getType());
            String to = PropertyType.nameFromValue((int)4);
            throw new ValueFormatException(NLS.bind((String)Messages.unableToConvertValue, (Object[])new Object[]{this.value, from, to}), (Throwable)t);
        }
    }

    public long getLong() throws ValueFormatException {
        try {
            return Long.parseLong(this.value);
        }
        catch (NumberFormatException t) {
            String from = PropertyType.nameFromValue((int)this.getType());
            String to = PropertyType.nameFromValue((int)3);
            throw new ValueFormatException(NLS.bind((String)Messages.unableToConvertValue, (Object[])new Object[]{this.value, from, to}), (Throwable)t);
        }
    }

    @Deprecated
    public InputStream getStream() throws RepositoryException {
        return this.getBinary().getStream();
    }

    public String getString() {
        return this.value;
    }

    public int getType() {
        return this.type == 0 ? 1 : this.type;
    }

    public int hashCode() {
        return Utils.hashCode(this.type, this.value);
    }
}

