/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr.cnd;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.modeshape.jcr.ChildNodeDefinition;
import org.jboss.tools.modeshape.jcr.Messages;
import org.jboss.tools.modeshape.jcr.NamespaceMapping;
import org.jboss.tools.modeshape.jcr.NodeTypeDefinition;
import org.jboss.tools.modeshape.jcr.PropertyDefinition;
import org.jboss.tools.modeshape.jcr.Utils;
import org.jboss.tools.modeshape.jcr.attributes.Abstract;
import org.jboss.tools.modeshape.jcr.attributes.AttributeState;
import org.jboss.tools.modeshape.jcr.attributes.Autocreated;
import org.jboss.tools.modeshape.jcr.attributes.DefaultType;
import org.jboss.tools.modeshape.jcr.attributes.Mandatory;
import org.jboss.tools.modeshape.jcr.attributes.Mixin;
import org.jboss.tools.modeshape.jcr.attributes.Multiple;
import org.jboss.tools.modeshape.jcr.attributes.NoFullText;
import org.jboss.tools.modeshape.jcr.attributes.NoQueryOrder;
import org.jboss.tools.modeshape.jcr.attributes.OnParentVersion;
import org.jboss.tools.modeshape.jcr.attributes.Orderable;
import org.jboss.tools.modeshape.jcr.attributes.PrimaryItem;
import org.jboss.tools.modeshape.jcr.attributes.PropertyType;
import org.jboss.tools.modeshape.jcr.attributes.Protected;
import org.jboss.tools.modeshape.jcr.attributes.QueryOperators;
import org.jboss.tools.modeshape.jcr.attributes.Queryable;
import org.jboss.tools.modeshape.jcr.attributes.SameNameSiblings;
import org.jboss.tools.modeshape.jcr.cnd.CndElement;
import org.jboss.tools.modeshape.jcr.cnd.CndTokenizer;
import org.jboss.tools.modeshape.jcr.cnd.CommentedCndElement;
import org.jboss.tools.modeshape.jcr.cnd.CompactNodeTypeDefinition;
import org.jboss.tools.modeshape.jcr.text.ParsingException;
import org.jboss.tools.modeshape.jcr.text.Position;
import org.jboss.tools.modeshape.jcr.text.TokenStream;

public final class CndImporter {
    private final boolean jcr170 = true;
    private final Stack<CommentedCndElement> cndElements = new Stack();
    private String currentComment;
    private CommentedCndElement previousElement;

    public CompactNodeTypeDefinition importFrom(File file, Collection<Throwable> problems) throws IOException {
        return this.importFrom(Utils.read(file), problems, file.getCanonicalPath());
    }

    public CompactNodeTypeDefinition importFrom(InputStream stream, Collection<Throwable> problems, String resourceName) throws IOException {
        return this.importFrom(Utils.read(stream), problems, resourceName);
    }

    public CompactNodeTypeDefinition importFrom(String content, Collection<Throwable> problems, String resourceName) {
        try {
            return this.parse(content);
        }
        catch (RuntimeException e) {
            problems.add(e);
            return null;
        }
    }

    public CompactNodeTypeDefinition parse(String content) {
        Utils.verifyIsNotNull(content, "content is null");
        CompactNodeTypeDefinition cnd = new CompactNodeTypeDefinition();
        CndTokenizer tokenizer = new CndTokenizer();
        TokenStream tokens = new TokenStream(content, tokenizer, false);
        tokens.start();
        while (tokens.hasNext()) {
            if (tokens.matches("<", "any value", "=", "any value", ">")) {
                this.parseNamespaceMapping(tokens, cnd);
                continue;
            }
            if (tokens.matches("[", "any value", "]")) {
                this.parseNodeTypeDefinition(tokens, cnd);
                continue;
            }
            if (tokens.matches("[", "]")) {
                this.parseNodeTypeDefinition(tokens, cnd);
                continue;
            }
            if (tokens.matches(32)) {
                this.parseComment(tokens);
                continue;
            }
            Position position = tokens.previousPosition();
            Object[] args = new Object[]{tokens.consume(), position.getLine(), position.getColumn()};
            throw new ParsingException(position, NLS.bind((String)Messages.expectedNamespaceOrNodeDefinition, (Object[])args));
        }
        return cnd;
    }

    private void parseChildNodeDefinition(TokenStream tokens, NodeTypeDefinition nodeTypeDefn) {
        assert (tokens != null) : "tokens is null";
        assert (nodeTypeDefn != null) : "nodeTypeDefn is null";
        tokens.consume("+");
        ChildNodeDefinition childNodeDefn = new ChildNodeDefinition(nodeTypeDefn);
        this.push(childNodeDefn);
        String name = this.parseName(tokens);
        if (!Utils.isEmpty(name)) {
            childNodeDefn.setName(name);
        }
        this.parseComment(tokens);
        this.parseRequiredPrimaryTypes(tokens, childNodeDefn);
        this.parseComment(tokens);
        this.parseDefaultType(tokens, childNodeDefn.getDefaultType());
        this.parseComment(tokens);
        this.parseNodeAttributes(tokens, nodeTypeDefn, childNodeDefn);
        nodeTypeDefn.addChildNodeDefinition(childNodeDefn);
        CndElement cndElement = this.pop();
        assert (childNodeDefn == cndElement) : "Element not expected child node: " + cndElement.toCndNotation(CndElement.NotationType.LONG);
    }

    private boolean parseComment(TokenStream tokens) {
        if (tokens.matches(32)) {
            do {
                boolean sameLine = false;
                try {
                    sameLine = tokens.nextPosition().getLine() == tokens.previousPosition().getLine();
                }
                catch (NoSuchElementException noSuchElementException) {}
                String newComment = CommentedCndElement.Helper.removeCommentCharacters(tokens.consume());
                if (sameLine || !Utils.isEmpty(this.currentComment) && !this.cndElements.isEmpty()) {
                    if (Utils.isEmpty(this.currentComment)) {
                        this.currentComment = "";
                    } else if (!this.currentComment.endsWith("\n")) {
                        this.currentComment = String.valueOf(this.currentComment) + '\n';
                    }
                    this.currentComment = String.valueOf(this.currentComment) + newComment;
                    CommentedCndElement cndElement = null;
                    cndElement = this.cndElements.isEmpty() ? this.previousElement : this.cndElements.peek();
                    String comment = cndElement.getComment();
                    if (Utils.isEmpty(comment)) {
                        comment = this.currentComment;
                    } else {
                        if (!comment.endsWith("\n")) {
                            comment = String.valueOf(comment) + '\n';
                        }
                        comment = String.valueOf(comment) + this.currentComment;
                    }
                    cndElement.setComment(comment);
                    this.currentComment = null;
                    continue;
                }
                if (this.currentComment == null) {
                    this.currentComment = "";
                } else if (!this.currentComment.endsWith("\n")) {
                    this.currentComment = String.valueOf(this.currentComment) + '\n';
                }
                this.currentComment = String.valueOf(this.currentComment) + newComment;
            } while (tokens.matches(32));
            return true;
        }
        return false;
    }

    private void parseDefaultType(TokenStream tokens, DefaultType defaultType) {
        assert (tokens != null) : "tokens is null";
        assert (defaultType != null) : "defaultType is null";
        if (tokens.canConsume("=")) {
            if (tokens.canConsume('?')) {
                defaultType.set(AttributeState.Value.VARIANT);
            } else {
                String typeName = this.parseName(tokens);
                if (!Utils.isEmpty(typeName)) {
                    defaultType.setDefaultType(typeName);
                }
            }
        }
    }

    private void parseDefaultValues(TokenStream tokens, PropertyDefinition propDefn) {
        List<String> values;
        assert (tokens != null) : "tokens is null";
        assert (propDefn != null) : "propDefn is null";
        this.parseComment(tokens);
        if (tokens.canConsume("=") && !(values = this.parseStringList(tokens)).isEmpty()) {
            if (values.size() == 1 && AttributeState.VARIANT_STRING.equals(values.get(0))) {
                propDefn.changeState(PropertyDefinition.PropertyName.DEFAULT_VALUES, AttributeState.Value.VARIANT);
            } else {
                for (String value : values) {
                    propDefn.addDefaultValue(value);
                }
            }
        }
    }

    private String parseName(TokenStream tokens) {
        String value = tokens.consume();
        return this.removeQuotes(value);
    }

    private List<String> parseNameList(TokenStream tokens) {
        assert (tokens != null) : "tokens is null";
        ArrayList<String> names = new ArrayList<String>();
        if (tokens.canConsume('?')) {
            names.add(AttributeState.VARIANT_STRING);
        } else {
            boolean foundComma = false;
            boolean saveComma = false;
            do {
                if (tokens.matches(32)) {
                    this.parseComment(tokens);
                    saveComma = true;
                } else {
                    names.add(this.parseName(tokens));
                    saveComma = false;
                }
                if (saveComma) continue;
                foundComma = tokens.matches(',');
            } while (tokens.canConsume(',') || tokens.matches(32) || foundComma);
        }
        return names;
    }

    private void parseNamespaceMapping(TokenStream tokens, CompactNodeTypeDefinition cnd) {
        assert (tokens != null) : "tokens is null";
        assert (cnd != null) : "cnd is null";
        NamespaceMapping namespaceMapping = new NamespaceMapping();
        this.push(namespaceMapping);
        tokens.consume("<");
        String prefix = this.removeQuotes(tokens.consume());
        namespaceMapping.setPrefix(prefix);
        tokens.consume("=");
        String uri = this.removeQuotes(tokens.consume());
        namespaceMapping.setUri(uri);
        tokens.consume(">");
        cnd.addNamespaceMapping(namespaceMapping);
        CndElement cndElement = this.pop();
        assert (namespaceMapping == cndElement) : "Element not expected namespace mapping: " + cndElement.toCndNotation(CndElement.NotationType.LONG);
    }

    private void parseNodeAttributes(TokenStream tokens, NodeTypeDefinition nodeTypeDefn, ChildNodeDefinition childNodeDefn) {
        assert (tokens != null) : "tokens is null";
        assert (nodeTypeDefn != null) : "nodeTypeDefn is null";
        assert (childNodeDefn != null) : "childNodeDefn is null";
        while (true) {
            if (tokens.canConsumeAnyOf(Autocreated.NOTATION[0].toUpperCase(), Autocreated.NOTATION[1].toUpperCase(), Autocreated.NOTATION[2].toUpperCase())) {
                if (tokens.canConsume('?')) {
                    childNodeDefn.changeState(ChildNodeDefinition.PropertyName.AUTOCREATED, AttributeState.Value.VARIANT);
                    continue;
                }
                childNodeDefn.changeState(ChildNodeDefinition.PropertyName.AUTOCREATED, AttributeState.Value.IS);
                continue;
            }
            if (tokens.canConsumeAnyOf(Mandatory.NOTATION[0].toUpperCase(), Mandatory.NOTATION[1].toUpperCase(), Mandatory.NOTATION[2].toUpperCase())) {
                if (tokens.canConsume('?')) {
                    childNodeDefn.changeState(ChildNodeDefinition.PropertyName.MANDATORY, AttributeState.Value.VARIANT);
                    continue;
                }
                childNodeDefn.changeState(ChildNodeDefinition.PropertyName.MANDATORY, AttributeState.Value.IS);
                continue;
            }
            if (tokens.canConsumeAnyOf(Protected.NOTATION[0].toUpperCase(), Protected.NOTATION[1].toUpperCase(), Protected.NOTATION[2].toUpperCase())) {
                if (tokens.canConsume('?')) {
                    childNodeDefn.changeState(ChildNodeDefinition.PropertyName.PROTECTED, AttributeState.Value.VARIANT);
                    continue;
                }
                childNodeDefn.changeState(ChildNodeDefinition.PropertyName.PROTECTED, AttributeState.Value.IS);
                continue;
            }
            if (tokens.canConsumeAnyOf(SameNameSiblings.NOTATION[0].toUpperCase(), SameNameSiblings.NOTATION[1].toUpperCase(), SameNameSiblings.NOTATION[2].toUpperCase())) {
                if (tokens.canConsume('?')) {
                    childNodeDefn.changeState(ChildNodeDefinition.PropertyName.SAME_NAME_SIBLINGS, AttributeState.Value.VARIANT);
                    continue;
                }
                childNodeDefn.changeState(ChildNodeDefinition.PropertyName.SAME_NAME_SIBLINGS, AttributeState.Value.IS);
                continue;
            }
            if (tokens.canConsumeAnyOf("MULTIPLE", "MUL", "*")) {
                if (tokens.canConsume('?')) {
                    childNodeDefn.changeState(ChildNodeDefinition.PropertyName.SAME_NAME_SIBLINGS, AttributeState.Value.VARIANT);
                    continue;
                }
                childNodeDefn.changeState(ChildNodeDefinition.PropertyName.SAME_NAME_SIBLINGS, AttributeState.Value.IS);
                continue;
            }
            if (tokens.matchesAnyOf(Utils.toUpperCase(OnParentVersion.toArray()))) {
                String opv = tokens.consume();
                childNodeDefn.setOnParentVersion(opv);
                continue;
            }
            if (tokens.matches(32)) {
                this.parseComment(tokens);
                continue;
            }
            if (tokens.canConsumeAnyOf("PRIMARYITEM", "PRIMARY", "PRI", "!")) {
                nodeTypeDefn.setPrimaryItemName(childNodeDefn.getName());
                continue;
            }
            if (!tokens.canConsumeAnyOf(PrimaryItem.NOTATION[0].toUpperCase(), PrimaryItem.NOTATION[1].toUpperCase(), PrimaryItem.NOTATION[2].toUpperCase())) break;
            nodeTypeDefn.setPrimaryItemName(childNodeDefn.getName());
        }
    }

    private void parseNodeTypeAttributes(TokenStream tokens, NodeTypeDefinition nodeTypeDefn) {
        assert (tokens != null) : "tokens is null";
        assert (nodeTypeDefn != null) : "nodeTypeDefn is null";
        while (true) {
            if (tokens.canConsumeAnyOf(Orderable.NOTATION[0].toUpperCase(), Orderable.NOTATION[1].toUpperCase(), Orderable.NOTATION[2].toUpperCase())) {
                if (tokens.canConsume('?')) {
                    nodeTypeDefn.changeState(NodeTypeDefinition.PropertyName.ORDERABLE, AttributeState.Value.VARIANT);
                    continue;
                }
                nodeTypeDefn.changeState(NodeTypeDefinition.PropertyName.ORDERABLE, AttributeState.Value.IS);
                continue;
            }
            if (tokens.canConsumeAnyOf(Mixin.NOTATION[0].toUpperCase(), Mixin.NOTATION[1].toUpperCase(), Mixin.NOTATION[2].toUpperCase())) {
                if (tokens.canConsume('?')) {
                    nodeTypeDefn.changeState(NodeTypeDefinition.PropertyName.MIXIN, AttributeState.Value.VARIANT);
                    continue;
                }
                nodeTypeDefn.changeState(NodeTypeDefinition.PropertyName.MIXIN, AttributeState.Value.IS);
                continue;
            }
            if (tokens.canConsumeAnyOf(Abstract.NOTATION[0].toUpperCase(), Abstract.NOTATION[1].toUpperCase(), Abstract.NOTATION[2].toUpperCase())) {
                if (tokens.canConsume('?')) {
                    nodeTypeDefn.changeState(NodeTypeDefinition.PropertyName.ABSTRACT, AttributeState.Value.VARIANT);
                    continue;
                }
                nodeTypeDefn.changeState(NodeTypeDefinition.PropertyName.ABSTRACT, AttributeState.Value.IS);
                continue;
            }
            if (tokens.canConsumeAnyOf(Queryable.NO_QUERY_NOTATION[0].toUpperCase(), Queryable.NO_QUERY_NOTATION[1].toUpperCase(), Queryable.NO_QUERY_NOTATION[2].toUpperCase())) {
                nodeTypeDefn.changeState(NodeTypeDefinition.PropertyName.QUERYABLE, AttributeState.Value.IS_NOT);
                continue;
            }
            if (tokens.canConsumeAnyOf(Queryable.QUERY_NOTATION[0].toUpperCase(), Queryable.QUERY_NOTATION[1].toUpperCase(), Queryable.QUERY_NOTATION[2].toUpperCase())) {
                nodeTypeDefn.changeState(NodeTypeDefinition.PropertyName.QUERYABLE, AttributeState.Value.IS);
                continue;
            }
            if (tokens.canConsumeAnyOf(PrimaryItem.NOTATION[0].toUpperCase(), PrimaryItem.NOTATION[1].toUpperCase(), PrimaryItem.NOTATION[2].toUpperCase())) {
                if (tokens.canConsume('?')) {
                    nodeTypeDefn.changeState(NodeTypeDefinition.PropertyName.PRIMARY_ITEM, AttributeState.Value.VARIANT);
                    continue;
                }
                nodeTypeDefn.setPrimaryItemName(this.removeQuotes(tokens.consume()));
                continue;
            }
            if (!tokens.matches(32)) break;
            this.parseComment(tokens);
        }
    }

    private void parseNodeTypeDefinition(TokenStream tokens, CompactNodeTypeDefinition cnd) {
        assert (tokens != null) : "tokens is null";
        assert (cnd != null) : "cnd is null";
        NodeTypeDefinition nodeType = new NodeTypeDefinition();
        this.push(nodeType);
        String name = this.parseNodeTypeName(tokens);
        if (!Utils.isEmpty(name)) {
            nodeType.setName(name);
        }
        this.parseComment(tokens);
        List<String> superTypes = this.parseSupertypes(tokens);
        if (!superTypes.isEmpty()) {
            for (String superType : superTypes) {
                nodeType.addSuperType(superType);
            }
        }
        this.parseComment(tokens);
        this.parseNodeTypeAttributes(tokens, nodeType);
        this.parseComment(tokens);
        this.parsePropertyOrChildNodeDefinitions(tokens, nodeType);
        cnd.addNodeTypeDefinition(nodeType);
        CndElement cndElement = this.pop();
        assert (nodeType == cndElement) : "Element not expected node type: " + cndElement.toCndNotation(CndElement.NotationType.LONG);
    }

    private String parseNodeTypeName(TokenStream tokens) {
        assert (tokens != null) : "tokens is null";
        tokens.consume("[");
        String name = this.parseName(tokens);
        if ("]".equals(name)) {
            return "";
        }
        tokens.consume("]");
        return name;
    }

    private void parsePropertyAttributes(TokenStream tokens, NodeTypeDefinition nodeTypeDefn, PropertyDefinition propDefn) {
        assert (tokens != null) : "tokens is null";
        assert (propDefn != null) : "propDefn is null";
        while (true) {
            if (tokens.canConsumeAnyOf(Autocreated.NOTATION[0].toUpperCase(), Autocreated.NOTATION[1].toUpperCase(), Autocreated.NOTATION[2].toUpperCase())) {
                if (tokens.canConsume('?')) {
                    propDefn.changeState(PropertyDefinition.PropertyName.AUTOCREATED, AttributeState.Value.VARIANT);
                    continue;
                }
                propDefn.changeState(PropertyDefinition.PropertyName.AUTOCREATED, AttributeState.Value.IS);
                continue;
            }
            if (tokens.canConsumeAnyOf(Mandatory.NOTATION[0].toUpperCase(), Mandatory.NOTATION[1].toUpperCase(), Mandatory.NOTATION[2].toUpperCase())) {
                if (tokens.canConsume('?')) {
                    propDefn.changeState(PropertyDefinition.PropertyName.MANDATORY, AttributeState.Value.VARIANT);
                    continue;
                }
                propDefn.changeState(PropertyDefinition.PropertyName.MANDATORY, AttributeState.Value.IS);
                continue;
            }
            if (tokens.canConsumeAnyOf(Protected.NOTATION[0].toUpperCase(), Protected.NOTATION[1].toUpperCase(), Protected.NOTATION[2].toUpperCase())) {
                if (tokens.canConsume('?')) {
                    propDefn.changeState(PropertyDefinition.PropertyName.PROTECTED, AttributeState.Value.VARIANT);
                    continue;
                }
                propDefn.changeState(PropertyDefinition.PropertyName.PROTECTED, AttributeState.Value.IS);
                continue;
            }
            if (tokens.canConsumeAnyOf(Multiple.NOTATION[0].toUpperCase(), Multiple.NOTATION[1].toUpperCase(), Multiple.NOTATION[2].toUpperCase())) {
                if (tokens.canConsume('?')) {
                    propDefn.changeState(PropertyDefinition.PropertyName.MULTIPLE, AttributeState.Value.VARIANT);
                    continue;
                }
                propDefn.changeState(PropertyDefinition.PropertyName.MULTIPLE, AttributeState.Value.IS);
                continue;
            }
            if (tokens.matchesAnyOf(Utils.toUpperCase(OnParentVersion.toArray()))) {
                String opv = tokens.consume();
                propDefn.setOnParentVersion(opv);
                continue;
            }
            if (tokens.canConsumeAnyOf(NoFullText.NOTATION[0].toUpperCase(), NoFullText.NOTATION[1].toUpperCase(), NoFullText.NOTATION[2].toUpperCase())) {
                if (tokens.canConsume('?')) {
                    propDefn.changeState(PropertyDefinition.PropertyName.NO_FULL_TEXT, AttributeState.Value.VARIANT);
                    continue;
                }
                propDefn.changeState(PropertyDefinition.PropertyName.NO_FULL_TEXT, AttributeState.Value.IS);
                continue;
            }
            if (tokens.canConsumeAnyOf(NoQueryOrder.NOTATION[0].toUpperCase(), NoQueryOrder.NOTATION[1].toUpperCase(), NoQueryOrder.NOTATION[2].toUpperCase())) {
                if (tokens.canConsume('?')) {
                    propDefn.changeState(PropertyDefinition.PropertyName.NO_QUERY_ORDER, AttributeState.Value.VARIANT);
                    continue;
                }
                propDefn.changeState(PropertyDefinition.PropertyName.NO_QUERY_ORDER, AttributeState.Value.IS);
                continue;
            }
            if (tokens.canConsumeAnyOf(QueryOperators.NOTATION[0].toUpperCase(), QueryOperators.NOTATION[1].toUpperCase(), QueryOperators.NOTATION[2].toUpperCase())) {
                this.parseQueryOperators(tokens, propDefn);
                continue;
            }
            if (tokens.matches(32)) {
                this.parseComment(tokens);
                continue;
            }
            if (!tokens.canConsumeAnyOf("PRIMARY", "PRI", "!")) break;
            nodeTypeDefn.setPrimaryItemName(propDefn.getName());
        }
    }

    private void parsePropertyDefinition(TokenStream tokens, NodeTypeDefinition nodeTypeDefn) {
        assert (tokens != null) : "tokens is null";
        assert (nodeTypeDefn != null) : "nodeTypeDefn is null";
        tokens.consume("-");
        PropertyDefinition propDefn = new PropertyDefinition(nodeTypeDefn);
        this.push(propDefn);
        String name = this.parseName(tokens);
        if (!Utils.isEmpty(name)) {
            propDefn.setName(name);
        }
        this.parseComment(tokens);
        this.parsePropertyType(tokens, propDefn);
        this.parseComment(tokens);
        this.parseDefaultValues(tokens, propDefn);
        this.parseComment(tokens);
        this.parsePropertyAttributes(tokens, nodeTypeDefn, propDefn);
        this.parseComment(tokens);
        this.parseValueConstraints(tokens, propDefn);
        nodeTypeDefn.addPropertyDefinition(propDefn);
        CndElement cndElement = this.pop();
        assert (propDefn == cndElement) : "Element not expected property: " + cndElement.toCndNotation(CndElement.NotationType.LONG);
    }

    private void parsePropertyOrChildNodeDefinitions(TokenStream tokens, NodeTypeDefinition nodeTypeDefn) {
        assert (tokens != null) : "tokens is null";
        assert (nodeTypeDefn != null) : "nodeTypeDefn is null";
        while (true) {
            if (tokens.matches("-")) {
                this.parsePropertyDefinition(tokens, nodeTypeDefn);
                continue;
            }
            if (tokens.matches("+")) {
                this.parseChildNodeDefinition(tokens, nodeTypeDefn);
                continue;
            }
            if (!tokens.matches(32)) break;
            if (!this.parseComment(tokens) || this.previousElement == null) continue;
            String comment = this.previousElement.getComment();
            if (comment == null) {
                comment = "";
            } else if (!comment.endsWith("\n")) {
                comment = String.valueOf(comment) + '\n';
            }
            this.previousElement.setComment(String.valueOf(comment) + this.currentComment);
            this.currentComment = null;
        }
    }

    private void parsePropertyType(TokenStream tokens, PropertyDefinition propDefn) {
        assert (tokens != null) : "tokens is null";
        assert (propDefn != null) : "propDefn is null";
        this.parseComment(tokens);
        if (tokens.canConsume("(")) {
            if (tokens.matchesAnyOf(Utils.toUpperCase(PropertyType.validValues()))) {
                String propertyType = tokens.consume();
                propDefn.setType(PropertyType.find(propertyType));
            }
            tokens.consume(")");
        }
    }

    private void parseQueryOperators(TokenStream tokens, PropertyDefinition propDefn) {
        assert (tokens != null) : "tokens is null";
        assert (propDefn != null) : "propDefn is null";
        if (tokens.canConsume('?')) {
            propDefn.changeState(PropertyDefinition.PropertyName.QUERY_OPS, AttributeState.Value.VARIANT);
        } else {
            this.parseComment(tokens);
            String operatorList = this.removeQuotes(tokens.consume());
            ArrayList<String> operators = new ArrayList<String>();
            String[] stringArray = operatorList.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String operatorValue = stringArray[n2];
                QueryOperators.QueryOperator operator = QueryOperators.QueryOperator.find(operatorValue.trim());
                if (operator == null) {
                    throw new ParsingException(tokens.previousPosition(), NLS.bind((String)Messages.invalidQueryOperator, (Object)operator, (Object)propDefn.getName()));
                }
                operators.add(operatorValue);
                ++n2;
            }
            if (!operators.isEmpty()) {
                propDefn.setAvailableQueryOperators(operators.toArray(new String[operators.size()]));
            }
        }
    }

    private void parseRequiredPrimaryTypes(TokenStream tokens, ChildNodeDefinition childNodeDefn) {
        assert (tokens != null) : "tokens is null";
        assert (childNodeDefn != null) : "childNodeDefn is null";
        this.parseComment(tokens);
        if (tokens.canConsume("(")) {
            List<String> requiredTypeNames = this.parseNameList(tokens);
            if (!requiredTypeNames.isEmpty()) {
                if (requiredTypeNames.size() == 1 && AttributeState.VARIANT_STRING.equals(requiredTypeNames.get(0))) {
                    childNodeDefn.changeState(ChildNodeDefinition.PropertyName.REQUIRED_TYPES, AttributeState.Value.VARIANT);
                } else {
                    for (String requiredTypeName : requiredTypeNames) {
                        childNodeDefn.addRequiredType(requiredTypeName);
                    }
                }
            }
            tokens.consume(")");
        }
    }

    private List<String> parseStringList(TokenStream tokens) {
        assert (tokens != null) : "tokens is null";
        ArrayList<String> strings = new ArrayList<String>();
        if (tokens.canConsume('?')) {
            strings.add(AttributeState.VARIANT_STRING);
        } else {
            boolean foundComma = false;
            boolean saveComma = false;
            boolean firstTime = true;
            do {
                if (tokens.matches(32)) {
                    this.parseComment(tokens);
                    saveComma = true;
                } else if (firstTime || foundComma) {
                    strings.add(this.removeQuotes(tokens.consume()));
                    saveComma = false;
                }
                if (!saveComma) {
                    foundComma = tokens.matches(',');
                }
                firstTime = false;
            } while (tokens.canConsume(',') || this.parseComment(tokens) || foundComma);
        }
        return strings;
    }

    private List<String> parseSupertypes(TokenStream tokens) {
        assert (tokens != null) : "tokens is null";
        this.parseComment(tokens);
        if (tokens.canConsume(">")) {
            return this.parseNameList(tokens);
        }
        return Collections.emptyList();
    }

    private void parseValueConstraints(TokenStream tokens, PropertyDefinition propDefn) {
        List<String> constraints;
        assert (tokens != null) : "tokens is null";
        assert (propDefn != null) : "propDefn is null";
        if (tokens.canConsume("<") && !(constraints = this.parseStringList(tokens)).isEmpty()) {
            if (constraints.size() == 1 && AttributeState.VARIANT_STRING.equals(constraints.get(0))) {
                propDefn.changeState(PropertyDefinition.PropertyName.VALUE_CONSTRAINTS, AttributeState.Value.VARIANT);
            } else {
                for (String constraint : constraints) {
                    propDefn.addValueConstraint(constraint);
                }
            }
        }
    }

    private CndElement pop() {
        this.previousElement = this.cndElements.pop();
        return this.previousElement;
    }

    private void push(CommentedCndElement commentedElement) {
        if (!Utils.isEmpty(this.currentComment)) {
            String cndElementComment = commentedElement.getComment();
            if (cndElementComment == null) {
                cndElementComment = "";
            } else if (!cndElementComment.endsWith("\n")) {
                cndElementComment = String.valueOf(cndElementComment) + '\n';
            }
            commentedElement.setComment(String.valueOf(cndElementComment) + this.currentComment);
            this.currentComment = null;
        }
        this.cndElements.push(commentedElement);
    }

    private final String removeQuotes(String text) {
        return text.replaceFirst("^['\"]+", "").replaceAll("['\"]+$", "");
    }
}

