/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.factory;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.mapping.PluginConstants;
import org.teiid.designer.mapping.factory.IChoiceFactory;

public class ChoiceFactoryManager
implements PluginConstants,
PluginConstants.ExtensionPoints.ChoiceObjectHandler {
    private static final Class CLASS = ChoiceFactoryManager.class;
    private static final String PREFIX = I18nUtil.getPropertyPrefix((Class)CLASS);
    private static Map choiceHandlerMap;

    static {
        ChoiceFactoryManager.buildChoiceHanderMaps();
    }

    private ChoiceFactoryManager() {
    }

    private static void buildChoiceHanderMaps() {
        choiceHandlerMap = new HashMap();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.teiid.designer.mapping", "choiceObjectHandler");
        IExtension[] extensions = extensionPoint.getExtensions();
        if (extensions.length > 0) {
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                Object extension = null;
                Object sFactoryClass = null;
                int j = 0;
                while (j < elements.length) {
                    try {
                        extension = elements[j].createExecutableExtension("factoryClass");
                        if (extension instanceof IChoiceFactory) {
                            choiceHandlerMap.put(sFactoryClass, extension);
                        } else {
                            Util.log(4, Util.getString(String.valueOf(PREFIX) + "invalidChoiceHandlerMapperClass", new Object[]{extension.getClass().getName()}));
                        }
                    }
                    catch (Exception theException) {
                        Util.log(4, (Throwable)theException, Util.getString(String.valueOf(PREFIX) + "loadingChoiceHandlerProblem", new Object[]{elements[j].getAttribute("name")}));
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public static IChoiceFactory getChoiceFactory(EObject eo) {
        CoreArgCheck.isNotNull((Object)eo);
        for (IChoiceFactory icf : choiceHandlerMap.values()) {
            if (!icf.supports(eo)) continue;
            return icf;
        }
        return null;
    }
}

