/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingRoot;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.core.util.ModelResourceContainerFactory;
import org.teiid.designer.mapping.PluginConstants;
import org.teiid.designer.metamodels.transformation.FragmentMappingRoot;

public class FragmentMappingAdapter
implements PluginConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(FragmentMappingAdapter.class);
    private FragmentMappingRoot fragmentRoot;
    private EObject root;

    public FragmentMappingAdapter(EObject theTreeRoot) {
        CoreArgCheck.isNotNull((Object)theTreeRoot);
        this.root = theTreeRoot;
        ArrayList<MappingRoot> fragmentRoots = new ArrayList<MappingRoot>();
        ModelContents mc = ModelerCore.getModelEditor().getModelContents(this.root);
        if (mc != null) {
            List mappingRoots = mc.getTransformations(theTreeRoot);
            if (mappingRoots != null && !mappingRoots.isEmpty()) {
                int size = mappingRoots.size();
                int i = 0;
                while (i < size) {
                    MappingRoot mappingRoot = (MappingRoot)mappingRoots.get(i);
                    if (mappingRoot instanceof FragmentMappingRoot) {
                        fragmentRoots.add(mappingRoot);
                    }
                    ++i;
                }
            }
            this.setFragmentRoots(fragmentRoots);
        }
    }

    public FragmentMappingAdapter(EObject theTreeRoot, List theFragmentRoots) {
        CoreArgCheck.isNotNull((Object)theTreeRoot);
        this.root = theTreeRoot;
        this.setFragmentRoots(theFragmentRoots);
    }

    public void addFragment(EObject theFragmentReference, EObject theFragment) {
        ModelContents mc;
        CoreArgCheck.isNotNull((Object)theFragmentReference);
        CoreArgCheck.isNotNull((Object)theFragment);
        if (this.fragmentRoot == null && (mc = ModelerCore.getModelEditor().getModelContents(this.root)) != null) {
            this.fragmentRoot = ModelResourceContainerFactory.createNewFragmentMappingRoot((EObject)this.root);
        }
        boolean createFragment = true;
        List mappings = this.getMappings();
        if (!mappings.isEmpty()) {
            int size = 0;
            int i = 0;
            while (i < size) {
                Mapping mapping = (Mapping)mappings.get(i);
                EObject fragmentReference = this.getFragmentReference(mapping);
                if (theFragmentReference.equals(fragmentReference)) {
                    createFragment = false;
                    break;
                }
                ++i;
            }
        }
        if (createFragment) {
            this.fragmentRoot.createMapping(Collections.singletonList(theFragment), Collections.singletonList(theFragmentReference));
        } else {
            Util.log(4, Util.getString(String.valueOf(PREFIX) + "duplicateFragment", new Object[]{theFragmentReference}));
        }
    }

    public boolean containsFragments() {
        return this.getFragmentCount() > 0;
    }

    public EObject getFragment(EObject theFragmentReference) {
        List fragmentMappings;
        CoreArgCheck.isNotNull((Object)theFragmentReference);
        EObject result = null;
        if (this.containsFragments() && !(fragmentMappings = this.getMappings()).isEmpty()) {
            int size = fragmentMappings.size();
            int i = 0;
            while (i < size) {
                Mapping mapping = (Mapping)fragmentMappings.get(i);
                EObject fragmentReference = this.getFragmentReference(mapping);
                if (theFragmentReference.equals(fragmentReference)) {
                    result = this.getFragment(mapping);
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    private EObject getFragment(Mapping theMapping) {
        CoreArgCheck.isNotNull((Object)theMapping);
        EList inputs = theMapping.getInputs();
        return inputs.isEmpty() ? null : (EObject)inputs.get(0);
    }

    private int getFragmentCount() {
        return this.fragmentRoot == null ? 0 : this.getMappings().size();
    }

    private EObject getFragmentReference(Mapping theMapping) {
        CoreArgCheck.isNotNull((Object)theMapping);
        EList outputs = theMapping.getOutputs();
        return outputs.isEmpty() ? null : (EObject)outputs.get(0);
    }

    public EObject getInputSet() {
        EObject result = null;
        return result;
    }

    public EObject getInputSet(EObject theFragmentReference) {
        List mappings;
        CoreArgCheck.isNotNull((Object)theFragmentReference);
        EObject result = null;
        if (this.containsFragments() && !(mappings = this.getMappings()).isEmpty()) {
            int size = mappings.size();
            int i = 0;
            while (i < size) {
                Mapping mapping = (Mapping)mappings.get(i);
                EObject fragmentReference = this.getFragmentReference(mapping);
                theFragmentReference.equals(fragmentReference);
                ++i;
            }
        }
        return result;
    }

    private List getMappings() {
        return this.fragmentRoot == null ? null : this.fragmentRoot.getNested();
    }

    public void removeFragment(EObject theFragmentReference) {
        CoreArgCheck.isNotNull((Object)theFragmentReference);
        if (this.containsFragments()) {
            boolean foundIt = false;
            List mappings = this.getMappings();
            int size = mappings.size();
            int i = 0;
            while (i < size) {
                Mapping mapping = (Mapping)mappings.get(i);
                EObject fragmentReference = this.getFragmentReference(mapping);
                if (theFragmentReference.equals(fragmentReference)) {
                    foundIt = true;
                    break;
                }
                ++i;
            }
            if (!foundIt) {
                Util.log(4, Util.getString(String.valueOf(PREFIX) + "removeFragmentProblemNotFound", new Object[]{theFragmentReference}));
            }
        } else {
            Util.log(4, Util.getString(String.valueOf(PREFIX) + "removeFragmentProblemNoRoot", new Object[]{theFragmentReference}));
        }
    }

    private void setFragmentRoots(List theFragmentRoots) {
        CoreArgCheck.isNotNull((Object)theFragmentRoots);
        if (!theFragmentRoots.isEmpty()) {
            int size = theFragmentRoots.size();
            int i = 0;
            while (i < size) {
                Object potentialRoot = theFragmentRoots.get(i);
                if (potentialRoot instanceof FragmentMappingRoot) {
                    if (this.fragmentRoot == null) {
                        this.fragmentRoot = (FragmentMappingRoot)potentialRoot;
                    } else {
                        Util.log(4, Util.getString(String.valueOf(PREFIX) + "multipleFragmentRootsFound", new Object[]{potentialRoot}));
                    }
                } else {
                    Util.log(4, Util.getString(String.valueOf(PREFIX) + "notFragmentRoot", new Object[]{potentialRoot}));
                }
                ++i;
            }
        }
    }
}

