/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.osgi.service.prefs.BackingStoreException;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ClearEObjectReferences;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.core.util.ModelResourceContainerFactory;
import org.teiid.designer.core.util.ModelVisitor;
import org.teiid.designer.core.util.ModelVisitorProcessor;
import org.teiid.designer.core.util.NewModelObjectHelperManager;
import org.teiid.designer.mapping.PluginConstants;
import org.teiid.designer.mapping.factory.CompositorBasedBuilderStrategy;
import org.teiid.designer.mapping.factory.IMappableTree;
import org.teiid.designer.mapping.factory.ITreeToRelationalMapper;
import org.teiid.designer.mapping.factory.IterationBasedBuilderStrategy;
import org.teiid.designer.mapping.factory.MappableTreeIterator;
import org.teiid.designer.mapping.factory.MappingClassBuilderStrategy;
import org.teiid.designer.mapping.factory.MappingClassGenerationVisitor;
import org.teiid.designer.mapping.factory.MappingClassSplitterVisitor;
import org.teiid.designer.mapping.factory.ModelMapperFactory;
import org.teiid.designer.mapping.factory.TreeMappingAdapter;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.diagram.DiagramContainer;
import org.teiid.designer.metamodels.diagram.DiagramEntity;
import org.teiid.designer.metamodels.transformation.InputSet;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.MappingClassColumn;
import org.teiid.designer.metamodels.transformation.MappingClassSet;
import org.teiid.designer.metamodels.transformation.StagingTable;
import org.teiid.designer.metamodels.transformation.TransformationFactory;

public class MappingClassFactory {
    private static MappingClassBuilderStrategy defaultStrategy;
    private static final String STRATEGY_PREF_KEY = "MappingClassFactory.defaultStrategy";
    private static final String COMPOSITOR_PREF_VALUE = "MappingClassFactory.compositorStrategy";
    private static final String ITERATION_PREF_VALUE = "MappingClassFactory.iterationStrategy";
    private EObject treeRoot;
    private ITreeToRelationalMapper mapper;
    private IMappableTree tree;
    private TreeMappingAdapter mapping;
    private AdapterFactory emfAdapter;
    private TransformationFactory metamodelFactory;
    private MappingClassSet mappingClassSet;
    private boolean generatingMappingClasses = false;

    public static MappingClassBuilderStrategy getDefaultStrategy() {
        if (defaultStrategy == null) {
            IEclipsePreferences defaultPrefs;
            IEclipsePreferences prefs = ModelerCore.getPreferences((String)"org.teiid.designer.mapping");
            String defValue = prefs.get(STRATEGY_PREF_KEY, (defaultPrefs = ModelerCore.getDefaultPreferences((String)"org.teiid.designer.mapping")).get(STRATEGY_PREF_KEY, null));
            defaultStrategy = COMPOSITOR_PREF_VALUE.equals(defValue) ? MappingClassBuilderStrategy.compositorStrategy : MappingClassBuilderStrategy.iterationStrategy;
        }
        return defaultStrategy;
    }

    public static void setDefaultStrategy(MappingClassBuilderStrategy strategy) {
        IEclipsePreferences prefs = ModelerCore.getPreferences((String)"org.teiid.designer.mapping");
        if (strategy instanceof CompositorBasedBuilderStrategy) {
            prefs.put(STRATEGY_PREF_KEY, COMPOSITOR_PREF_VALUE);
        } else {
            assert (strategy instanceof IterationBasedBuilderStrategy);
            prefs.put(STRATEGY_PREF_KEY, ITERATION_PREF_VALUE);
        }
        defaultStrategy = strategy;
        try {
            ModelerCore.savePreferences((String)"org.teiid.designer.mapping");
        }
        catch (BackingStoreException e) {
            PluginConstants.Util.log((Throwable)e);
        }
    }

    public MappingClassFactory(ITreeToRelationalMapper mapper) {
        this.mapper = mapper;
        this.tree = mapper.getMappableTree();
        this.treeRoot = mapper.getMappableTree().getTreeRoot();
        this.mapping = new TreeMappingAdapter(this.treeRoot);
        this.metamodelFactory = TransformationFactory.eINSTANCE;
    }

    public MappingClassFactory(ITreeToRelationalMapper mapper, TreeMappingAdapter mapping) {
        this.mapper = mapper;
        this.tree = mapper.getMappableTree();
        this.treeRoot = mapper.getMappableTree().getTreeRoot();
        this.mapping = mapping;
        this.metamodelFactory = TransformationFactory.eINSTANCE;
    }

    public TreeMappingAdapter getMappingAdapter() {
        return this.mapping;
    }

    public Set generateMappingClasses(EObject node, MappingClassBuilderStrategy strategy, boolean autoPopulateAttributes) {
        this.setGeneratingMappingClasses(true);
        HashSet result = new HashSet();
        Map mappingClassMap = strategy.buildMappingClassMap(node, this.tree, this.mapper);
        MappingClassGenerationVisitor visitor = new MappingClassGenerationVisitor(this.mapper, this, mappingClassMap, autoPopulateAttributes, true, result);
        MappableTreeIterator nodeIter = new MappableTreeIterator(this.tree);
        if (nodeIter.hasNext()) {
            nodeIter.next();
        }
        while (nodeIter.hasNext()) {
            visitor.visit((EObject)nodeIter.next());
        }
        this.finishGeneratingMappingClasses(autoPopulateAttributes);
        this.setGeneratingMappingClasses(false);
        return result;
    }

    private void setGeneratingMappingClasses(boolean generating) {
        this.mapping.setGeneratingMappingClasses(generating);
        this.generatingMappingClasses = generating;
    }

    public boolean isGeneratingMappingClasses() {
        return this.generatingMappingClasses;
    }

    public boolean canCreateMappingClass(EObject location) {
        if (this.mapping != null && this.mapping.getMappingClass(location) != null) {
            return false;
        }
        if (this.mapper != null) {
            return this.mapper.allowsMappingClass(location);
        }
        return false;
    }

    public boolean canCreateStagingTable(EObject location) {
        if (this.mapping != null && this.mapping.getStagingTable(location) != null) {
            return false;
        }
        if (this.mapper != null) {
            return this.mapper.allowsMappingClass(location);
        }
        return false;
    }

    public MappingClass createMappingClass(EObject location, boolean moveParentAttributes, boolean markRecursive) {
        MappingClass newMappingClass = this.metamodelFactory.createMappingClass();
        if (newMappingClass != null) {
            List allTransforms;
            ModelContents modelContents;
            boolean setGenerated = false;
            if (!this.isGeneratingMappingClasses()) {
                this.setGeneratingMappingClasses(true);
                setGenerated = true;
            }
            EObject newTreeMappingRoot = this.mapping.createTreeMappingRoot(newMappingClass);
            newMappingClass.setMappingClassSet(this.getMappingClassSet());
            newMappingClass.setName(this.convertLocationNameToMappingClassName(location));
            InputSet inputSet = this.metamodelFactory.createInputSet();
            inputSet.setMappingClass(newMappingClass);
            this.mapping.addMappingClassAtLocation(newTreeMappingRoot, newMappingClass, location);
            if (markRecursive) {
                newMappingClass.setRecursionAllowed(true);
            }
            if ((modelContents = ModelerCore.getModelEditor().getModelContents((EObject)newMappingClass)) != null && (allTransforms = modelContents.getTransformations((EObject)newMappingClass)).isEmpty()) {
                try {
                    NewModelObjectHelperManager.helpCreate((Object)newMappingClass, null);
                }
                catch (ModelerCoreException err) {
                    PluginConstants.Util.log((Throwable)err);
                }
            }
            if (moveParentAttributes) {
                List documentNodes = this.getMappingClassExtentNodes(newMappingClass);
                ArrayList<EObject> mappableDocumentNodes = new ArrayList<EObject>(documentNodes.size() + 1);
                if (this.mapper.isMappable(location)) {
                    mappableDocumentNodes.add(location);
                }
                for (EObject docNode : documentNodes) {
                    if (!this.mapper.isMappable(docNode) || mappableDocumentNodes.contains(docNode)) continue;
                    mappableDocumentNodes.add(docNode);
                }
                if (!mappableDocumentNodes.isEmpty()) {
                    this.moveOrCreateMappingClassColumns(newMappingClass, mappableDocumentNodes, new HashMap(), false, new HashSet());
                }
            }
            if (setGenerated) {
                this.setGeneratingMappingClasses(false);
            }
        }
        return newMappingClass;
    }

    public MappingClass createMappingClass(EObject location, boolean markRecursive) {
        MappingClass result = this.metamodelFactory.createMappingClass();
        if (result != null) {
            List allTransforms;
            ModelContents modelContents;
            EObject newTreeMappingRoot = this.mapping.createTreeMappingRoot(result);
            result.setMappingClassSet(this.getMappingClassSet());
            result.setName(this.convertLocationNameToMappingClassName(location));
            this.mapping.addMappingClassAtLocation(newTreeMappingRoot, result, location);
            InputSet inputSet = this.metamodelFactory.createInputSet();
            inputSet.setMappingClass(result);
            if (markRecursive) {
                result.setRecursionAllowed(true);
            }
            if ((modelContents = ModelerCore.getModelEditor().getModelContents((EObject)result)) != null && (allTransforms = modelContents.getTransformations((EObject)result)).isEmpty()) {
                try {
                    NewModelObjectHelperManager.helpCreate((Object)result, null);
                }
                catch (ModelerCoreException err) {
                    PluginConstants.Util.log((Throwable)err);
                }
            }
        }
        return result;
    }

    private void finishGeneratingMappingClasses(boolean createAttributes) {
        Iterator iter = this.getMappingClassSet().getMappingClasses().iterator();
        MappingClass mappingClass = null;
        while (iter.hasNext()) {
            mappingClass = (MappingClass)iter.next();
            EObject attribute = this.mapping.getMappingClassLocation(mappingClass);
            this.finishCreateMappingClass(attribute, mappingClass, createAttributes);
        }
    }

    private void finishCreateMappingClass(EObject location, MappingClass mappingClass, boolean moveParentAttributes) {
        if (mappingClass != null && moveParentAttributes) {
            List documentNodes = this.getMappingClassExtentNodes(mappingClass);
            ArrayList<EObject> mappableDocumentNodes = new ArrayList<EObject>(documentNodes.size() + 1);
            if (this.mapper.isMappable(location)) {
                mappableDocumentNodes.add(location);
            }
            for (EObject docNode : documentNodes) {
                if (!this.mapper.isMappable(docNode) || mappableDocumentNodes.contains(docNode)) continue;
                mappableDocumentNodes.add(docNode);
            }
            if (!mappableDocumentNodes.isEmpty()) {
                this.moveOrCreateMappingClassColumns(mappingClass, mappableDocumentNodes, new HashMap(), true, new HashSet());
            }
        }
    }

    public List getMappingClassExtentNodes(MappingClass theMappingClass) {
        ArrayList<EObject> extentNodes = new ArrayList<EObject>();
        List locations = this.mapping.getMappingClassOutputLocations(theMappingClass);
        ArrayList columnLocations = new ArrayList();
        Iterator iter = theMappingClass.getColumns().iterator();
        while (iter.hasNext()) {
            columnLocations.addAll(this.mapping.getMappingClassColumnOutputLocations((MappingClassColumn)iter.next()));
        }
        if (!locations.isEmpty()) {
            List allMCLocations = this.mapping.getAllMappingClassLocations();
            for (EObject nextLocation : locations) {
                extentNodes.add(nextLocation);
                extentNodes.addAll(this.gatherExtentNodes(nextLocation, columnLocations, allMCLocations));
            }
        }
        return extentNodes;
    }

    public StagingTable createStagingTable(EObject location) {
        StagingTable newStagingTable = this.metamodelFactory.createStagingTable();
        if (newStagingTable != null) {
            List allTransforms;
            EObject newTreeMappingRoot = this.mapping.createTreeMappingRoot((MappingClass)newStagingTable);
            newStagingTable.setMappingClassSet(this.getMappingClassSet());
            newStagingTable.setName(this.convertLocationNameToStagingTableName(location));
            this.mapping.addStagingTableAtLocation(newTreeMappingRoot, newStagingTable, location);
            ModelContents modelContents = ModelerCore.getModelEditor().getModelContents((EObject)newStagingTable);
            if (modelContents != null && (allTransforms = modelContents.getTransformations((EObject)newStagingTable)).isEmpty()) {
                try {
                    NewModelObjectHelperManager.helpCreate((Object)newStagingTable, null);
                }
                catch (ModelerCoreException err) {
                    PluginConstants.Util.log((Throwable)err);
                }
            }
        }
        return newStagingTable;
    }

    public void deleteStagingTable(StagingTable table) throws ModelerCoreException {
        this.mapping.deleteMappingClass((MappingClass)table);
    }

    public void deleteMappingClass(MappingClass mappingClass) throws ModelerCoreException {
        this.mapping.deleteMappingClass(mappingClass);
    }

    public void deleteMappingClassColumn(MappingClassColumn column) throws ModelerCoreException {
        ArrayList locationList = new ArrayList(this.mapping.getMappingClassColumnOutputLocations(column));
        Iterator iter = locationList.iterator();
        while (iter.hasNext()) {
            this.mapping.removeMappingClassColumnLocation(column, (EObject)iter.next());
        }
        ModelerCore.getModelEditor().delete((EObject)column);
    }

    public boolean canMergeMappingClasses(MappingClass upperMappingClass, MappingClass lowerMappingClass) {
        boolean result = false;
        List topLocations = this.mapping.getMappingClassOutputLocations(upperMappingClass);
        if (!topLocations.isEmpty()) {
            EObject topLocation = (EObject)topLocations.get(0);
            List bottomLocations = this.mapping.getMappingClassOutputLocations(lowerMappingClass);
            if (!bottomLocations.isEmpty()) {
                EObject bottomParent;
                EObject bottomLocation = (EObject)bottomLocations.get(0);
                EObject topParent = this.tree.getParent(topLocation);
                if (topParent.equals(bottomParent = this.tree.getParent(bottomLocation))) {
                    result = true;
                } else if (this.tree.isAncestorOf(topLocation, bottomLocation) || this.tree.isAncestorOf(bottomLocation, topLocation)) {
                    result = true;
                } else {
                    boolean keepGoing = true;
                    Object topChoice = null;
                    EObject bottomChoice = null;
                    while (keepGoing) {
                        if (topChoice == null && (topParent = this.tree.getParent(topParent)) != null && this.tree.isChoiceNode(topParent)) {
                            topChoice = topParent;
                        }
                        if (bottomChoice == null && (bottomParent = this.tree.getParent(bottomParent)) != null && this.tree.isChoiceNode(bottomParent)) {
                            bottomChoice = bottomParent;
                        }
                        if (topChoice != null && bottomChoice != null) {
                            result = topChoice.equals(bottomChoice);
                            keepGoing = false;
                        }
                        if (topParent != null && bottomParent != null) continue;
                        keepGoing = false;
                    }
                }
            }
        }
        return result;
    }

    public void mergeMappingClasses(MappingClass upperMappingClass, MappingClass lowerMappingClass, boolean removeDuplicates) throws ModelerCoreException {
        this.setGeneratingMappingClasses(true);
        List upperLocations = this.mapping.getMappingClassOutputLocations(upperMappingClass);
        ArrayList lowerLocations = new ArrayList(this.mapping.getMappingClassOutputLocations(lowerMappingClass));
        boolean keepLooking = true;
        Iterator topIter = upperLocations.iterator();
        while (keepLooking && topIter.hasNext()) {
            EObject topLocation = (EObject)topIter.next();
            Iterator bottomIter = lowerLocations.iterator();
            while (keepLooking && bottomIter.hasNext()) {
                EObject bottomLocation = (EObject)bottomIter.next();
                if (!this.tree.isAncestorOf(topLocation, bottomLocation)) continue;
                keepLooking = false;
            }
        }
        if (keepLooking) {
            for (EObject location : lowerLocations) {
                this.mapping.addMappingClassLocation(upperMappingClass, location);
                this.mapping.removeMappingClassLocation(lowerMappingClass, location);
            }
        }
        EList bottomAttributes = lowerMappingClass.getColumns();
        ArrayList copyOfChildren = new ArrayList(bottomAttributes);
        Iterator iter = copyOfChildren.iterator();
        MappingClassColumn nextAttribute = null;
        MappingClassColumn duplicateAttribute = null;
        while (iter.hasNext()) {
            Iterator locIter;
            nextAttribute = (MappingClassColumn)iter.next();
            List locations = this.mapping.getMappingClassColumnOutputLocations(nextAttribute);
            duplicateAttribute = this.getDuplicateAttributeMO(upperMappingClass, nextAttribute);
            if (duplicateAttribute != null && !removeDuplicates) {
                EList existingColumns = upperMappingClass.getColumns();
                HashMap<String, String> existingNames = new HashMap<String, String>(existingColumns.size() + 2);
                Iterator nameIter = existingColumns.iterator();
                while (nameIter.hasNext()) {
                    String theName = ((MappingClassColumn)nameIter.next()).getName();
                    existingNames.put(theName, theName);
                }
                if (duplicateAttribute.getName().equals(nextAttribute.getName())) {
                    String dupeName = this.generateAttributeName(duplicateAttribute.getName(), existingNames, (EObject)duplicateAttribute);
                    List dupeLocations = this.mapping.getMappingClassColumnOutputLocations(duplicateAttribute);
                    if (!dupeLocations.isEmpty()) {
                        dupeName = this.generateAttributeName(duplicateAttribute.getName(), existingNames, (EObject)dupeLocations.get(0));
                    }
                    ModelerCore.getModelEditor().rename((EObject)duplicateAttribute, dupeName);
                    existingNames.put(dupeName, dupeName);
                }
                String newName = this.generateAttributeName(nextAttribute.getName(), existingNames, (EObject)nextAttribute);
                if (!locations.isEmpty()) {
                    newName = this.generateAttributeName(nextAttribute.getName(), existingNames, (EObject)locations.get(0));
                }
                ModelerCore.getModelEditor().rename((EObject)nextAttribute, newName);
            }
            if (!removeDuplicates) {
                ModelerCore.getModelEditor().move((Object)upperMappingClass, (EObject)nextAttribute);
                locIter = locations.iterator();
                while (locIter.hasNext()) {
                    this.mapping.addMappingClassColumnLocation(nextAttribute, (EObject)locIter.next());
                }
                continue;
            }
            if (duplicateAttribute != null) continue;
            ModelerCore.getModelEditor().move((Object)upperMappingClass, (EObject)nextAttribute);
            locIter = locations.iterator();
            while (locIter.hasNext()) {
                this.mapping.addMappingClassColumnLocation(nextAttribute, (EObject)locIter.next());
            }
        }
        ModelContents modelContents = ModelerCore.getModelEditor().getModelContents((EObject)lowerMappingClass);
        if (modelContents != null) {
            List allDiagrams;
            List allTransforms = modelContents.getTransformations((EObject)lowerMappingClass);
            if (allTransforms != null && !allTransforms.isEmpty()) {
                Iterator tIter = allTransforms.iterator();
                while (tIter.hasNext()) {
                    ModelerCore.getModelEditor().delete((EObject)tIter.next(), true, false);
                }
            }
            if ((allDiagrams = modelContents.getDiagrams((EObject)lowerMappingClass)) != null && !allDiagrams.isEmpty()) {
                Iterator dIter = allDiagrams.iterator();
                while (dIter.hasNext()) {
                    ModelerCore.getModelEditor().delete((EObject)dIter.next(), true, false);
                }
            }
            this.clearDiagramRefs((EObject)lowerMappingClass);
        }
        this.mapping.deleteMappingClass(lowerMappingClass);
        this.setGeneratingMappingClasses(false);
    }

    protected void clearDiagramRefs(EObject eObj) {
        ModelContents modelContents;
        if (eObj != null && (modelContents = ModelerCore.getModelEditor().getModelContents(eObj)) != null && modelContents.getDiagramContainer(false) != null) {
            DiagramContainer cntr = modelContents.getDiagramContainer(false);
            try {
                ClearEObjectReferences visitor = new ClearEObjectReferences(eObj);
                ModelVisitorProcessor processor = new ModelVisitorProcessor((ModelVisitor)visitor);
                processor.walk((EObject)cntr, 2);
                for (EObject affectedObj : visitor.getAffectedObjects()) {
                    if (!(affectedObj instanceof DiagramEntity) || ((DiagramEntity)affectedObj).getModelObject() != null) continue;
                    Diagram diagram = ((DiagramEntity)affectedObj).getDiagram();
                    diagram.getDiagramEntity().remove((Object)affectedObj);
                }
            }
            catch (ModelerCoreException err) {
                PluginConstants.Util.log((Throwable)err);
            }
        }
    }

    public boolean canSplitMappingClass(MappingClass theMappingClass, MappingClassBuilderStrategy strategy) {
        EObject location;
        boolean result = false;
        List locations = this.mapping.getMappingClassOutputLocations(theMappingClass);
        if (locations.size() > 1) {
            result = true;
        } else if (!locations.isEmpty() && (location = (EObject)locations.get(0)) != null) {
            Map mappingClassMap = strategy.buildMappingClassMap(location, this.tree, this.mapper);
            for (EObject docNode : mappingClassMap.keySet()) {
                if (!this.shouldContainMappingClass(docNode) || this.mapping.getMappingClass(docNode) != null) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public void splitMappingClass(MappingClass mappingClass, MappingClassBuilderStrategy strategy, boolean moveAttributes) {
        Map mappingClassMap = strategy.buildMappingClassMap(this.tree.getTreeRoot(), this.tree, this.mapper);
        ArrayList docNodes = new ArrayList(this.mapping.getMappingClassOutputLocations(mappingClass));
        if (docNodes.size() > 1) {
            Iterator docIter = docNodes.iterator();
            EObject remainingNode = (EObject)docIter.next();
            while (docIter.hasNext()) {
                EObject docNode = (EObject)docIter.next();
                MappingClass newClass = this.createMappingClass(docNode, false, false);
                Collection nodesToMap = (Collection)mappingClassMap.get(docNode);
                if (nodesToMap == null || nodesToMap.isEmpty()) continue;
                this.moveOrCreateMappingClassColumns(newClass, nodesToMap, new HashMap(), false, new HashSet());
            }
            ArrayList locationsToRemove = new ArrayList(docNodes);
            locationsToRemove.remove(remainingNode);
            Iterator removeIter = locationsToRemove.iterator();
            while (removeIter.hasNext()) {
                this.mapping.removeMappingClassLocation(mappingClass, (EObject)removeIter.next());
            }
        } else {
            List referencedNodes = this.mapping.getMappingClassOutputLocations(mappingClass);
            EObject documentNode = (EObject)referencedNodes.get(0);
            MappingClassSplitterVisitor visitor = new MappingClassSplitterVisitor(mappingClass, this.mapping, this.mapper, this, mappingClassMap);
            MappableTreeIterator nodeIter = new MappableTreeIterator(this.tree, documentNode);
            while (nodeIter.hasNext()) {
                visitor.visit((EObject)nodeIter.next());
            }
        }
    }

    public boolean canAddLocation(MappingClassColumn column, EObject location) {
        boolean result = false;
        if (ModelMapperFactory.isXmlTreeNode(location)) {
            MappingClass mc;
            List mcLocations;
            boolean bl = result = !this.mapping.getMappingClassColumnOutputLocations(column).contains(location);
            if (result && !(mcLocations = this.mapping.getMappingClassOutputLocations(mc = column.getMappingClass())).contains(location)) {
                Iterator locIter = mcLocations.iterator();
                while (locIter.hasNext()) {
                    if (!this.tree.isAncestorOf((EObject)locIter.next(), location)) continue;
                    result = true;
                    break;
                }
            }
            if (result) {
                result = this.mapping.getMappingClassColumn(location) == null;
            }
        }
        return result;
    }

    public void addLocation(MappingClassColumn column, EObject location) {
        this.mapping.addMappingClassColumnLocation(column, location);
    }

    public boolean canRemoveLocation(MappingClassColumn column, EObject location) {
        return this.mapping.getMappingClassColumnOutputLocations(column).contains(location);
    }

    public void removeLocation(MappingClassColumn column, EObject location) {
        this.mapping.removeMappingClassColumnLocation(column, location);
    }

    public MappingClassSet getMappingClassSet() {
        if (this.mappingClassSet == null) {
            this.mappingClassSet = ModelResourceContainerFactory.getMappingClassSet((EObject)this.treeRoot, (boolean)true);
        }
        return this.mappingClassSet;
    }

    public boolean canGenerateMappingClasses() {
        boolean canGenerate = true;
        if (this.getMappingClassSet() == null || !this.getMappingClassSet().eContents().isEmpty()) {
            canGenerate = false;
        }
        return canGenerate;
    }

    public EObject getTreeRoot() {
        return this.treeRoot;
    }

    String convertLocationNameToMappingClassName(EObject node) {
        String newName = this.getName(node);
        String possibleName = null;
        if (this.mapper.isContainerNode(node)) {
            Collection children = this.tree.getChildren(node);
            if (children.size() == 1) {
                EObject child = (EObject)children.iterator().next();
                newName = this.getName(child);
            } else {
                EObject parent = this.tree.getParent(node);
                if (parent != null && this.tree.getTreeRoot() != parent) {
                    newName = this.getName(parent);
                    possibleName = String.valueOf(this.getName(parent)) + '_' + this.getName(node);
                }
            }
        }
        if (this.mapping.containsMappingClassWithName(newName) && possibleName != null) {
            newName = possibleName;
        }
        String result = newName;
        int suffix = 0;
        boolean tryAgain = true;
        while (tryAgain) {
            if (this.mapping.containsMappingClassWithName(result)) {
                result = String.valueOf(newName) + ++suffix;
                continue;
            }
            tryAgain = false;
        }
        return result;
    }

    String convertLocationNameToStagingTableName(EObject node) {
        String newName = "ST_" + this.getName(node);
        List existingStagingTables = this.mapping.getAllStagingTables();
        ArrayList<String> names = new ArrayList<String>(existingStagingTables.size());
        Iterator iter = existingStagingTables.iterator();
        while (iter.hasNext()) {
            names.add(((StagingTable)iter.next()).getName());
        }
        String result = newName;
        int suffix = 0;
        boolean tryAgain = true;
        while (tryAgain) {
            if (names.contains(result)) {
                result = String.valueOf(newName) + ++suffix;
                continue;
            }
            tryAgain = false;
        }
        return result;
    }

    void moveOrCreateMappingClassColumns(MappingClass mappingClass, Collection documentNodeList, Map nameMappingClassColumnMap, boolean initialBuild, Set datatypeAccumulator) {
        HashMap<String, String> mcColumnNameMap = new HashMap<String, String>(documentNodeList.size());
        for (EObject nodeToMap : documentNodeList) {
            boolean createMappingClassColumn = true;
            MappingClassColumn mcColumn = null;
            if (!initialBuild) {
                mcColumn = this.mapping.getMappingClassColumn(nodeToMap);
            }
            if (mcColumn != null) {
                ArrayList locations = new ArrayList(this.mapping.getMappingClassColumnOutputLocations(mcColumn));
                if (locations.size() > 1) {
                    this.mapping.removeMappingClassColumnLocation(mcColumn, nodeToMap);
                } else {
                    String mcColumnName = mcColumn.getName();
                    if (!this.mappingClassContainsAttribute(mappingClass, mcColumn)) {
                        try {
                            this.mapping.removeMappingClassColumnLocation(mcColumn, nodeToMap);
                            ModelerCore.getModelEditor().move((Object)mappingClass, (EObject)mcColumn);
                            this.mapping.addMappingClassColumnLocation(mcColumn, nodeToMap);
                            createMappingClassColumn = false;
                            nameMappingClassColumnMap.put(mcColumnName, mcColumn);
                            mcColumnNameMap.put(mcColumnName, mcColumnName);
                        }
                        catch (Exception e) {
                            PluginConstants.Util.log((Throwable)e);
                        }
                    } else {
                        if (nameMappingClassColumnMap.get(mcColumnName) != null) {
                            nameMappingClassColumnMap.put(mcColumnName, mcColumn);
                            mcColumnNameMap.put(mcColumnName, mcColumnName);
                        }
                        createMappingClassColumn = false;
                    }
                }
            }
            if (!createMappingClassColumn) continue;
            MappingClassColumn existingMappingClassColumn = null;
            try {
                boolean createNewMappingClassColumn = true;
                String proposedNewMappingClassColumnName = this.getName(nodeToMap);
                for (Map.Entry entry : nameMappingClassColumnMap.entrySet()) {
                    if (!proposedNewMappingClassColumnName.equalsIgnoreCase((String)entry.getKey())) continue;
                    existingMappingClassColumn = (MappingClassColumn)nameMappingClassColumnMap.get(proposedNewMappingClassColumnName);
                    if (this.areDataTypesEquivalent(nodeToMap, existingMappingClassColumn)) {
                        createNewMappingClassColumn = false;
                        break;
                    }
                    proposedNewMappingClassColumnName = this.generateAttributeName(proposedNewMappingClassColumnName, mcColumnNameMap, nodeToMap);
                    break;
                }
                MappingClassColumn newMappingClassColumn = null;
                if (createNewMappingClassColumn) {
                    newMappingClassColumn = this.metamodelFactory.createMappingClassColumn();
                    newMappingClassColumn.setName(proposedNewMappingClassColumnName);
                    newMappingClassColumn.setMappingClass(mappingClass);
                    EObject datatype = this.tree.getDatatype(nodeToMap);
                    if (datatype != null) {
                        newMappingClassColumn.setType(datatype);
                        datatypeAccumulator.add(datatype);
                    }
                    nameMappingClassColumnMap.put(proposedNewMappingClassColumnName, newMappingClassColumn);
                    mcColumnNameMap.put(proposedNewMappingClassColumnName, proposedNewMappingClassColumnName);
                }
                this.mapping.addMappingClassColumnLocation(newMappingClassColumn, nodeToMap);
            }
            catch (Exception e) {
                PluginConstants.Util.log((Throwable)e);
            }
        }
    }

    private boolean mappingClassContainsAttribute(MappingClass mappingClass, MappingClassColumn mappingClassColumn) {
        boolean result = false;
        if (mappingClass.getColumns() != null && !mappingClass.getColumns().isEmpty()) {
            Iterator iter = mappingClass.getColumns().iterator();
            MappingClassColumn nextColumn = null;
            while (iter.hasNext() && !result) {
                nextColumn = (MappingClassColumn)iter.next();
                if (nextColumn != mappingClassColumn) continue;
                result = true;
            }
        }
        return result;
    }

    String getName(EObject node) {
        if (this.emfAdapter == null) {
            this.emfAdapter = ModelerCore.getMetamodelRegistry().getAdapterFactory();
        }
        IItemLabelProvider provider = (IItemLabelProvider)this.emfAdapter.adapt((Notifier)node, IItemLabelProvider.class);
        return provider.getText((Object)node);
    }

    private boolean shouldContainMappingClass(EObject node) {
        boolean result = false;
        if (this.mapper.allowsMappingClass(node)) {
            if (this.mapper.canIterate(node)) {
                result = true;
            } else if (this.mapper.isRecursive(node)) {
                result = true;
            }
        }
        return result;
    }

    private boolean areDataTypesEquivalent(EObject documentNode, MappingClassColumn mappingAttribute) {
        return false;
    }

    private String generateAttributeName(String duplicateName, HashMap existingNames, EObject node) {
        String baseName;
        int count = 0;
        String result = baseName = this.mapper.getMappableTree().getUniqueName(node);
        while (existingNames.get(result) != null) {
            result = String.valueOf(baseName) + ++count;
        }
        return result;
    }

    private MappingClassColumn getDuplicateAttributeMO(MappingClass topMappingClass, MappingClassColumn proposedColumn) {
        EList topAttributes = topMappingClass.getColumns();
        if (topAttributes == null || topAttributes.isEmpty()) {
            return null;
        }
        MappingClassColumn nextColumn2 = null;
        for (MappingClassColumn nextColumn2 : topAttributes) {
            if (!nextColumn2.getName().equalsIgnoreCase(proposedColumn.getName())) continue;
            return nextColumn2;
        }
        return null;
    }

    private List gatherExtentNodes(EObject locationNode, Collection columnLocations, Collection mappingClassLocations) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject node : this.mapper.getMappableTree().getChildren(locationNode)) {
            if (columnLocations.contains(node)) {
                result.add(node);
                result.addAll(this.gatherExtentNodes(node, columnLocations, mappingClassLocations));
                continue;
            }
            if (mappingClassLocations.contains(node)) continue;
            result.add(node);
            result.addAll(this.gatherExtentNodes(node, columnLocations, mappingClassLocations));
        }
        return result;
    }

    public EObject findXmlDocumentTreeNode(String treeNodeName) {
        XmlDocumentNodeFinderVisitor visitor = new XmlDocumentNodeFinderVisitor(treeNodeName);
        MappableTreeIterator nodeIter = new MappableTreeIterator(this.tree);
        if (nodeIter.hasNext()) {
            nodeIter.next();
        }
        while (nodeIter.hasNext() && visitor.keepSearching()) {
            visitor.visit((EObject)nodeIter.next());
        }
        return visitor.getTreeNode();
    }

    class XmlDocumentNodeFinderVisitor {
        EObject treeNode;
        String treeNodeName;

        public XmlDocumentNodeFinderVisitor(String name) {
            this.treeNodeName = name;
        }

        public void visit(EObject eObject) {
            String eObjectName;
            if (this.treeNode == null && this.treeNodeName.equalsIgnoreCase(eObjectName = MappingClassFactory.this.getName(eObject))) {
                this.treeNode = eObject;
            }
        }

        public boolean keepSearching() {
            return this.treeNode == null;
        }

        public EObject getTreeNode() {
            return this.treeNode;
        }
    }
}

