/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.factory;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.mapping.PluginConstants;
import org.teiid.designer.mapping.factory.ITreeToRelationalMapper;
import org.teiid.designer.metamodels.core.ModelAnnotation;

public class ModelMapperFactory
implements PluginConstants,
PluginConstants.ExtensionPoints.ModelMapper {
    private static final Class CLASS = ModelMapperFactory.class;
    private static final String PREFIX = I18nUtil.getPropertyPrefix((Class)CLASS);
    private static Map uriConfigElementMap;
    private static Map uriMapperMap;

    static {
        ModelMapperFactory.buildMapperMaps();
    }

    private ModelMapperFactory() {
    }

    private static void buildMapperMaps() {
        uriConfigElementMap = new HashMap();
        uriMapperMap = new HashMap();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.teiid.designer.mapping", "modelMapper");
        IExtension[] extensions = extensionPoint.getExtensions();
        if (extensions.length > 0) {
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                Object extension = null;
                String metamodelUri = null;
                int j = 0;
                while (j < elements.length) {
                    try {
                        extension = elements[j].createExecutableExtension("name");
                        if (extension instanceof ITreeToRelationalMapper) {
                            metamodelUri = elements[j].getAttribute("metamodelUri");
                            if (metamodelUri != null && metamodelUri.length() > 0) {
                                uriMapperMap.put(metamodelUri, extension);
                                uriConfigElementMap.put(metamodelUri, elements[j]);
                            } else {
                                Util.log(4, Util.getString(String.valueOf(PREFIX) + "invalidModelId", new Object[]{extension.getClass().getName()}));
                            }
                        } else {
                            Util.log(4, Util.getString(String.valueOf(PREFIX) + "invalidMapperClass", new Object[]{extension.getClass().getName()}));
                        }
                    }
                    catch (Exception theException) {
                        Util.log(4, (Throwable)theException, Util.getString(String.valueOf(PREFIX) + "loadingMapperProblem", new Object[]{elements[j].getAttribute("name")}));
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public static ITreeToRelationalMapper createModelMapper(String theMetamodelUri) {
        CoreArgCheck.isNotNull((Object)theMetamodelUri);
        CoreArgCheck.isNotEmpty((String)theMetamodelUri);
        ITreeToRelationalMapper result = null;
        IConfigurationElement configElement = (IConfigurationElement)uriConfigElementMap.get(theMetamodelUri);
        if (configElement != null) {
            try {
                result = (ITreeToRelationalMapper)configElement.createExecutableExtension("name");
            }
            catch (CoreException coreException) {
                Util.log(4, Util.getString(String.valueOf(PREFIX) + "createMapperProblem", new Object[]{theMetamodelUri, configElement.getAttribute("name")}));
            }
        }
        return result;
    }

    public static ITreeToRelationalMapper createModelMapper(EObject theTreeNode) {
        CoreArgCheck.isNotNull((Object)theTreeNode);
        ITreeToRelationalMapper result = null;
        String uri = ModelMapperFactory.getMetamodelUri(theTreeNode);
        if (uri != null) {
            result = ModelMapperFactory.createModelMapper(uri);
        }
        if (result != null) {
            result.setTreeRoot(theTreeNode);
        }
        return result;
    }

    private static String getMetamodelUri(EObject theTreeNode) {
        ModelAnnotation annot;
        Resource eResource;
        CoreArgCheck.isNotNull((Object)theTreeNode);
        Container container = ModelerCore.getContainer((EObject)theTreeNode);
        if (container == null) {
            try {
                container = ModelerCore.getModelContainer();
            }
            catch (CoreException err) {
                ModelerCore.Util.log((Throwable)err);
            }
        }
        if ((eResource = ModelerCore.getModelEditor().findResource(container, theTreeNode)) instanceof EmfResource && (annot = ((EmfResource)eResource).getModelAnnotation()) != null && annot.getPrimaryMetamodelUri() != null) {
            return annot.getPrimaryMetamodelUri();
        }
        return null;
    }

    public static boolean isTreeRoot(EObject theTreeNode) {
        CoreArgCheck.isNotNull((Object)theTreeNode);
        boolean result = false;
        String uri = ModelMapperFactory.getMetamodelUri(theTreeNode);
        if (uri != null) {
            ITreeToRelationalMapper mapper = (ITreeToRelationalMapper)uriMapperMap.get(uri);
            if (mapper == null) {
                if (!uriMapperMap.containsKey(uri)) {
                    uriMapperMap.put(uri, null);
                }
            } else {
                result = mapper.isTreeRoot(theTreeNode);
            }
        }
        return result;
    }

    public static boolean isXmlTreeNode(EObject theTreeNode) {
        CoreArgCheck.isNotNull((Object)theTreeNode);
        boolean result = false;
        String uri = theTreeNode.eClass().getEPackage().getNsURI();
        ITreeToRelationalMapper mapper = (ITreeToRelationalMapper)uriMapperMap.get(uri);
        if (mapper != null) {
            result = mapper.isTreeNode(theTreeNode);
        }
        return result;
    }

    public static EObject getTreeRoot(EObject someTreeNode) {
        EObject treeRoot = null;
        if (ModelMapperFactory.isTreeRoot(someTreeNode)) {
            treeRoot = someTreeNode;
        } else if (someTreeNode.eContainer() != null) {
            EObject parent = someTreeNode.eContainer();
            boolean failure = false;
            while (treeRoot == null && !failure) {
                if (ModelMapperFactory.isTreeRoot(parent)) {
                    treeRoot = parent;
                    continue;
                }
                if (parent.eContainer() != null) {
                    parent = parent.eContainer();
                    continue;
                }
                failure = true;
            }
        }
        return treeRoot;
    }

    public static EObject getXsdComponent(EObject theTreeNode) {
        CoreArgCheck.isNotNull((Object)theTreeNode);
        EObject result = null;
        String uri = theTreeNode.eClass().getEPackage().getNsURI();
        ITreeToRelationalMapper mapper = (ITreeToRelationalMapper)uriMapperMap.get(uri);
        if (mapper != null) {
            result = mapper.getXsdComponent(theTreeNode);
        }
        return result;
    }
}

