/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.util.ModelResourceContainerFactory;
import org.teiid.designer.mapping.PluginConstants;
import org.teiid.designer.mapping.factory.DefaultMappableTree;
import org.teiid.designer.mapping.factory.FragmentMappingAdapter;
import org.teiid.designer.mapping.factory.IMappableTree;
import org.teiid.designer.mapping.factory.TreeMappingClassLocator;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.MappingClassColumn;
import org.teiid.designer.metamodels.transformation.StagingTable;
import org.teiid.designer.metamodels.transformation.TransformationMappingRoot;
import org.teiid.designer.metamodels.transformation.TreeMappingRoot;

public class TreeMappingAdapter
implements PluginConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(TreeMappingAdapter.class);
    private EObject root;
    private TreeMappingClassLocator mappingLocator;
    private boolean generatingMappingClasses = false;

    public TreeMappingAdapter(EObject theTreeRoot) {
        CoreArgCheck.isNotNull((Object)theTreeRoot);
        this.mappingLocator = new TreeMappingClassLocator(theTreeRoot);
        this.root = theTreeRoot;
        this.mappingLocator.loadTreeNodesToMappingClassScopeMap();
    }

    public boolean isGeneratingMappingClasses() {
        return this.generatingMappingClasses;
    }

    public void setGeneratingMappingClasses(boolean isGenerating) {
        this.generatingMappingClasses = isGenerating;
        this.mappingLocator.setGeneratingMappingClasses(isGenerating);
    }

    public void addMappingClassAtLocation(EObject treeMappingRoot, MappingClass theMappingClass, EObject location) {
        this.mappingLocator.addMappingClassAtLocation(treeMappingRoot, theMappingClass, location);
    }

    public List getAllMappingClassLocations() {
        return new ArrayList(this.mappingLocator.getAllMappingClassLocations());
    }

    public void addStagingTableAtLocation(EObject treeMappingRoot, StagingTable theStagingTable, EObject location) {
        this.mappingLocator.addMappingClassAtLocation(treeMappingRoot, (MappingClass)theStagingTable, location);
    }

    public boolean containsMappingClassWithName(String someName) {
        return this.mappingLocator.containsMappingClassWithName(someName);
    }

    public void addMappingClassLocation(MappingClass theMappingClass, EObject theTreeNode) {
        CoreArgCheck.isNotNull((Object)theMappingClass);
        CoreArgCheck.isNotNull((Object)theTreeNode);
        if (!this.mappingLocator.containsLocation((EObject)theMappingClass, theTreeNode)) {
            try {
                TreeMappingRoot treeMappingRoot = (TreeMappingRoot)this.mappingLocator.getMappingRoot(theMappingClass);
                this.mappingLocator.addOutputLocation(theMappingClass, theTreeNode);
                this.addMappingClassAtLocation((EObject)treeMappingRoot, theMappingClass, theTreeNode);
            }
            catch (Exception e) {
                PluginConstants.Util.log(4, (Throwable)e, e.getMessage());
            }
        }
    }

    public void addMappingClassColumnLocation(MappingClassColumn theMappingColumn, EObject theTreeNode) {
        CoreArgCheck.isNotNull((Object)theMappingColumn);
        CoreArgCheck.isNotNull((Object)theTreeNode);
        this.mappingLocator.addMappingClassColumnLocation(theMappingColumn, theTreeNode);
    }

    public EObject createTreeMappingRoot(MappingClass theMappingClass) {
        CoreArgCheck.isNotNull((Object)theMappingClass);
        if (this.mappingLocator.hasTreeRoot(theMappingClass)) {
            return this.mappingLocator.getMappingRoot(theMappingClass);
        }
        TreeMappingRoot newRoot = null;
        try {
            newRoot = ModelResourceContainerFactory.createNewTreeMappingRoot((EObject)this.root, (Resource)this.root.eResource());
            ModelerCore.getModelEditor().addValue((Object)newRoot, (Object)theMappingClass, newRoot.getInputs());
        }
        catch (Exception theException) {
            Util.log(4, (Throwable)theException, Util.getString(String.valueOf(PREFIX) + "createMappingRootProblem", new Object[]{this.root, theMappingClass}));
        }
        return newRoot;
    }

    public List getAllMappingClasses() {
        List returnList = Collections.unmodifiableList(this.mappingLocator.getMappingClasses());
        return returnList;
    }

    public List getAllStagingTables() {
        return Collections.unmodifiableList(this.mappingLocator.getStagingTables());
    }

    public FragmentMappingAdapter getFragmentMappingAdapter() {
        return this.mappingLocator.getFragmentAdapter();
    }

    public EObject getStagingTableOutputLocation(StagingTable theStagingTable) {
        return this.mappingLocator.getStagingTableLocation((EObject)theStagingTable);
    }

    public List getMappingClassOutputLocations(MappingClass theMappingClass) {
        List resultsList = Collections.unmodifiableList(this.mappingLocator.getMappingClassLocations((EObject)theMappingClass));
        return resultsList;
    }

    public List getMappingClassColumnOutputLocations(MappingClassColumn theMappingColumn) {
        return this.mappingLocator.getMappingClassColumnOutputLocations(theMappingColumn);
    }

    public StagingTable getStagingTable(EObject theTreeNode) {
        CoreArgCheck.isNotNull((Object)theTreeNode);
        return (StagingTable)this.mappingLocator.getStagingTable(theTreeNode);
    }

    public EObject getMappingClassLocation(MappingClass theMappingClass) {
        CoreArgCheck.isNotNull((Object)theMappingClass);
        List locations = this.mappingLocator.getMappingClassLocations((EObject)theMappingClass);
        EObject location = null;
        if (!locations.isEmpty()) {
            location = (EObject)locations.get(0);
        }
        return location;
    }

    public MappingClass getMappingClass(EObject theTreeNode) {
        CoreArgCheck.isNotNull((Object)theTreeNode);
        return (MappingClass)this.mappingLocator.getMappingClass(theTreeNode);
    }

    public MappingClassColumn getMappingClassColumn(EObject theTreeNode, MappingClass theMappingClass) {
        CoreArgCheck.isNotNull((Object)theTreeNode);
        MappingClassColumn result = this.mappingLocator.getMappingClassColumn(theTreeNode, theMappingClass);
        return result;
    }

    public MappingClass getMappingClassForTreeNode(EObject theTreeNode) {
        return this.mappingLocator.getMappingClassForTreeNode(theTreeNode);
    }

    public List getTreeNodesInAMappingClassScope(MappingClass theMappingClass) {
        List extentNodes = this.mappingLocator.getTreeNodesInAMappingClassScope(theMappingClass);
        return extentNodes;
    }

    public List getColumnLocations(MappingClass theMappingClass) {
        return this.mappingLocator.getColumnLocations(theMappingClass);
    }

    public MappingClassColumn getMappingClassColumn(EObject theTreeNode) {
        CoreArgCheck.isNotNull((Object)theTreeNode);
        MappingClassColumn result = this.mappingLocator.getMappingClassColumn(theTreeNode);
        return result;
    }

    public boolean isMapped(EObject theTreeNode) {
        CoreArgCheck.isNotNull((Object)theTreeNode);
        return this.getMappingClassColumn(theTreeNode) != null;
    }

    public StagingTable getStagingTableForRootTreeNode(EObject theTreeNode) {
        return (StagingTable)this.mappingLocator.getStagingTable(theTreeNode);
    }

    public void removeMappingClassLocation(MappingClass theMappingClass, EObject theTreeNode) {
        CoreArgCheck.isNotNull((Object)theMappingClass);
        CoreArgCheck.isNotNull((Object)theTreeNode);
        try {
            this.mappingLocator.removeOutputLocation(theMappingClass, theTreeNode);
        }
        catch (Exception e) {
            Util.log(4, (Throwable)e, Util.getString(String.valueOf(PREFIX) + "removeLocationTreeNodeNotFound", new Object[]{theTreeNode, "MappingClass", theMappingClass}));
        }
    }

    public void deleteMappingClass(MappingClass theMappingClass) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)theMappingClass);
        this.mappingLocator.deleteMappingClass((EObject)theMappingClass);
    }

    public void removeMappingClassColumnLocation(MappingClassColumn theMappingColumn, EObject theTreeNode) {
        CoreArgCheck.isNotNull((Object)theMappingColumn);
        CoreArgCheck.isNotNull((Object)theTreeNode);
        this.mappingLocator.removeMappingClassColumnLocation(theMappingColumn, theTreeNode);
    }

    public List getParentMappingClasses(MappingClass theMappingClass, EObject docRoot, boolean includeStagingTables) {
        return this.getParentMappingClasses(theMappingClass, new DefaultMappableTree(docRoot), includeStagingTables);
    }

    public List getParentMappingClasses(MappingClass theMappingClass, IMappableTree theMappableTree, boolean includeStagingTables) {
        ArrayList<MappingClass> result = new ArrayList<MappingClass>();
        ArrayList<EObject> locations = null;
        if (theMappingClass instanceof StagingTable) {
            locations = new ArrayList<EObject>();
            locations.add(this.getStagingTableOutputLocation((StagingTable)theMappingClass));
        } else {
            locations = new ArrayList();
            locations.addAll(this.getMappingClassOutputLocations(theMappingClass));
        }
        List mappingClasses = this.getAllMappingClasses();
        block0: for (MappingClass mc : mappingClasses) {
            if (mc == null || mc.equals(theMappingClass)) continue;
            Iterator testLocIter = this.getMappingClassOutputLocations(mc).iterator();
            while (testLocIter.hasNext() && locations.size() != 0) {
                EObject possibleLoc = (EObject)testLocIter.next();
                int i = 0;
                while (i < locations.size()) {
                    if (theMappableTree.isAncestorOf(possibleLoc, (EObject)locations.get(i))) {
                        result.add(mc);
                        continue block0;
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    public EObject getDocument() {
        EObject firstRoot;
        List mappingRoots = this.mappingLocator.getMappingRoots();
        if (mappingRoots != null && !mappingRoots.isEmpty() && (firstRoot = (EObject)mappingRoots.get(0)) != null && firstRoot instanceof TransformationMappingRoot) {
            return ((TransformationMappingRoot)firstRoot).getTarget();
        }
        return null;
    }
}

