/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.factory;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingRoot;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.util.ListAndMapUtil;
import org.teiid.designer.mapping.PluginConstants;
import org.teiid.designer.mapping.factory.MappingList;
import org.teiid.designer.mapping.factory.TreeMappingAdapter;
import org.teiid.designer.mapping.factory.TreeMappingClassLocator;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.MappingClassColumn;

public class TreeMappingClassColumnLocator
implements PluginConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(TreeMappingAdapter.class);
    private TreeMappingClassLocator mappingClassLocator;
    private HashMap treeNodesToMappingClassColumnsMap = new HashMap();

    public TreeMappingClassColumnLocator(TreeMappingClassLocator mappingClassLocator) {
        this.mappingClassLocator = mappingClassLocator;
    }

    public void addMappingClassColumnLocation(MappingClassColumn theMappingColumn, EObject theTreeNode) {
        CoreArgCheck.isNotNull((Object)theMappingColumn);
        CoreArgCheck.isNotNull((Object)theTreeNode);
        MappingList theColumnMappingList = this.getMappingClassColumnMappingList(theMappingColumn);
        if (theColumnMappingList != null) {
            if (!theColumnMappingList.contains(theTreeNode)) {
                try {
                    ModelerCore.getModelEditor().addValue((Object)theColumnMappingList.mapping, (Object)theTreeNode, theColumnMappingList.list);
                    this.treeNodesToMappingClassColumnsMap.put(theTreeNode, theMappingColumn);
                }
                catch (Exception e) {
                    PluginConstants.Util.log(4, (Throwable)e, e.getMessage());
                }
            } else {
                Util.log(2, Util.getString(String.valueOf(PREFIX) + "duplicateMapping", new Object[]{"addLocation", "MappingClassColumn", theMappingColumn, theTreeNode}));
            }
        } else {
            Util.log(4, Util.getString(String.valueOf(PREFIX) + "mappingRootsProblem", new Object[]{"addLocation", "MappingClass", theMappingColumn, theTreeNode}));
        }
    }

    public void removeMappingClassColumnLocation(MappingClassColumn theMappingColumn, EObject theTreeNode) {
        CoreArgCheck.isNotNull((Object)theMappingColumn);
        CoreArgCheck.isNotNull((Object)theTreeNode);
        MappingList theColumnMappingList = this.getMappingClassColumnMappingList(theMappingColumn);
        if (theColumnMappingList != null) {
            try {
                ModelerCore.getModelEditor().removeValue((Object)theColumnMappingList.mapping, (Object)theTreeNode, theColumnMappingList.list);
                this.treeNodesToMappingClassColumnsMap.remove(theTreeNode);
            }
            catch (Exception e) {
                Util.log(4, (Throwable)e, Util.getString(String.valueOf(PREFIX) + "removeLocationTreeNodeNotFound", new Object[]{theTreeNode, "MappingClassColumn", theMappingColumn}));
            }
        } else {
            Util.log(4, Util.getString(String.valueOf(PREFIX) + "removeLocationTreeNodeNotFound", new Object[]{theTreeNode, "MappingClassColumn", theMappingColumn}));
        }
    }

    public HashMap getTreeNodesToMappingClassColumnsMap() {
        if (this.treeNodesToMappingClassColumnsMap == null) {
            this.loadTreeNodesToMappingClassColumnsMap();
        }
        return this.treeNodesToMappingClassColumnsMap;
    }

    public void loadTreeNodesToMappingClassColumnsMap() {
        this.treeNodesToMappingClassColumnsMap = this.treeNodesToMappingClassColumnsMap != null ? new HashMap(this.treeNodesToMappingClassColumnsMap.keySet().size()) : new HashMap();
        List mappingClasses = this.mappingClassLocator.getMappingClasses();
        int size = mappingClasses.size();
        int i = 0;
        while (i < size) {
            EList columns;
            MappingClass mappingClass = (MappingClass)mappingClasses.get(i);
            if (mappingClass != null && (columns = mappingClass.getColumns()) != null && !columns.isEmpty()) {
                int numColumns = columns.size();
                int j = 0;
                while (j < numColumns) {
                    MappingClassColumn col = (MappingClassColumn)columns.get(j);
                    List treeNodes = this.getMappingClassColumnOutputLocations(col);
                    for (EObject oTreeNodeTemp : treeNodes) {
                        this.treeNodesToMappingClassColumnsMap.put(oTreeNodeTemp, col);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public MappingList getMappingClassColumnMappingList(MappingClassColumn theMappingColumn) {
        CoreArgCheck.isNotNull((Object)theMappingColumn);
        MappingList result = null;
        MappingClass mappingClass = theMappingColumn.getMappingClass();
        MappingRoot mappingRoot = (MappingRoot)this.mappingClassLocator.getMappingRoot(mappingClass);
        if (mappingRoot != null) {
            EList columnMappings = mappingRoot.getNested();
            if (!columnMappings.isEmpty()) {
                int size = columnMappings.size();
                int i = 0;
                while (i < size) {
                    Mapping mapping = (Mapping)columnMappings.get(i);
                    EList columns = mapping.getInputs();
                    if (columns.size() == 1) {
                        Object column_1 = columns.get(0);
                        if (column_1 != null && column_1 == theMappingColumn) {
                            result = new MappingList(mapping, mapping.getOutputs());
                            break;
                        }
                    } else {
                        HashMap columnsMap = ListAndMapUtil.createMapFromList((List)columns);
                        if (columnsMap.get(theMappingColumn) != null) {
                            result = new MappingList(mapping, mapping.getOutputs());
                            break;
                        }
                    }
                    ++i;
                }
            }
            if (result == null) {
                Mapping newMapping = this.createColumnMapping(mappingRoot, theMappingColumn);
                result = new MappingList(newMapping, newMapping.getOutputs());
            }
        }
        return result;
    }

    public MappingClassColumn getMappingClassColumn(EObject theTreeNode, MappingClass theMappingClass) {
        CoreArgCheck.isNotNull((Object)theTreeNode);
        MappingClassColumn result = null;
        for (MappingClassColumn column : theMappingClass.getColumns()) {
            MappingList theColumnMappingList = this.getMappingClassColumnMappingList(column);
            if (theColumnMappingList == null) continue;
            if (theColumnMappingList.list.size() == 1) {
                Object mappedNode = theColumnMappingList.list.get(0);
                if (mappedNode == null || mappedNode != theTreeNode) continue;
                result = column;
                break;
            }
            if (!theColumnMappingList.contains(theTreeNode)) continue;
            result = column;
            break;
        }
        return result;
    }

    public MappingClassColumn getMappingClassColumn(EObject theTreeNode) {
        CoreArgCheck.isNotNull((Object)theTreeNode);
        MappingClassColumn result = (MappingClassColumn)this.treeNodesToMappingClassColumnsMap.get(theTreeNode);
        return result;
    }

    public List getMappingClassColumnOutputLocations(MappingClassColumn theMappingColumn) {
        MappingList theColumnMappingList = this.getMappingClassColumnMappingList(theMappingColumn);
        List result = null;
        result = theColumnMappingList == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(theColumnMappingList.list);
        return result;
    }

    private Mapping createColumnMapping(MappingRoot theMappingRoot, MappingClassColumn theMappingColumn) {
        CoreArgCheck.isNotNull((Object)theMappingRoot);
        CoreArgCheck.isNotNull((Object)theMappingColumn);
        Mapping mapping = theMappingRoot.createMapping(Collections.singletonList(theMappingColumn), (Collection)Collections.EMPTY_LIST);
        theMappingRoot.getNested().add((Object)mapping);
        return mapping;
    }
}

