/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mapping.MappingRoot;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.util.ListAndMapUtil;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.mapping.PluginConstants;
import org.teiid.designer.mapping.factory.FragmentMappingAdapter;
import org.teiid.designer.mapping.factory.ITreeToRelationalMapper;
import org.teiid.designer.mapping.factory.MappableTreeIterator;
import org.teiid.designer.mapping.factory.MappingList;
import org.teiid.designer.mapping.factory.ModelMapperFactory;
import org.teiid.designer.mapping.factory.TreeMappingClassColumnLocator;
import org.teiid.designer.mapping.factory.XmlDocumentMappingClassVisitor;
import org.teiid.designer.metamodels.transformation.FragmentMappingRoot;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.MappingClassColumn;
import org.teiid.designer.metamodels.transformation.StagingTable;
import org.teiid.designer.metamodels.transformation.TreeMappingRoot;

public class TreeMappingClassLocator
implements PluginConstants {
    private ModelContents modelContents;
    private EObject root;
    private ITreeToRelationalMapper mapper;
    private FragmentMappingAdapter fragmentAdapter;
    private TreeMappingClassColumnLocator columnMappingLocator;
    private List mappingRoots;
    private List fragmentRoots;
    private HashMap stagingTablesToRootMap = new HashMap();
    private HashMap mappingClassesToRootMap = new HashMap();
    private HashMap locationToMappingClassMap = new HashMap();
    private HashMap locationToStagingTableMap = new HashMap();
    private HashMap stagingTableLocationMap = new HashMap();
    private HashMap mappingClassesNameMap = new HashMap();
    private List mappingClassesArray = Collections.EMPTY_LIST;
    private List stagingTablesArray = Collections.EMPTY_LIST;
    private HashMap treeNodesToMappingClassScopeMap = new HashMap();
    private boolean hasChanges = false;
    private boolean generatingMappingClasses = false;

    public TreeMappingClassLocator(EObject treeRoot) {
        this.root = treeRoot;
        this.modelContents = ModelerCore.getModelEditor().getModelContents(this.root);
        this.mapper = ModelMapperFactory.createModelMapper(this.root);
        this.columnMappingLocator = new TreeMappingClassColumnLocator(this);
        this.initialize();
    }

    public boolean isGeneratingMappingClasses() {
        return this.generatingMappingClasses;
    }

    public void setGeneratingMappingClasses(boolean isGenerating) {
        boolean finished = false;
        if (this.generatingMappingClasses && !isGenerating) {
            finished = true;
        }
        this.generatingMappingClasses = isGenerating;
        if (finished) {
            this.resetIfChanged();
        }
    }

    public EObject getDocumentTreeRoot() {
        return this.root;
    }

    public ITreeToRelationalMapper getMapper() {
        return this.mapper;
    }

    public FragmentMappingAdapter getFragmentAdapter() {
        return this.fragmentAdapter;
    }

    public List getMappingClasses() {
        this.resetIfChanged();
        return this.mappingClassesArray;
    }

    public EObject getMappingClass(EObject treeNodeLocation) {
        this.resetIfChanged();
        EObject theMappingClass = (EObject)this.locationToMappingClassMap.get(treeNodeLocation);
        return theMappingClass;
    }

    public List getStagingTables() {
        this.resetIfChanged();
        return this.stagingTablesArray;
    }

    public EObject getStagingTable(EObject treeNodeLocation) {
        return (EObject)this.locationToStagingTableMap.get(treeNodeLocation);
    }

    public List getFragmentRoots() {
        return this.fragmentRoots;
    }

    public List getMappingClassLocations(EObject mappingClass) {
        this.resetIfChanged();
        ArrayList<EObject> locations = new ArrayList<EObject>();
        for (EObject nextLoc : this.locationToMappingClassMap.keySet()) {
            EObject nextMC = (EObject)this.locationToMappingClassMap.get(nextLoc);
            if (nextMC != mappingClass) continue;
            locations.add(nextLoc);
        }
        return locations;
    }

    public EObject getStagingTableLocation(EObject stagingTable) {
        this.resetIfChanged();
        return (EObject)this.stagingTableLocationMap.get(stagingTable);
    }

    public boolean hasTreeRoot(MappingClass mappingClass) {
        return this.mappingClassesToRootMap.get(mappingClass) != null;
    }

    public EObject getMappingRoot(MappingClass mappingClass) {
        EObject mappingRoot = null;
        mappingRoot = mappingClass instanceof StagingTable ? (EObject)this.stagingTablesToRootMap.get(mappingClass) : (EObject)this.mappingClassesToRootMap.get(mappingClass);
        return mappingRoot;
    }

    public List getMappingRoots() {
        return this.mappingRoots;
    }

    public List getAllMappingClassLocations() {
        this.resetIfChanged();
        ArrayList result = new ArrayList(this.locationToMappingClassMap.keySet());
        return result;
    }

    public void addMappingClassAtLocation(EObject treeMappingRoot, MappingClass mappingClass, EObject location) {
        this.hasChanges = true;
        if (mappingClass instanceof StagingTable) {
            if (this.stagingTablesToRootMap.get(mappingClass) == null) {
                this.stagingTablesToRootMap.put(mappingClass, treeMappingRoot);
                this.mappingRoots.add(treeMappingRoot);
            }
            this.locationToStagingTableMap.put(location, mappingClass);
            this.stagingTableLocationMap.put(mappingClass, location);
        } else {
            if (this.mappingClassesToRootMap.get(mappingClass) == null) {
                this.mappingClassesToRootMap.put(mappingClass, treeMappingRoot);
                this.mappingRoots.add(treeMappingRoot);
                this.mappingClassesNameMap.put(mappingClass.getName(), mappingClass.getName());
            }
            this.locationToMappingClassMap.put(location, mappingClass);
        }
        this.addOutputLocation(mappingClass, location);
    }

    public void removeMappingClassFromLocation(EObject treeMappingRoot, MappingClass mappingClass, EObject location) {
        this.hasChanges = true;
        if (this.mappingClassesToRootMap.get(mappingClass) != null) {
            this.mappingClassesToRootMap.remove(mappingClass);
            this.mappingRoots.remove(treeMappingRoot);
            this.mappingClassesNameMap.remove(mappingClass.getName());
        }
        this.locationToMappingClassMap.remove(location);
        this.removeOutputLocation(mappingClass, location);
    }

    public boolean containsLocation(EObject mappingClass, EObject location) {
        EObject cachedMC;
        EObject cachedST;
        this.resetIfChanged();
        boolean result = false;
        result = mappingClass instanceof StagingTable ? (cachedST = (EObject)this.locationToStagingTableMap.get(location)) != null && cachedST == mappingClass : (cachedMC = (EObject)this.locationToMappingClassMap.get(location)) != null && cachedMC == mappingClass;
        return result;
    }

    public boolean containsMappingClassWithName(String someName) {
        return this.mappingClassesNameMap.get(someName) != null;
    }

    public boolean addOutputLocation(MappingClass theMappingClass, EObject theTreeNode) {
        boolean result = false;
        try {
            TreeMappingRoot treeMappingRoot = (TreeMappingRoot)this.getMappingRoot(theMappingClass);
            if (!treeMappingRoot.getOutputs().contains((Object)theTreeNode)) {
                ModelerCore.getModelEditor().addValue((Object)treeMappingRoot, (Object)theTreeNode, treeMappingRoot.getOutputs());
                this.hasChanges = true;
            }
        }
        catch (Exception e) {
            PluginConstants.Util.log(4, (Throwable)e, e.getMessage());
        }
        return result;
    }

    public boolean removeOutputLocation(MappingClass theMappingClass, EObject theTreeNode) {
        boolean result = false;
        try {
            TreeMappingRoot treeMappingRoot = (TreeMappingRoot)this.getMappingRoot(theMappingClass);
            if (treeMappingRoot.getOutputs().contains((Object)theTreeNode)) {
                ModelerCore.getModelEditor().removeValue((Object)treeMappingRoot, (Object)theTreeNode, treeMappingRoot.getOutputs());
                this.removeEntryFromTreeNodesToMappingClassScopeMap(theMappingClass);
                this.hasChanges = true;
            }
        }
        catch (Exception e) {
            PluginConstants.Util.log(4, (Throwable)e, e.getMessage());
        }
        return result;
    }

    public void deleteMappingClass(EObject mappingClass) throws ModelerCoreException {
        if (mappingClass instanceof StagingTable) {
            EObject treeMappingRoot = (EObject)this.stagingTablesToRootMap.get(mappingClass);
            if (treeMappingRoot != null) {
                this.mappingClassesToRootMap.remove(mappingClass);
                ModelerCore.getModelEditor().delete(treeMappingRoot, true, false);
            }
            ModelerCore.getModelEditor().delete(mappingClass);
            EObject location = (EObject)this.stagingTableLocationMap.get(mappingClass);
            if (location != null) {
                this.locationToStagingTableMap.remove(location);
            }
            this.stagingTableLocationMap.remove(mappingClass);
        } else {
            EObject treeMappingRoot = (EObject)this.mappingClassesToRootMap.get(mappingClass);
            if (treeMappingRoot != null) {
                this.mappingClassesToRootMap.remove(mappingClass);
                ModelerCore.getModelEditor().delete(treeMappingRoot, true, false);
            }
            ModelerCore.getModelEditor().delete(mappingClass);
            List locations = this.getMappingClassLocations(mappingClass);
            Iterator iter = locations.iterator();
            while (iter.hasNext()) {
                this.locationToMappingClassMap.remove(iter.next());
            }
        }
        this.mappingClassesNameMap.remove(((MappingClass)mappingClass).getName());
        this.hasChanges = true;
    }

    public List gatherCoarseExtentNodes(EObject visibleNode, HashMap columnLocationsMap) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject node : this.getMapper().getMappableTree().getChildren(visibleNode)) {
            if (columnLocationsMap.get(node) != null) {
                result.add(node);
                result.addAll(this.gatherCoarseExtentNodes(node, columnLocationsMap));
                continue;
            }
            if (this.getMappingClass(node) != null) continue;
            result.add(node);
            result.addAll(this.gatherCoarseExtentNodes(node, columnLocationsMap));
        }
        return result;
    }

    public MappingClass getMappingClassForTreeNode(EObject theTreeNode) {
        MappingClass result = (MappingClass)this.treeNodesToMappingClassScopeMap.get(theTreeNode);
        return result;
    }

    public List getTreeNodesInAMappingClassScope(MappingClass theMappingClass) {
        this.resetIfChanged();
        List columnLocations = this.getColumnLocations(theMappingClass);
        HashMap columnLocationsMap = ListAndMapUtil.createMapFromList((List)columnLocations);
        List locations = this.getMappingClassLocations((EObject)theMappingClass);
        ArrayList extentNodes = Collections.EMPTY_LIST;
        if (!locations.isEmpty()) {
            extentNodes = new ArrayList();
            int size = locations.size();
            int i = 0;
            while (i < size) {
                extentNodes.add(locations.get(i));
                extentNodes.addAll(this.gatherCoarseExtentNodes((EObject)locations.get(i), columnLocationsMap));
                ++i;
            }
        }
        return extentNodes;
    }

    public void loadTreeNodesToMappingClassScopeMap() {
        this.treeNodesToMappingClassScopeMap = new HashMap(this.mappingClassesArray.size());
        int size = this.mappingClassesArray.size();
        int i = 0;
        while (i < size) {
            MappingClass mappingClass = (MappingClass)this.mappingClassesArray.get(i);
            if (mappingClass != null) {
                this.addEntryToTreeNodesToMappingClassScopeMap(mappingClass);
            }
            ++i;
        }
        this.columnMappingLocator.loadTreeNodesToMappingClassColumnsMap();
    }

    private void addEntryToTreeNodesToMappingClassScopeMap(MappingClass mappingClass) {
        List lstNodes = this.getTreeNodesInAMappingClassScope(mappingClass);
        if (lstNodes != null && !lstNodes.isEmpty()) {
            int iNodes = lstNodes.size();
            int j = 0;
            while (j < iNodes) {
                EObject eoTemp = (EObject)lstNodes.get(j);
                if (this.getMapper().isMappable(eoTemp)) {
                    this.treeNodesToMappingClassScopeMap.put(eoTemp, mappingClass);
                }
                ++j;
            }
        }
    }

    private void removeEntryFromTreeNodesToMappingClassScopeMap(MappingClass mappingClass) {
        Set colNodes = this.treeNodesToMappingClassScopeMap.keySet();
        if (colNodes != null && !colNodes.isEmpty()) {
            Iterator it = colNodes.iterator();
            while (it.hasNext()) {
                EObject tempNodeKey = (EObject)it.next();
                MappingClass tempMappingClass = (MappingClass)this.treeNodesToMappingClassScopeMap.get(tempNodeKey);
                if (tempMappingClass != mappingClass) continue;
                it.remove();
            }
        }
    }

    public void addMappingClassColumnLocation(MappingClassColumn theMappingColumn, EObject theTreeNode) {
        this.hasChanges = true;
        this.columnMappingLocator.addMappingClassColumnLocation(theMappingColumn, theTreeNode);
    }

    public void removeMappingClassColumnLocation(MappingClassColumn theMappingColumn, EObject theTreeNode) {
        this.hasChanges = true;
        this.columnMappingLocator.removeMappingClassColumnLocation(theMappingColumn, theTreeNode);
    }

    public MappingList getMappingClassColumnMappingList(MappingClassColumn theMappingColumn) {
        this.resetIfChanged();
        return this.columnMappingLocator.getMappingClassColumnMappingList(theMappingColumn);
    }

    public MappingClassColumn getMappingClassColumn(EObject theTreeNode, MappingClass theMappingClass) {
        this.resetIfChanged();
        return this.columnMappingLocator.getMappingClassColumn(theTreeNode, theMappingClass);
    }

    public MappingClassColumn getMappingClassColumn(EObject theTreeNode) {
        this.resetIfChanged();
        return this.columnMappingLocator.getMappingClassColumn(theTreeNode);
    }

    public List getMappingClassColumnOutputLocations(MappingClassColumn theMappingColumn) {
        this.resetIfChanged();
        return this.columnMappingLocator.getMappingClassColumnOutputLocations(theMappingColumn);
    }

    public List getColumnLocations(MappingClass theMappingClass) {
        this.resetIfChanged();
        ArrayList result = new ArrayList();
        Iterator iter = theMappingClass.getColumns().iterator();
        while (iter.hasNext()) {
            result.addAll(this.getMappingClassColumnOutputLocations((MappingClassColumn)iter.next()));
        }
        return result;
    }

    private void initialize() {
        this.fragmentRoots = new ArrayList();
        this.mappingRoots = this.modelContents.getTransformations(this.root);
        if (this.mappingRoots == null || this.mappingRoots.isEmpty()) {
            this.mappingRoots = new ArrayList();
        } else {
            int size = this.mappingRoots.size();
            int i = 0;
            while (i < size) {
                MappingRoot mappingRoot = (MappingRoot)this.mappingRoots.get(i);
                Iterator outputIter = mappingRoot.getOutputs().iterator();
                if (mappingRoot instanceof TreeMappingRoot) {
                    MappingClass mappingClass = this.getMappingClass(mappingRoot);
                    if (mappingClass instanceof StagingTable) {
                        this.stagingTablesToRootMap.put(mappingClass, mappingRoot);
                        while (outputIter.hasNext()) {
                            Object oTreeNode = outputIter.next();
                            this.stagingTableLocationMap.put(mappingClass, oTreeNode);
                            this.locationToStagingTableMap.put(oTreeNode, mappingClass);
                        }
                    } else {
                        this.mappingClassesToRootMap.put(mappingClass, mappingRoot);
                        this.mappingClassesNameMap.put(mappingClass.getName(), mappingClass.getName());
                        while (outputIter.hasNext()) {
                            Object oTemp = outputIter.next();
                            this.locationToMappingClassMap.put(oTemp, mappingClass);
                        }
                    }
                } else if (mappingRoot instanceof FragmentMappingRoot) {
                    this.fragmentRoots.add(mappingRoot);
                }
                ++i;
            }
        }
        this.fragmentAdapter = new FragmentMappingAdapter(this.root, this.getFragmentRoots());
        this.resetOrderedLists();
    }

    private void resetIfChanged() {
        if (this.hasChanges && !this.isGeneratingMappingClasses()) {
            this.resetOrderedLists();
            this.loadTreeNodesToMappingClassScopeMap();
        }
    }

    private void resetOrderedLists() {
        if (this.mappingRoots.isEmpty()) {
            this.clear();
            return;
        }
        XmlDocumentMappingClassVisitor visitor = new XmlDocumentMappingClassVisitor(this.locationToMappingClassMap, this.locationToStagingTableMap);
        MappableTreeIterator nodeIter = new MappableTreeIterator(this.mapper.getMappableTree());
        if (nodeIter.hasNext()) {
            nodeIter.next();
        }
        while (nodeIter.hasNext()) {
            visitor.visit((EObject)nodeIter.next());
        }
        this.mappingClassesArray = visitor.getOrderedMappingClasses();
        this.stagingTablesArray = visitor.getOrderedStagingTables();
        this.hasChanges = false;
    }

    private void clear() {
        this.mappingClassesArray = Collections.EMPTY_LIST;
        this.stagingTablesArray = Collections.EMPTY_LIST;
        if (!this.locationToMappingClassMap.isEmpty()) {
            this.locationToMappingClassMap.clear();
        }
        if (!this.stagingTablesToRootMap.isEmpty()) {
            this.stagingTablesToRootMap.clear();
        }
        if (!this.mappingClassesToRootMap.isEmpty()) {
            this.mappingClassesToRootMap.clear();
        }
        if (!this.locationToMappingClassMap.isEmpty()) {
            this.locationToMappingClassMap.clear();
        }
        if (!this.locationToStagingTableMap.isEmpty()) {
            this.locationToStagingTableMap.clear();
        }
        if (!this.stagingTableLocationMap.isEmpty()) {
            this.stagingTableLocationMap.clear();
        }
        if (!this.treeNodesToMappingClassScopeMap.isEmpty()) {
            this.treeNodesToMappingClassScopeMap.clear();
        }
        if (!this.mappingClassesNameMap.isEmpty()) {
            this.mappingClassesNameMap.clear();
        }
    }

    private MappingClass getMappingClass(MappingRoot theMappingRoot) {
        CoreArgCheck.isNotNull((Object)theMappingRoot);
        MappingClass result = null;
        EList inputs = theMappingRoot.getInputs();
        int size = inputs.size();
        if (size > 0) {
            result = (MappingClass)inputs.get(0);
        }
        return result;
    }

    public String toString() {
        int buffSize = 100 + 80 * this.mappingClassesArray.size() + 80 * this.stagingTablesArray.size();
        StringBuffer buffer = new StringBuffer(buffSize);
        buffer.append("\n  TreeToEObjectMapping Contents:");
        buffer.append('\n').append("  # Mapping Classes = " + this.mappingClassesArray.size());
        Iterator iter = null;
        String name = null;
        EObject nextEObj2 = null;
        int count = 0;
        for (EObject nextEObj2 : this.mappingClassesArray) {
            name = ModelerCore.getModelEditor().getName(nextEObj2);
            buffer.append('\n').append("        [" + count + "] " + name);
            ++count;
        }
        count = 0;
        buffer.append('\n').append("  # Staging Tables = " + this.stagingTablesArray.size());
        for (EObject nextEObj2 : this.stagingTablesArray) {
            name = ModelerCore.getModelEditor().getName(nextEObj2);
            buffer.append('\n').append("        [" + count + "] " + name);
            ++count;
        }
        buffer.append('\n');
        return buffer.toString();
    }
}

