/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;

public class XmlDocumentMappingClassVisitor {
    private ArrayList mappingClasses;
    private ArrayList stagingTables;
    private HashMap locationToMappingClassMap;
    private HashMap locationToStagingTableMap;
    private HashMap remainingMCLocations;
    private HashMap remainingSTLocations;

    public XmlDocumentMappingClassVisitor(HashMap locToMCMap, HashMap locToSTMap) {
        this.locationToMappingClassMap = locToMCMap;
        this.locationToStagingTableMap = locToSTMap;
        this.remainingMCLocations = this.simpleSetToMap(locToMCMap.keySet());
        this.remainingSTLocations = this.simpleSetToMap(locToSTMap.keySet());
        this.mappingClasses = new ArrayList();
        this.stagingTables = new ArrayList();
    }

    public void visit(EObject object) {
        EObject stagingTable;
        EObject mappingClass;
        if (this.remainingMCLocations.containsKey(object) && (mappingClass = (EObject)this.locationToMappingClassMap.get(object)) != null) {
            this.mappingClasses.add(mappingClass);
            this.removeLocationsForMappingClass(mappingClass);
        }
        if (this.remainingSTLocations.containsKey(object) && (stagingTable = (EObject)this.locationToStagingTableMap.get(object)) != null) {
            this.stagingTables.add(stagingTable);
            this.removeLocationsForStagingTable(stagingTable);
        }
    }

    public ArrayList getOrderedMappingClasses() {
        return this.mappingClasses;
    }

    public ArrayList getOrderedStagingTables() {
        return this.stagingTables;
    }

    private void removeLocationsForMappingClass(EObject mappingClass) {
        ArrayList<EObject> removeList = new ArrayList<EObject>();
        for (EObject nextLoc : this.locationToMappingClassMap.keySet()) {
            EObject nextMC = (EObject)this.locationToMappingClassMap.get(nextLoc);
            if (nextMC != mappingClass) continue;
            removeList.add(nextLoc);
        }
        if (!removeList.isEmpty()) {
            Iterator removeIter = removeList.iterator();
            while (removeIter.hasNext()) {
                this.remainingMCLocations.remove(removeIter.next());
            }
        }
    }

    private void removeLocationsForStagingTable(EObject stagingTable) {
        ArrayList<EObject> removeList = new ArrayList<EObject>();
        for (EObject nextLoc : this.locationToStagingTableMap.keySet()) {
            EObject nextMC = (EObject)this.locationToStagingTableMap.get(nextLoc);
            if (nextMC != stagingTable) continue;
            removeList.add(nextLoc);
        }
        if (!removeList.isEmpty()) {
            Iterator removeIter = removeList.iterator();
            while (removeIter.hasNext()) {
                this.remainingSTLocations.remove(removeIter.next());
            }
        }
    }

    private HashMap simpleSetToMap(Set theSet) {
        HashMap hmap = new HashMap(theSet.size());
        for (Object oTemp : theSet) {
            hmap.put(oTemp, oTemp);
        }
        return hmap;
    }
}

