/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.tycho.m2e.felix.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.lifecyclemapping.model.IPluginExecutionMetadata;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.core.project.configurator.AbstractBuildParticipant;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ILifecycleMappingConfiguration;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;
import org.sonatype.plexus.build.incremental.BuildContext;

public class MavenBundlePluginConfigurator
extends AbstractProjectConfigurator {
    private static final IMaven maven = MavenPlugin.getMaven();
    private static final QualifiedName PROP_FORCE_GENERATE = new QualifiedName(MavenBundlePluginConfigurator.class.getName(), "forceGenerate");
    private static final ArtifactVersion VERSION_2_3_6 = new DefaultArtifactVersion("2.3.6");
    public static final String PARAM_MANIFESTLOCATION = "manifestLocation";

    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
    }

    public AbstractBuildParticipant getBuildParticipant(IMavenProjectFacade projectFacade, final MojoExecution execution, IPluginExecutionMetadata executionMetadata) {
        return new AbstractBuildParticipant(){

            public Set<IProject> build(int kind, IProgressMonitor monitor) throws Exception {
                BuildContext buildContext = this.getBuildContext();
                IMavenProjectFacade facade = this.getMavenProjectFacade();
                IProject project = facade.getProject();
                MavenProject mavenProject = facade.getMavenProject(monitor);
                Map instructions = (Map)maven.getMojoParameterValue(mavenProject, execution, "instructions", Map.class, monitor);
                MojoExecution _execution = MavenBundlePluginConfigurator.amendMojoExecution(mavenProject, execution, instructions);
                IFile manifest = MavenBundlePluginConfigurator.this.getManifestFile(facade, _execution, monitor);
                boolean generate = 6 == kind;
                generate = generate || Boolean.parseBoolean((String)project.getSessionProperty(PROP_FORCE_GENERATE));
                project.setSessionProperty(PROP_FORCE_GENERATE, null);
                boolean bl = generate = generate || this.isIncludeBndFileChange(buildContext, instructions);
                if (!generate) {
                    return null;
                }
                maven.execute(mavenProject, _execution, monitor);
                manifest.refreshLocal(2, monitor);
                if (MavenBundlePluginConfigurator.isDeclerativeServices(mavenProject.getBasedir(), instructions)) {
                    IFolder outputFolder = this.getOutputFolder(monitor, facade, _execution);
                    outputFolder.getFolder("OSGI-OPT").refreshLocal(2, monitor);
                    outputFolder.getFolder("OSGI-INF").refreshLocal(2, monitor);
                }
                return null;
            }

            protected IFolder getOutputFolder(IProgressMonitor monitor, IMavenProjectFacade facade, MojoExecution _execution) throws CoreException {
                File outputDirectory = (File)MavenBundlePluginConfigurator.this.getParameterValue(facade.getMavenProject(), "outputDirectory", File.class, _execution, monitor);
                IPath outputPath = facade.getProjectRelativePath(outputDirectory.getAbsolutePath());
                IFolder outputFolder = facade.getProject().getFolder(outputPath);
                return outputFolder;
            }

            private boolean isIncludeBndFileChange(BuildContext buildContext, Map<String, String> instructions) throws CoreException {
                for (String path : MavenBundlePluginConfigurator.getIncludeBndFilePaths(instructions)) {
                    if (!buildContext.hasDelta(path)) continue;
                    return true;
                }
                return false;
            }

            public void clean(IProgressMonitor monitor) throws CoreException {
                IMavenProjectFacade facade = this.getMavenProjectFacade();
                MavenProject mavenProject = facade.getMavenProject(monitor);
                Map instructions = (Map)maven.getMojoParameterValue(mavenProject, execution, "instructions", Map.class, monitor);
                if (MavenBundlePluginConfigurator.isDeclerativeServices(mavenProject.getBasedir(), instructions)) {
                    IFolder outputFolder = this.getOutputFolder(monitor, facade, execution);
                    outputFolder.getFolder("OSGI-OPT").delete(true, monitor);
                    outputFolder.getFolder("OSGI-INF").delete(true, monitor);
                }
            }
        };
    }

    protected static MojoExecution amendMojoExecution(MavenProject mavenProject, MojoExecution execution, Map<String, String> instructions) {
        if ("bundle".equals(execution.getGoal())) {
            MojoDescriptor descriptor = execution.getMojoDescriptor().clone();
            descriptor.setGoal("manifest");
            descriptor.setImplementation("org.apache.felix.bundleplugin.ManifestPlugin");
            MojoExecution _execution = new MojoExecution(execution.getPlugin(), "manifest", "m2e-tycho:" + execution.getExecutionId() + ":manifest");
            _execution.setConfiguration(execution.getConfiguration());
            _execution.setMojoDescriptor(descriptor);
            _execution.setLifecyclePhase(execution.getLifecyclePhase());
            execution = _execution;
        }
        Xpp3Dom configuration = new Xpp3Dom(execution.getConfiguration());
        if (VERSION_2_3_6.compareTo((Object)new DefaultArtifactVersion(execution.getVersion())) <= 0) {
            MavenBundlePluginConfigurator.setBoolean(configuration, "rebuildBundle", true);
        }
        if (MavenBundlePluginConfigurator.isDeclerativeServices(mavenProject.getBasedir(), instructions)) {
            MavenBundlePluginConfigurator.setBoolean(configuration, "unpackBundle", true);
        }
        execution.setConfiguration(configuration);
        return execution;
    }

    protected static boolean isDeclerativeServices(Map<String, String> instructions) {
        return instructions.containsKey("Service-Component") || instructions.containsKey("_dsannotations");
    }

    protected static boolean isDeclerativeServices(File basedir, Map<String, String> instructions) {
        if (MavenBundlePluginConfigurator.isDeclerativeServices(instructions)) {
            return true;
        }
        for (String path : MavenBundlePluginConfigurator.getIncludeBndFilePaths(instructions)) {
            if (!MavenBundlePluginConfigurator.isDeclerativeServices(MavenBundlePluginConfigurator.loadBndFile(new File(basedir, path)))) continue;
            return true;
        }
        return false;
    }

    private static Map<String, String> loadBndFile(File file) {
        Properties properties = new Properties();
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
                properties.load(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String key : properties.stringPropertyNames()) {
            map.put(key, properties.getProperty(key));
        }
        return map;
    }

    static List<String> getIncludeBndFilePaths(Map<String, String> instructions) {
        ManifestElement[] elements;
        if (instructions == null) {
            return Collections.emptyList();
        }
        String include = instructions.get("_include");
        if (include == null) {
            return Collections.emptyList();
        }
        try {
            elements = ManifestElement.parseHeader((String)"_include", (String)include);
        }
        catch (BundleException bundleException) {
            return Collections.emptyList();
        }
        ArrayList<String> includes = new ArrayList<String>();
        ManifestElement[] manifestElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ManifestElement element = manifestElementArray[n2];
            String path = element.getValueComponents()[0];
            if (path.startsWith("-") || path.startsWith("~")) {
                path = path.substring(1);
            }
            includes.add(path);
            ++n2;
        }
        return includes;
    }

    private static void setBoolean(Xpp3Dom configuration, String name, boolean value) {
        Xpp3Dom parameter = configuration.getChild(name);
        if (parameter == null) {
            parameter = new Xpp3Dom(name);
            configuration.addChild(parameter);
        }
        parameter.setValue(Boolean.toString(value));
    }

    public void mavenProjectChanged(MavenProjectChangedEvent event, IProgressMonitor monitor) throws CoreException {
        if (3 == event.getKind() && 1 == event.getFlags()) {
            this.forceManifestRegeneration(event.getMavenProject().getProject(), monitor);
        }
    }

    protected IFile getManifestFile(IMavenProjectFacade facade, MojoExecution execution, IProgressMonitor monitor) throws CoreException {
        File manifestFile = (File)this.getParameterValue(facade.getMavenProject(), PARAM_MANIFESTLOCATION, File.class, execution, monitor);
        IPath projectPath = facade.getProjectRelativePath(manifestFile.getAbsolutePath()).append("MANIFEST.MF");
        return facade.getProject().getFile(projectPath);
    }

    public boolean hasConfigurationChanged(IMavenProjectFacade newFacade, ILifecycleMappingConfiguration oldProjectConfiguration, MojoExecutionKey key, IProgressMonitor monitor) {
        if (super.hasConfigurationChanged(newFacade, oldProjectConfiguration, key, monitor)) {
            block4: {
                try {
                    if (this.equalsManifestLocation(newFacade.getMojoExecution(key, monitor), oldProjectConfiguration.getMojoExecutionConfiguration(key))) break block4;
                    return true;
                }
                catch (CoreException coreException) {
                    return true;
                }
            }
            this.forceManifestRegeneration(newFacade.getProject(), monitor);
        }
        return false;
    }

    private boolean equalsManifestLocation(MojoExecution mojoExecution, Xpp3Dom oldConfiguration) {
        if (mojoExecution == null) {
            return true;
        }
        Xpp3Dom configuration = mojoExecution.getConfiguration();
        Xpp3Dom metainf = this.getManifestLocation(configuration);
        Xpp3Dom oldMetainf = this.getManifestLocation(oldConfiguration);
        return metainf != null ? metainf.equals((Object)oldMetainf) : oldMetainf == null;
    }

    protected Xpp3Dom getManifestLocation(Xpp3Dom configuration) {
        return configuration != null ? configuration.getChild(PARAM_MANIFESTLOCATION) : null;
    }

    protected void forceManifestRegeneration(IProject project, IProgressMonitor monitor) throws CoreException {
        project.setSessionProperty(PROP_FORCE_GENERATE, (Object)"true");
    }
}

