/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.tycho.m2e.internal;

import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.osgi.util.ManifestElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.tycho.m2e.internal.PDEProjectHelper;

public class EmbeddedArtifacts {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedArtifacts.class);
    private static final String EMBEDDED_ARTIFACTS = "Embedded-Artifacts";

    public static Map<ArtifactKey, String> getEmbeddedArtifacts(IProject project) {
        LinkedHashMap<ArtifactKey, String> result;
        block15: {
            result = new LinkedHashMap<ArtifactKey, String>();
            try {
                Manifest mf;
                IFile mfFile = PDEProjectHelper.getBundleManifest(project);
                if (mfFile == null || !mfFile.isAccessible()) break block15;
                Throwable throwable = null;
                Object var5_6 = null;
                try (InputStream is = mfFile.getContents();){
                    mf = new Manifest(is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                String value = mf.getMainAttributes().getValue(EMBEDDED_ARTIFACTS);
                if (value != null) {
                    ManifestElement[] manifestElementArray = ManifestElement.parseHeader((String)EMBEDDED_ARTIFACTS, (String)value);
                    int n = manifestElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ManifestElement me = manifestElementArray[n2];
                        String path = me.getValue();
                        String g = me.getAttribute("g");
                        String a = me.getAttribute("a");
                        String v = me.getAttribute("v");
                        String c = me.getAttribute("c");
                        if (g != null && a != null && v != null && path != null) {
                            result.put(new ArtifactKey(g, a, v, c), path);
                        } else {
                            log.debug("Malformd Include-Artifacts element paht={};g={};a={};v={};c={}", new Object[]{path, g, a, v, c});
                        }
                        ++n2;
                    }
                }
            }
            catch (Exception e) {
                log.warn("Count not read generated bundle manifest of project {}", (Object)project.getName(), (Object)e);
            }
        }
        return result;
    }
}

